@extends('backend.layouts.app')
@section('title', "Orders")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-9 col-9">
                <h4 class="card-title mb-0">
                    Order #{{$order_det->id}}
                </h4>
            </div>
            <div class="col-sm-3 col-3 pull-right">
            <div class="btn-toolbar" role="toolbar" aria-label="" style="margin-top: 20px;float: right;">
                <a href="{{ route('admin.orders') }}" class="btn btn-warning"><i class="fa fa-reply"></i></a>             
            </div>
            </div>
        </div>
         @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach 
                </ul>
            </div>
        @endif
        <hr> 
        <div class="row mt-4">
            <div class="col-md-12 col-lg-12 col-sm-12" style="display: flex;">
                <div class="col-md-4 col-lg-4 col-sm-4" style="">
                    <b>{{$user_det->name}}</b>
                    <p>{{$user_det->email}}<br>
                    @if($user_det->dialcode)+{{$user_det->dialcode}}@endif {{$user_det->mobile}}
                    <br>{{$user_det->address_1}}{{($user_det->address_2)?', '.$user_det->address_2 : ''}}
                    <br>
                    @if($city){{$city->name}}, @endif @if($state){{$state->name}}, @endif @if($country){{$country->title_en}} @endif
                </p>
                </div>
                <div class="col-md-4 col-lg-4 col-sm-4"></div>
                <div class="col-md-4 col-lg-4 col-sm-4" style="text-align: right; float:right;">
                    <b>Order Number : </b> {{$order_det->order_num}}<br>
                    <b>Payment Status : </b><button class="btn btn-sm btn-primary" disabled><?= ucfirst($order_det->status);?></button><br>
                    <a data-bs-toggle="modal" data-bs-target="#myModal1" class="m-2 btn btn-sm btn-primary" style="color: #fff;">Change Payment Status</a><br>
                    <b>Delivery Status : </b><button class="btn btn-sm btn-primary" disabled><?= ucfirst($items[0]->status);?></button><br>
                    <!-- <a data-toggle="modal" data-target="#myModal" class="m-2 btn btn-sm btn-primary" style="color: #fff;">Change Delivery Status</a><br> -->
                    <?php 
                    $date = strtotime($order_det->created_at); 
                    $new_date = date('d-m-Y', $date);
                    ?>
                    <b>Order Date : </b> {{$new_date}}<br>
                    <b>Total Amount : </b> {{$currency->symbol}}{{$order_det->order_total_base}}
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-4">
                       <div class="table-responsive col-sm-12">
                    <div class="table-responsive p-3">
                        <table class="table table-bordered" style="text-align: center; width: 100%"
                        id="topics_">
                     <thead class="dker">
                                <th style="text-align:center;" class="attend_data">Sl.No</th>
                                <th style="text-align:center;" class="attend_data">Photo</th>
                                <th style="text-align:center; width:20%;max-width:100px;" class="attend_data">Title</th>
                                <th style="text-align:center;" class="attend_data">Payment Status</th>
                                <th style="text-align:center;" class="attend_data">Quantity</th>
                                <th style="text-align:center;" class="attend_data">Price</th>
                                <th style="text-align:center;" class="attend_data">Total</th>
                     </thead>
                        <tbody>
                            <?php 
                            for ($i=0; $i<count($items_det); $i++) { 
                                ?>
                            <tr class="odd">
                                <td><?=$i+1;?></td>
                                <td><img src="{{asset('storage/products/'.$img[$i]->filename)}}" style="width: 100px;"></td>
                                <td>{{$items_det[$i]->title}}</td>
                                <td><?= ucfirst($order_det->status);?></td>
                                <td>{{$items[$i]->qty}}</td>
                                <td>{{$currency->symbol}}{{$items[$i]->price_base}}</td>
                                <td>{{$currency->symbol}}{{$items[$i]->qty * $items[$i]->price_base}}</td>
                            </tr>
                           <?php }
                            ?>
                        </tbody>
                    </table>
                    </div>
                </div>
    </div>
     <div class="col-md-12 col-sm-12 p-4">
        <div class="col-md-4 col-lg-4 col-sm-6" style="text-align: right; float:right;">
                <strong>Sub Total : {{$currency->symbol}}{{$order_det->total}}&nbsp;&nbsp;&nbsp;&nbsp;</strong><br>
                <strong>Tax : {{$currency->symbol}}0 &nbsp;&nbsp;&nbsp;&nbsp;</strong><br>
                 <strong>Shipping : {{$currency->symbol}}0&nbsp;&nbsp;&nbsp;&nbsp;</strong><br>
                <hr style="">
                <strong>Total :{{$currency->symbol}}{{$order_det->total}} &nbsp;&nbsp;&nbsp;&nbsp;<b></b></strong><br>
            </div>
            <div class="col-md-8 col-lg-8 col-sm-6">
                
            <div class="table-responsive">
            <h5>Order Activity</h5>
                    <div class="table-responsive">
                        <table class="table table-bordered" style="text-align: center; width: 100%" id="topics_">
                     <thead class="dker">
                                <th style="text-align:center;" class="attend_data">Sl.No</th>
                                {{-- <th style="text-align:center;" class="attend_data">Order Id</th> --}}
                                <th style="text-align:center; width:20%;max-width:100px;" class="attend_data">Date</th>
                                <th style="text-align:center;" class="attend_data">Status Type</th>
                                <th style="text-align:center;" class="attend_data">Status</th>
                                <th style="text-align:center;" class="attend_data">Notes</th>
                     </thead>
                        <tbody>
                            <?php 
                            for ($i=0; $i<count($activities); $i++) { 
                                 $date = strtotime($activities[$i]->trans_date); 
                                $new_date = date('d-m-Y', $date);
                                ?>
                                <tr>
                                    <td>{{$i+1}}</td>
                                        {{-- <td>{{$activities[$i]->orderid}}</td> --}}
                                    <td>{{$new_date}}</td>
                                    <td>{{$activities[$i]->type}}</td>
                                    <td>{{$activities[$i]->status}}</td>
                                    <td>{{$activities[$i]->notes}}</td>
                                </tr>
                            <?php }
                            ?>
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
</div>

<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title">Change Delivery Status</h5>
          <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <form action="{{route('admin.orders.change-delivery-status')}}" method="POST">
              @csrf
              <input type="hidden" name="order_id" value="{{$order_det->id}}">
              <input type="hidden" name="from" value="all">
              <div class="">
                <div class="">
                    <strong>Select Delivery Status : </strong>
                <select class="form-control form-select" style="width: 65%;" name="deliverystatus" id="deliverystatus" required>
                    <option value=''>Delivery Status</option>
                    <option value="pending">Pending</option>
                    <option value="active">Active</option>
                    <option value="cancelled">Cancelled</option>
                    <option value="completed">Completed</option>
                </select>
                </div>
                <div class="mt-2">
                <strong>Notes : </strong>
                    <textarea class="form-control" rows="3" name="notes" style="width:65%;" placeholder="Notes"></textarea>    
                </div>        
                <div class="mt-1">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                </div>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>


<div class="modal fade" id="myModal1" role="dialog">
    <div class="modal-dialog">
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Change Payment Status</h4>
          <button type="button" class="close" data-bs-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <form action="{{route('admin.orders.change-payment-status')}}" method="POST">
              @csrf
              <input type="hidden" name="from" value="all">
              <input type="hidden" name="order_id" value="{{$order_det->id}}">
              <div class="">
                <div class="">
                <strong>Select Payment Status : </strong>
                <select class="form-control form-select" style="width: 65%;" name="paymentstatus" id="paymentstatus" required>
                    <option value=''>Payment Status</option>
                    <option value="pending">Pending</option>
                    <option value="paid">Paid</option>
                    <option value="cancelled">Cancelled</option>
                    <option value="refunded">Refunded</option>
                </select>
                </div>
                <div class="mt-2">
                <strong>Notes : </strong>
                    <textarea class="form-control" name="notes" rows="3" style="width:65%;" placeholder="Notes"></textarea>    
                </div>            
                <div class="mt-1">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                </div>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
      
    </div>
  </div>
@endsection      

@push ('after-scripts')
<script type="text/javascript">

</script>
@endpush
