@extends('backend.layouts.app')
@section('title', "Add New Category")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Add New Product
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <a href="{{ route('admin.products') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
            </div>
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col-md-12">
                {{ html()->form('POST', route('admin.products.save-product'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
                @csrf
                <div class="row">
                    <div class="col-lg-12 col-sm-12 col-md-12">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="title_en"><b>Title</b> <span style="color: red;">*</span></label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <input type="text" class="form-control" id="title_en" value="{{old('title')}}" name="title" required>
                        </div>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="type"><b>Type</b> <span style="color: red;">*</span> </label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <select class="form-control form-select" id="type" name="type">
                                <option value="digital">Digital/Service</option>                                
                                <option value="physical">Physical</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="category"><b>Category</b> <span style="color: red;">*</span> </label>
                        </div>

                        <div class="col-md-6 col-lg-6 col-sm-6">
                            <select class="form-control form-select select2" id="multiselect" multiple="multiple" name="category[]">
                                <?php
                                for ($i = 0; $i < count($categories); $i++) { ?>
                                    <option value="<?= $categories[$i]->id ?>"><?= $categories[$i]->title ?></option>
                                    <?php
                                    if (isset($subcategories[$i])) {
                                        for ($j = 0; $j < count($subcategories); $j++) {
                                            if ($subcategories[$j]->parent == $categories[$i]->id) {
                                    ?>
                                                <option value="<?= $subcategories[$j]->id ?>"><?= $categories[$i]->title ?> >> <?= $subcategories[$j]->title ?></option>
                                    <?php }
                                        }
                                    }
                                    ?>
                                <?php    }
                                ?>
                            </select>
                        </div>
                    </div>
                    <input type="hidden" name="currency" value="{{config('app.currency_symbol')}}">
                    {{-- <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="currency"><b>Currency</b> <span style="color: red;">*</span> </label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <select class="form-control" id="currency" name="currency">
                                    @foreach($currency as $cur)
                                    <option value="{{$cur->code}}">{{$cur->symbol}} {{$cur->code}}</option>
                    @endforeach
                    </select>
                </div>
            </div> --}}

            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="type"><b>Price</b> <span style="color: red;">*</span> </label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text">{{config('app.currency_symbol')}}</span>
                    </div>
                    <input class="form-control" id="price" type="number" step="0.01" name="price" value="{{old('price')}}" required>
                </div>
                </div>
            </div>

            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="type"><b>Offer Price</b> </label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text">{{config('app.currency_symbol')}}</span>
                    </div>
                    <input class="form-control" id="offer_price" type="number" step="0.01" name="offer_price" value="{{old('offer_price')}}">
                </div>
                </div>
            </div>
            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="has_downloads"><b>Has Downloads</b> <span style="color: red;">*</span></label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <select class="form-control form-select" id="has_downloads" name="has_downloads">
                        <option value="1">Yes</option>
                        <option value="0" selected>No</option>
                    </select>
                    <span>You can configure downloads after creating the product. Product List > Actions > Downloads</span>
                </div>
            </div>

            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <label for="short_desc"><b>Short Description</b> <span style="color: red;">*</span>
                    </label>
                    <span class="float-right" id="brief_desc_count"></span>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <textarea class="form-control" id="short_desc" name="short_desc" maxlength="500" rows="5" required>{{old('short_desc')}}</textarea>
                </div>
            </div>


            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="details"><b>Details</b></label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <textarea class="form-control" id="editor1" name="details" rows="5">{{old('details')}}</textarea>
                </div>
            </div>

            <div id="physical" class="col-lg-12 col-sm-12 col-md-12 mt-4" style="display: none;">
                <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <label for="dimension"><b>Dimension</b></label>
                    </div>
                    <div class="col-md-6 col-lg-6 col-sm-6">
                        <input type="text" class="form-control" id="dimension" value="{{old('dimension')}}" name="dimension">
                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <label for="color"><b>Color</b></label>
                    </div>
                    <div class="col-md-6 col-lg-6 col-sm-6">
                        <input type="text" class="form-control" id="color" value="{{old('color')}}" name="color">
                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <label for="brand"><b>Brand</b></label>
                    </div>
                    <div class="col-md-6 col-lg-6 col-sm-6">
                        <input type="text" class="form-control" id="brand" value="{{old('brand')}}" name="brand">
                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <label for="weight"><b>Weight</b>&nbsp;&nbsp; (In K.G)</label>
                    </div>
                    <div class="col-md-6 col-lg-6 col-sm-6">
                        <input type="text" class="form-control" id="weight" value="{{old('weight')}}" name="weight">
                    </div>
                </div>

                <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                    <div class="col-lg-4 col-md-4 col-sm-4">
                        <label for="stock"><b>Stock</b> (For Unlimited Enter -1)</label>
                    </div>
                    <div class="col-md-6 col-lg-6 col-sm-6">
                        <input type="number" class="form-control" id="stock" value="0" name="stock">
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="status"><b>Status</b> <span style="color: red;">*</span></label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <select class="form-control form-select" id="status" name="status">
                        <option value="enabled">Enabled</option>
                        <option value="disabled">Disabled</option>
                    </select>
                </div>
            </div>

            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="file"><b>Featured Image</b> <span style="color: red;">*</span></label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <input type="file" name="file" id="file" class="form-control" value="{{old('file')}}" required>
                    Extensions: .png, .jpg, .jpeg, .gif, .svg
                </div>

            </div>
            <div class="col-lg-12 col-sm-12 col-md-12 ml-3">
                <b>Note : </b> More images can be uploaded after product creation. Go to Product Edit -> Media tab
            </div>
            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="file"><b>Video Url</b></label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <input type="text" class="form-control" id="video_url" value="{{old('video_url')}}" name="video_url">
                </div>

            </div>

            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="file"><b>Video</b></label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <input type="file" accept="video/mp4,video/x-m4v,video/*" name="video" id="video" class="form-control" value="{{old('video')}}">
                    File must be in mp4 format. Maximum file size 100MB
                </div>
            </div>
            <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                <div class="col-lg-4 col-md-4 col-sm-4">
                    <label for="display_order"><b>Display Order</b> <span style="color: red;">*</span><label>
                </div>
                <div class="col-md-6 col-lg-6 col-sm-6">
                    <input type="number" value="9999" min="0" name="display_order" id="display_order" class="form-control" required>
                </div>
            </div>
            <div class="col-lg-12 col-sm-12 col-md-12 ml-4 mt-4">
                <button type="submit" class="ml-2 btn btn-primary">Save</button>
                <a href="{{ route('admin.products') }}" type="submit" class="btn btn-danger">Cancel</a>
            </div>
        </div>
        </form>
    </div>
</div>
<!--col-->
</div>
<!--row-->
</div>
</div>
@endsection

@push ('after-scripts')
<script type="text/javascript">
    $(document).ready(function() {
        var type = $('#type').val();
        if (type == "physical") {
            $('#physical').css('display', 'block');
        } else {
            $('#physical').css('display', 'none');
        }
        $('#type').on('change', function() {
            var type = $('#type').val();
            if (type == "physical") {
                $('#physical').css('display', 'block');
            } else {
                $('#physical').css('display', 'none');
            }
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#short_desc_en').keyup(function() {
            var head_text_length = $('#short_desc_en').val().length;
            var text_remaining = 500 - head_text_length;
            // alert(head_text_length);
            $('#brief_desc_count').html(head_text_length + ' / ' + 500);
        });

        $('#short_desc_fr').keyup(function() {
            var head_text_length = $('#short_desc_fr').val().length;
            var text_remaining = 500 - head_text_length;
            // alert(head_text_length);
            $('#brief_desc_count_fr').html(head_text_length + ' / ' + 500);
        });

        $('#short_desc_it').keyup(function() {
            var head_text_length = $('#short_desc_it').val().length;
            var text_remaining = 500 - head_text_length;
            // alert(head_text_length);
            $('#brief_desc_count_it').html(head_text_length + ' / ' + 500);
        });

        $('#short_desc_es').keyup(function() {
            var head_text_length = $('#short_desc_es').val().length;
            var text_remaining = 500 - head_text_length;
            // alert(head_text_length);
            $('#brief_desc_count_es').html(head_text_length + ' / ' + 500);
        });

        $('#short_desc_de').keyup(function() {
            var head_text_length = $('#short_desc_de').val().length;
            var text_remaining = 500 - head_text_length;
            // alert(head_text_length);
            $('#brief_desc_count_de').html(head_text_length + ' / ' + 500);
        });

        $('#short_desc_pt').keyup(function() {
            var head_text_length = $('#short_desc_pt').val().length;
            var text_remaining = 500 - head_text_length;
            // alert(head_text_length);
            $('#brief_desc_count_pt').html(head_text_length + ' / ' + 500);
        });
    });
</script>
@endpush