@extends('backend.layouts.app')
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush
@section('title', "Edit Product")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-8">
                <h4 class="card-title mb-0">
                    Edit Product
                </h4>
            </div>
            <!--/.col-->
        </div>
      
         <ul class="nav nav-tabs" id="myTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="basic-tab" data-bs-toggle="tab" data-bs-target="#basic" type="button" role="tab" aria-controls="basic" aria-selected="true"> Product Details</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="curriculum-tab" data-bs-toggle="tab" data-bs-target="#curriculum" type="button" role="tab" aria-controls="curriculum" aria-selected="false"> Media</button>
            </li>
        </ul>
        <!--/.row-->
        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade show active" id="basic" role="tabpanel" aria-labelledby="basic-tab">
                    <form action="{{route('admin.products.update-product')}}" method="post">
                        @csrf
                        <input type="hidden" name="slug" value="{{$product_det->slug}}">
                        <div class="col-lg-12 col-sm-12 col-md-12">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="title_en"><b>Title</b> <span style="color: red;">*</span></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="title" value="{{$product_det->title}}" name="title" required>             
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="type"><b>Type</b> <span style="color: red;">*</span> </label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <select class="form-control form-select" id="type" name="type">
                                    <option value="digital" @if($product_det->type == "digital") selected @endif>Digital/Service</option>                                    
                                    <option value="physical" @if($product_det->type == "physical") selected @endif>Physical</option>
                                </select>
                            </div>
                        </div>


                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="category"><b>Category</b> <span style="color: red;">*</span> </label>
                            </div>
                           
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <select class="form-control select2" id="multiselect" multiple="multiple" name="category[]" required>
                                <?php 
                                    for ($i=0; $i < count($categories); $i++) { ?>
                                       <option value="<?=$categories[$i]->id?>" <?php
                                       foreach ($product_cat as $cat) {
                                           if($cat->category_id == $categories[$i]->id){ ?>
                                           selected
                                           <?php }
                                       }
                                        ?> ><?=$categories[$i]->title?></option>
                                       <?php 
                                       if (isset($subcategories[$i])) {
                                           for ($j=0; $j < count($subcategories); $j++) { 
                                                if ($subcategories[$j]->parent == $categories[$i]->id) {
                                                    ?>
                                                <option value="<?=$subcategories[$j]->id?>"
                                                <?php
                                                    foreach ($product_cat as $cat) {
                                                        if($cat->category_id == $subcategories[$j]->id)
                                                    { 
                                                    ?> 
                                                        selected
                                                <?php }
                                                    }
                                                ?> 
                                                    ><?=$categories[$i]->title?> >> <?=$subcategories[$j]->title?></option>
                                            <?php }
                                            }
                                       }
                                       ?>
                                <?php    }
                                ?>
                              </select>
                            </div>
                        </div>
                        <input type="hidden" name="currency" value="{{config('app.currency_symbol')}}">
                        {{-- <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="currency"><b>Currency</b> <span style="color: red;">*</span> </label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <select class="form-control" id="currency" name="currency">
                                    @foreach($currency as $cur)
                                    <option value="{{$cur->code}}" @if($product_det->currency == $cur->code) selected @endif>{{$cur->symbol}} {{$cur->code}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div> --}}

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="type"><b>Price</b> <span style="color: red;">*</span> </label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="number" class="form-control" id="price" value="{{$product_det->price}}" name="price" required>    
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="type"><b>Offer Price</b> </label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="number" class="form-control" id="offer_price" value="{{$product_det->offer_price}}" name="offer_price" >    
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                    <label for="has_downloads"><b>Has Downloads</b> <span style="color: red;">*</span></label>
                                </div>
                                <div class="col-md-6 col-lg-6 col-sm-6">
                                    <select class="form-control form-select" id="has_downloads" name="has_downloads">
                                        <option value="1" @if($product_det->has_downloads == "1") selected  @endif>Yes</option>
                                        <option value="0" @if($product_det->has_downloads == "0") selected  @endif>No</option>
                                    </select>
                                </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                                <div class="col-lg-6 col-md-6 col-sm-6">
                                    <label for="short_desc"><b>Short Description</b> <span style="color: red;">*</span>
                                </label>
                                    <span class="float-right" id="brief_desc_count"></span>
                                </div>
                                <div class="col-md-6 col-lg-6 col-sm-6">
                                    <textarea class="form-control" id="short_desc" name="short_desc" rows="5" maxlength="500" required>{{$product_det->short_desc}}</textarea>
                                </div>
                        </div>
                        

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="details_en"><b>Details</b></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <textarea class="form-control textarea_editor" name="details" rows="7" maxlength="500">{{$product_det->details}}</textarea>
                            </div>
                        </div>

                        <div id="physical" class="col-lg-12 col-sm-12 col-md-12 mt-4" style="padding: 0; display: none;">
                          <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="dimension"><b>Dimension</b></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="dimension" value="{{$product_det->dimension}}" name="dimension">
                            </div>
                          </div>

                         <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="color"><b>Color</b></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="color" value="{{$product_det->color}}" name="color">
                            </div>
                         </div>

                         <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="brand"><b>Brand</b></label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="brand" value="{{$product_det->brand}}" name="brand">
                            </div>
                         </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="weight"><b>Weight</b>&nbsp;&nbsp; (In K.G)</label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="weight" value="{{$product_det->weight}}" name="weight">
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="stock"><b>Stock</b> (For Unlimited Enter -1)</label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="number" class="form-control" id="stock" value="{{$product_det->stock}}" name="stock">
                            </div>
                        </div>
                        </div>
                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                                <div class="col-lg-4 col-md-4 col-sm-4">
                                    <label for="status"><b>Status</b> <span style="color: red;">*</span></label>
                                </div>
                                <div class="col-md-6 col-lg-6 col-sm-6">
                                    <select class="form-control form-select" id="status" name="status">
                                        <option value="pending_approval" @if($product_det->status == "pending_approval") selected @endif>Pending Approval</option>
                                        <option value="disapproved" @if($product_det->status == "disapproved") selected @endif>Disapproved</option>
                                        <option value="enabled" @if($product_det->status == "enabled") selected @endif>Enabled</option>
                                        <option value="disabled" @if($product_det->status == "disabled") selected @endif>Disabled</option>
                                    </select>
                                </div>
                        </div>
                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="display_order"><b>Display Order</b> <span style="color: red;">*</span><label>
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="number" value="{{$product_det->order}}" min="0" name="display_order" id="display_order" class="form-control" required>
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12 col-md-12 ml-4 mt-4">
                            <button type="submit" class="ml-2 btn btn-primary">Save</button>
                            <a href="{{ route('admin.products') }}" type="submit" class="btn btn-danger">Cancel</a>
                        </div>
                    </form>
                </div>
                <div class="tab-pane fade" id="curriculum" role="tabpanel" aria-labelledby="curriculum-tab">
                    <form action="{{route('admin.products.upload-products-images')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" value="{{$product_det->id}}">
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="file"><b>Featured Image</b> <span style="color: red;">*</span></label>
                            </div>
                            <div class="m-2">
                                <img src="{{asset('storage/products/'.$featured_img->filename)}}" style="width: 350px;">
                            </div>
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="file" name="featured_img" id="file" class="form-control" value="{{old('featured_img')}}">
                                Extensions: .png, .jpg, .jpeg, .gif, .svg
                            </div>
                        </div>

                        <div class="col-lg-8 col-sm-12 col-md-8 mt-4"> 
                            <div class="col-lg-8 col-sm-12 col-md-8 mt-4">
                                <label>Additional Images</label>
                            </div>
                            
                            @foreach($addtional_imgs as $img)
                                <img src="{{asset('storage/products/'.$img->filename)}}" style="width: 150px"><a href="{{route('admin.products.removeimg',[$img->filename,$product_det->slug])}}" class="btn btn-danger btn-sm" style="position: absolute;margin-left: -26px;">&times;</a>
                            @endforeach
                        </div>
                        <div class="col-lg-8 col-sm-12 col-md-8 mt-4">
                            <div class="wrapper">
                              <div class="drop" style="height: 200px;border: 3px dashed rgb(218, 223, 227);background: transparent;position: inherit;">
                                <div class="cont">
                                  <i class="fa fa-cloud-upload"></i>
                                  <h5>Choose or Drag & Drop Files</h5>
                                  <div class="browse">
                                    click here to browse
                                  </div>
                                </div>
                                <output id="list"></output><input id="files" multiple="true" name="files[]" type="file" />
                              </div>
                        </div>
                        </div>
                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="file"><b>Video Url</b></label>
                            </div>
                            @if(isset($videourl))
                            <a href="{{$videourl->filename}}" style="margin-left: 15px;">{{$videourl->filename}}</a>
                            @endif
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="text" class="form-control" id="video_url" @if(isset($videourl)) value="{{$videourl->filename}}"  @endif name="video_url">
                            </div>
                        </div>
                        <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                            <div class="col-lg-4 col-md-4 col-sm-4">
                                <label for="file"><b>Video</b></label>
                            </div>
                            @if(isset($video))
                            <div>
                                <iframe width="200" height="200" src="{{asset('storage/products/'.$video->filename)}}" title="YouTube video player" frameborder="0" style="height: 300px !important;width: 300px !important" ></iframe>
                            </div>
                            @endif
                            <div class="col-md-6 col-lg-6 col-sm-6">
                                <input type="file" accept="video/mp4,video/x-m4v,video/*" name="video" id="video" class="form-control" value="{{old('video')}}">
                                File must be in mp4 format. Maximum file size 100MB
                            </div>
                        </div>
                        <div class="col-lg-12 col-sm-12 col-md-12 ml-4 mt-4">
                            <button type="submit" class="ml-2 btn btn-primary">Save</button>
                            <a href="{{ route('admin.products') }}" type="submit" class="btn btn-danger">Cancel</a>
                        </div>
                    </div>
                </form>
                </div>
            </div>
    </div>
</div>
@endsection

@push('after-styles')
<style type="text/css">
    /* .wrapper {
  width: 100%;
  height: 100%;
}
.drop {
  width: 96%;
  height: 96%;
  border: 3px divashed #DADFE3;
  border-radius: 15px;
  overflow: hidden;
  text-align: center;
  background: white;
  -webkit-transition: all 0.5s ease-out;
  -moz-transition: all 0.5s ease-out;
  transition: all 0.5s ease-out;
  margin: auto;
  position: absolute;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;

}
.drop .cont {
  width: 500px;
  height: 170px;
  color: #8E99A5;
  -webkit-transition: all 0.5s ease-out;
  -moz-transition: all 0.5s ease-out;
  transition: all 0.5s ease-out;
  margin: auto;
  position: absolute;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
} */
/* .drop .cont i {
  font-size: 400%;
  color: #8E99A5;
  position: relative;
}
.drop .cont .tit {
  font-size: 400%;
  text-transform: uppercase;
}
.drop .cont .desc {
  color: #A4AEBB;
}
.drop .cont .browse {
  margin: 10px 25%;
  color: white;
  padding: 8px 16px;
  border-radius: 5px;
  background: #09f;
}
.drop input {
  width: 100%;
  height: 100%;
  cursor: pointer;
  background: red;
  opacity: 0;
  margin: auto;
  position: inherit;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
} */

/* #list {
  width: 100%;
  text-align: left;
  position: absolute;
  left: 0;
  top: 0;
}
#list .thumb {
  height: 75px;
  border: 1px solid #323a44;
  margin: 10px 5px 0 0;
} */
</style>
@endpush

@push ('after-scripts')
<script type="text/javascript">
    var drop = $("input");
drop.on('dragenter', function (e) {
  $(".drop").css({
    "border": "4px dashed #09f",
    "background": "rgba(0, 153, 255, .05)"
  });
  $(".cont").css({
    "color": "#09f"
  });
}).on('dragleave dragend mouseout drop', function (e) {
  $(".drop").css({
    "border": "3px dashed #DADFE3",
    "background": "transparent"
  });
  $(".cont").css({
    "color": "#8E99A5"
  });
});



function handleFileSelect(evt) {
  var files = evt.target.files; // FileList object

  // Loop through the FileList and render image files as thumbnails.
  for (var i = 0, f; f = files[i]; i++) {

    // Only process image files.
    if (!f.type.match('image.*')) {
      continue;
    }

    var reader = new FileReader();

    // Closure to capture the file information.
    reader.onload = (function(theFile) {
      return function(e) {
        // Render thumbnail.
        var span = document.createElement('span');
        span.innerHTML = ['<img class="thumb" src="', e.target.result,
                          '" title="', escape(theFile.name), '"/>'].join('');
        document.getElementById('list').insertBefore(span, null);
      };
    })(f);

    // Read in the image file as a data URL.
    reader.readAsDataURL(f);
  }
}
$('#files').change(handleFileSelect);
</script>

<script type="text/javascript">
$(document).ready(function() {

       var type = $('#type').val();
        if(type == "physical"){
            $('#physical').css('display','block');
        }else{
            $('#physical').css('display','none');
        }
    $('#type').on('change',function(){
        var type = $('#type').val();
        if(type == "physical"){
            $('#physical').css('display','block');
        }else{
            $('#physical').css('display','none');
        }
    });


});
</script>

<script type="text/javascript">
    $('#short_desc').keyup(function() {
      var head_text_length = $('#short_desc').val().length;
      var text_remaining = 500 - head_text_length;
      $('#brief_desc_count').html(head_text_length + ' / ' + 500);
    });

</script>
@endpush
