@extends('backend.layouts.app')
@section('title', "Products")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Products
                </h4>
            </div><!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Product"  style="margin-top: 20px;float: right;"> 
                    <a href="{{ route('admin.products.create-product') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Product"><i class="bi bi-plus-circle"></i> Create</a>
                </div><!--btn-toolbar-->
            </div><!--col-->            
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="products-table">
                        <thead class="dker">
                            <tr>
                                <th>#</th>
                                <th>Title</th>
                                <th>Type</th>
                                <th>Category</th>
                                <th>Price</th>
                                <th>Offer Price</th>
                                <th>Created At</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                    </table>
                </div>
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection      

@push ('after-scripts')
<!-- DataTables Core and Extensions -->
<script type="text/javascript">

    $('#products-table').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        ajax: '{{ route("admin.products.products-list") }}',
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'title',name:'title'},
            {data: 'type', name: 'type'},
            {data: 'category', name: 'category'},
            {data: 'price', name: 'price'},
            {data: 'offer_price', name: 'offer_price'},
            {data: 'created_at', name: 'created_at',"visible": false,
                "searchable": false},
            {data: 'action', name: 'action', orderable: false, searchable: false}
        ]
    });


</script>
@endpush
