@extends('backend.layouts.app')
@section('title', "Associated Downloads")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Associated Downloads
                </h4>
            </div>
            <!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Course Info Page" style="margin-top: 20px;float: right;">
                    <a href="{{route('admin.products')}}" class="btn btn-warning"><i class="fas fa-reply"></i></a>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table id="downloads-table" class="table table-hover ">
                        <thead>
                            <tr>
                                <th style="text-align: center;">Name</th>
                                <th style="text-align: center;">Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="row mt-4">
            <div class="col">
                <hr>
                <h4>Associate New Downloads</h4>
                <form action="{{route('admin.products.associate-downloads')}}" method="post">
                    @csrf
                    <input type="hidden" name="product_id" value="{{$product_det->id}}">

                    <div class="col-lg-12 col-sm-12 col-md-12 mt-4">
                        <div class="col-lg-4 col-md-4 col-sm-4">
                            <label for="product"><b>Select Product</b> <span style="color: red;">*</span></label>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-6" style="display: flex;">
                            <select class="form-control form-select" id="product" name="download" required>
                                <option value="">Select a Downloadable</option>
                                @foreach($products as $product)
                                <option value="{{$product->id}}">{{$product->name}}</option>
                                @endforeach
                            </select>
                            <div class="col-md-6 col-lg-6 col-sm-6" style="padding: 6px 0 0 6px;">
                                <a href="{{route('admin.downloads-management')}}">Manage Downloads&gt;&gt;</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-12 col-md-12 ml-4 mt-4">
                        <button type="submit" class="ml-2 btn btn-primary">Add</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push ('after-scripts')
<!-- DataTables Core and Extensions -->
<script type="text/javascript">
    $('#downloads-table').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        ajax: '{{ route("admin.products.downloads-list",[$product_det->slug]) }}',
        columns: [{
                data: 'name',
                name: 'name'
            },
            {
                data: 'action',
                name: 'action',
                orderable: false,
                searchable: false
            }
        ],
        columnDefs: [{
            "targets": 0,
            "className": "text-center",
        }, {
            "targets": 1,
            "className": "text-center",
        }],
    });
</script>
@endpush