<!DOCTYPE html>
<html>
    <head>
        <title>{{ $user->name }}</title>
        <style type="text/css">
            body {
                font-family: "dejavu sans", serif;
                color: #121212;
                font-size: 12px;
            }
            th {
                font-weight: 600;
            }
            .bordered th, td {
                border: 1px solid rgb(212, 212, 212);
                border-collapse: collapse;
            }
        </style>        
    </head>
    <body>
        <h2>User Profile</h2>
        <table style="width:100%;" >
            {{-- <tr>
                <td style="padding-bottom:12px;width:30%;color:#777777;">Title</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ $user->title }}</td>
            </tr>                 --}}
            <tr>
                <td style="padding-bottom:12px;padding-left:20px;width:30%;color:#777777;">First Name</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ $user->first_name }}</td>
            </tr>
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Middle Name</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">@if($user->middle_name) {{ $user->middle_name }} @else -- @endif</td>
            </tr>
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Last Name</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">@if($user->last_name) {{ $user->last_name }} @else -- @endif</td>
            </tr>
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Gender</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">@if($user->gender) {{ ucfirst($user->gender) }} @else -- @endif</td>
            </tr>  
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Marital status</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails)? ucwords($userDetails->marital_status) : '' }}</td>
            </tr> 
            <tr
                @if ($userDetails) 
                    @if ($userDetails->marital_status != 'married') 
                        style="display:none;" 
                    @else 
                        style="" 
                    @endif
                @else 
                    style="display:none;" 
                @endif >
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Date of Marriage</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails)? date('d-m-Y', strtotime($userDetails->date_of_marriage)) : '' }}</td>
            </tr> 
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">E-mail</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">@if($user->email) {{ $user->email }} @else -- @endif</td>
            </tr>
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Date of Birth</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">@if($user->birthday) {{date("d-m-Y", strtotime($user->birthday))}}@else -- @endif</td>
            </tr>
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Mobile</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">@if($user->dialcode) +{{ $user->dialcode }}-@endif{{ $user->mobile }}</td>
            </tr>
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Whatsapp</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                    @if($user->whatsapp)
                        @if($user->dialcode) +{{ $user->dialcode }}-@endif{{ $user->whatsapp }}
                    @else
                        <br>--
                    @endif
                </td>
            </tr>
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Alternate Contact</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                    @if($user->whatsapp)
                        @if($user->dialcode) +{{ $user->dialcode }}-@endif{{ $user->alternate_contact }}
                    @else
                        <br>--
                    @endif
                </td>
            </tr>
        </table>
        
        <table style="width:100%;">
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Interested Study Level</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($user && $user->overseas_study_level_selection)? $user->overseas_study_level_selection:'--' }}</td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Country Interested in</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                    @php
                            $show_country = "";
                            $country_interested = explode(",",$user->country_interested);
                        @endphp
                            @if(filter_var($country_interested[0], FILTER_VALIDATE_INT))
                                @foreach ($country_interested as $country) 
                                    @php
                                        $show_country .= get_country_name($country);
                                    @endphp
                                    @if(!$loop->last)
                                        $show_country .= ", ";
                                    @endif
                                @endforeach
                            @else
                                @php
                                    $show_country = $user->country_interested;
                                @endphp
                            @endif
                        {{-- {{ $user->country_interested ? $user->country_interested : '-' }} --}}
                        {{ $show_country }}
                </td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Course Interested to Study</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                    {{ $user->overseas_course_intersted ? $user->overseas_course_intersted : '-'}}
                </td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Intake</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                    @if($userDetails){{ $userDetails->intake_month ? date('F', mktime(0,0,0,$userDetails->intake_month)) : '-'}} {{ $userDetails->intake_year ? $userDetails->intake_year : '-'}} @endif
                </td>
            </tr>   
            @if(env('ADDITIONAL_SERVICES_ENABLE'))  
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Other Services Interested In</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">@if($user->services)
                    @php 
                            $service_interested = explode(",", $user->services);
                        @endphp
                        @foreach($service_interested as $interest)
                            @if(!$loop->last)
                                {{get_services($interest)}},
                            @else
                                {{get_services($interest)}}
                            @endif
                        @endforeach
                        @else
                        -
                        @endif
                </td>
            </tr>  
            @endif
        </table>

        <table style="width:100%;">
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Highest Level of Education</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails && $userDetails->highest_level_education)? ucfirst($userDetails->highest_level_education):'--' }}</td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Passout Year</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;"> 
                     {{ ($userDetails && $userDetails->passout_year)? $userDetails->passout_year:'--' }}</td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Score/Grade</td>
               
                
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
    {{ $userDetails->qualification_score ?? '' }}
</td>

            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Currently Studying Course</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails && $userDetails->current_course)? get_country_name($userDetails->current_course):'--' }}</td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Work Experience</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails && $userDetails->work_experience)? get_country_name($userDetails->work_experience):'--' }}</td>
            </tr>     
        </table>

        <table style="width:100%;">
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Nationality</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails && $userDetails->nationality)? get_country_name($userDetails->nationality):'--' }}</td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Citizenship</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails && $userDetails->citizenship)? get_country_name($userDetails->citizenship):'--' }}</td>
            </tr>     
            <tr>
                <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Country of Education</td>
                <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">{{ ($userDetails && $userDetails->country_of_education)? get_country_name($userDetails->country_of_education):'--' }}</td>
            </tr>      
        </table>

        {{-- //Dynamic inputs data --}}
        @if($userDetails->user_data_js != 'null' && $userDetails->user_data_js != '')
            <h4 class="">Additional Information</h4>
            <table style="width:100%;">
            <?php $attrData =  json_decode($userDetails->user_data_js, true); 
                if($user->is_lead){
                    $user_type = 'lead';
                }
                if(!$user->is_lead){
                    $user_type = 'student';
                }
            ?>
            @foreach($attrData as $key=>$att)
                @if(get_attr_label($key,$user_type) != '')
                    <tr>
                        <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">{{get_attr_label($key,$user_type)}}</td>
                        <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        @if(is_array($att))
                            @foreach($att as $att_arr)
                                {{$att_arr}}
                                @if( !$loop->last),
                                @endif
                            @endforeach
                        @else
                            {{($att)? $att : '--'}}
                        @endif
                        </td>
                    </tr> 
                @endif
            @endforeach   
            </table>
        @endif
        {{-- //Dynamic inputs data --}}

        @if($user->student_type!='course')
            {{-- <hr class="" style="height:2px;border-width:0;background-color:#b6b4b482"> --}}
            <h4 class="">Current Address</h4>
            <table style="width:100%;">
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Address</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($user->address_1!='')?$user->address_1:'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Country</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($user->country!='')?get_country_name($user->country):'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">State</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($user->state!='')?get_state_name($user->state):'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">City</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($user->city!='')?$user->city:'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Postal Code</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($user->post_code!='')?$user->post_code:'--' }}
                    </td>
                </tr>    
            </table>
            {{-- <hr class="" style="height:2px;border-width:0;background-color:#b6b4b482"> --}}
            <h4 class="">Permanent Address</h4>
            <table style="width:100%;">
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Address</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails)? $userDetails->permanent_address : '--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Country</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails)? get_country_name($userDetails->permanent_country) : '--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">State</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails)? get_state_name($userDetails->permanent_state) : '--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">City</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails)? $userDetails->permanent_city : '--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Postal Code</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails)? $userDetails->permanent_post_code : '--'}}
                    </td>
                </tr>    
            </table>
            
            <h4 class="">Passport Information</h4>
            <table style="width:100%;">
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Name (As in Passport)</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->name_passport)? $userDetails->name_passport : '--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Passport No.</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->passport_num)? $userDetails->passport_num : '--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Issue Date</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        @if($userDetails)
                        @if($userDetails->passport_issue_date) {{date("d-m-Y", strtotime($userDetails->passport_issue_date))}}@else
                        -- @endif
                        @else
                        --
                        @endif
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Expiry Date</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        @if($userDetails)
                        @if($userDetails && $userDetails->passport_expiry_date) {{date("d-m-Y", strtotime($userDetails->passport_expiry_date))}}@else
                        -- @endif
                        @else
                        --
                        @endif
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Issue Country</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails)? get_country_name($userDetails->passport_country): '--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">City of Birth</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->city_of_birth)? $userDetails->city_of_birth:'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Country of Birth</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails)? get_country_name($userDetails->country_of_birth) : '--' }}
                    </td>
                </tr>    
            </table>
            {{-- <hr class="" style="height:2px;border-width:0;background-color:#b6b4b482"> --}}
            <h4 class="">Nationality</h4>
            <table style="width:100%;">
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Is the applicant a citizen of more than one country?</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        @if($userDetails)
                        {{ ($userDetails->dual_citizenship==1)?'Yes':'No' }}@if($userDetails->dual_citizenship=='1') [{{get_country_name($userDetails->dual_citizenship_country)}}] @endif
                        @else
                        --
                        @endif
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Is the applicant living and studying in any other country?</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        @if($userDetails)
                        {{ ($userDetails->studying_abroad==1)?'Yes':'No' }}@if($userDetails->studying_abroad=='1') [{{get_country_name($userDetails->studying_abroad_country)}}] @endif
                        @else
                        --
                        @endif
                    </td>
                </tr>    
            </table>
            {{-- <hr class="" style="height:2px;border-width:0;background-color:#b6b4b482"> --}}
            <h4 class="">Background Info</h4>
            <table style="width:100%;">
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Has applicant applied for any type of immigration into any country?</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        @if($userDetails)
                        {{ ($userDetails && $userDetails->immigration==1)?'Yes':'No' }}@if($userDetails->immigration=='1') [{{get_country_name($userDetails->immigration_country)}}] @endif
                        @else
                        --
                        @endif
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Does applicant suffer from a serious medical condition?</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->medical_condition==1)?'Yes':'No' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Has applicant Visa refusal for any country?</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        @if($userDetails)
                            {{ ($userDetails->visa_refusal==1)?'Yes':'No' }}@if($userDetails->visa_refusal=='1') [{{get_country_name($userDetails->visa_refusal_country)}}] @endif
                        @else
                        --
                        @endif
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Has applicant ever been convicted of a criminal offence?</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->criminal_offence==1)?'Yes':'No' }}
                    </td>
                </tr>    
            </table>
            {{-- <hr class="" style="height:2px;border-width:0;background-color:#b6b4b482"> --}}
            <h4 class="">Emergency Contacts</h4>
            <table style="width:100%;">
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Name</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_name)? ucfirst($userDetails->emergency_name):'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Email</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_email)? ucfirst($userDetails->emergency_email):'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Phone</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_phone)? ucfirst($userDetails->emergency_phone):'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Relationship with Applicant</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_relation)? ucfirst($userDetails->emergency_relation):'--' }}
                    </td>
                </tr>    
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Address</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_address)? ucfirst($userDetails->emergency_address):'--' }}
                    </td>
                </tr> 
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Country</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_country)? get_country_name($userDetails->emergency_country):'--' }}
                    </td>
                </tr> 
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">State</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_state)? get_state_name($userDetails->emergency_state):'--' }}
                    </td>
                </tr> <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">City</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_city)? ucfirst($userDetails->emergency_city):'--' }}
                    </td>
                </tr> 
                <tr>
                    <td style="padding-bottom:12px;padding-left:15px;width:30%;color:#777777;">Postal Code</td>
                    <td style="padding-bottom:12px;padding-left:20px;font-size: 1.2em;">
                        {{ ($userDetails && $userDetails->emergency_postalcode)? ucfirst($userDetails->emergency_postalcode):'--' }}
                    </td>
                </tr> 
            </table>
        @endif
        <hr class="" style="height:2px;border-width:0;background-color:#b6b4b482; margin-top: 60px;">
    </body>
</html>
