@extends('backend.layouts.app')

@section('title', "Referral Payout Report")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0"> Referral Payout Report</h4>
            </div><!--col-->
        </div><!--row-->
        <p id="GFG_UP" style="font-size: 15px; font-weight: bold;">
        </p>
        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="student_data">
                        <thead>
                            <tr>
                                <th class="attend_data">SI No.</th>
                                <th class="attend_data">Date</th>
                                <th class="attend_data">Referrer</th>
                                <th class="attend_data">Amount</th>
                                <th class="attend_data">Notes</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(count($pages)>0)
                            <?php $slno = 1; ?>
                            @foreach($pages as $page)
                            <tr>
                                <td>{{$slno}}</td>
                                <td>{{$page->paid_at}}</td>
                                <td>{{get_user_name_by_id($page->user_id)}} ({{get_user_email_by_id($page->user_id)}})</td>
                                <td>Rs. {{ $page->debit }}</td>
                                <td>{{ $page->payment_notes }}</td>
                            </tr>
                            <?php $slno++; ?>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="5" class="text-center h4 p-5">No Data!</td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div><!--card-body-->
</div><!--card-->
@endsection

@push('after-styles')
<link href="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css" rel="stylesheet" type="text/css" />
<style>
    #batch_tbl_filter input {
        display: block;
        width: 100%;
        height: calc(2.0625rem + 2px);
        padding: 0.375rem 0.75rem;
        font-size: 0.875rem;
        font-weight: 400;
        line-height: 1.5;
        color: #5c6873;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #e4e7ea;
        border-radius: 0.25rem;
        transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
    }

    #batch_tbl_paginate {
        margin-top: 15px;
    }

    #batch_tbl_paginate a {
        margin-right: 5px;
        cursor: pointer;
        padding: 0.5rem 0.75rem;
        line-height: 1.25;
        border: 1px solid #c8ced3;
    }

    .dt-buttons {
        margin-bottom: 10px;
    }
</style>
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script>
    $(document).ready(function() {
        var table = $('#student_data').DataTable({
            "ordering": false,
        });
    });
</script>
@endpush