@extends('backend.layouts.app')

@section('title', "Referral Payouts")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0"> 
                    Referral Payout
                </h4>
            </div><!--col-->
        </div><!--row-->
        <form class="form-horizontal" method="POST" action="{{route('admin.referral.make-payout')}}">
            @csrf
            <div class="row mt-4">
                <label>Select Month</label>
                <div class="col-sm-12 col-md-2">
                    <select name="month" id="select_month" style="width:100%;" class='form-control form-select'>
                        <option value="">Select Month</option>
                            <?php 
                                $month = date('n',strtotime(date('Y-01-01')));
                                for ($i = 0; $i <= 12; $i++) { ?>
                                <option value="<?php echo date("Y-m", strtotime( date( 'Y-m-01' )." -$i months")); ?>" >
                            <?php echo date("F Y", strtotime( date( 'Y-m-01' )." -$i months"));
                            ?>
                            <?php } ?>
                        </option>
                    </select>
                </div>
                <div class="col-sm-12 col-md-2">
                    <button class="btn btn-primary btn-sm" onclick="javascript:filterReffs();" type="button" value="Continue">Continue </button>
                </div>
            </div>
            
            <div class="row mt-4">
                <div class="col lead-horizontal" >
                    <div class="">
                        <table class="table w-100" id="reff_list">
                            <thead>
                                <tr>
                                    <th style="padding-right: 10px !important;">Referer</th>
                                    <th>Pay Pref. Mode</th>
                                    <th>Pay Pref. Details</th>
                                    <th>No. of Referrals</th>
                                    <th>Reward</th>
                                </tr>
                            </thead>
                            <tfoot style="display: none;">
                                <tr>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th style="text-align:right">Total:</th>
                                    <th></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
                <div class="col-md-12 process-selected" style="display: none;">
                    <div class="float-end">
                        <p id="total_display"></p>
                        <button class="btn btn-primary btn-sm" type="submit" id="create_btn" value="create">Make Payout</button>
                    </div>
                    <div class="float-left">
                        <span class="text-center" id="error_msg"></span>
                    </div>
                </div>
            </div>
        </form>  
</div>
</div>
@endsection
@push('after-styles')
<style>

</style>
@endpush

@push('after-scripts')
<script>
    function loadData(myleads) {
        $('#reff_list').DataTable({
            "dom": '<"row"<"col-md-3 text-start"><"col-md-5 text-start"><"col-md-4 text-end"B>>',
            "fnFooterCallback": function( nFoot, aData, iStart, iEnd, aiDisplay ) {
            var table = $('#reff_list').DataTable(); // Get DataTables instance
            var grandTotal = 0;
            // Loop through visible rows (all rows if no filtering)
            for (var i = 0; i < aiDisplay.length; i++) {
            var rowIndex = aiDisplay[i];
            var rowData = table.row(rowIndex).data(); // Get data for the current row
            var [currency, reward] = rowData['reward'].split(' ');
            var amt = parseFloat(reward); // Extract value from "Total Price" column (6 is the column index)
            grandTotal += amt;
            }
            if(grandTotal){
                // Update footer
                table.column(4).footer().innerHTML = currency+' '+ grandTotal;
                $('#total_display').html("<b>Total:</b> "+currency+' '+ grandTotal);
            }else{
                $('#total_display').html("");
                $(".process-selected").hide();
            }
            },
            "processing": true,
            "pageLength": 1000,
            //"paging": false,
            //"ordering": false,
            "searching": false,
            "serverSide": true,
            "autoWidth": true,
            "responsive": true,
            "ajax": {
                "url": "{{route('admin.referral.getReferrals')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'month': $('#select_month').val(),
                },
                dataSrc: function (json){
                if(json.payment_status){
                    $("#error_msg").html("<h3 class='text-danger'>Payout already processed for this month.</h3>");
                    $("#create_btn").prop("disabled",true);
                    $(".process-selected").show();
                }else{
                    $("#error_msg").html("");
                    $("#create_btn").prop("disabled",false);
                    $(".process-selected").show();
                }
                 return json.data ;
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
                $('#bulk_operation').show();                
            },
            columns: [
                {
                    data: 'referer',
                },
                {
                    data: 'payment_mode',
                    orderable: false,
                },
                {
                    data: 'payment_details',
                },
                {
                    data: 'no_of_reffs',
                },
                {
                    data: 'reward',
                },
            ],
            "buttons": [
                {
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: true,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: true,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: true,
                    header: true,
                    orientation: 'landscape',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: true,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: true,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
            ]
        });
    }

function filterReffs() {
        if(document.getElementById('select_month').value == ''){
            alert("Please select Month");
            document.getElementById('select_month').focus();
        }
        else{
            $("#reff_list").dataTable().fnDestroy();
            loadData();
        }
    }
</script>
@endpush
