@extends('backend.layouts.app')

@section('title', "Referral Payouts")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0"> 
                    Referral Payouts
                </h4>
            </div><!--col-->
        </div><!--row-->
<div class="row mt-4">
    <div class="col">
        <div>
            <table class="table" id="reff_table">
                <thead>
                    <tr>
                        <th>SL No.</th>
                        <th>Referer</th>
                        <th>Payment Preferences</th>
                        <th>Amount</th>
                        <th>Payment Notes</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $slno = 1; ?>
                    @foreach($reffs as $reff)                     
                    <tr>
                        <form action="{{route('admin.referral-payout-mark-paid')}}" method="POST">
                            @csrf
                        <input type="hidden" name="payout_id" value="{{$reff->id}}">
                        <td>{{$slno}}</td>
                        <td>{{get_user_name_by_id($reff->user_id)}} ({{get_user_email_by_id($reff->user_id)}})</td>
                        <td>
                            Mode: {{strtoupper(get_user_by_id($reff->user_id)->payment_pref_mode)}}
                            <br>
                            {{get_user_by_id($reff->user_id)->payment_pref_detail}}
                        </td>
                        <td>Rs.{{$reff->debit}}</td>
                        <td><textarea name="payment_notes"></textarea></td>
                        <td><button type="submit" onclick="return confirm('Are you sure?')" class="btn btn-sm btn-secondary">Mark Paid</button></td>
                        </form>
                    </tr>
                    <?php $slno++; ?>
                    @endforeach  
                </tbody>
            </table>
        </div>
    </div> 
</div>    
</div><!--card-body-->
</div><!--card-->
@endsection
@push('after-styles')
<style>
     #reff_table_filter input {
        display: block;
        width: 100%;
        height: calc(2.0625rem + 2px);
        padding: 0.375rem 0.75rem;
        font-size: 0.875rem;
        font-weight: 400;
        line-height: 1.5;
        color: #5c6873;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #e4e7ea;
        border-radius: 0.25rem;
        transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;        
    }
    #reff_table_paginate {
        float: right;
        margin-top: 15px;
    }    
    #reff_table_paginate a {
        margin-right: 5px;
        cursor: pointer;
        padding: 0.5rem 0.75rem;
        line-height: 1.25;
        border: 1px solid #c8ced3;        
    }
</style>
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script>
$(document).ready(function ()
{
    var table = $('#reff_table').DataTable({
        "ordering": false,
        'searching': false
    });
});
</script>
@endpush
