@extends('backend.layouts.app')

@section('title', "Referral Rewards")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0"> 
                    Referral Rewards
                </h4>
            </div><!--col-->
        </div><!--row-->
<div class="row mt-4">
    <div class="col">
        <div>
            <table class="table" id="reff_table">
                <thead>
                    <tr>
                        <th>SL No.</th>
                        <th>Date</th>
                        <th>Referer</th>
                        <th>Clients</th>
                        <th>Amount Credit</th>
                        <th>Debit</th>
                        <th>Notes</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $slno = 1; ?>
                    @foreach($reffs as $reff)                     
                    <tr>
                        <td>{{$slno}}</td>
                        <td>{{$reff->created_at}}</td>
                        <td>{{get_user_name_by_id($reff->user_id)}} ({{get_user_email_by_id($reff->user_id)}})</td>
                        <td>{{get_user_name_by_id($reff->student_id)}} ({{get_user_email_by_id($reff->student_id)}})</td>
                        <td>Rs.{{$reff->credit}}</td>
                        <td>Rs.{{$reff->debit}}</td>
                        <td>@if($reff->payment_notes){{$reff->payment_notes}}@else {{$reff->notes}} @endif</td>
                    </tr>
                    <?php $slno++; ?>
                    @endforeach  
                </tbody>
            </table>
        </div>
    </div> 
</div>    
</div><!--card-body-->
</div><!--card-->
@endsection
@push('after-styles')
<style>
     #reff_table_filter input {
        display: block;
        width: 100%;
        height: calc(2.0625rem + 2px);
        padding: 0.375rem 0.75rem;
        font-size: 0.875rem;
        font-weight: 400;
        line-height: 1.5;
        color: #5c6873;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #e4e7ea;
        border-radius: 0.25rem;
        transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;        
    }
    #reff_table_paginate {
        float: right;
        margin-top: 15px;
    }    
    #reff_table_paginate a {
        margin-right: 5px;
        cursor: pointer;
        padding: 0.5rem 0.75rem;
        line-height: 1.25;
        border: 1px solid #c8ced3;        
    }
</style>
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script>
$(document).ready(function ()
{
    var table = $('#reff_table').DataTable({
        "ordering": false,
        'searching': false
    });
});
</script>
@endpush
