@extends('backend.layouts.app')

@section('title', "Student Referral Signups")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0"> 
                    Student Referral Signups
                </h4>
            </div>
        </div>
        <div class="row mt-4">
            <div class="col">
                <div>
                    <table class="table" id="datatable">
                        <thead>
                            <tr>
                                <th>SI No.</th>
                                <th>Date</th>
                                <th>Name</th>
                                {{-- <th>Email</th>
                                <th>Mobile</th> --}}
                                <th>Refered By</th>
                                <th>Commission</th>
                                <th style="min-width: 105px !important;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $slno = 1; ?>
                            @foreach($users as $user)                     
                            <tr>
                                <td>{{$slno}}</td>
                                <td>{{get_date_time_formated($user->created_at)}}</td>
                                <td><a target="_blank" href="{{route('admin.auth.user.show', $user->uid)}}"><b>{{$user->user_full_name}}</b></a>
                                    <p>ID: {{$user->uid}}</p>
                                </td>
                                <td><a target="_blank" href="{{route('admin.auth.user.show', $user->rid)}}"><b>{{$user->referred_by}}</b></a>
                                    <p>ID: {{$user->rid}}</p>
                                </td>
                                <td>@if($user->commission){{config('app.currency_symbol')}}{{$user->commission}}@else -- @endif</td>
                                <td>
                                    {{-- @if($user->ref_status)
                                        <button class="btn btn-sm btn-success disabled" data-id='{{$user->uid}}'>Confirmed</button>
                                    @else --}}
                                <button class="btn btn-sm btn-primary confirmed-btn" name="confirm_item" data-id='{{$user->uid}}'>Set/Update Commission</button>
                                    {{-- @endif --}}
                                </td>
                            </tr>
                            <?php $slno++; ?>
                            @endforeach  
                        </tbody>
                    </table>
                </div>
            </div> 
        </div>    
    </div>
</div>

<div class="modal fade" id="confirmedAmountModal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Set/Update Referral Amount</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="font-size: 50px;"></button>
            </div>
            <div class="modal-body load_modal">

            </div>
        </div>
    </div>
</div>
@endsection

@push ('after-scripts')
<script type="text/javascript">
    $(document).ready(function() {  
        $(document).on('click', '.confirmed-btn', function() {
            var this_id = $(this).attr('data-id');
            var base_url = "{{ url('admin/referral-signups/status-update/model/')}}/" + this_id;
            $.get(base_url, function(data) {
                $('#confirmedAmountModal').on('shown.bs.modal', function() {
                    $('#confirmedAmountModal .load_modal').html(data);
                });
                $('#confirmedAmountModal').modal('show');
                $('#confirmedAmountModal').on('hidden.bs.modal', function() {
                    $('#confirmedAmountModal .load_modal').html("");
                });
            });
        });
    });
</script>
@endpush

@push('after-styles')
<style>
     /* #datatable_filter input {
        display: block;
        width: 100%;
        height: calc(2.0625rem + 2px);
        padding: 0.375rem 0.75rem;
        font-size: 0.875rem;
        font-weight: 400;
        line-height: 1.5;
        color: #5c6873;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #e4e7ea;
        border-radius: 0.25rem;
        transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;        
    }
    #datatable_paginate {
        float: right;
        margin-top: 15px;
    }    
    #datatable_paginate a {
        margin-right: 5px;
        cursor: pointer;
        padding: 0.5rem 0.75rem;
        line-height: 1.25;
        border: 1px solid #c8ced3;        
    } */
</style>
@endpush

@push('after-scripts')
{{-- <script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script> --}}
<script>
$(document).ready(function ()
{
    var table = $('#datatable').DataTable({
        "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',
        "ordering": false,
        'searching': true,
        "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
            ]
    });
});
</script>
@endpush
