@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div>
   <?php $count = get_pending_masters_setup(); ?>
    {{-- #fc7899 succes-card border:2px solid rgb(34, 212, 146);--}}
    @if($count == 0)
        <div class="rounded mb-3" style="background-color: #d4edda; padding:10px 10px 0 0">
            <div class="card-body px-3" style="padding-bottom: 1px">
                <h4 style="color: #276534; ">Master Setup</h4>
                <p style="color: #276534;">Great! You have completed the setup</a></p>
            </div>
        </div>
    @else
        <div class="rounded mb-3" style=" background-color: #F8D7DA;padding:10px 10px 0 0">
            <div class="px-3" style="padding-bottom: 1px">
                <h4 style="color: #7F2E36;">Master Setup</h4>
                <p style="color: #7F2E36;">You have {{get_pending_masters_setup()}} Pending Steps &nbsp; <a href="{{route('admin.master-setup')}}" style="text-decoration:underline">Complete Steps
                <svg width="15px" fill="white" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="#7F2E36" d="M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"/></svg>
                </a></p>
            </div>
        </div>
    @endif                 
</div>

<div class="card">
    <div class="card-body pt-3">
        <div class="row">
            <div class="col" style="margin-bottom:10px;">
                <h4 style="">Settings</h4>
            </div>
        </div>
        <!-- Bordered Tabs -->
        <div class="row">
            <div class="col-2">
                <ul class="nav flex-column nav-tabs nav-tabs-bordered settingsNav">
                    {!!get_settings_tabs('settings')!!}
                </ul>
            </div>

            <div class="col-10">
                <div class="tab-content pt-4">

                    <div class="tab-pane fade general show active" id="general">

                        <form class="row g-3" action="{{route('admin.settings.general')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="" class="form-label required-field" style="font-size: 15px;">App Name</label>
                                    <input type="text" name="app_name" class="form-control" value="{{get_site_config('app_name')}}" required>
                                    <span style="font-size:0.9em;">Your website/application name</span>
                                </div>
                                <div class="col-md-6">
                                    <label for="" class="form-label" style="font-size: 15px;">Contact Phone No.</label>
                                    <input type="text" name="contact_phone" class="form-control" value="{{get_site_config('contact_phone')}}">
                                    <label for="" class="form-label" style="font-size: 15px;">Email ID</label>
                                    <input type="text" name="contact_email" class="form-control" value="{{get_site_config('contact_email')}}">
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-6">
                                    <label for="" style="font-size: 15px;" class="form-label">Website Logo</label><br>
                                    @if(get_site_config('website_logo'))
                                    <img src="{{ url('storage/'.get_site_config('website_logo')) }}" alt="Current logo" style="height:70px;padding:8px 0px 10px">
                                    @endif
                                    <input class="" type="file" name="website_logo_file">
                                    <br />
                                    <span style="font-size:0.9em;">Allowed file types: png, jpg, gif, svg<br />
                                    File size must not exceed 500KB<br />
                                    Image less than 400px width is preferred
                                    </span>
                                    <br />
                                    <div class="input-group w-50">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="padding: 5px;font-size: 15px;">Logo Height (px)</span>
                                        </div>
                                        <input type="number" name="website_logo_ht" class="form-control" placeholder="Logo Height" value="{{get_site_config('website_logo_ht')}}">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="" style="font-size: 15px;" class="form-label">Website Sticky Logo (Used in Student Panel, Mobile View)</label><br>
                                    @if(get_site_config('website_sticky_logo'))
                                    <img src="{{ url('storage/'.get_site_config('website_sticky_logo')) }}" alt="Current logo" style="height:70px;padding:8px 0px 10px">
                                    @endif
                                    <input class="" type="file" name="website_sticky_logo_file">
                                    <br />
                                    <span style="font-size:0.9em;">Allowed file types: png, jpg, gif, svg<br />
                                    File size must not exceed 500KB<br />
                                    Image less than 400px width is preferred
                                    </span>
                                    <br />
                                    <div class="input-group w-50">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="padding: 5px;font-size: 15px;">Logo Height (px)</span>
                                        </div>
                                        <input type="number" name="website_sticky_logo_ht" class="form-control" placeholder="Logo Height" value="{{get_site_config('website_sticky_logo_ht')}}">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mt-4">
                                    <label for="" style="font-size: 15px;" class="form-label">Admin Panel (Backend) Logo</label><br>
                                    @if(get_site_config('backend_logo'))
                                    <img src="{{ url('storage/'.get_site_config('backend_logo')) }}" alt="Current logo" style="height:70px;padding:8px 0px 10px">
                                    @endif
                                    <input class="" type="file" name="backend_logo_file">
                                    <br />
                                    <span style="font-size:0.9em;">Allowed file types: png, jpg, gif, svg<br />
                                        File size must not exceed 500KB<br />
                                        Image less than 400px width is preferred
                                    </span>
                                    <br />
                                    <div class="input-group w-50">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="padding: 5px;font-size: 15px;">Logo Height (px)</span>
                                        </div>
                                        <input type="number" name="backend_logo_ht" class="form-control" placeholder="Logo Height" value="{{get_site_config('backend_logo_ht')}}">
                                    </div>

                                </div>
                                <div class="col-md-6 mt-4">
                                    <label for="" style="font-size: 15px;" class="form-label">Email Logo</label><br>
                                    @if(get_site_config('email_logo'))
                                    <img src="{{ url('storage/'.get_site_config('email_logo')) }}" alt="Current logo" style="height:70px;padding:8px 0px 10px">
                                    @endif
                                    <input class="" type="file" name="email_logo_file">
                                    <br />
                                    <span style="font-size:0.9em;">Allowed file types: png, jpg, gif, svg<br />
                                        File size must not exceed 500KB<br />
                                        Image less than 400px width is preferred
                                    </span>
                                    <br />
                                    <div class="input-group w-50">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="padding: 5px;font-size: 15px;">Logo Height (px)</span>
                                        </div>
                                        <input type="number" name="email_logo_ht" class="form-control" placeholder="Logo Height" value="{{get_site_config('email_logo_ht')}}">
                                    </div>

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-5 mt-4">
                                    <label for="" style="font-size: 15px;" class="form-label">Website Favicon</label><br>
                                    @if(get_site_config('favicon'))
                                    <img src="{{ url('storage/'.get_site_config('favicon')) }}" alt="Favicon" style="height:32px;padding:8px 0px 10px"><br />
                                    @endif
                                    <input class="" type="file" name="favicon_file" accept=".png">
                                    <br />
                                    <span style="font-size:0.9em;">Allowed file type: png<br />
                                        File size must not exceed 200KB<br />
                                        Preferred dimension(px): 32x32 / 64x64 / 128x128<br />
                                        <a class="text-primary" href="https://en.wikipedia.org/wiki/Favicon" target="_blank"><i class="fa fa-question-circle"></i> What is favicon</a>
                                    </span>
                                    <br />
                                </div>
                            </div>


                            <div class="row">
                                <div class="col-md-5 mt-4">
                                    <label for="" style="font-size: 15px;" class="form-label">Front end Theme</label><br>
                                </div>
                                <div class="col-sm-12 col-md-12">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <select class="form-select" 
                                                id="branch" 
                                                name="frontend_theme" 
                                                style="@if(get_site_config('frontend_theme') == 'blue') color: #1976d2 !important; font-weight: bolder !important; 
                                                    @elseif(get_site_config('frontend_theme') == 'green') color: #00acc1 !important; font-weight: bolder !important; 
                                                    @elseif(get_site_config('frontend_theme') == 'red') color: #f62d51 !important; font-weight: bolder !important; 
                                                    @elseif(get_site_config('frontend_theme') == 'purple') color: #7460ee !important; font-weight: bolder !important; 
                                                    @elseif(get_site_config('frontend_theme') == 'megna') color: #00897b !important; font-weight: bolder !important; 
                                                    @endif"
                                                required>
                                                    <option {{(get_site_config('frontend_theme') == 'blue' || get_site_config('frontend_theme') == '')? 'selected' : ''}} value="blue" style="color: #1976d2 !important; font-weight: bolder !important;">Blue</option>
                                                    <option {{(get_site_config('frontend_theme') == 'green' || get_site_config('frontend_theme') == '')? 'selected' : ''}} value="green" style="color: #00acc1 !important; font-weight: bolder !important;">Green</option>
                                                    <option {{(get_site_config('frontend_theme') == 'red' || get_site_config('frontend_theme') == '')? 'selected' : ''}} value="red" style="color: #f62d51 !important; font-weight: bolder !important;">Red</option>
                                                    <option {{(get_site_config('frontend_theme') == 'purple' || get_site_config('frontend_theme') == '')? 'selected' : ''}} value="purple" style="color: #7460ee !important; font-weight: bolder !important;">Purple</option>
                                                    <option {{(get_site_config('frontend_theme') == 'megna' || get_site_config('frontend_theme') == '')? 'selected' : ''}} value="megna" style="color: #00897b !important; font-weight: bolder !important;">Megna</option>
                                                </select>
        
                                                {{-- <input {{(get_site_config('frontend_theme') == 'blue' || get_site_config('frontend_theme') == '')? 'checked' : ''}} class="form-check-input" type="radio" value='blue' id="blue" name="frontend_theme">
                                                <label class="form-check-label" for="blue">
                                                    Blue&nbsp;&nbsp;
                                                </label>
                                                <label style="background-color: #1976d2 !important; width: 20px; height: 17px;" class="rounded"></label>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        
                                                <input {{(get_site_config('frontend_theme') == 'green')? 'checked' : ''}} class="form-check-input" type="radio" value='green' id="green" name="frontend_theme" >
                                                <label class="form-check-label" for="green">
                                                    Green&nbsp;&nbsp;
                                                </label>
                                                <label style="background-color: #00acc1 !important; width: 20px; height: 17px;" class="rounded"></label>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        
        
                                                <input {{(get_site_config('frontend_theme') == 'red')? 'checked' : ''}} class="form-check-input" type="radio" value='red' id="red" name="frontend_theme" >
                                                <label class="form-check-label" for="red">
                                                    Red&nbsp;&nbsp;
                                                </label>
                                                <label style="background-color: #f62d51 !important; width: 20px; height: 17px;" class="rounded"></label>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        
                                                <input {{(get_site_config('frontend_theme') == 'purple')? 'checked' : ''}} class="form-check-input" type="radio" value='purple' id="purple" name="frontend_theme" >
                                                <label class="form-check-label" for="purple">
                                                    Purple&nbsp;&nbsp;
                                                </label>
                                                <label style="background-color: #7460ee !important; width: 20px; height: 17px;" class="rounded"></label>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        
                                                <input {{(get_site_config('frontend_theme') == 'megna')? 'checked' : ''}} class="form-check-input" type="radio" value='megna' id="megna" name="frontend_theme" >
                                                <label class="form-check-label" for="megna">
                                                    Megna&nbsp;&nbsp;
                                                </label>
                                                <label style="background-color: #00897b !important; width: 20px; height: 17px;" class="rounded"></label>
                                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; --}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row col-12 mt-4">
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                </div>
                            </div>
                        </form>

                    </div>

                    <div class="tab-pane fade home-page pt-3" id="home-page">

                        <form class="row g-3" action="{{route('admin.settings.homepage')}}" method="post">
                            @csrf
                            <div class="col-md-12">
                                <h4>Show Sections</h4>
                                <small>Enable the sections that you want to show on the home page</small>
                            </div>
                            <div class="col-md-12">

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck1" name="home_page_slider_enabled" @if(get_site_config('home_page_slider_enabled')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck1">
                                        Slider
                                    </label>
                                    <br /><small>Upload banners & text content to display in the home page slider section.<br />To add/edit banners, go to Settings > Banners </small>
                                </div>

                                {{--<div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck2" name="home_page_coaching_courses_enabled" @if(get_site_config('home_page_coaching_courses_enabled')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck2">
                                        Coaching Classes
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck3" name="home_page_online_courses_enabled" @if(get_site_config('home_page_online_courses_enabled')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck3">
                                        Online Courses
                                    </label>
                                </div>--}}
                                {{-- <div class="form-check">
                                    
                                                                    <br />
                                    <input class="form-check-input" type="checkbox" id="gridCheck4" name="home_page_countryinfo_enabled" @if(get_site_config('home_page_countryinfo_enabled')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck4">
                                        Country Information
                                    </label>
                                    <br />
                                    <small>You can upload information documents related to various Study Overseas countries. These will be shown in the home page. To add/edit documents, Go to Study Abroad > Country Information.</small>
                                </div>

                                <div class="form-check mt-4">
                                    <input class="form-check-input" type="checkbox" id="gridCheck5" name="home_page_student_signup" @if(get_site_config('home_page_student_signup')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck5">
                                        Student Login/Signup
                                    </label>
                                </div>

                                <div class="form-check mt-4">
                                    <input class="form-check-input" type="checkbox" id="gridCheck6" name="home_page_agent_signup" @if(get_site_config('home_page_agent_signup')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck6">
                                        Agent Login Button
                                    </label>
                                </div> --}}

                                <div class="form-check mt-4">
                                    <input class="form-check-input" type="checkbox" id="gridCheck7" name="home_page_staff_login" @if(get_site_config('home_page_staff_login')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck7">
                                        Staff Login Button
                                    </label>
                                </div>

                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-sm">Save</button>
                            </div>
                        </form>

                    </div>

                    <div class="tab-pane fade modules pt-3 " id="modules">
                        <form class="row g-3" action="{{route('admin.settings.modules')}}" method="post">
                            @csrf
                            <div class="col-md-12">
                                <h4> Enable the required modules</h4>
                            </div>
                            <div class="col-md-12">

                                @if(config('app.product_code') == 'TRAINING' || config('app.product_code') == 'EDUCTRL_CRM')
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck10" name="module_coaching_classes" @if(get_site_config('module_coaching_classes')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck10">
                                        Coaching Classes
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck11" name="module_online_courses" @if(get_site_config('module_online_courses')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck11">
                                        Online Courses
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck12" name="module_course_purchase" @if(get_site_config('module_course_purchase')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck12">
                                        Buy Courses Online
                                    </label>
                                </div>
                                @endif

                                <!-- <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck13" name="module_shop" @if(get_site_config('module_shop')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck13">
                                        Shop
                                    </label>
                                    <br />
                                    <small>To sell digital/physical products, enable this module. You can create products, categories from 'Shop' page.</small>
                                </div> -->

                                <hr>

                                <h4>Student Panel</h4>
                                @if(config('app.product_code') == 'OVERSEAS' || config('app.product_code') == 'EDUCTRL_CRM')
                                <!-- <small>To hide a feature from student panel, disable it</small> -->
                                
                               
                                <!-- <p><strong>Study Abroad</strong></p> -->
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck21" name="academic_details_in_profile" @if(get_site_config('academic_details_in_profile')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck21">
                                        Detailed Profile
                                    </label>
                                    <br/>
                                    <small>Academic details,English tests,Employement/Visa/International travel history,etc.</small>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheckF" name="university_course_finder" @if(get_site_config('university_course_finder')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheckF">
                                        Course Finder
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck23" name="module_course_suggestion" @if(get_site_config('module_course_suggestion')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck23">
                                        Course Suggestions
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck22" name="module_country_info" @if(get_site_config('module_country_info')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck22">
                                        Country Information
                                    </label>
                                </div>
                                
                                <!-- <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck24" name="module_sop" @if(get_site_config('module_sop')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck24">
                                        SOP Request
                                    </label>
                                </div> -->
                                <!-- <br /> -->
                                @endif

                                @if(config('app.product_code') == 'TRAINING' || config('app.product_code') == 'EDUCTRL_CRM')
                                <p><strong>Coaching</strong></p>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck25" name="module_membermenu_allcoaching" @if(get_site_config('module_membermenu_allcoaching')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck25">
                                        All Coaching Classes
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck26" name="module_membermenu_allonlinecourses" @if(get_site_config('module_membermenu_allonlinecourses')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck26">
                                        All Online Courses
                                    </label>
                                </div>
                                <!-- <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck26" name="module_mycertificate" @if(get_site_config('module_mycertificate')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck26">
                                        My Certificate
                                    </label>
                                </div> -->
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck27" name="module_democlasses" @if(get_site_config('module_democlasses')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck27">
                                        Demo Classes
                                    </label>
                                </div>
                                @endif

                                <!-- <br /> -->
                                <!-- <p><strong>Other Features</strong></p> -->
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck31" name="module_helpdesk" @if(get_site_config('module_helpdesk')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck31">
                                        Helpdesk (Support Tickets)
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck32" name="module_resources" @if(get_site_config('module_resources')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck32">
                                        Resources
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck32" name="module_webinar" @if(get_site_config('module_webinar')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck32">
                                        Webinar & Events
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="agent_module_webinar" name="agent_module_webinar" @if(get_site_config('agent_module_webinar')) checked="checked" @endif>
                                    <label class="form-check-label" for="agent_module_webinar">
                                        Webinar & Events(Agent Side)
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck42" name="module_student_referral" @if(get_site_config('module_student_referral')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck42">
                                        Student Referral
                                    </label>
                                    <p class="small">
                                        Allow students to refer other students & earn commission. A unique referral code is generated for each student. Referral URL cookie is valid for 30 days.
                                    </p>
                                </div>

                                <br />
                                <p><strong>Languages</strong></p>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="lang_en" name="lang_en" disabled checked="checked">
                                    <label class="form-check-label" for="lang_en">
                                        English
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="lang_fr" name="lang_fr" @if(get_site_config('lang_fr')) checked="checked" @endif>
                                    <label class="form-check-label" for="lang_fr">
                                        French
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="lang_it" name="lang_it" @if(get_site_config('lang_it')) checked="checked" @endif>
                                    <label class="form-check-label" for="lang_it">
                                        Italian
                                    </label>
                                </div>

                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="lang_es" name="lang_es" @if(get_site_config('lang_es')) checked="checked" @endif>
                                    <label class="form-check-label" for="lang_es">
                                        Spanish
                                    </label>
                                </div>

                                <hr>
                                <h4>Payment Gateways</h4>
                                <!-- <small>This is applicable only if 'Shop' feature is enabled</small> -->
                                <!-- <br />
                                <br /> -->
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck41" name="payment_paypal" @if(get_site_config('payment_paypal')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck41">
                                        Paypal
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck42" name="payment_stripe" @if(get_site_config('payment_stripe')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck42">
                                        Stripe
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck42" name="payment_stripe" @if(get_site_config('payment_stripe')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck43">
                                        Razorpay
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="gridCheck44" name="payment_bank" @if(get_site_config('payment_bank')) checked="checked" @endif>
                                    <label class="form-check-label" for="gridCheck43">
                                        Bank Transfer (Manual Payment Tracking)
                                    </label>
                                </div>

                                <hr>
                                <h4>Cookie Consent Banner & GDPR</h4>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="cookie_consent_banner" name="cookie_consent_banner" @if(get_site_config('cookie_consent_banner')) checked="checked" @endif>
                                    <label class="form-check-label" for="cookie_consent_banner">
                                        Enable (Enable Cookie Consent Banner)
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="student_agent_terminate_account" name="student_agent_terminate_account" @if(get_site_config('student_agent_terminate_account')) checked="checked" @endif>
                                    <label class="form-check-label" for="cookie_consent_banner">
                                        Allow Student/ Agent to Terminate Account
                                    </label>
                                </div>
                                <hr>
                                <h4>Show Footer Links</h4>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="privacy_policy" name="privacy_policy" @if(get_site_config('privacy_policy')) checked="checked" @endif>
                                    <label class="form-check-label" for="privacy_policy">
                                        Privacy Policy <a href="{{route('admin.articles')}}">(Edit Content <i class="fa fa-edit text-primary"></i>)</a>
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="term_of_service" name="term_of_service" @if(get_site_config('term_of_service')) checked="checked" @endif>
                                    <label class="form-check-label" for="term_of_service">
                                        Terms of Service <a href="{{route('admin.articles')}}">(Edit Content <i class="fa fa-edit text-primary"></i>)</a>
                                    </label>
                                </div>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-primary btn-sm">Save</button>
                            </div>
                        </form>
                    </div>

                    {{--
                    <div class="tab-pane fade email pt-3 " id="email">
                        <form class="row g-3" action="{{route('admin.settings.smtp')}}" method="post">
                    @csrf
                    <div class="col-md-12">
                        <h4>SMTP Server Configuration</h4>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font-size: 15px;" class="form-label">Host Name</label><br>
                            <input class="form-control " name="smtp_host" type="text" value="{{get_site_config('smtp_host')}}">
                        </div>
                        <div class="col-md-2">
                            <label for="" style="font-size: 15px;" class="form-label">Port</label><br>
                            <input class="form-control " name="smtp_port" type="text" value="{{get_site_config('smtp_port')}}">
                        </div>
                        <div class="col-md-2">
                            <label for="" style="font-size: 15px;" class="form-label">Connection Type</label><br>
                            <select class="form-select" aria-label="Default select example">
                                <option value="ssl" @if(get_site_config('smtp_connection')=='ssl' ) selected @endif>SSL</option>
                                <option value="tls" @if(get_site_config('smtp_connection')=='tls' ) selected @endif>TLS</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-4">
                            <label for="" style="font-size: 15px;" class="form-label">From Email</label><br>
                            <input class="form-control " name="smtp_email" type="text" value="{{get_site_config('smtp_email')}}">
                        </div>

                        <div class="col-md-8">

                        </div>

                        <div class="col-md-4">
                            <label for="" style="font-size: 15px;" class="form-label">Password</label><br>
                            <input class="form-control " name="smtp_password" type="password" value="{{get_site_config('smtp_password')}}">
                        </div>

                        <div class="col-md-8">

                        </div>
                    </div>

                    <div class="text-center">
                        <button type="submit" class="btn btn-primary btn-sm">Save</button>
                    </div>
                    </form>
                </div>
                --}}

                <!-- Student -->

                <!-- /Student -->
                <div class="tab-pane fade advanced pt-3 " id="advanced">

                    <form class="row g-3" action="{{route('admin.settings.advanced')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="row my-3">
                            <div class="col-12">
                                <h4>Email, Mobile No. Mandatory Fields Configuration</h4>
                                <br>
                            </div>
                            <div class="col-md-6">
                                <h5>For Lead Creation from Admin Panel</h5>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="lead_email_and_mobile" value="email" @if(get_site_config('lead_create_admin_mandatory') == 'email') checked @endif id="lead_email_mandatory">
                                    <label class="form-check-label" for="lead_email_mandatory">Email is Required</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="lead_email_and_mobile" value="mobile" @if(get_site_config('lead_create_admin_mandatory') == 'mobile') checked @endif id="lead_mobile_mandatory" >
                                    <label class="form-check-label" for="lead_mobile_mandatory">Mobile no. is Required</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="lead_email_and_mobile" value="email_or_mobile" @if(get_site_config('lead_create_admin_mandatory') == 'email_or_mobile') checked @endif id="lead_email_or_mobile_mandatory" >
                                    <label class="form-check-label" for="lead_email_or_mobile_mandatory">Either Email or Mobile no. is Required</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="lead_email_and_mobile" value="email_and_mobile" @if(get_site_config('lead_create_admin_mandatory') == 'email_and_mobile') checked @endif id="lead_email_and_mobile_mandatory" >
                                    <label class="form-check-label" for="lead_email_and_mobile_mandatory">Both Email and Mobile no. are Required</label>
                                </div>
                            </div>
                            <div class="col-md-6 mt-3 mt-sm-0">
                                <h5>For Lead Creation from Web To Lead/API/Import</h5>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="web_api_import_email_and_mobile" value="email" @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email') checked @endif id="web_api_import_email_mandatory">
                                    <label class="form-check-label" for="web_api_import_email_mandatory">Email is Required</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="web_api_import_email_and_mobile" value="mobile" @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile') checked @endif id="web_api_import_mobile_mandatory" >
                                    <label class="form-check-label" for="web_api_import_mobile_mandatory">Mobile no. is Required</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="web_api_import_email_and_mobile" value="email_or_mobile" @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_or_mobile') checked @endif id="web_api_import_email_or_mobile_mandatory" >
                                    <label class="form-check-label" for="web_api_import_email_or_mobile_mandatory">Either Email or Mobile no. is Required</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="web_api_import_email_and_mobile" value="email_and_mobile" @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile') checked @endif id="web_api_import_email_and_mobile_mandatory">
                                    <label class="form-check-label" for="web_api_import_email_and_mobile_mandatory">Both Email and Mobile no. are Required</label>
                                </div>
                            </div>
                            <div class="col-md-6 mt-3">
                                <h5>For Student Creation from Admin Panel</h5>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="student_email_and_mobile" value="email" @if(get_site_config('student_create_admin_mandatory') == 'email') checked @endif id="student_email_mandatory">
                                    <label class="form-check-label" for="student_email_mandatory">Email is Required</label>
                                </div>
                                {{-- <div class="form-check">
                                    <input class="form-check-input" type="radio" name="student_email_and_mobile" value="mobile" @if(get_site_config('student_create_admin_mandatory') == 'mobile') checked @endif id="student_mobile_mandatory" >
                                    <label class="form-check-label" for="student_mobile_mandatory">Mobile no. is Required</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="student_email_and_mobile" value="email_or_mobile" @if(get_site_config('student_create_admin_mandatory') == 'email_or_mobile') checked @endif id="lead_email_or_mobile_mandatory" >
                                    <label class="form-check-label" for="lead_email_or_mobile_mandatory">Either Email or Mobile no. is Required</label>
                                </div> --}}
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="student_email_and_mobile" value="email_and_mobile" @if(get_site_config('student_create_admin_mandatory') == 'email_and_mobile') checked @endif id="student_email_and_mobile_mandatory" >
                                    <label class="form-check-label" for="student_email_and_mobile_mandatory">Both Email and Mobile no. are Required</label>
                                </div>
                            </div>

                            <p class="mt-3"><strong>Note:</strong><br /><strong>Unique Values</strong>: Required fields(email/mobile) must be unique (duplicates not accepted)</p>
                        </div>

                        <div class="row pt-3">
                            <hr>
                            <div class="col-12 pb-3">
                                <h5>Lead Create Next Follow-up Mandatory Fields Configuration</h5>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="lead_create_next_followup_mandate" value="1" @if(get_site_config('lead_create_next_followup_mandate')) checked @endif id="lead_create_next_followup_mandate">
                                    <label class="form-check-label" for="lead_create_next_followup_mandate">Next Follow-up is Required</label>
                                </div>
                            </div>
                        </div>

                        <div class="row pt-3">
                            <hr>
                            <div class="col-md-6">
                                <label class="form-label">DocuEsign API URL</label>
                                <input type="text" name="docusign_api_url" value="{{ get_site_config('docusign_api_url') }}"
                                    class="form-control">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">DocuEsign API Token</label>
                                <input type="text" name="docusign_api_token" value="{{ get_site_config('docusign_api_token') }}"
                                    class="form-control">
                            </div>
                        </div>
                        
                        {{-- <div class="row pb-3">
                            <hr>
                            <div class="row">
                                <div class="col-12">
                                    <h4>Invoice Configuration</h4>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                <div class="form-group">
                                    <label>Your Business Name</label>
                                    <input type="text" name="invoice_business_name" class="form-control" value="{{get_site_config('invoice_business_name')}}">
                                </div>
                                <div class="form-group">
                                    <label>Business Phone</label>
                                    <input type="text" name="invoice_business_phone" class="form-control" value="{{get_site_config('invoice_business_phone')}}">
                                </div>
                                <div class="form-group">
                                    <label>Business Email</label>
                                    <input type="text" name="invoice_business_email" class="form-control" value="{{get_site_config('invoice_business_email')}}">
                                </div>
                                <div class="form-group">
                                    <label>Business Address</label>
                                    <input type="text" name="invoice_business_address" class="form-control" value="{{get_site_config('invoice_business_address')}}">
                                </div>
                                <div class="form-group">
                                    <label>{{_label('tax_id')}}</label>
                                    <input type="text" name="invoice_business_taxid" class="form-control" value="{{get_site_config('invoice_business_taxid')}}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <strong>Bank Account Details</strong><br />
                                <span class="text-muted">If you have enabled Bank Transfer payment mode, enter the Bank account no., Payee, Branch, Swift code details.</span>
                                <textarea name="payment_bank_details" class="form-control" style="height: 150px" placeholder="Enter bank details">{{get_site_config('payment_bank_details')}}</textarea>
                            </div>
                        </div>

                        <div class="row pt-3 pb-3">
                            <div class="col-6">
                                <strong>Invoice Terms & Conditions Text: </strong>
                                <div class="form-group col-md-12">
                                    <textarea name="invoice_terms_text" class="form-control" style="height: 100px" placeholder="Enter invoice terms & conditions text">{{get_site_config('invoice_terms_text')}}</textarea>
                                </div>
                            </div>
                            <div class="col-6">
                                <strong>Invoice Footer Text: </strong>
                                <div class="form-group col-md-12">
                                    <textarea name="invoice_footer_text" class="form-control" style="height: 100px" placeholder="Enter invoice footer text">{{get_site_config('invoice_footer_text')}}</textarea>
                                </div>
                            </div>
                        </div> --}}

                        <!-- employee configuration -->
                 <div class="row my-3">
                    <div class="col-12">
                        <hr>
                        <h4>Employee Configurations</h4>
                        <br>
                    </div>
                    <div class="col-md-12">
                      
                        <div class="col-12">
                        <label class="required-field">Departments</label>
                            <input type="text" style="margin: 0%" class="form-control" name="employee_department" value="{{get_site_config('employee_department')}}" required>
                            <p class="small">Enter pipe ('|') seperated values</p>
                        </div>
                        <div class="col-12">
                        <label class="required-field">Designations</label>
                            <input type="text" style="margin: 0%" class="form-control" name="employee_designation" value="{{get_site_config('employee_designation')}}" required>
                            <p class="small">Enter pipe ('|') seperated values</p>
                        </div>
                        <div class="col-12">
                        <label class="required-field">Employement Type</label>
                            <input type="text" style="margin: 0%" class="form-control" name="employee_type" value="{{get_site_config('employee_type')}}" required>
                            <p class="small">Enter pipe ('|') seperated values</p>
                        
                        </div>
                        <div class="col-12">
                        <label class="required-field">Employment Status</label>
                            <input type="text" style="margin: 0%" class="form-control" name="employee_status" value="{{get_site_config('employee_status')}}" required>
                            <p class="small">Enter pipe ('|') seperated values</p>
                        
                        </div>
                        <div class="col-12">
                        <label class="required-field"> Onboarding Status</label>
                            <input type="text" style="margin: 0%" class="form-control" name="onboarding_status" value="{{get_site_config('onboarding_status')}}" required>
                            <p class="small">Enter pipe ('|') seperated values</p>
                        
                        </div>

                    </div>
                 </div>
                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <h4>Student Referral Payout Modes</h4>
                                    <div class="form-group">
                                        <label class="required-field">Define the Payment modes</label>
                                        <input type="text" style="margin: 0%" class="form-control" name="student_referral_payout_modes" value="{{get_site_config('student_referral_payout_modes')}}" required>
                                        <p class="small">Enter comma seperated values</p>
                                    </div>
                            </div>
                        </div>
                        <div class="row pb-3">
                            <div class="col-md-12">
                                <hr>
                                <h4>Event Notifications</h4>
                                <p>
                                    <strong>Events are: Lead Generated/Created, Student Signup/Created, Agent Signup</strong>
                                    <br />
                                    Send Event notification emails to
                                    <input style="margin-bottom: 0;" type="text" name="event_notification_email" class="form-control" value="{{get_site_config('event_notification_email')}}">
                                    <small>Enter comma seperated emails. Maximum 3 ids.</small>
                                    <br />
                                    <br />
                                    <strong>Support Ticket Notifications</strong>
                                    <br />
                                    Send notification emails to
                                    <input style="margin-bottom: 0;" type="text" name="support_ticket_notification_email" class="form-control" value="{{get_site_config('support_ticket_notification_email')}}">
                                    <small>Enter comma seperated emails. Maximum 3 ids.</small>

                                </p>

                            </div>
                        </div> 
                        
                        <div class="row ">
                            <div class="col-12">
                                <hr>
                                <h4>Student Qualification Levels</h4>
                                    <div class="form-group">
                                        <label class="required-field">Define the Qualification Levels for Student</label>
                                        <input type="text" style="margin: 0%" class="form-control" name="student_qualification_levels" value="{{get_site_config('student_qualification_levels')}}" required>
                                        <p class="small">Enter comma seperated values</p>
                                    </div>
                            </div>
                        </div>
                        
                        <div class="row ">
                            <div class="col-12">
                                <hr>
                                <h4>Student Disqualified Reasons</h4>
                                    <div class="form-group">
                                        <label class="required-field">Define the reasons for Student Disqualification</label>
                                        <input type="text" style="margin: 0%" class="form-control" name="student_disqualified_reason" value="{{get_site_config('student_disqualified_reason')}}" required>
                                        <p class="small">Enter comma seperated values</p>
                                    </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <h4>Student Terms & Conditions</h4>
                                <strong>Student Signup Terms: </strong>
                                <div class="form-group  col-md-6">
                                    <select style="margin-bottom: 0;" name="student_signup_terms_page" class="form-control form-select">
                                        <option value="">Select</option>
                                        @foreach($content_pages as $page)
                                        <option value="{{$page->id}}" @if(get_site_config('student_signup_terms_page')==$page->id) selected @endif>{{$page->title}}</option>
                                        @endforeach
                                    </select>
                                    <small>To create a new page, Go to <a class="text-primary" href="{{ route('admin.articles') }}">Pages</a></small><br />
                                    <small>This page will be linked to student signup form Terms & Conditions.</small>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <strong>Student Study Abroad University Applications Submission Terms: </strong>
                                <div class="form-group col-md-6">
                                    <select style="margin-bottom: 0;" name="student_application_terms_page" class="form-control form-select">
                                        <option value="">Select</option>
                                        @foreach($content_pages as $page)
                                        <option value="{{$page->id}}" @if(get_site_config('student_application_terms_page')==$page->id) selected @endif>{{$page->title}}</option>
                                        @endforeach
                                    </select>
                                    <small>To create a new page, Go to <a class="text-primary" href="{{ route('admin.articles') }}">Pages</a></small><br />
                                    <small>This page content will be shown to student during study abroad apply form submission.</small>

                                </div>
                            </div>
                        </div>

                        {{-- <div class="row">
                            <div class="col-12">
                                <hr>
                                <h4>Apply Through Agents</h4>
                                <div class="form-group">
                                    <label class="required-field">Define the Agents</label>
                                    <input type="text" style="margin: 0%" class="form-control" name="application_apply_through" value="{{get_site_config('application_apply_through')}}" required>
                                    <p class="small">Enter comma seperated values</p>
                                </div>
                            </div>
                        </div> --}}

                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <h4>Sample Documents</h4>
                                <small>You can share sample document formats to students. These are shown in student panel, document upload section.</small>
                                <br />
                                <br />
                                <strong>Sample CV for Students</strong><br />
                                @if(get_site_config('sample_cv'))
                                <div><a class="text-small" href="<?php echo url('storage/' . get_site_config('sample_cv')) ?>" target="_blank"><?php echo substr(get_site_config('sample_cv'), 7); ?></a></div>
                                @endif
                                <input type="file" name="sample_cv" accept=".pdf,.doc,.docx">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <strong>Sample SOP for Students</strong><br />
                                @if(get_site_config('sample_sop'))
                                <div><a class="text-small" href="<?php echo url('storage/' . get_site_config('sample_sop')) ?>" target="_blank"><?php echo substr(get_site_config('sample_sop'), 7); ?></a></div>
                                @endif
                                <input type="file" name="sample_sop" accept=".pdf,.doc,.docx">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <strong>Sample 'LOR Professional' for Students</strong><br />
                                @if(get_site_config('sample_professional_lor'))
                                <div><a class="text-small" href="<?php echo url('storage/' . get_site_config('sample_professional_lor')) ?>" target="_blank"><?php echo substr(get_site_config('sample_professional_lor'), 8); ?></a></div>
                                @endif
                                <input type="file" name="sample_professional_lor" accept=".pdf,.doc,.docx">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <strong>Sample 'LOR Academic' for Students</strong><br />
                                @if(get_site_config('sample_academic_lor'))
                                <div><a class="text-small" href="<?php echo url('storage/' . get_site_config('sample_academic_lor')) ?>" target="_blank"><?php echo substr(get_site_config('sample_academic_lor'), 8); ?></a></div>
                                @endif
                                <input type="file" name="sample_academic_lor" accept=".pdf,.doc,.docx">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <strong>Sample 'MOU' for Students</strong><br />
                                @if(get_site_config('sample_mou'))
                                <div><a class="text-small" href="<?php echo url('storage/' . get_site_config('sample_mou')) ?>" target="_blank"><?php echo substr(get_site_config('sample_mou'), 8); ?></a></div>
                                @endif
                                <input type="file" name="sample_mou" accept=".pdf,.doc,.docx">
                            </div>
                        </div>


                        <!-- <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Frontend - Google Analytics Tracking ID</label><br>

                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="    padding: 0.305rem 0.75rem;">UA-</span>
                                    </div>
                                    <input type="text" class="form-control" aria-describedby="basic-addon1">
                                </div>
                            </div>
                            <div class="col-md-6">
                            </div>
                            <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Backend - Google Analytics Tracking ID</label><br>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="padding: 0.305rem 0.75rem;">UA-</span>
                                    </div>
                                    <input type="text" class="form-control" aria-describedby="basic-addon1">
                                </div>
                            </div>
                            <div class="col-md-6">
                            </div> -->
                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <h4>Google Recaptcha</h4>
                                <p>Recaptcha v2 integration. Refer the Admin guide "Google Recaptcha" section for instructions on how to generate site key & secret key</p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Site Key</label><br>
                                <input type="text" class="form-control" name="recaptcha_site_key" value="{{get_site_config('recaptcha_site_key')}}">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Secret Key</label><br>
                                <input type="text" class="form-control" name="recaptcha_secret_key" value="{{get_site_config('recaptcha_secret_key')}}">
                            </div>
                        </div>
                        <div class="row pt-3">
                            <div class="col-12 pb-3">
                                <h5>Enable Captcha for</h5>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="student_signup_captcha" value="1" @if(get_site_config('student_signup_captcha')) checked @endif id="student_signup_captcha">
                                    <label class="form-check-label" for="student_signup_captcha">Student Signup page</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="agent_signup_captcha" value="1" @if(get_site_config('agent_signup_captcha')) checked @endif id="agent_signup_captcha">
                                    <label class="form-check-label" for="agent_signup_captcha">Agent Signup page</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="web_to_lead_captcha" value="1" @if(get_site_config('web_to_lead_captcha')) checked @endif id="web_to_lead_captcha">
                                    <label class="form-check-label" for="web_to_lead_captcha">Web to lead forms</label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="form_builder_captcha" value="1" @if(get_site_config('form_builder_captcha')) checked @endif id="form_builder_captcha">
                                    <label class="form-check-label" for="form_builder_captcha">Form Builder forms</label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <hr>
                                <h4>Include JS code in all pages</h4>
                                <p>Below javascript code will be included in all the files. This can be used for analytics, chat plugin, etc.</p>
                                <label for="" style="font-size: 15px;" class="form-label">Website Frontend JS codes</label><br>
                            </div>
                            {{-- <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Fronted(Website/Student Panel) - js codes</label><br>
                                <textarea name="js_frontend" class="form-control" style="height: 100px">{{get_site_config('js_frontend')}}</textarea>
                            </div> --}}
                            <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Chatbot or Enter Essential js codes</label><br>
                                <textarea name="essential_js_frontend" class="form-control" style="height: 100px">{{get_site_config('essential_js_frontend')}}</textarea>
                                <span>Will be always shown, irrespective of cookie consent.</span>
                            </div>
                            <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Backend(Admin/Staff/Agent Panel) - js codes</label><br>
                                <textarea name="js_backend" class="form-control" style="height: 100px">{{get_site_config('js_backend')}}</textarea>
                            </div>
                            <div class="col-md-6">
                                <br>
                                <label for="" style="font-size: 15px;" class="form-label">Analytics/ Performance Related js codes</label><br>
                                <textarea name="analytics_performance_js_frontend" class="form-control" style="height: 100px">{{get_site_config('analytics_performance_js_frontend')}}</textarea>
                            </div>
                            <div class="col-md-6"></div>
                            <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Markenting/ Advertising/ Retargeting Related js codes</label><br>
                                <textarea name="marketing_advertising_retargeting_js_frontend" class="form-control" style="height: 100px">{{get_site_config('marketing_advertising_retargeting_js_frontend')}}</textarea>
                            </div>
                            <div class="col-md-6"></div>
                            <div class="col-md-6">
                                <label for="" style="font-size: 15px;" class="form-label">Functional (Preferences)</label><br>
                                <textarea name="functional_preferences_js_frontend" class="form-control" style="height: 100px">{{get_site_config('functional_preferences_js_frontend')}}</textarea>
                            </div>
                        </div>

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary btn-sm">Save</button>
                        </div>
                    </form>
                </div>

            </div>
        </div>
        <!-- End Bordered Tabs -->

    </div>
</div>
</div>

@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
    });
</script>
@endpush