@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" id="setting" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->
                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('additional-docs')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade general active show" id="banners">
                                <div class="row">
                                    <div class="col-sm-10">
                                        <h4>Additional Documents Configuration</h4>
                                    </div>  
                                    <div class="col-sm-2 btn-toolbar" role="toolbar" aria-label="Add New Document">
                                        <a id="addDoc" data-toggle="modal" data-target='#add_doc_modal' class="btn btn-primary btn-sm" data-toggle="tooltip" title="Add New Document"><i class="bi bi-plus-circle"></i> New</a>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <hr>
                                        <h4>Existing Configurations</h4>

                                        <div class="table-responsive" style="border: 1px solid rgb(244, 240, 240); border-radius: 6px;">
                                            <table class="table table-striped bg-none mb-0">
                                                <thead class="tableHeading">
                                                    <tr>
                                                        <th>Document Title</th>
                                                        <th>For Country</th>
                                                        <th>Section</th>
                                                        <th style="width: 10%;">Display Order</th>
                                                        <th>Status</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                    <tbody>
                                                        @if(count($docs))
                                                        @foreach($docs as $doc)
                                                        <tr>
                                                            <td>{{$doc->title}}</td>
                                                            @if($doc->country_specific==0)
                                                            <td>{{'All'}}</td>
                                                            @else
                                                            <td>
                                                                {{$doc->countries}}
                                                            </td>
                                                            @endif
                                                            <td>
                                                                {{get_doc_section_name($doc->section_id)}}
                                                            </td>
                                                            {{-- <td>{{$doc->display_order}} <button>Save</button></td> --}}
                                                            <td class="text-center qty">
                                                                <input style="" class="form-control" id="order{{$doc->id}}" onchange="update_order({{$doc->id}})" type="number" value="{{$doc->display_order}}" name="display_order" style="">
                                                                <span style="display:none;" id="load-ing-{{$doc->id}}" class="text-success p-3"><b>Updating...</b></span>
                                                            </td>
                                                            <td>
                                                                @if($doc->status) 
                                                                <button class="btn btn-success btn-sm" onclick="document.location='{{route('admin.additional-docs.changestatus', [$doc->id, 0])}}'">Enabled</button> 
                                                                @else 
                                                                <button class="btn btn-secondary btn-sm" onclick="document.location='{{route('admin.additional-docs.changestatus', [$doc->id, 1])}}'">Disabled</button>  
                                                                @endif
                                                            </td>
                                                            <td>
                                                                <a title="Edit" href="" id="editDoc" class="btn btn-primary btn-sm" data-toggle="modal" data-title="{{ $doc->title }}" data-notes="{{ $doc->doc_notes }}" data-section_id="{{ $doc->section_id }}" data-doc_id="{{ $doc->id }}" data-file_count="{{$doc->file_count}}" data-file_types="{{$doc->file_types}}" data-country_specific="{{$doc->country_specific}}" data-countries="{{$doc->countries}}"><i class='fas fa-edit' style='font-size:17px'></i></a>
                                                                <a title="Delete" class="btn btn-danger btn-sm" href="{{ route('admin.additional-docs.delete', $doc->id)}}" data-method="delete"><i class="fa fa-trash"></i></a>
                                                            </td>
                                                        </tr>
                                                        @endforeach
                                                        @else
                                                        <tr>
                                                            <td colspan="5" class="text-center">No Record Found</td>
                                                        </tr>
                                                        @endif
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- End Bordered Tabs -->
                </div>
            </div>
        </div>
    </div>
</div>
</div>

<div class="modal fade" id="add_doc_modal">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Configuration</h5>
                <button type="button" class="btn btn-sm btn-outline-dark" data-bs-dismiss="modal">&times;</button>
            </div>
            <form id="docForm" method="POST" action="{{route('admin.additional-docs.save')}}">
                @csrf
                <div class="modal-body">
                    <span class="label required-field"><b>Document Title</b></span>
                    <input type="text" autocomplete="off" name="document_title" class="form-control" required>
                    <span class="label required-field"><b>Section</b></span>
                    <select name="section" style="width:100%;" class="form-select" required>
                            <option value="">Select</option>
                            @foreach($sections as $section)
                                <option value="{{$section->id}}">{{$section->section}}</option>
                            @endforeach
                    </select>
                    <span class="label required-field"><b>No. of files that can be uploaded</b></span>
                    <select name="number_of_files" class="form-control form-select" required>
                        @for($num = 1; $num <= 10; $num++)
                            <option value="{{$num}}">{{$num}}</option>
                        @endfor
                    </select>
                    <span class="label required-field"><b>File types allowed</b></span>
                    <select name="file_types_allowed[]" style="width:100%;" class="form-select select2" multiple="multiple" required>
                            <option value=".pdf">.pdf</option>
                            <option value=".doc">.doc</option>
                            <option value=".docx">.docx</option>
                            <option value=".jpg">jpg</option>
                            <option value=".png">png</option>
                            <option value=".zip">zip</option>
                    </select>
                    <span class="label"><b>File upload hint/notes</b></span>
                    <input type="text" autocomplete="off" name="doc_notes" class="form-control">
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <span class="label"><b>Is this document specific to a study abroad country?</b></span><br>
                            <input type="radio" checked name="country_specific" id="country_specific_no" value="0"> <label for="country_specific_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="country_specific" id="country_specific_yes" value="1"> <label for="country_specific_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="form-group row" id="countries_block" style="display:none;">
                        <span class="label"><b>Select Countries</b></span><br>
                        <select name="countries[]" id="countries" style="width:100%; margin-bottom: 0" class="form-select select2" multiple="multiple">
                            {{-- <option value="">Select Countries</option> --}}
                            @foreach(get_study_countries() as $country)
                            <option value="{{$country}}">{{$country}}</option>
                            @endforeach
                        </select>
                        <small class="form-text">If a student has University Applications for the above country, this document upload field will be shown.</small>
                    </div>
                    <div class="row mt-3">
                        <div class="col text-center">
                            <button type="submit" class="btn btn-md btn-primary" style="font-size: 0.9em;">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
</div>



<div class="modal fade" id="doc_update_modal">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Edit Document</h5>
                <button type="button" class="btn btn-sm btn-outline-dark" data-bs-dismiss="modal">&times;</button>
            </div>
            <form id="statusDataForm" method="POST" action="{{route('admin.additional-docs.update')}}">
                @csrf
                <input type="hidden" id="doc_id" name="doc_id" value="">
                <div class="modal-body">
                    <span class="label required-field"><b>Document Title</b></span>
                    <input type="text" autocomplete="off" id="edit_document_title" name="document_title" class="form-control" required>
                    <span class="label required-field"><b>Section</b></span>
                    <select name="section" style="width:100%;" class="form-select" id="edit_section" required>
                            <option value="">Select</option>
                            @foreach($sections as $section)
                                <option value="{{$section->id}}">{{$section->section}}</option>
                            @endforeach
                    </select>
                    <span class="label required-field"><b>No. of files that can be uploaded</b></span>
                    <select name="number_of_files" id="edit_number_of_files" class="form-control form-select" required>
                        @for($num = 1; $num <= 10; $num++)
                            <option value="{{$num}}">{{$num}}</option>
                        @endfor
                    </select>
                    <span class="label required-field"><b>File types allowed</b></span>
                    <select name="file_types_allowed[]" id="edit_file_types_allowed" style="width:100%;" class="form-select select3" multiple="multiple" required>
                            <option value=".pdf">.pdf</option>
                            <option value=".doc">.doc</option>
                            <option value=".docx">.docx</option>
                            <option value=".jpg">.jpg</option>
                            <option value=".png">.png</option>
                            <option value=".zip">.zip</option>
                    </select>
                    <span class="label"><b>File upload hint/notes</b></span>
                    <input type="text" autocomplete="off" id="doc_notes" name="doc_notes" value="" class="form-control">
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <span class="label"><b>Is this document specific to a study abroad country?</b></span><br>
                            <input type="radio" checked name="country_specific" id="edit_country_specific_no" value="0"> <label for="edit_country_specific_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="country_specific" id="edit_country_specific_yes" value="1"> <label for="edit_country_specific_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="form-group row" id="edit_countries_block" style="display:none;">
                        <span class="label"><b>Select Countries</b></span><br>
                        <select name="countries[]" id="edit_countries" style="width:100%; margin-bottom: 0" class="form-select select3" multiple="multiple">
                            {{-- <option value="">Select Countries</option> --}}
                            @foreach(get_study_countries() as $country)
                            <option value="{{$country}}">{{$country}}</option>
                            @endforeach
                        </select>
                        <small class="form-text">If a student has University Applications for the above country, this document upload field will be shown.</small>
                    </div>

                            
                    <div class="row mt-3">
                        <div class="col text-center">
                            <button type="submit" class="btn btn-md btn-primary" style="font-size: 0.9em;">Update</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
</div>
@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>
$(document).ready(function() {
  $(".select2").select2({
    dropdownParent: $("#add_doc_modal")
  });
  $(".select3").select2({
    dropdownParent: $("#doc_update_modal")
  });
    $("#country_specific_yes").click(function() {
            $("#countries_block").show();
            $('#countries').prop('required',true);
    });
    $("#country_specific_no").click(function() {
            $("#countries_block").hide();
            $('#countries').prop("required", false).val("");
    });

    $("#edit_country_specific_yes").click(function() {
            $("#edit_countries_block").show();
            $('#edit_countries').prop('required',true);
    });
    $("#edit_country_specific_no").click(function() {
            $("#edit_countries_block").hide();
            $('#edit_countries').prop("required", false).val("");
    });
    $('#doc_update_modal').on('hidden.bs.modal', function () {
        $(this).find('form').trigger('reset');
        $("#edit_file_types_allowed").val("").trigger('change');
        $("#edit_countries").val("").trigger('change');
    })
});
    addDeleteForms();
    $('body').on('click', '#editDoc', function(event) {

        event.preventDefault();
        var doc_id = $(this).data('doc_id');
        var title = $(this).data('title');
        var section_id = $(this).data('section_id');
        var file_count = $(this).data('file_count');
        var file_types = $(this).data('file_types');
        var country_specific = $(this).data('country_specific');
        var doc_notes = $(this).data('notes');
        $('#doc_update_modal').modal('show');
        $('#doc_id').val(doc_id);
        $('#edit_document_title').val(title);
        $('#edit_number_of_files').val(file_count);
        $('#edit_section').val(section_id);
        $('#doc_notes').val(doc_notes);
        var typesArray = file_types.split(', ');
        //console.log(typesArray);
        var $typeselect = $("#edit_file_types_allowed");
        var data = $typeselect.val() || [];
        $(typesArray).each(function () {
            // console.log(this);
            // console.log($typeselect.find("option[value='" + this + "']").length);
        if(!$typeselect.find("option[value='" + this + "']").length) {
            $typeselect.append(new Option(this, this, false, true));
        }
        data.push(this);
        });
        $typeselect.val(data).trigger('change');
        if(country_specific ==0){
            $('#edit_country_specific_no').prop("checked", true);
            $("#edit_countries_block").hide();
            $('#edit_countries').prop("required", false).val("");
        }else{
            $('#edit_country_specific_yes').prop("checked", true);
            $("#edit_countries_block").show();
            $('#edit_countries').prop('required',true);
            var countries = $(this).data('countries');
            var countriesArray = countries.split(', ');
            var $countryselect = $("#edit_countries");
            var country_data = $countryselect.val() || [];
            $(countriesArray).each(function () {
            if(!$countryselect.find("option[value='" + this + "']").length) {
                $countryselect.append(new Option(this, this, true, true));
            }
            country_data.push(this);
            });
            $countryselect.val(country_data).trigger('change');
        }
        

    });

$('body').on('click', '#addDoc', function(event) {
event.preventDefault();
// var id = $(this).data('id');
// var order = $(this).data('order');
// var color = $(this).data('color');
// var edit_status = $(this).data('status');
$('#add_doc_modal').modal('show');
// $('#status_id').val(id);
// $('#color').val(color);
// $('#edit_status').val(edit_status);
// $('#display_order').val(order);

});

function update_order(id){
    var order = $('#order'+id).val();
    $("#load-ing-"+id).show();
    console.log("#load-ing-"+id);
     $.ajax({
            url: '{{ route('admin.additional-docs.updateOrder') }}',
            method: "get",
            data: {
                id: id, 
                order: order
            },
            success: function (response) {
                $("#load-ing-"+id).hide();
                if(response.status == 200){
                    $.toast({
                        heading: 'Success',
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3000,
                        stack: 6
                    });
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Something went wrong!',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 8
                    });
                }
                
            }
       });
  }
</script>
@endpush