@extends('backend.layouts.app')

@section('title', 'Settings: University Applications status')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('application-stages')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>University Applications Status</h4>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Application Stage" style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Application Stage"><i class="bi bi-plus-circle"></i> New</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>File Upload</th>
                                                        <th>Notes Required</th>
                                                        <th>Can go back?</th>
                                                        <th>Country Applicable</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($stages as $stage)
                                                    <tr>
                                                        <td>{{ $stage->status_name }}
                                                            @if($stage->case_close_success =='1')
                                                            <br>
                                                            <span class="badge badge-success">University Applications Completed</span>
                                                            @elseif($stage->case_close_rejected =='1')
                                                            <br>
                                                            <span class="badge badge-danger">University Applications Rejected</span>
                                                            @endif
                                                        </td>
                                                        <td>{!!($stage->file_upload) ? 'Yes' : 'No' !!}
                                                            @if($stage->file_upload_max && $stage->file_upload)
                                                            <br>
                                                                {{"No. of files: ".$stage->file_upload_max}}
                                                            @endif
                                                            <br>
                                                            
                                                            @if($stage->file_upload_required && $stage->file_upload)
                                                            Mandatory: Yes
                                                            @elseif(!$stage->file_upload_required && $stage->file_upload)
                                                            Mandatory: No
                                                            @else

                                                            @endif                                                        
                                                        </td>
                                                        <td>{{ ($stage->notes_required) ? 'Yes' : 'No' }}</td>
                                                        <td>{{ ($stage->can_go_back) ? 'Yes' : 'No' }}</td>
                                                        <td>{{ $stage->country_applicable }}</td>
                                                        <td>{{ $stage->stage_order }}</td>
                                                        <td>
                                                            <a title="Edit" href="javascript:void(0);" class="btn btn-primary btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-id="{{$stage->id}}" data-display_order="{{$stage->stage_order}}" data-color="{{$stage->color}}" data-name="{{$stage->status_name}}" data-notes_req="{{$stage->notes_required}}" data-go_back="{{$stage->can_go_back}}" data-case_close_success="{{$stage->case_close_success}}" data-case_close_rejected="{{$stage->case_close_rejected}}" data-file_upload_required="{{$stage->file_upload_required}}" data-file_upload_max="{{$stage->file_upload_max}}" data-countries="{{($stage->country_applicable) ? $stage->country_applicable : 0}}" data-file_upload="{{$stage->file_upload}}" data-action_url="{{route('admin.settings.application-stages.update', $stage->id)}}"><i class='fas fa-edit ' style='font-size:17px'></i></a>
                                                            <a title="Delete" href="#" onclick="delStatus({{$stage->id}})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <small><b>Notes:</b>
                                            <ul>
                                                <li>Super Admin is allowed to change a University Applications status to previous status even if "Can go back to previous stage = No"</li>
                                            </ul>
                                        </small>
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="{{route('admin.settings.application-stages.store')}}" id="">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New University Applications Stage</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="name" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Is Notes mandatory?</b></span><br>
                            <input type="radio" checked name="notes_required" id="notes_required_no" value="0"> <label for="notes_required_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="notes_required" id="notes_required_yes" value="1"> <label for="notes_required_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label"><b>Can attach File?</b></span><br>
                            <input type="radio" checked name="file_upload" id="file_upload_no" value="0"> <label for="file_upload_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="file_upload" id="file_upload_yes" value="1"> <label for="file_upload_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="file_div" style="display: none;">
                        <span class="label f_req"><b>No. of files that can be attached</b></span>
                        <select name="number_of_files" id="number_of_files" class="form-control form-select">
                            @for($num = 1; $num <= 5; $num++)
                                <option value="{{$num}}">{{$num}}</option>
                            @endfor
                        </select>

                        <div class="form-group row">
                            <div class="col-sm-12">
                                <span class="label f_req"><b>Is file attachment Upload mandatory?</b></span><br>
                                <input type="radio" checked name="file_upload_required" id="file_upload_required_no" value="0"> <label for="file_upload_required_no"> No</label>&nbsp;
                                &nbsp;
                                &nbsp;
                                <input type="radio" name="file_upload_required" id="file_upload_required_yes" value="1"> <label for="file_upload_required_yes"> Yes</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Can go back to previous stage from this stage?</b></span><br>
                            <input type="radio" checked name="can_go_back" id="can_go_back_no" value="0"> <label for="can_go_back_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="can_go_back" id="can_go_back_yes" value="1"> <label for="can_go_back_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Is this Case Close stage?</b></span><br>
                            <input type="radio" checked name="case_close" id="case_close_no" value="0"> <label for="case_close_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="case_close" id="case_close_yes" value="1"> <label for="case_close_yes"> Yes</label>
                        </div>
                    </div>

                    <div class="form-group row mt-2 case_div" style="display: none;">
                        <div class="col-sm-12">
                            {{-- <span class="label required-field"><b>Case closed(Rejected)</b></span><br> --}}
                            <input type="radio" name="case_close_type" id="case_close_success" value="1"> <label for="case_close_success"> University Applications Successful completion</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="case_close_type" id="case_close_rejected" value="0"> <label for="case_close_rejected"> University Applications rejected</label>
                        </div>
                    </div>

                    <div class="form-group mt-2">
                        <span class="label"><b>Select Countries</b></span><br>
                        <select name="countries[]" id="countries" style="width:100%; margin-bottom: 0" class="form-select select3" multiple="multiple">
                            @foreach(get_study_countries() as $country)
                            <option value="{{$country}}">{{$country}}</option>
                            @endforeach
                        </select>
                        <small class="form-text">If University Application Status is for specific country, this status will be shown.</small>
                    </div>

                    <div class="form-group mt-2">
                        <label class="label required-field">Stage Order</label>
                        <input type="number" name="stage_order" class="form-control" value="1" required>
                    </div>
                    <div class="form-group mt-2">
                        <label class="required-field"><b>Color</b></label>
                        <input type="text" autocomplete="off" class="form-control colorPicker" name="color" required />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="" id="edit_app-status">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit University Applications Stage</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="edit_name" id="edit_name" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Is Notes mandatory?</b></span><br>
                            <input type="radio" name="edit_notes_required" id="edit_notes_required_no" value="0"> <label for="edit_notes_required_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="edit_notes_required" id="edit_notes_required_yes" value="1"> <label for="edit_notes_required_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label"><b>Can attach File?</b></span><br>
                            <input type="radio" name="edit_file_upload" id="edit_file_upload_no" value="0"> <label for="edit_file_upload_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="edit_file_upload" id="edit_file_upload_yes" value="1"> <label for="edit_file_upload_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="edit_file_div" style="display: none;">
                        <span class="label edit_f_req"><b>No. of files that can be attached</b></span>
                        <select name="edit_number_of_files" id="edit_number_of_files" class="form-control form-select">
                            @for($num = 1; $num <= 5; $num++)
                                <option value="{{$num}}">{{$num}}</option>
                            @endfor
                        </select>

                        <div class="form-group row">
                            <div class="col-sm-12">
                                <span class="label edit_f_req"><b>Is file attachment Upload mandatory?</b></span><br>
                                <input type="radio" name="edit_file_upload_required" id="edit_file_upload_required_no" value="0"> <label for="edit_file_upload_required_no"> No</label>&nbsp;
                                &nbsp;
                                &nbsp;
                                <input type="radio" name="edit_file_upload_required" id="edit_file_upload_required_yes" value="1"> <label for="edit_file_upload_required_yes"> Yes</label>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Can go back to previous stage from this stage?</b></span><br>
                            <input type="radio" checked name="edit_can_go_back" id="edit_can_go_back_no" value="0"> <label for="edit_can_go_back_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="edit_can_go_back" id="edit_can_go_back_yes" value="1"> <label for="edit_can_go_back_yes"> Yes</label>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Is this Case Close stage?</b></span><br>
                            <input type="radio" checked name="edit_case_close" id="edit_case_close_no" value="0"> <label for="edit_case_close_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="edit_case_close" id="edit_case_close_yes" value="1"> <label for="edit_case_close_yes"> Yes</label>
                        </div>
                    </div>

                    <div class="form-group row mt-2 edit_case_div" style="display: none;">
                        <div class="col-sm-12">
                            {{-- <span class="label required-field"><b>Case closed(Rejected)</b></span><br> --}}
                            <input type="radio" name="edit_case_close_type" id="edit_case_close_type_success" value="1"> <label for="edit_case_close_type_success"> University Applications Successful completion</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="edit_case_close_type" id="edit_case_close_type_rejected" value="0"> <label for="edit_case_close_type_rejected"> University Applications rejected</label>
                        </div>
                    </div>

                    <div class="form-group mt-2">
                        <span class="label"><b>Select Countries</b></span><br>
                        <select name="countries[]" id="edit_countries" style="width:100%; margin-bottom: 0" class="form-select select2" multiple="multiple">
                            @foreach(get_study_countries() as $country)
                            <option value="{{$country}}">{{$country}}</option>
                            @endforeach
                        </select>
                        <small class="form-text">If University Application Status is for specific country, this status will be shown.</small>
                    </div>

                    <div class="form-group mt-2">
                        <label class="label required-field">Stage Order</label>
                        <input type="number" name="edit_stage_order" id="edit_stage_order" class="form-control" required>
                    </div>
                    <div class="form-group mt-2">
                        <label class="required-field"><b>Color</b></label>
                        <input type="text" autocomplete="off" id="edit_color" class="form-control colorPicker" name="edit_color" required />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $(".select2").select2({
            dropdownParent: $("#edit_modal")
        });
        $(".select3").select2({
            dropdownParent: $("#create_modal")
        });
       
        $('.edit_row').click(function() {
            $('#edit_name').val($(this).data('name'));
            $('#edit_stage_order').val($(this).data('display_order'));
            $("#edit_number_of_files").val($(this).data('file_upload_max'));
            $('#edit_color').val($(this).data('color'));
            var notes_req = $(this).data('notes_req');
            var file_upload = $(this).data('file_upload');
            var go_back = $(this).data('go_back');
            var case_close_success = $(this).data('case_close_success');
            var case_close_rejected = $(this).data('case_close_rejected');
            var file_upload_required = $(this).data('file_upload_required');
            var file_upload_max = $(this).data('file_upload_max');

            var countries = $(this).data('countries');
            if(countries!=0){
                console.log(countries);
                var countriesArray = countries.split(', ');
                var $countryselect = $("#edit_countries");
                var country_data = $countryselect.val() || [];
                if(countriesArray.length!=0){
                    $(countriesArray).each(function () {
                    if(!$countryselect.find("option[value='" + this + "']").length) {
                        $countryselect.append(new Option(this, this, true, true));
                    }
                    country_data.push(this);
                    });
                    $countryselect.val(country_data).trigger('change');
                }
            }else{
                $('#edit_countries').val('').trigger('change');
            }

            if(notes_req == '0'){
                $('#edit_notes_required_no').prop("checked", true);
            }else{
                $('#edit_notes_required_yes').prop("checked", true);
            }
            if(file_upload == '0'){
                $('#edit_file_upload_no').prop("checked", true);
                $(".edit_file_div").hide();
                $('#edit_number_of_files').prop("required", false).val("1");

            }else{
                $('#edit_file_upload_yes').prop("checked", true);
                $(".edit_file_div").show();
                $('.edit_f_req').addClass('required-field');
                $('#edit_number_of_files').prop('required',true);
            }
            if(file_upload_required == '0'){
                $('#edit_file_upload_required_no').prop("checked", true);
            }else{
                $('#edit_file_upload_required_yes').prop("checked", true);
            }
            if(go_back == '0'){
                $('#edit_can_go_back_no').prop("checked", true);
            }else{
                $('#edit_can_go_back_yes').prop("checked", true);
            }
            if(case_close_success == '1'){
                $('#edit_case_close_yes,#edit_case_close_type_success').prop("checked", true);
                $(".edit_case_div").show();
                $("[name='edit_case_close_type']").prop('required',true);
            } 
            else if(case_close_rejected == '1'){
                $('#edit_case_close_yes,#edit_case_close_type_rejected').prop("checked", true);
                $(".edit_case_div").show();
                $("[name='edit_case_close_type']").prop('required',true);
            }
            else{
                $('#edit_case_close_no').prop("checked", true);
                $(".edit_case_div").hide();
                $("[name='edit_case_close_type']").prop("required", false);
            }
                        
            $('#edit_app-status').attr('action', $(this).data('action_url'));

        });

        $("#file_upload_yes").click(function() {
            $(".file_div").show();
            $('.f_req').addClass('required-field');
            $('#number_of_files').prop('required',true);
        });
        $("#file_upload_no").click(function() {
            $(".file_div").hide();
            $('#number_of_files').prop("required", false).val("1");
        });

        $("#case_close_yes").click(function() {
            $(".case_div").show();
            $("[name='case_close_type']").prop('required',true);
        });
        $("#case_close_no").click(function() {
            $(".case_div").hide();
            $("[name='case_close_type']").prop("required", false);
            $("[name='case_close_type']").prop('checked', false);
        });

        //Edit
        $("#edit_file_upload_yes").click(function() {
            $(".edit_file_div").show();
            $('.edit_f_req').addClass('required-field');
            $('#edit_number_of_files').prop('required',true);
        });
        $("#edit_file_upload_no").click(function() {
            $(".edit_file_div").hide();
            $('#edit_number_of_files').prop("required", false).val("1");
        });

        $("#edit_case_close_yes").click(function() {
            $(".edit_case_div").show();
            $("[name='edit_case_close_type']").prop('required',true);
        });
        $("#edit_case_close_no").click(function() {
            $(".edit_case_div").hide();
            $("[name='edit_case_close_type']").prop("required", false);
            $("[name='edit_case_close_type']").prop('checked', false);
        });

        $('#edit_modal').on('hidden.bs.modal', function () {
            $('#edit_modal form')[0].reset();
        });


    });
    function delStatus(id){
        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        Swal.fire({
            title: "Are you sure you want to delete this University Applications status?",
            html: "" + warning + "",
            showCancelButton: true,
            confirmButtonColor: "#DC3545",
            confirmButtonText: `Delete`,
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('admin/settings/application-stages/delete/')}}/"+id;
                } else if (result.isDenied) {
                    
                }
        });
    }
</script>
@endpush