@extends('backend.layouts.app')

@section('title', 'Settings: Business Configs')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('business-configs')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Business Management </h4>
                                    </div>
                                    @if(env('MULTIPLE_BUSINESS_MANAGEMENT_ENABLE'))
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Business Config." style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Application Stage"><i class="bi bi-plus-circle"></i> New</button>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table nowrap w-100">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 6%">Sl No.</th>
                                                        <th>Business</th>
                                                        <th>Email</th>
                                                        <th>Phone</th>
                                                        <th style="width: 18%">Address</th>
                                                        {{-- <th>Tax ID</th>
                                                        <th style="width: 18%">Bank Details</th>
                                                        <th style="width: 15%">Footer Text</th>
                                                        <th style="width: 15%">Terms & Conditions</th> --}}
                                                        <th style="width: 6%">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($bizConfigs))
                                                        @foreach($bizConfigs as $bizConfig)
                                                        <tr>
                                                            <td class="">
                                                                {{ $loop->iteration }}
                                                            </td>
                    
                                                            <td class="text-left">
                                                                <b>{{$bizConfig->name}}</b><br>

                                                                @if($bizConfig->logo)
                                                                    <img src="{{ url('storage/'.$bizConfig->logo) }}" alt="Business logo" style="height:90px;padding:3px 0px 3px;"><br>
                                                                @endif
                                                            </td>
                                                            <td class="text-left">{{$bizConfig->email}}</td>
                                                            <td class="text-left">{{$bizConfig->phone}}</td>
                                                            <td class="text-left">{{$bizConfig->address}}</td>
                                                            {{-- <td class="text-left">{{$bizConfig->tax_id}}</td>
                                                            <td class="text-left">{!!nl2br($bizConfig->bank_details)!!}</td>
                                                            <td class="text-left">{!!nl2br($bizConfig->footer_text)!!}</td>
                                                            <td class="text-left">{!!nl2br($bizConfig->terms_text)!!}</td> --}}
                                                            <td class="text-center">
                                                                <div style="display: flex; text-align: center;">
                                                                    <a class="btn btn-sm edit_conf" href="" data-bs-toggle="modal" data-bs-target="#edit_modal" data-name="{{ $bizConfig->name }}" data-email="{{ $bizConfig->email }}" data-bizConfig_id="{{ $bizConfig->id }}" data-phone="{{$bizConfig->phone}}" data-address="{{$bizConfig->address}}" data-tax_id="{{$bizConfig->tax_id}}" data-footer_text="{{$bizConfig->footer_text}}" data-terms_text="{{$bizConfig->terms_text}}" data-business_logo="{{$bizConfig->logo}}" data-bank_details="{{$bizConfig->bank_details}}" data-action_url="{{route('admin.settings.business-configs.update', $bizConfig->id)}}"><i class='fas fa-edit text-primary' style='font-size:17px'></i></a>
                                                                    @if(env('MULTIPLE_BUSINESS_MANAGEMENT_ENABLE'))
                                                                    <a href="#" onclick="delConfig({{$bizConfig->id}})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                                                    @endif
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        @endforeach
                                                    @else
                                                    <tr>
                                                        <td colspan="10" class="text-center">
                                                            <p class="p-3">No Business Configuration Found!</p>
                                                        </td>
                                                    </tr>
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <form method="post" action="{{route('admin.settings.business-configs.store')}}" id="" enctype="multipart/form-data">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Business Configuration</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-2">
                        <div class="form-group col-6">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="name" class="form-control required-field mb-1" placeholder="" maxlength="100" required>
                    </div>
                    <div class="form-group col-6">
                        <label class=""><b>Business Logo</b></label>
                        <input type="file" name="business_logo" class="form-control mb-1">
                    </div>
                    </div>
                    <div class="row mb-2">
                    <div class="form-group col-6">
                        <label class="required-field"><b>Phone No.</b></label>
                        <input type="text" name="phone" class="form-control required-field mb-1" placeholder="" maxlength="15" required>
                    </div>
                    <div class="form-group col-6">
                        <label class="required-field"><b>Email</b></label>
                        <input type="email" name="email" class="form-control required-field mb-1" placeholder="" maxlength="50" required>
                    </div>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>@lang('labels.general.taxid')</b></label>
                        <input type="text" name="tax_id" class="form-control mb-1" placeholder="" maxlength="50">
                    </div>
                    {{-- <div class="form-group mb-2">
                        <label class=""><b>Business Reg No.</b></label>
                        <input type="text" name="business_reg_number" class="form-control mb-1" placeholder="" maxlength="50">
                    </div> --}}
                    <div class="form-group mb-2">
                        <label class=""><b>Address</b></label>
                        <textarea name="address" rows="3" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>Bank Details</b></label>
                        <textarea name="bank_details" rows="3" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>Terms & Conditions</b></label>
                        <textarea name="terms_conditions" rows="3" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>Footer Text</b></label>
                        <textarea name="footer_text" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
    
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- //Edit modal --}}
<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <form method="post" id="edit_config_form" enctype="multipart/form-data">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Business Configuration</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-2">
                        <div class="form-group col-6">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="name" id="edit_name" class="form-control required-field mb-1" placeholder="" maxlength="100" required>
                    </div>
                    <div class="form-group col-6">
                        <label class=""><b>Business Logo</b></label>
                        <input type="file" name="business_logo" id="edit_business_logo" class="form-control mb-1">
                    </div>
                    </div>
                    <div class="row mb-2">
                    <div class="form-group col-6">
                        <label class="required-field"><b>Phone No.</b></label>
                        <input type="text" name="phone" id="edit_phone" class="form-control required-field mb-1" placeholder="" maxlength="15" required>
                    </div>
                    <div class="form-group col-6">
                        <label class="required-field"><b>Email</b></label>
                        <input type="email" name="email" id="edit_email" class="form-control required-field mb-1" placeholder="" maxlength="50" required>
                    </div>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>@lang('labels.general.taxid')</b></label>
                        <input type="text" name="tax_id" id="edit_tax_id" class="form-control mb-1" placeholder="" maxlength="50">
                    </div>
                    {{-- <div class="form-group mb-2">
                        <label class=""><b>Business Reg No.</b></label>
                        <input type="text" name="business_reg_number" id="edit_business_reg_number" class="form-control mb-1" placeholder="" maxlength="50">
                    </div> --}}
                    <div class="form-group mb-2">
                        <label class=""><b>Address</b></label>
                        <textarea name="address" id="edit_address" rows="3" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>Bank Details</b></label>
                        <textarea name="bank_details" rows="3" id="edit_bank_details" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>Terms & Conditions</b></label>
                        <textarea name="terms_conditions" rows="3" id="edit_terms_conditions" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class=""><b>Footer Text</b></label>
                        <textarea name="footer_text" id="edit_footer_Text" class="form-control mb-1" maxlength="200"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>
{{-- //Edit Modal --}}

@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>
    var sel_vals = onload_type_val = edit_wrapper = selValArr = "";
    $(document).ready(function(){
            
    //Edit modal
    $('.edit_conf').click(function() {

            $('#edit_name').val($(this).data('name'));
            $('#edit_email').val($(this).data('email'));
            $('#edit_phone').val($(this).data('phone'));
            $('#edit_address').val($(this).data('address'));
            $('#edit_tax_id').val($(this).data('tax_id'));
            // $('#edit_business_reg_number').val($(this).data('reg_num'));
            $('#edit_footer_Text').val($(this).data('footer_text'));
            $('#edit_bank_details').val($(this).data('bank_details'));
            $('#edit_terms_conditions').val($(this).data('terms_text'));
            //$('#edit_business_logo').val($(this).data('business_logo'));
            $('#edit_config_form').attr('enctype', 'multipart/form-data');
            $('#edit_config_form').attr('action', $(this).data('action_url'));
            
    });
    $('#edit_modal').on('hidden.bs.modal', function () {
        $(this).find('form').trigger('reset');
    });
    $('#create_modal').on('hidden.bs.modal', function () {
        $(this).find('form').trigger('reset');
    });
});


function delConfig(id){
        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        Swal.fire({
        title: "Are you sure you want to delete this Business Configuration?",
        html: "" + warning + "",
        showCancelButton: true,
        confirmButtonColor: "#DC3545",
        confirmButtonText: `Delete`,
        }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "{{ url('admin/settings/business-configs/delete/')}}/"+id;
        } else if (result.isDenied) {
            
        }
        });
    }

</script>
@endpush