@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Settings</h4>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('course-certificate-configuration')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                    <div class="tab-pane fade general show active" id="general">

                        <form class="row g-3" action="{{route('admin.settings.course-certificate-configuration-save')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-md-5 mt-2">
                                    <label for="" class="form-label required-field" style="font-size: 15px;">Company/Business Name</label>
                                    <input type="text" name="certificate_business_name" class="form-control" value="{{get_site_config('certificate_business_name')}}" required>
                                    <br />
                                    <br />
                                    <label for="" style="font-size: 15px;" class="form-label required-field">Company/Business Logo</label><br>
                                    @if(get_site_config('certificate_logo'))
                                    <img src="{{ url('storage/'.get_site_config('certificate_logo')) }}" alt="Company/Business logo" style="height:70px;padding:8px 0px 10px">
                                    @endif
                                    <input class="" type="file" name="certificate_logo_file">
                                    <br />
                                    <span style="font-size:0.9em;">Allowed: png, jpg. File size must not exceed 200KB</span>
                                    <br />
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text required-field" style="padding: 5px;font-size: 15px;">Img Height (px)</span>
                                        </div>
                                        <input type="number" name="certificate_logo_ht" class="form-control" placeholder=" Height" value="{{(get_site_config('certificate_logo_ht'))?get_site_config('certificate_logo_ht') : '150'}}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-5 mt-4">
                                    <label for="" style="font-size: 15px;" class="form-label required-field">Signature</label><br>
                                    @if(get_site_config('certificate_sign'))
                                    <img src="{{ url('storage/'.get_site_config('certificate_sign')) }}" alt="Certificate Sign" style="height:70px;padding:8px 0px 10px">
                                    @endif
                                    <input class="" type="file" name="certificate_sign_file">
                                    <br />
                                    <span style="font-size:0.9em;">Allowed: png, jpg.
                                        File size must not exceed 200KB</span>
                                    <br />
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text required-field" style="padding: 5px;font-size: 15px;">Img Height (px)</span>
                                        </div>
                                        <input type="number" name="certificate_sign_ht" class="form-control" placeholder="Height" value="{{(get_site_config('certificate_sign_ht'))? get_site_config('certificate_sign_ht') : '200'}}" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row col-12 mt-4">
                                <div class="text-center">
                                    <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                </div>
                            </div>
                        </form>

                    </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
    });

    function copyToClipboard() {
        containerid = 'web_lead_html_code';
        if (document.selection) {
            var range = document.body.createTextRange();
            range.moveToElementText(document.getElementById(containerid));
            range.select().createTextRange();
            document.execCommand("copy");
        } else if (window.getSelection) {
            var range = document.createRange();
            range.selectNode(document.getElementById(containerid));
            window.getSelection().addRange(range);
            document.execCommand("copy");
            alert("Text has been copied to Clipboard")
        }
    }
</script>
@endpush