@extends('backend.layouts.app')

@section('title', 'Settings: Custom Attributes')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('custom-attributes')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Custom Attributes</h4>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Application Stage" style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Application Stage"><i class="bi bi-plus-circle"></i> New</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive" style="height:500px!important;">
                                            <table class="table table-striped fixTableHead">
                                                <thead style="background-color: rgb(242,242,242);">
                                                    <tr>
                                                        <th>Sl No.</th>
                                                        <th>Name</th>
                                                        <th>Label</th>
                                                        <th>Type</th>
                                                        <th>Placeholder</th>
                                                        <th>Selection Values</th>
                                                        <th>Is multiple</th>
                                                        <th>Input Datatype</th>
                                                        <th>Min</th>
                                                        <th>Max</th>
                                                        <th>Laravel Rules</th>
                                                        <th>Attribute For</th>
                                                        <th>Mandatory For Lead</th>
                                                        <th>Mandatory For Student</th>
                                                        <th style="width: 8%;">Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($attrs as $attr)
                                                    <tr>
                                                        <td class="">
                                                            {{ $loop->iteration }}
                                                        </td>
                
                                                        <td class="text-left">{{$attr->name}}</td>
                                                        <td class="text-left">{{$attr->label}}</td>
                                                        <td class="text-left">{{$attr->type}}</td>
                                                        <td class="text-left">{{$attr->placeholder}}</td>
                                                        <td class="text-left">{{$attr->selection_values}}</td>
                                                        <td class="text-left">{{($attr->select_multiple) ? 'Yes' : 'No'}}</td>
                                                        <td class="text-left">{{$attr->input_datatype}}</td>
                                                        <td class="text-left">{{$attr->input_min}}</td>
                                                        <td class="text-left">{{$attr->input_max}}</td>
                                                        <td class="text-left">{{$attr->laravel_rules}}</td>
                                                        <td class="text-left">
                                                            @if($attr->for_lead && $attr->for_student)
                                                                Lead & Student
                                                            @else
                                                                @if($attr->for_lead)
                                                                    Lead
                                                                @endif
                                                                @if($attr->for_student)
                                                                    Student
                                                                @endif
                                                            @endif
                                                        </td>
                                                        <td class="text-left">
                                                            {{($attr->for_lead_mandatory) ? "Yes" : ""}}
                                                        </td>
                                                        <td class="text-left">
                                                            {{($attr->for_student_mandatory) ? "Yes" : ""}}
                                                        </td>
                                                       
                                                        <td class="text-center qty">
                                                            <input style="" class="form-control" id="order{{$attr->id}}" onchange="update_order({{$attr->id}})" type="number" value="{{$attr->display_order}}" name="display_order" style="">
                                                            <span style="display:none;" id="load-ing-{{$attr->id}}" class="text-success p-3"><b>Updating...</b></span>
                                                        </td>
                                                        <td class="text-center">
                                                            <div style="display: flex; text-align: center;">
                                                                <a class="btn btn-sm edit_attr" href="" data-bs-toggle="modal" data-bs-target="#edit_modal" data-name="{{ $attr->name }}" data-label="{{ $attr->label }}" data-attr_id="{{ $attr->id }}" data-type="{{$attr->type}}" data-placeholder="{{$attr->placeholder}}" data-selection_values="{{$attr->selection_values}}" data-select_multiple="{{$attr->select_multiple}}" data-input_datatype="{{$attr->input_datatype}}" data-input_min="{{$attr->input_min}}" data-input_max="{{$attr->input_max}}" data-laravel_rules="{{$attr->laravel_rules}}" data-for_lead="{{$attr->for_lead}}" data-for_student="{{$attr->for_student}}" data-for_lead_mandatory="{{$attr->for_lead_mandatory}}" data-for_student_mandatory="{{$attr->for_student_mandatory}}" data-action_url="{{route('admin.settings.custom-attributes.update', $attr->id)}}"><i class='fas fa-edit text-primary' style='font-size:17px'></i></a>
                                                                <a href="#" onclick="delAttr({{$attr->id}})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                                            </div>
                
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        {{-- <small><b>Notes:</b>
                                            <ul>
                                                <li>Super Admin is allowed to change a application status to previous status even if "Can go back to previous stage = No"</li>
                                            </ul>
                                        </small> --}}
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog modal-md" role="document">
        <form method="post" action="{{route('admin.settings.custom-attributes.store')}}" id="">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Custom Attribute</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="name" class="form-control required-field mb-1" placeholder="" maxlength="100" required>
                        <small>Unique name for your reference</small>
                    </div>
                    <div class="form-group row mt-2 att_for">
                        <div class="col-sm-12">
                            <span class="label required-field mb-2"><b>Attribute For</b></span><br>
                            <input class="attr_chk" type="checkbox" name="attribute_for[]" id="attr_lead" value="leads" required> <label for="attr_lead"> Leads</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input class="attr_chk" type="checkbox" name="attribute_for[]" id="attr_stu" value="students" required> <label for="attr_stu"> Students</label>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Type</b></span><br>
                            <select class="form-select" id="type" name="type" required>
                                <option value="">Select Type</option>
                                <option value="select">Select Box</option>
                                <option value="input">Input Field</option>
                                <option value="textarea">Text Area</option>
                                <option value="checkbox">Checkbox</option>
                                <option value="radio">Radio Options</option>
                            </select>  
                        </div>
                    </div>
                    <div class="form-group row mt-2" id="selection_box" style="display: none;">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Selection</b></span><br>
                            <select class="form-control form-select" id="selection" name="selection">
                                <option value="">Select</option>
                                <option value="single">Single Value</option>
                                <option value="multiple">Multiple</option>
                            </select>              
                        </div>
                    </div>

                    <div class="form-group row mt-2" id="input_box" style="display: none;">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Input Data Type</b></span><br>
                            <select class="form-control form-select" id="input_type" name="input_type">
                                <option value="">Select</option>
                                <option value="text">Text</option>
                                <option value="number">Number</option>
                                <option value="decimal">Decimal</option>
                                <option value="date">Date</option>
                                <option value="year">Year</option>
                                <option value="email">Email</option>
                                <option value="phone">Phone</option>
                                <option value="url">Url</option>
                            </select>              
                        </div>
                    </div>

                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Label</b></span><br>
                            <input type="text" class="form-control mb-1" id="label" value="{{old('label')}}" name="label" required>
                            <small>This is shown as form input label to the user</small>
                        </div>
                    </div>

                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label"><b>Placeholder</b></span><br>
                            <input type="text" class="form-control mb-1" id="placeholder" value="{{old('placeholder')}}" name="placeholder">
                            <small>Form input placeholder</small>
                        </div>
                    </div>

{{-- //Values --}}
                    <div class="form-group row mt-2" id="values_box" style="display: none;">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Values</b></span><br>
                        </div>
                        <div class="field_wrapper col-sm-12">
                            <div>
                                <input type="text" style="width:95%;" class="form-control values" name="values[]" value=""/>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                            </div>
                        <div class="col-sm-6 text-end">
                            <a href="javascript:void(0);" style="" class="add_more_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
                        </div>
                        </div>
                    </div>
{{-- //Values --}} 
        <div id="validation_div" style="display: none;">
            <div class="form-group row mt-2">
                <hr>
                <div class="col-lg-4 col-md-12 col-sm-12">
                    <label class="h6"><b>Validation</b><label>
                </div>
            </div>
            <div class="form-group row mt-1">
                <div class="col-sm-12 col-md-6">
                    <span class="label "><b id="min_val_lbl">Minimum Value</b></span><br>
                    <input type="text" name="min_val" id="min_val" class="form-control">
                </div>
            
                <div class="col-sm-12 col-md-6">
                    <span class="label"><b id="max_val_lbl">Maximum Value</b></span><br>
                    <input type="text" name="max_val" id="max_val" class="form-control">
                </div>
            </div>
        </div>

            {{-- <div class="form-group row mt-2">
                <div class="col-sm-12">
                    <span class="label"><b>Validation Rules</b></span><br>
                <input type="text" name="laravel_rules" id="laravel_rules" class="form-control mb-1">
                <small>Laravel validation</small>
            </div>
            </div> --}}
            <div class="form-group row mt-2" id="mand_multiple">
                <div class="col-sm-6" id="lead_mand_blk" style="display: none;">
                    <span class="label"><b>Mandatory for Leads?</b></span><br>
                    <input type="checkbox" id="lead_mandatory" style="height: 18px;width: 18px;" value="1" name="lead_mandatory">
                </div>
                <div class="col-sm-6" id="stu_mand_blk" style="display: none;">
                    <span class="label"><b>Mandatory for Students?</b></span><br>
                    <input type="checkbox" id="student_mandatory" style="height: 18px;width: 18px;" value="1" name="student_mandatory">
                </div>
            </div>
            {{-- <div class="form-group row mt-2">
                <div class="col-sm-4" id="">
                    <span class="label required-field"><b>Display Order</b></span><br>
                    <input type="number" name="display_order" id="display_order" class="form-control" required>
                </div>
            </div> --}}
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- //Edit modal --}}
<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog modal-md" role="document">
        <form method="post" id="edit_attr_form">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Custom Attribute</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" id="edit_name" name="name" class="form-control required-field mb-1" placeholder="" maxlength="100" required>
                        <small>Unique name for your reference</small>
                    </div>
                    <div class="form-group row mt-2 att_for">
                        <div class="col-sm-12">
                            <span class="label required-field mb-2"><b>Attribute For</b></span><br>
                            <input class="attr_chk" type="checkbox" name="attribute_for[]" id="edit_attr_lead" value="leads" required> <label for="edit_attr_lead"> Leads</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input class="attr_chk" type="checkbox" name="attribute_for[]" id="edit_attr_stu" value="students" required> <label for="edit_attr_stu"> Students</label>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Type</b></span><br>
                            <select class="form-select" id="edit_type" name="type" required>
                                <option value="">Select Type</option>
                                <option value="select">Select Box</option>
                                <option value="input">Input Field</option>
                                <option value="textarea">Text Area</option>
                                <option value="checkbox">Checkbox</option>
                                <option value="radio">Radio Options</option>
                            </select>  
                        </div>
                    </div>
                    <div class="form-group row mt-2" id="edit_selection_box" style="display: none;">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Selection</b></span><br>
                            <select class="form-control form-select" id="edit_selection" name="selection">
                                <option value="">Select</option>
                                <option value="single">Single Value</option>
                                <option value="multiple">Multiple</option>
                            </select>              
                        </div>
                    </div>

                    <div class="form-group row mt-2" id="edit_input_box" style="display: none;">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Input Data Type</b></span><br>
                            <select class="form-control form-select" id="edit_input_type" name="input_type">
                                <option value="">Select</option>
                                <option value="text">Text</option>
                                <option value="number">Number</option>
                                <option value="decimal">Decimal</option>
                                <option value="date">Date</option>
                                <option value="year">Year</option>
                                <option value="email">Email</option>
                                <option value="phone">Phone</option>
                                <option value="url">Url</option>
                            </select>              
                        </div>
                    </div>

                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Label</b></span><br>
                            <input type="text" class="form-control mb-1" id="edit_label" value="{{old('label')}}" name="label" required>
                            <small>This is shown as form input label to the user</small>
                        </div>
                    </div>

                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label"><b>Placeholder</b></span><br>
                            <input type="text" class="form-control mb-1" id="edit_placeholder" value="{{old('placeholder')}}" name="placeholder">
                            <small>Form input placeholder</small>
                        </div>
                    </div>

{{-- //Values --}}
                    <div class="form-group row mt-2" id="edit_values_box" style="display: none;">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Values</b></span><br>
                        </div>
                        <div class="edit_field_wrapper col-sm-12">
                            <div>
                                <input type="text" style="width:95%; display:none;" class="form-control edit_values" name="values[]" value=""/>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                            </div>
                        <div class="col-sm-6 text-end">
                            <a href="javascript:void(0);" style="" class="edit_add_more_button btn btn-sm btn-outline-success" title="Add field"><i style="font-size:15px;" class="bi bi-plus"></i>Add More</a>
                        </div>
                        </div>
                    </div>
{{-- //Values --}} 
        <div id="edit_validation_div" style="display: none;">
            <div class="form-group row mt-2">
                <hr>
                <div class="col-lg-4 col-md-12 col-sm-12">
                    <label class="h6"><b>Validation</b><label>
                </div>
            </div>
            <div class="form-group row mt-1">
                <div class="col-sm-12 col-md-6">
                    <span class="label "><b id="edit_min_val_lbl">Minimum Value</b></span><br>
                    <input type="text" name="min_val" id="edit_min_val" class="form-control">
                </div>
            
                <div class="col-sm-12 col-md-6">
                    <span class="label"><b id="edit_max_val_lbl">Maximum Value</b></span><br>
                    <input type="text" name="max_val" id="edit_max_val" class="form-control">
                </div>
            </div>
        </div>

            {{-- <div class="form-group row mt-2">
                <div class="col-sm-12">
                    <span class="label"><b>Validation Rules</b></span><br>
                <input type="text" name="laravel_rules" id="edit_laravel_rules" class="form-control mb-1">
                <small>Laravel validation</small>
            </div>
            </div> --}}
            <div class="form-group row mt-2" id="edit_mand_multiple">
                <div class="col-sm-6" id="edit_lead_mand_blk" style="display: none;">
                    <span class="label"><b>Mandatory for Leads?</b></span><br>
                    <input type="checkbox" id="edit_lead_mandatory" style="height: 18px;width: 18px;" value="1" name="lead_mandatory">
                </div>
                <div class="col-sm-6" id="edit_stu_mand_blk" style="display: none;">
                    <span class="label"><b>Mandatory for Students?</b></span><br>
                    <input type="checkbox" id="edit_student_mandatory" style="height: 18px;width: 18px;" value="1" name="student_mandatory">
                </div>
            </div>
            {{-- <div class="form-group row mt-2">
                <div class="col-sm-4" id="">
                    <span class="label required-field"><b>Display Order</b></span><br>
                    <input type="number" name="display_order" id="display_order" class="form-control" required>
                </div>
            </div> --}}
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>
{{-- //Edit Modal --}}

@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">

<style> 
    .fixTableHead { 
      overflow-y: auto; 
      height: 110px; 
    } 
    .fixTableHead thead { 
      position: sticky; 
      top: 0; 
      z-index: 1000;
    } 
    table { 
      border-collapse: collapse;         
      width: 100%; 
    } 
</style>
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>
    var sel_vals = onload_type_val = edit_wrapper = selValArr = "";
    $(document).ready(function(){
            
            $('#type').change(function() {
                var type_val = $(this).val();
                if(type_val == "select"){
                    $("#selection").removeAttr('disabled');
                    $("#selection_box").css('display','block');
                    $("#selection").attr('required',true);
                    $("#input_type").val('');
                    $("#input_type").attr('disabled','disabled');
                    $("#input_box,#validation_div").css('display','none');

                    $(".values").removeAttr('disabled');
                    $("#values_box").css('display','block');
                }
                else if(type_val == "textarea"){
                    $("#selection").val('');
                    $("#selection").removeAttr('required');
                    $("#selection,.values").attr('disabled','disabled');
                    $("#selection_box,#values_box").css('display','none');
                    $("#input_type").val('');
                    $("#validation_div").css('display','none');
                    $("#input_type").attr('disabled','disabled');
                    $("#input_box").css('display','none');
                }

                else if(type_val == "checkbox" || type_val == "radio"){
                    $(".values").removeAttr('disabled');
                    $("#values_box").css('display','block');
                    $("#input_type").val('');
                    $("#input_type").attr('disabled','disabled');
                    $("#input_box,#selection_box,#validation_div").css('display','none');
                }
                else if(type_val == "input"){
                    $("#input_type").removeAttr('disabled');
                    $("#input_type").attr('required',true);
                    $("#input_box,#validation_div").css('display','block');
                    $("#selection").val('');
                    $("#selection").removeAttr('required');
                    $("#selection,.values").attr('disabled','disabled');
                    $("#selection_box,#values_box").css('display','none');
                }
                else{
                    $("#selection,#input_type,.values").val('');
                    $("#selection,#input_type,.values").attr('disabled','disabled');
                    $("#selection,#input_type").removeAttr('required');
                    $("#selection_box,#input_box,#values_box,#validation_div").css('display','none');
                }
            });   
            
            
            $('#input_type').change(function() {
                var inpt_type_val = $(this).val();
                if(inpt_type_val == "number" || inpt_type_val == "decimal"){
                    $("#min_val_lbl").html('Minimum Value');
                    $("#max_val_lbl").html('Maximum Value');
                    $("#validation_div").css('display','block');
                }
                else if(inpt_type_val == "date" || inpt_type_val == "year"){
                    
                    $("#validation_div").css('display','none');
                }
                else{
                    $("#min_val_lbl").html('Minimum character');
                    $("#max_val_lbl").html('Maximum character');
                    $("#validation_div").css('display','block');
                    
                }
            }); 

        //Add more field
            var maxField = 20; //Input fields increment limitation
            var addButton = $('.add_more_button'); //Add button selector
            var wrapper = $('.field_wrapper'); //Input field wrapper
            var fieldHTML = '<div><input type="text" style="width:95%;display:inline;" class="form-control values" name="values[]" value=""/> <a style="display:inline;" href="javascript:void(0);" class="remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div>'; //New input field html 
            var x = 1; //Initial field counter is 1
            
            //Once add button is clicked
            $(addButton).click(function(){
                //Check maximum number of input fields
                if(x < maxField){ 
                    x++; //Increment field counter
                    $(wrapper).append(fieldHTML); //Add field html
                }
            });
            
            //Once remove button is clicked
            $(wrapper).on('click', '.remove_button', function(e){
                e.preventDefault();
                $(this).parent('div').remove(); //Remove field html
                x--; //Decrement field counter
            });
        //Add more field

    //Edit modal
    $('.edit_attr').click(function() {
            $('#edit_attr_lead,#edit_attr_stu').prop("required", false);
            $('#edit_attr_stu,#edit_attr_lead,#edit_student_mandatory,#edit_lead_mandatory').prop("checked", false);
            $("#edit_stu_mand_blk,#edit_lead_mand_blk").css('display','none');

            $('#edit_name').val($(this).data('name'));
            $('#edit_label').val($(this).data('label'));
            $('#edit_min_val').val($(this).data('input_min'));
            $('#edit_max_val').val($(this).data('input_max'));
            onload_type_val = $(this).data('type');
            var for_lead = $(this).data('for_lead');
            var for_student = $(this).data('for_student');
            $('#edit_placeholder').val($(this).data('placeholder'));
            var for_lead_mandatory = $(this).data('for_lead_mandatory');
            var for_student_mandatory = $(this).data('for_student_mandatory');

            sel_vals = $(this).data('selection_values');
            //console.log("Inside "+sel_vals);
            $("#edit_type").val($(this).data('type')).change();

            if(sel_vals != ""){
                edit_wrapper = $('.edit_field_wrapper');
                $('.dyna').remove();
                selValArr = sel_vals.split('|');
                console.log(selValArr);
                $.each(selValArr,function(i){
                    if(i == 0){
                        $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/></div>');
                    }else{
                        $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/> <a style="display:inline;" href="javascript:void(0);" class="edit_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div>');
                    }
                });
                 
            }

            $("#edit_input_type").val($(this).data('input_datatype')).change();

            if($(this).data('select_multiple') == 1){
                $("#edit_selection").val("multiple").change();
            }
            else if($(this).data('select_multiple') == 0){
                $("#edit_selection").val("single").change();
            }else{
                $("#edit_selection").val("").change();
            }
            

            if(for_lead == 1){
                $('#edit_attr_lead').prop("checked", true);
                $("#edit_lead_mand_blk").css('display','block');
                if(for_lead_mandatory == 1){

                    $('#edit_lead_mandatory').prop("checked", true);
                }
            }
            if(for_student == 1){
                $('#edit_attr_stu').prop("checked", true);
                $("#edit_stu_mand_blk").css('display','block');
                if(for_student_mandatory == 1){
                    $('#edit_student_mandatory').prop("checked", true);
                }
            }
            if(onload_type_val == "select"){
                    $("#edit_selection").removeAttr('disabled');
                    $("#edit_selection_box").css('display','block');
                    $("#edit_selection").attr('required',true);
                    $("#edit_input_type").val('');
                    $("#edit_input_type").attr('disabled','disabled');
                    $("#edit_input_box,#edit_validation_div").css('display','none');

                    $(".edit_values").removeAttr('disabled');
                    $("#edit_values_box").css('display','block');
                }
                else if(onload_type_val == "textarea"){
                    $("#edit_selection").val('');
                    $("#edit_selection").removeAttr('required');
                    $("#edit_selection,.edit_values").attr('disabled','disabled');
                    $("#edit_selection_box,#edit_values_box").css('display','none');
                    $("#edit_input_type").val('');
                    $("#edit_validation_div").css('display','none');
                    $("#edit_input_type").attr('disabled','disabled');
                    $("#edit_input_box").css('display','none');
                }

                else if(onload_type_val == "checkbox" || onload_type_val == "radio"){
                    $(".edit_values").removeAttr('disabled');
                    $("#edit_values_box").css('display','block');
                    $("#edit_input_box,#edit_selection_box,#edit_validation_div").css('display','none');
                }
                else if(onload_type_val == "input"){
                    $("#edit_input_type").removeAttr('disabled');
                    $("#edit_input_type").attr('required',true);
                    $("#edit_input_box,#edit_validation_div").css('display','block');
                    $("#edit_selection").val('');
                    $("#edit_selection").removeAttr('required');
                    $("#edit_selection,.edit_values").attr('disabled','disabled');
                    $("#edit_selection_box,#edit_values_box").css('display','none');
                }
                else{
                    $("#edit_selection,#edit_input_type,.edit_values").val('');
                    $("#edit_selection,#edit_input_type,.edit_values").attr('disabled','disabled');
                    $("#edit_selection,#edit_input_type").removeAttr('required');
                    $("#edit_selection_box,#edit_input_box,#edit_values_box,#edit_validation_div").css('display','none');
                }
                
            $('#edit_attr_form').attr('action', $(this).data('action_url'));
            
    });



        $('#edit_type').on("change",function(){
                $("div.dyna").remove();
                $(".edit_values").css('display','none'); 
                var edit_type_val = $(this).val();
                if(edit_type_val == "select"){
                    $("#edit_selection").removeAttr('disabled');
                    $("#edit_selection_box").css('display','block');
                    $("#edit_selection").attr('required',true);
                    $("#edit_input_type").val('');
                    $("#edit_input_type").attr('disabled','disabled');
                    $("#edit_input_box,#edit_validation_div").css('display','none');
                    console.log("Type "+edit_type_val);
                    console.log("Global "+sel_vals);
                    console.log("On load "+onload_type_val);
                    if(onload_type_val != "select" ){
                        $(".edit_values").css('display','block');
                        $("div.dyna").remove();
                    }
                    if(onload_type_val == "select" && sel_vals != ""){
                        if(sel_vals != ""){
                            $('.dyna').remove();
                            selValArr = sel_vals.split('|');
                            $.each(selValArr,function(i){
                                if(i == 0){
                                    $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/></div>');
                                    }else{
                                        $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/> <a style="display:inline;" href="javascript:void(0);" class="edit_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div>');
                                    }
                            });
                            
                        }
                    }
                    
                    $(".edit_values").removeAttr('disabled');
                    $("#edit_values_box").css('display','block');
                }
                else if(edit_type_val == "textarea"){
                    $("#edit_selection").val('');
                    $("#edit_selection").removeAttr('required');
                    $("#edit_selection,.edit_values").attr('disabled','disabled');
                    $("#edit_selection_box,#edit_values_box").css('display','none');
                    $("#edit_input_type").val('');
                    $("#edit_validation_div").css('display','none');
                    $("#edit_input_type").attr('disabled','disabled');
                    $("#edit_input_box").css('display','none');
                }

                else if(edit_type_val == "checkbox" ){
                    $(".edit_values").removeAttr('disabled');
                    console.log("Type "+edit_type_val);
                    
                    if(onload_type_val != "checkbox"){
                        $(".edit_values").css('display','block');
                        $("div.dyna").remove();
                    }
                    if(onload_type_val == "checkbox" && sel_vals != ""){
                        if(sel_vals != ""){
                            $('.dyna').remove();
                            selValArr = sel_vals.split('|');
                            $.each(selValArr,function(i){
                                if(i == 0){
                                    $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/></div>');
                                }else{
                                    $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/> <a style="display:inline;" href="javascript:void(0);" class="edit_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div>');
                                }
                            });
                            
                        }
                    }
                    
                    $("#edit_values_box").css('display','block');
                    $("#edit_input_box,#edit_selection_box,#edit_validation_div").css('display','none');
                }
                else if(edit_type_val == "radio"){
                    $(".edit_values").removeAttr('disabled');
                    console.log("Type "+edit_type_val);
                    
                    if(onload_type_val != "radio"){
                        $(".edit_values").css('display','block');
                        $("div.dyna").remove();
                    }
                    if(onload_type_val === "radio" && sel_vals != ""){
                        if(sel_vals != ""){
                        // wrapper = $('.edit_field_wrapper');
                            $('.dyna').remove();
                            selValArr = sel_vals.split('|');
                            // console.log(selValArr);
                            $.each(selValArr,function(i){
                                if(i == 0){
                                    $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/></div>');
                                }else{
                                    $(edit_wrapper).append('<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value="'+selValArr[i]+'"/> <a style="display:inline;" href="javascript:void(0);" class="edit_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div>');
                                }
                            });
                            
                        }
                    }
                    $("#edit_values_box").css('display','block');
                    $("#edit_input_box,#edit_selection_box,#edit_validation_div").css('display','none');
                }
                else if(edit_type_val == "input"){
                    $("#edit_input_type").removeAttr('disabled');
                    $("#edit_input_type").attr('required',true);
                    $("#edit_input_box,#edit_validation_div").css('display','block');
                    $("#edit_selection").val('');
                    $("#edit_selection").removeAttr('required');
                    $("#edit_selection,.edit_values").attr('disabled','disabled');
                    $("#edit_selection_box,#edit_values_box").css('display','none');
                }
                else{
                    $("#edit_selection,#edit_input_type,.edit_values").val('');
                    $("#edit_selection,#edit_input_type,.edit_values").attr('disabled','disabled');
                    $("#edit_selection,#edit_input_type").removeAttr('required');
                    $("#edit_selection_box,#edit_input_box,#edit_values_box,#edit_validation_div,.edit_values").css('display','none');
                }
            });   
            
            
            $('#edit_input_type').change(function() {
                var inpt_type_val = $(this).val();
                if(inpt_type_val == "number" || inpt_type_val == "decimal"){
                    $("#edit_min_val_lbl").html('Minimum Value');
                    $("#edit_max_val_lbl").html('Maximum Value');
                    $("#edit_validation_div").css('display','block');
                }
                else if(inpt_type_val == "date" || inpt_type_val == "year"){
                    
                    $("#edit_validation_div").css('display','none');
                }
                else{
                    $("#edit_min_val_lbl").html('Minimum character');
                    $("#edit_max_val_lbl").html('Maximum character');
                    $("#edit_validation_div").css('display','block');
                    
                }
            }); 


        //Add more field(Edit)
            var editMaxField = 20; //Input fields increment limitation
            var editAddButton = $('.edit_add_more_button'); //Add button selector
            var editWrapper = $('.edit_field_wrapper'); //Input field wrapper
            var editFieldHTML = '<div class="dyna"><input type="text" style="width:95%;display:inline;" class="form-control edit_values" name="values[]" value=""/> <a style="display:inline;" href="javascript:void(0);" class="edit_remove_button"><i style="font-size:18px;float: right;" class="bi bi-dash-circle"></i></a></div>'; //New input field html 
            var a = 1; //Initial field counter is 1
            
            //Once add button is clicked
            $(editAddButton).click(function(){
                //Check maximum number of input fields
                if(a < editMaxField){ 
                    a++; //Increment field counter
                    $(editWrapper).append(editFieldHTML); //Add field html
                }
            });
            //Once remove button is clicked
            $(editWrapper).on('click', '.edit_remove_button', function(j){
                j.preventDefault();
                $(this).parent('div').remove(); //Remove field html
                a--; //Decrement field counter
            });
        //Add more field

            $('#edit_modal').on('hidden.bs.modal', function () {
                $(this).find('form').trigger('reset');
            });
            $('#create_modal').on('hidden.bs.modal', function () {
                $(this).find('form').trigger('reset');
            });
        });
    function delStatus(id){
        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        Swal.fire({
        title: "Are you sure you want to delete this application status?",
        html: "" + warning + "",
        showCancelButton: true,
        confirmButtonColor: "#DC3545",
        confirmButtonText: `Delete`,
        }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "{{ url('admin/settings/application-stages/delete/')}}/"+id;
        } else if (result.isDenied) {
            
        }
        });
    }
$(function(){
    var requiredCheckboxes = $('.att_for :checkbox[required]');

    requiredCheckboxes.change(function(){
        if(requiredCheckboxes.is(':checked')) {
            requiredCheckboxes.removeAttr('required');
        } else {
            requiredCheckboxes.attr('required', 'required');
        }
    });

    $('#attr_lead').change(function() {
        if($(this).is(":checked")) {
            $("#lead_mand_blk").css('display','block');
            return;
        }
        $("#lead_mand_blk").css('display','none');
    });
    $('#attr_stu').change(function() {
        if($(this).is(":checked")) {
            $("#stu_mand_blk").css('display','block');
            return;
        }
        $("#stu_mand_blk").css('display','none');
    });


    $('#edit_attr_lead').change(function() {
        if($(this).is(":checked")) {
            $("#edit_lead_mand_blk").css('display','block');
            return;
        }
        $("#edit_lead_mand_blk").css('display','none');
    });
    $('#edit_attr_stu').change(function() {
        if($(this).is(":checked")) {
            $("#edit_stu_mand_blk").css('display','block');
            return;
        }
        $("#edit_stu_mand_blk").css('display','none');
    });
    
});
document.addEventListener("DOMContentLoaded", function() {
    var elements = document.getElementsByClassName("attr_chk");
    for (var i = 0; i < elements.length; i++) {
        elements[i].oninvalid = function(e) {
            e.target.setCustomValidity("");
            if (!e.target.validity.valid) {
                e.target.setCustomValidity("Please select atleast one.");
            }
        };
        elements[i].oninput = function(e) {
            e.target.setCustomValidity("");
        };
    }
})
function delAttr(id){
        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        Swal.fire({
        title: "Are you sure you want to delete this attribute?",
        html: "" + warning + "",
        showCancelButton: true,
        confirmButtonColor: "#DC3545",
        confirmButtonText: `Delete`,
        }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = "{{ url('admin/settings/custom-attributes/delete/')}}/"+id;
        } else if (result.isDenied) {
            
        }
        });
    }
function update_order(id){
    var order = $('#order'+id).val();
    $("#load-ing-"+id).show();
    console.log("#load-ing-"+id);
     $.ajax({
            url: '{{ route('admin.settings.custom-attributes.updateOrder') }}',
            method: "get",
            data: {
                id: id, 
                order: order
            },
            success: function (response) {
                $("#load-ing-"+id).hide();
                if(response.status == 200){
                    $.toast({
                        heading: 'Success',
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3000,
                        stack: 6
                    });
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Something went wrong!',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 8
                    });
                }
                
            }
       });
  }
</script>
@endpush