@extends('backend.layouts.app')

@section('title', 'Settings: Custom Labels')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('custom-labels')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Custom Labels</h4>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table nowrap">
                                                <thead>
                                                    <tr>
                                                        <th>Sl No.</th>
                                                        <th>Label</th>
                                                        <th>Value</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($labels as $label)
                                                    <tr action="{{route('admin.settings.custom-labels.update',$label->label)}}">
                                                        <td class="">
                                                            {{ $loop->iteration }}
                                                        </td>
                                                        <td class="text-left">{{$label->label}}</td>
                                                            <td class="text-left">
                                                            {{-- <form id="form_{{ $loop->iteration }}"  method="post">
                                                                    @csrf --}}
                                                                <input type="text" name="{{$label->label}}" class="form-control w-50" value="{{$label->custom_text}}" required data-id="{{$label->id}}">
                                                                <p class="mb-0"><b>Default Value: </b>{{$label->default_text}}</p>
                                                            {{-- </form> --}}
                                                            </td>
                                                            <td class="text-center">
                                                                <div style="display: flex; text-align: center;">
                                                                        <button type="button" onclick="formAJAX(this)" class="btn btn-primary">Save</button>
                                                                </div>
                                                            </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        {{-- <small><b>Notes:</b>
                                            <ul>
                                                <li>Super Admin is allowed to change a application status to previous status even if "Can go back to previous stage = No"</li>
                                            </ul>
                                        </small> --}}
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
@endpush

@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>

function formAJAX(btn){
    var $form = $(btn).closest('[action]');
    var label_id = $form.find('[name]').data('id');
    var label_value = $form.find('[name]').val();
    console.log(label_id+"--"+label_value);
    $.ajax({
            url: $form.attr('action'),
            method: "post",
            data: {
                '_token': $('meta[name="csrf-token"]').attr('content'),
                'label_id':label_id,
                'label_value':label_value,
            },
            success: function (response) {
                if(response.status == 200){
                    $.toast({
                        heading: 'Success',
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 3000,
                        stack: 6
                    });
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Something went wrong!',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 8
                    });
                }
                
            }
       });
}
</script>
@endpush