@extends('backend.layouts.app')

@section('title', 'Settings: Forms')

@section('content')

<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('manage-forms')!!}
                        </ul>
                    </div>
                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                              <h4>Form Builder</h4><br />
                      <div class="row">
                          <div class="col-sm-12">
                            <label>Name</label>
                          </div>
                          <div class="col-sm-10">
                            <div class="form-group">							
                              <input type="text" name="form_name" id="form_name" value="{{$desiredForm->title}}" class="form-control mb-0">
                              <small> This is for your reference only</small>
                            </div>
                          </div>
                          <div class="col-sm-10">
                            <div class="form-group">
                              <label class=""><b>Form Heading</b></label>
                              <input type="text" name="form_heading" id="form_heading" value="{{$desiredForm->form_heading}}" class="form-control" maxlength="100">
                            </div>
                          </div>
                          <div class="col-sm-10">
                            <div class="form-group">
                              <label class=""><b>Form Description Text</b></label>
                              <input type="text" name="description" id="description" value="{{$desiredForm->description}}" class="form-control" maxlength="200">
                            </div>
                          </div>
                        <div class="col-sm-6">
                          <div class="form-group">
                              <label class="required-field"><b>Redirect URL after form Submission</b></label>
                              <input class="form-control" value="{{$desiredForm->redirect_url}}" type="text" id="redirect_url" name="redirect_url" required>
                          </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-3">
                              <div class="form-group">
                                  <label class="required-field">
                                      Branch
                                  </label>
                                  <select class="form-select mb-0" name="branch" id="assign_to_branch" required>
                                      <option value="">Select Branch</option>
                                      @foreach($branches as $branch)
                                      <option {{($desiredForm->branch == $branch->id)? 'selected' : ''}} value="{{$branch->id}}">{{$branch->branch_name}}</option>
                                      @endforeach
                                  </select>
                                  <small>Assign the new lead to this branch</small>
                              </div>
                            </div>
                            <div class="col-sm-3">
                              <div class="form-group">
                                <label class="">Assign the new leads to</label>
                                <select class="form-select" name="assign_to" id="assign_to">
                                    <option value="">Select Staff</option>
                                </select>
                              </div>
                            </div>
                        </div>
                        <hr class=" mt-3">
                      <div class="row" id="main-row">				
                        <div class="col-sm-12 col-md-5 col-lg-4 cat-form @if(count($forms) == 0) disabled @endif">
                          <h4>Add Items to Form</h4>
                          <p class="mb-0">Check the required fields & click "Add to Form"</p>
                          <div class="accordion mt-3" id="menu_items">
                          <div class="accordion-item">
                            {{-- <h2 class="accordion-header">
                              <button class="accordion-button collapsed mb-0" type="button" data-bs-toggle="collapse" data-bs-target="#modulesTab" aria-expanded="true" aria-controls="modulesTab">
                                Modules
                              </button>
                            </h2> --}}
                          <div id="modulesTab" class="accordion-collapse collapse show" style="background-color: rgb(250,250,250)" data-bs-parent="menu_items">
                            <div class="accordion-body" style="border: none !important;">			
                              <div class="ms-2 mb-2" style="position: sticky; top: 0; z-index: 10000; background-color: rgb(250,250,250); border-bottom: 1px solid rgb(194, 194, 194);">
                                <label><input type="checkbox" id="select-all-modules"> Select All</label>
                              </div>
                              
                              <div class="item-list-body " id="fields-sidebar" style="border: none !important;">
                                <ul class="list-unstyled " style="border: none !important;">                                  
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="full_name"> Full Name (First name & Last name)</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="name"> Name</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="gender"> Gender</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="marital_status"> Marital Status</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="date_of_birth"> Date of Birth</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="email"> Email</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="mobile"> Mobile Number</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="whatsapp"> Whatsapp Number</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="country_of_citizenship"> Country of Citizenship</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="city"> City</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="currently_studying_course"> Currently Studying Course</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="interested_study_level"> Interested Study Level</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="course_interested"> Course Interested to Study</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="intake"> Intake</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="country_interested"> Country Interested to Study</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="qualification"> Qualification</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="passout_year"> Passout Year</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="score"> Score/Grade</label></li>

                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="academic"> Academic</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="english_test"> English Test</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="experience"> Experience</label></li>
                                  <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2"><input class="all-items-input" type="checkbox" name="select-module[]" data-type="default_input" value="visa_refusal"> Do you have Visa refusal for any country?</label></li>

                                  @if(count($custom_attributes))
                                      @foreach($custom_attributes as $custom_attribute)
                                      <li class="my-2 all-items-menu rounded"><label class="px-2 pt-2">
                                          <input class="all-items-input"  type="checkbox" name="select-module[]" data-type="custom_attr" value="{{$custom_attribute->attr_name}}">
                                              {{$custom_attribute->label}}
                                      </label></li>
                                      @endforeach
                                  @endif
                                  

                                  
                                  {{-- <li><label><input type="checkbox" name="select-module[]" value="city"> City</label></li>
                                  <li><label><input type="checkbox" name="select-module[]" value="city"> City</label></li>
                                  <li><label><input type="checkbox" name="select-module[]" value="city"> City</label></li>
                                  <li><label><input type="checkbox" name="select-module[]" value="city"> City</label></li> --}}
                                  {{-- <li><label><input type="checkbox" name="select-module[]" value="{{'course'}}"> {{get_site_config('top_courses_heading')}}</label></li>
                                  <li><label><input type="checkbox" name="select-module[]" value="{{'university'}}"> {{get_site_config('top_universities_heading')}}</label></li>
                                  <li><label><input type="checkbox" name="select-module[]" value="{{'faq'}}"> {{get_site_config('faq_heading')}}</label></li>
                                  <li><label><input type="checkbox" name="select-module[]" value="{{'gallery'}}"> {{get_site_config('gallery_heading')}}</label></li>
                                  <li><label><input type="checkbox" name="select-module[]" value="{{'contact'}}"> {{get_site_config('contact_meta_title')}}</label></li> --}}
                                </ul>
                              </div>	
                                <div class="item-list-footer">
                                  <div class="row">
                                    <div class="col-12 text-start">
                                      <button type="button" id="add-modules" class="btn btn-outline-primary btn-sm"><i class="bi bi-plus-circle"></i> Add to Form</button>
                                    </div>
                                    <hr>
                                    <div class="col-12 text-start">
                                      <button type="button" id="add-enquiry" class="btn btn-outline-primary btn-sm">Add Enquiry Field</button>
                                    </div>
                                  </div>
                                </div>
                              </div>						
                            </div>
                        </div>
                      </div>		
                    </div>		
                              
                            <div class="col-sm-12 col-lg-8 col-md-7 cat-view">
                                <h4>Form Structure</h4>
                                {{-- @if($desiredForm == '')
                                  <h4>Create New Menu</h4>
                                  <form method="post" action="{{url('admin/create-menu')}}">
                                    {{csrf_field()}}
                                    <div class="row">
                                      <div class="col-sm-12">
                                        <label>Name</label>
                                      </div>
                                      <div class="col-sm-6">
                                        <div class="form-group">							
                                          <input type="text" name="title" class="form-control">
                                        </div>
                                      </div>
                                      <div class="col-sm-6 text-right">
                                        <button class="btn btn-sm btn-primary">Create Menu</button>
                                      </div>
                                    </div>
                                  </form>
                                  @else --}}
                                  <div id="menu-content">
                                      <div id="result"></div>
                                    <div style="min-height: 360px;">
                                        <p class="m-0">Drag the items to re-order.</p>
                                        <p class="m-0">Click down arrow to edit field details.</p>
                                        <p class="m-0 mb-3">After making changes, click "Save Form" button.</p>
                                        @if($desiredForm != '')
                                          <ul class="menu list-unstyled" id="formitems">
                                          @if(!empty($formitems))
                                            @foreach($formitems as $key=>$item)
                                              <li data-id="{{$item->id}}" class="mb-3">
                                                <span class="menu-item-bar rounded" style="background-color: rgb(239, 245, 255); border: rgb(223, 236, 255); box-shadow: 2px 2px 2px rgb(223, 236, 255); color: black;"><i class="fas fa-arrows-alt"></i> {{$item->title}} <a class="float-end" href="#collapse{{$item->id}}" data-bs-toggle="collapse"> <i class="fa fa-chevron-down"></i></a></span>
                                                <div class="collapse" id="collapse{{$item->id}}">
                                                  <div class="input-box border rounded" style="background-color: #fcfcfc">
                                                    <form method="post" action="{{url('admin/update-formitem')}}/{{$item->id}}">
                                                      {{csrf_field()}}
                                                      <div class="form-group row">
                                                        <div class="col-6">
                                                          <label>Label</label>
                                                          <input type="text" placeholder="" style="width: 100%;" {{($item->input_name == 'full_name') ? 'disabled' : ''}} name="label" value="{{($item->label)}}" class="form-control">
                                                        </div>
                                                        <div class="col-6">
                                                          <label>Placeholder Text</label>
                                                          <input type="text" placeholder="" style="width: 100%;" {{($item->input_name == 'full_name') ? 'disabled' : ''}} name="placeholder" value="{{$item->placeholder}}" class="form-control">
                                                        </div>
                                                        <div class="col-6">
                                                          <label>Hint Text</label>
                                                          <input type="text" placeholder="" style="width: 100%;" name="hint" {{($item->input_name == 'full_name') ? 'disabled' : ''}} value="{{$item->hint}}" class="form-control">
                                                        </div>
                                                        <div class="col-6"  style="padding-top: 26px;">
                                                          <label class="">
                                                            <input type="checkbox" {{($item->mandatory) ? 'checked' : ''}} name="mandatory" value="1"> Mandatory Field</label>
                                                          @if($item->input_name == 'email' || $item->input_name == 'mobile')
                                                          <label class="mt-2 mb-2 ms-2"><input type="checkbox" {{($item->unique) ? 'checked' : ''}} name="unique" value="1"> Unique (Do not accept duplicate {{($item->input_name == 'email') ? 'email': 'mobile'}})</label>
                                                          @endif
                                                        </div>
                                                      </div>
                                                      <div class="form-group row">
                                                        <div class="col-6">
                                                          <button class="btn btn-sm btn-primary">Update</button>
                                                        </div>
                                                        <div class="col-6 text-end">
                                                          @if($item->type == "custom_attr")
                                                          <a href="{{url('admin/delete-formitem')}}/{{$item->id}}/{{$key}}/{{$item->input_name}}" class="btn btn-sm btn-danger"><i class="fas fa-trash-alt text-white"></i></a>
                                                          @else
                                                          <a href="{{url('admin/delete-formitem')}}/{{$item->id}}/{{$key}}" class="btn btn-sm btn-danger"><i class="fas fa-trash-alt text-white"></i></a>
                                                          @endif
                                                        </div>
                                                      </div>
                                                    </form>
                                                  </div>
                                                </div>
                                            @endforeach
                                          @endif
                                        </ul>	
                                          @if(!empty($formitems))
                                          <div class="text-center w-75">
                                            <button class="btn btn-sm btn-primary" id="saveForm">Save Form</button>
                                          </div>
                                          @endif
                                        @endif	
                                      </div>	
                                   									
                                  </div>
                                {{-- @endif	 --}}
                              </div>	
                                </div>
                              <div id="serialize_output">@if($desiredForm){{$desiredForm->content}}@endif</div>
                             
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
<style>
    .item-list,.info-box{background: #fff;padding: 10px;}
    .item-list-body{max-height: 400px;overflow-y: auto; border: 1px solid rgb(212, 212, 212);padding: 6px;}
    .panel-body p{margin-bottom: 5px;}
    .info-box{margin-bottom: 15px;}
    .item-list-footer{padding-top: 10px;}
    .panel-heading a{display: block;}
    .form-inline{display: inline;}
    .form-inline select{padding: 4px 10px;}
    .btn-menu-select{padding: 4px 10px}
    .disabled{pointer-events: none; opacity: 0.7;}
    .menu-item-bar{background: #eee;padding: 10px 10px;border:1px solid #d7d7d7;margin-bottom: 5px; width: 75%; cursor: move;display: block;}
    #serialize_output{display: none;}
    .menulocation label{font-weight: normal;display: block;}
    body.dragging, body.dragging * {cursor: move !important;}
    .dragged {position: absolute;z-index: 1;}
    ol.example li.placeholder {position: relative;}
    ol.example li.placeholder:before {position: absolute;}
    #menuitem{list-style: none;}
    #menuitem ul{list-style: none;}
    .input-box{width:75%;background:#fff;padding: 10px;box-sizing: border-box;margin-bottom: 5px;}
    .input-box .form-control{width: 50%}

    #fields-sidebar::-webkit-scrollbar {
      width: 8px;               /* width of the entire scrollbar */
    }

    #fields-sidebar::-webkit-scrollbar-track {
      background: rgb(221, 221, 221);        /* color of the tracking area */
    }

    #fields-sidebar::-webkit-scrollbar-thumb {
      background-color: rgb(13,110,253);    /* color of the scroll thumb */
      border-radius: 20px;       /* roundness of the scroll thumb */
      border: 3px solid rgb(13,110,253);  /* creates padding around scroll thumb */
    }
</style>
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>

<script type="text/javascript" src="{{ asset('assets/backend/js/sortable.js') }}"></script>
{{-- <script type="text/javascript" src="{{ asset('assets/backend/js/sortable.min.js') }}"></script> --}}
{{-- <script src="https://cdn.jsdelivr.net/npm/jquery-sortablejs@latest/jquery-sortable.js"></script> --}}
<script>
$(document).ready(function() {

  $('#assign_to_branch').change(function(){
            var branch_id= $('#assign_to_branch').val();
            if(branch_id!=''){
            $.ajax({
            type: "get",
            url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+branch_id,
            cache: false,
            success: function(data){                     
            try{  
                if(data){
                    console.log(data);
                $("#assign_to").empty();
                    $("#assign_to").append('<option>Select Staff</option>');
                $.each(data,function(key,value){
                    $("#assign_to").append('<option value="'+key+'">'+value+'</option>');
                });
                }else{
                    $("#assign_to").empty();
                }
            }catch(e) {     
                alert('Exception while request..');
            }   

            },
            error: function(){                      
                alert('Error while request..');
            }
            });
            }
        });
  // $('#formitems').sortable();
var group = $("#formitems").sortable({
  group: 'serialization',
  animation: 150,
  nested: false,
  onDrop: function ($item, container, _super) {
    var data = group.sortable("serialize").get();	    
    var jsonString = JSON.stringify(data, ' ');
    $('#serialize_output').text(jsonString);
  	  _super($item, container);
  },
  tolerance: 10,
});
var data = group.sortable("serialize").get();	    
    var jsonString = JSON.stringify(data, ' ');
    $('#serialize_output').text(jsonString);
});

$(window).on('load', function() {
        if($('#assign_to_branch').val()!=''){
            var branch_id= $('#assign_to_branch').val();
            var cur_staff = "{{$desiredForm->assign_to}}";
            $.ajax({
            type: "get",
            url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+branch_id,
            cache: false,
            success: function(data){                     
            try{  
                //$('#assign_to_branch').html(data.html);
                if(data){
                $("#assign_to").empty();
                $("#assign_to").append('<option>Select Staff</option>');
                $.each(data,function(key,value){
                    if(key == cur_staff){
                        var sel = "selected";
                    }else{
                        var sel = "";
                    }
                    $("#assign_to").append('<option '+sel+' value="'+key+'">'+value+'</option>');
                });
            }else{
               $("#assign_to").empty();
            }
            }catch(e) {     
                alert('Exception while request..');
            }   

            },
            error: function(){                      
                alert('Error while request..');
            }
        });
    }
    });

    $('.all-items-input').click(function(item){
      if(!item.target.parentElement.parentElement.getAttribute("style")){
        item.target.parentElement.parentElement.style.backgroundColor = 'rgb(239, 245, 255)';
      } else{
        item.target.parentElement.parentElement.removeAttribute("style");
      }
    })

    $('#select-all-modules').click(function(event) {   
      if(this.checked) {
        $('#modulesTab :checkbox').each(function() {
          this.checked = true;    
          $(".all-items-menu").css('background-color', 'rgb(239, 245, 255)') ;              
        });
      }else{
        $('#modulesTab :checkbox').each(function() {
          this.checked = false;   
          $(".all-items-menu").css('background-color', '') ;                       
        });
      }
    });
</script>
@if($desiredForm)
<script>


	$('#add-modules').click(function(){
	var formid = <?=$desiredForm->id?>;
	var n = $('input[name="select-module[]"]:checked').length;
	var array = $('input[name="select-module[]"]:checked');
	var ids = [];
  var type = [];
	for(i=0;i<n;i++){
		ids[i] =  array.eq(i).val();
    type[i] = array.eq(i).data('type');
	}
	if(ids.length == 0){
		return false;
	}
	$.ajax({
		type:"get",
		data: {formid:formid,ids:ids,type:type},
		url: "{{url('admin/add-item-to-form')}}",				
		success:function(res){
      if(res!=''){
        alert(res);
      }
		location.reload();
		}
	})
	});


  $('#add-enquiry').click(function(){
	var formid = <?=$desiredForm->id?>;
	var id =  "enquiry";
	$.ajax({
		type:"get",
		data: {formid:formid,id:id},
		url: "{{url('admin/add-enquiry-to-form')}}",				
		success:function(res){
      if(res!=''){
        alert(res);
      }
		location.reload();
		}
	})
	});


$('#saveForm').click(function(){
  var formid = <?=$desiredForm->id?>;
  var newText = $("#serialize_output").text();
  var data = JSON.parse($("#serialize_output").text());
  var form_name = $("#form_name").val();
  var form_heading = $("#form_heading").val();
  var description = $("#description").val();
  var redirect_url = $("#redirect_url").val();
  var assign_to_branch = $("#assign_to_branch").val();
  var assign_to = $("#assign_to").val();
  if(data!=''){
    $.ajax({
    type:"post",
    data: {'_token': $('meta[name="csrf-token"]').attr('content'),formid:formid,data:data,title:form_name,form_heading:form_heading,description:description,redirect_url:redirect_url,branch:assign_to_branch,assign_to:assign_to},
    url: "{{url('admin/update-form')}}",				
    success:function(res){
    if(res.status == true){
      window.location.href = "{{route('admin.form-builder')}}";
    }
      // $.toast({
      //     heading: 'Success',
      //     text: "Form Saved",
      //     position: 'top-right',
      //     loaderBg: '#ff6849',
      //     icon: 'success',
      //     hideAfter: 2000,
      //     stack: 8
      // });
      // setTimeout(function(){
      //   window.location.reload();
      // }, 1500);
    }
    });
}else{
  alert("Please add Form Items.");
}
});
</script>
@endif		
@endpush