@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Settings</h4>
    </div>
</div>

<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('uni-apply-agents')!!}
                        </ul>
                    </div>
            <div class="col-10">   
                <div class="tab-content pt-4">
                    <div class="tab-pane fade general active show" id="uni_apply_agent">

                        <div class="row">
                            <div class="col-sm-12 col-md-9">
                                <h4>Edit University Apply Agent</h4>
                                <form action="{{route('admin.uni-apply-agent.save')}}" method="post">
                                    @csrf
                                    <input type="hidden" name="id" value="{{$agent->id}}" />
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group mb-3">
                                                <label class="required-field">Name</label>
                                                <input type="text" class="form-control" name="name" maxlength="150" value="{{$agent->name}}" required />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-6 col-md-6">
                                            <div class="form-group mb-3">
                                                <label>Phone</label>
                                                <input type="text" class="form-control" name="phone" value="{{$agent->phone}}" maxlength="12" />
                                            </div>
                                        </div>
                                        <div class="col-sm-6 col-md-6">
                                            <div class="form-group mb-3">
                                                <label>Email</label>
                                                <input type="email" class="form-control" name="email" value="{{$agent->email}}" maxlength="50" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group mb-3">
                                                <label class="required-field">Address</label><br />
                                                <textarea id="address" name="address" class="form-control" required>{!!$agent->address!!}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12 col-md-12">
                                            <div class="form-group mb-3">
                                                <label>@lang('labels.general.taxid')</label>
                                                <input type="text" class="form-control" name="tax_id" value="{{$agent->tax_id}}" maxlength="50">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-md-4 mb-3">
                                                <label class="required-field">Tax type</label>
                                                <select name="tax_type" class="form-select" required>
                                                <option value="">Select</option>
                                                <option {{($agent->tax_type == 'inclusive')? 'selected' : ''}} value="inclusive">Inclusive</option>
                                                <option {{($agent->tax_type == 'exclusive')? 'selected' : ''}} value="exclusive">Exclusive</option>
                                            </select>
                                        </div>
                                        <div class="form-group col-md-4 mb-3">
                                            <label class="required-field">Tax Percent</label>
                                            <input type="number" step="any" name="tax_percent" value="{{$agent->tax_percent}}" class="form-control" value="{{old('tax_percent')}}" required>
                                        </div>
                                        <div class="form-group col-md-4 mb-3">
                                            <label class="required-field">Commission Count</label>
                                            <select name="commission_count" class="form-select" required>
                                            <option {{($agent->commission_count == '1')? 'selected' : ''}} value="1">1</option>
                                            <option {{($agent->commission_count == '2')? 'selected' : ''}} value="2">2</option>
                                            <option {{($agent->commission_count == '3')? 'selected' : ''}} value="3">3</option>
                                            <option {{($agent->commission_count == '4')? 'selected' : ''}} value="4">4</option>
                                        </select>
                                    </div>
                                    </div>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                        <button type="button" class="btn btn-secondary btn-sm" onclick="document.location='{{route('admin.uni-apply-agents')}}'">Cancel</button>
                                    </div>

                            </div>
                        </div>

                    </div>
                </div>
                </div><!-- End Bordered Tabs -->

            </div>
        </div>

    </div>
</div>



@endsection