@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')


<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('email-smtp')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="sms_settings">
                                <h4>Email SMTP Details</h4><br />
                                <div class="row">
                                    <div class="col-sm-12 col-md-6">
                                        <div id="Msg91" class="mt-2">
                                            <div class="row">
                                                <div class="col-md-10">
                                                    <label class="mb-2">
                                                        <h5>Individual Emails</h5>
                                                    </label>
                                                </div>
                                                @unless(env('SAAS_MAIL_SERVER'))
                                                <div class="col-md-2"><a class="text-primary" href="#" id="editSmtp"><i class="fa fa-edit"></i>Edit</a></div>
                                                @endunless
                                            </div>
                                            @if(env('MAIL_DRIVER') == 'log')
                                            <h5 class="text-danger">MAIL DRIVER: log</h5>
                                            @endif

                                            @unless(env('SAAS_MAIL_SERVER'))
                                            @if(get_site_config('smtp_type')== 'google')
                                            <h4>Using Google Workspace Email</h4>
                                            <div id="gmail_details">
                                                <div class="form-group">
                                                    {{-- <h1>{{ LaravelGmail::user() }}</h1> --}}
                                                    @if(LaravelGmail::check())
                                                    <p><b>Status:</b> <span class="badge" style="background-color: #007206 !important">Connected</span></p>
                                                    <a class="btn btn-sm btn-danger" href="{{ url('oauth/gmail/logout') }}">Disconnect</a>
                                                    @else

                                                    <p><b>Status:</b> <span class="badge" style="background-color: #dc3545 !important">Not Connected</span></p>
                                                    <a class="btn btn-sm btn-primary" href="{{ url('oauth/gmail') }}">Connect</a>
                                                    @endif
                                                </div>
                                            </div>
                                            @else
                                            <h4>Using SMTP Server</h4>
                                            <div id="smtp_details">
                                                <div class="form-group">
                                                    <p class="mb-1"><label><b>SMTP Host Name: </b></label>
                                                        {{get_site_config('smtp_host')}}
                                                    </p>
                                                </div>
                                                <div class="form-group">
                                                    <p class="mb-1"><label><b>Port: </b></label>
                                                        {{get_site_config('smtp_port')}}
                                                    </p>
                                                </div>
                                                <div class="form-group">
                                                    <p class="mb-1"><label><b>Mail Username: </b></label>
                                                        {{get_site_config('smtp_email')}}
                                                    </p>
                                                </div>
                                                <div class="form-group">
                                                    <p class="mb-1"><label><b>Encryption: </b></label>
                                                        {{get_site_config('smtp_connection')}}
                                                    </p>
                                                </div>
                                                <div class="form-group">
                                                    <p class="mb-1"><label><b>From: </b></label>
                                                        {{get_site_config('smtp_from_email')}}
                                                    </p>
                                                </div>
                                                <div class="form-group">
                                                    <p class="mb-1"><label><b>Reply To: </b></label>
                                                        {{get_site_config('smtp_reply_to')}}
                                                    </p>
                                                </div>
                                            </div>
                                            @endif
                                            @endunless

                                        </div>
                                        <div class="row mt-3">
                                            <form action="{{route("admin.settings.email.test.individual")}}" method="POST">
                                                @csrf
                                                <div class="col-12">
                                                    <div class="form-group">
                                                        <label for="test_email" class="form-label required-field">Send Test Email</label>
                                                        <input type="email" name="test_email" id="test_email" placeholder="Email ID" class="form-control" required>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="submit" class="btn btn-primary">Send</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <div class="col-sm-12 col-md-6">
                                        <div id="Msg91" class="mt-2">
                                            <div class="row">
                                                <div class="col-md-10">
                                                    <label class="mb-2">
                                                        <h5>Bulk Emails (Broadcast)</h5>
                                                    </label>
                                                </div>
                                                @unless(env('SAAS_MAIL_SERVER'))
                                                <div class="col-md-2"><a class="text-primary" href="#" id="editBlkSmtp"><i class="fa fa-edit"></i>Edit</a></div>
                                                @endunless
                                            </div>

                                            @unless(env('SAAS_MAIL_SERVER'))
                                            @if(get_site_config('bulk_smtp_type')== 'google')
                                            <h4>Using Google Workspace Email</h4>
                                            @else
                                            <h4>Using SMTP Server</h4>
                                            <div class="form-group">
                                                <p class="mb-1"><label><b>SMTP Host Name: </b></label>
                                                    {{get_site_config('bulk_smtp_host')}}
                                                </p>
                                            </div>
                                            <div class="form-group">
                                                <p class="mb-1"><label><b>Port: </b></label>
                                                    {{get_site_config('bulk_smtp_port')}}
                                                </p>
                                            </div>
                                            <div class="form-group">
                                                <p class="mb-1"><label><b>Mail Username: </b></label>
                                                    {{get_site_config('bulk_smtp_email')}}
                                                </p>
                                            </div>
                                            <div class="form-group">
                                                <p class="mb-1"><label><b>Encryption: </b></label>
                                                    {{get_site_config('bulk_smtp_connection')}}
                                                </p>
                                            </div>
                                            <div class="form-group">
                                                <p class="mb-1"><label><b>From: </b></label>
                                                    {{get_site_config('bulk_smtp_from_email')}}
                                                </p>
                                            </div>
                                            <div class="form-group">
                                                <p class="mb-1"><label><b>Reply To: </b></label>
                                                    {{get_site_config('smtp_reply_to')}}
                                                </p>
                                            </div>

                                            <div class="form-group">
                                                {{-- <p class="mb-0"><b>Mail limit per hour: </b>{{ round(get_site_config('bulk_smtp_limit_hourly') * 60 * 60)}}</p> --}}
                                                <p class="mb-0"><b>Mail limit per hour: </b>{{ (get_site_config('bulk_smtp_limit_hourly')) ? round(get_site_config('bulk_smtp_limit_hourly')) : ''}}</p>
                                            </div>
                                            @endif
                                            @endunless

                                        </div>
                                        @if(get_site_config('bulk_smtp_host') && get_site_config('bulk_smtp_port') && get_site_config('bulk_smtp_email') && get_site_config('bulk_smtp_password') && get_site_config('bulk_smtp_connection'))
                                        <div class="row mt-3">
                                            <form action="{{route("admin.settings.email.test.bulk")}}" method="POST">
                                                @csrf
                                                <div class="col-12">
                                                    <div class="form-group">
                                                        <label for="test_email" class="form-label required-field">Send Test Email</label>
                                                        <input type="email" name="test_email" id="test_email" placeholder="Email ID" class="form-control" required>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <button type="submit" class="btn btn-primary">Send</button>
                                                </div>
                                            </form>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                @unless(env('SAAS_MAIL_SERVER'))
                                <div class="row">
                                    <div class="col-md-10">
                                        <p class="mt-4 mb-1"><b>Notes:</b></p>
                                        <ul>
                                            <li>If no Bulk SMTP (Broadcast) is configured, broadcast/campaign emails are sent from Individual Email SMTP server.</li>
                                            <li>If you configure Email SMTP for a staff, when staff manually sends an email to lead/student, it will be sent from staff email. Otherwise it will check for Branch SMTP details & the email is sent from branch email from the branch to which the student belongs to. If no Branch SMTP are available, email is sent from the Global SMTP(Individual) settings as above.</li>
                                        </ul>
                                    </div>
                                </div>
                                @endunless

                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@unless(env('SAAS_MAIL_SERVER'))
<div class="modal fade" id="smtp_update_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Email SMTP Configuration</h5>
                <button type="button" class="btn btn-sm btn-outline-dark" data-bs-dismiss="modal">&times;</button>
            </div>
            <form id="smtpDataForm" method="POST" action="{{route('admin.settings.smtp')}}">
                @csrf
                <input type="hidden" name="conf_type" value="single_smtp">
                <div class="modal-body">
                    <p>
                        <label><input type="radio" class="smtp_type" name="smtp_type" {{(get_site_config('smtp_type')=="google")?'checked':''}} value="google"> Google Workspace Email</label>&nbsp;&nbsp;&nbsp;&nbsp;
                        <label><input type="radio" class="smtp_type" name="smtp_type" {{(get_site_config('smtp_type')=="smtp_server")?'checked':''}} value="smtp_server"> SMTP Server</label>
                    </p>
                    <div id="smtp" style="display: none;">
                        <span class="label required-field"><b>Email/Username</b></span>
                        <input type="text" autocomplete="off" id="" name="username" value="{{get_site_config('smtp_email')}}" class="form-control smtp_class">

                        <span class="label required-field"><b>Password</b></span>
                        <input type="text" autocomplete="off" id="" name="password" value="{{!env('DEMO_MODE') ? get_site_config('smtp_password') : ''}}" class="form-control smtp_class">

                        <span class="label required-field"><b>Outgoing SMTP Hostname</b></span>
                        <input type="text" autocomplete="off" id="" name="hostname" value="{{get_site_config('smtp_host')}}" class="form-control smtp_class">

                        <div class="row">
                            <div class="col-md-6">
                                <span class="label required-field"><b>Port No.</b></span>
                                <input type="number" autocomplete="off" id="" name="port" value="{{get_site_config('smtp_port')}}" class="form-control smtp_class">
                            </div>
                            <div class="col-md-6">
                                <span class="label required-field"><b>Connection Type</b></span>
                                <select name="connection_type" class="form-select smtp_class" id="connection_type">
                                    <option value="">Select</option>
                                    <option value="ssl" @if(get_site_config('smtp_connection')=='ssl' ) selected @endif>SSL</option>
                                    <option value="tls" @if(get_site_config('smtp_connection')=='tls' ) selected @endif>TLS</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <span class="label required-field"><b>From Email</b></span>
                                <input type="text" autocomplete="off" value="{{get_site_config('smtp_from_email')}}" name="from_email" value="" class="form-control smtp_class">
                            </div>
                            <div class="col-md-6">
                                <span class="label"><b>Reply to Email (Optional)</b></span>
                                <input type="text" autocomplete="off" value="{{get_site_config('smtp_reply_to')}}" name="reply_to_email" value="" class="form-control">
                            </div>
                        </div>
                    </div>


                    <div id="gmail" style="display: none;">
                        <!-- <p class="p-2" style="background-color: #e5f0fd !important;font-size: 14px !important;">Refer Admin Guide <b>"Google Workspace Email SMTP Configuration"</b> to create a google app</p> -->

                        <span class="label required-field"><b>From Email</b></span>
                        <input type="text" autocomplete="off" id="" name="google_email_id" value="{{get_site_config('google_email_id')}}" class="form-control gmail_class">

                        <span class="label required-field"><b>Google App ID</b></span>
                        <input type="text" autocomplete="off" id="" name="google_project_id" value="{{get_site_config('google_project_id')}}" class="form-control gmail_class">

                        <span class="label required-field"><b>Google Client ID</b></span>
                        <input type="text" autocomplete="off" id="" name="google_client_id" value="{{get_site_config('google_client_id')}}" class="form-control gmail_class">

                        <span class="label required-field"><b>Google Client Secret</b></span>
                        <input type="text" autocomplete="off" id="" name="google_client_secret" value="{{get_site_config('google_client_secret')}}" class="form-control gmail_class">

                        <span class="label required-field"><b>Email from Name</b></span>
                        <input type="text" autocomplete="off" value="{{(get_site_config('google_email_from_name')) ? get_site_config('google_email_from_name') : get_site_config('app_name')}}" name="google_email_from_name" value="" class="form-control gmail_class">

                        <span class="label"><b>Reply to Email(Optional)</b></span>
                        <input type="text" autocomplete="off" value="{{get_site_config('google_email_reply_to')}}" name="google_email_reply_to" value="" class="form-control">
                    </div>

                    <div class="row mt-3">
                        <div class="col text-center">
                            <button type="submit" class="btn btn-md btn-primary" style="font-size: 0.9em;">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
</div>

<div class="modal fade" id="blk_smtp_update_modal">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Bulk Email SMTP Configuration</h5>
                <button type="button" class="btn btn-sm btn-outline-dark" data-bs-dismiss="modal">&times;</button>
            </div>
            <form id="smtpDataForm" method="POST" action="{{route('admin.settings.smtp')}}">
                @csrf
                <input type="hidden" name="conf_type" value="bulk_smtp">
                <div class="modal-body">
                    <p>
                        <label><input type="radio" class="bulk_smtp_type" name="bulk_smtp_type" {{(get_site_config('bulk_smtp_type')=="google")?'checked':''}} value="google"> Google Workspace Email</label>&nbsp;&nbsp;&nbsp;&nbsp;
                        <label><input type="radio" class="bulk_smtp_type" name="bulk_smtp_type" {{(get_site_config('bulk_smtp_type')=="smtp_server")?'checked':''}} value="smtp_server"> SMTP Server</label>
                    </p>
                    <div id="bulk_smtp" style="display: none;">
                        <span class="label required-field"><b>Email/Username</b></span>
                        <input type="text" autocomplete="off" id="" name="bulk_username" value="{{get_site_config('bulk_smtp_email')}}" class="form-control bulk_smtp_class">

                        <span class="label required-field"><b>Password</b></span>
                        <input type="text" autocomplete="off" id="" name="bulk_password" value="{{!env('DEMO_MODE') ? get_site_config('bulk_smtp_password') : ''}}" class="form-control bulk_smtp_class">

                        <span class="label required-field"><b>Outgoing SMTP Hostname</b></span>
                        <input type="text" autocomplete="off" id="" name="bulk_hostname" value="{{get_site_config('bulk_smtp_host')}}" class="form-control bulk_smtp_class">

                        <div class="row">
                            <div class="col-md-6">
                                <span class="label required-field"><b>Port No.</b></span>
                                <input type="number" autocomplete="off" id="" name="bulk_port" value="{{get_site_config('bulk_smtp_port')}}" class="form-control bulk_smtp_class">
                            </div>
                            <div class="col-md-6">
                                <span class="label required-field"><b>Connection Type</b></span>
                                <select name="bulk_connection_type" class="form-select bulk_smtp_class" id="">
                                    <option value="">Select</option>
                                    <option value="ssl" @if(get_site_config('bulk_smtp_connection')=='ssl' ) selected @endif>SSL</option>
                                    <option value="tls" @if(get_site_config('bulk_smtp_connection')=='tls' ) selected @endif>TLS</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <span class="label required-field"><b>From Email</b></span>
                                <input type="text" autocomplete="off" id="" name="bulk_from_email" value="{{get_site_config('bulk_smtp_from_email')}}" class="form-control bulk_smtp_class">
                            </div>
                            <div class="col-md-6">
                                <span class="label required-field"><b>Email Send Limit per hour</b></span>
                                <input type="number" value="{{get_site_config('bulk_smtp_limit_hourly')}}" name="bulk_smtp_limit_hourly" value="" class="form-control bulk_smtp_class">
                            </div>
                        </div>
                    </div>
                    <div id="bulk_gmail" style="display: none;">
                        <p class="p-2" style="background-color: #e5f0fd !important;font-size: 14px !important;">This will use same configuration as Individual email</p>
                    </div>

                    <div class="row mt-3">
                        <div class="col text-center">
                            <button type="submit" class="btn btn-md btn-primary" style="font-size: 0.9em;">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>

    </div>
</div>
@endunless

@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        if ("{{get_site_config('smtp_type')}}" == "google") {
            $('#smtp').hide();
            $('#gmail').show();
            $(".smtp_class").prop("required", false);
            $(".gmail_class").prop("required", true);
        }
        if ("{{get_site_config('smtp_type')}}" == "smtp_server") {
            $(".smtp_class").prop("required", true);
            $(".gmail_class").prop("required", false);
            $('#gmail').hide();
            $('#smtp').show();
        }
        //bulk
        if ("{{get_site_config('bulk_smtp_type')}}" == "google") {
            $('#bulk_smtp').hide();
            $('#bulk_gmail').show();
            $(".bulk_smtp_class").prop("required", false);
            $(".bulk_gmail_class").prop("required", true);
        }
        if ("{{get_site_config('bulk_smtp_type')}}" == "smtp_server") {
            $(".bulk_smtp_class").prop("required", true);
            $(".bulk_gmail_class").prop("required", false);
            $('#bulk_gmail').hide();
            $('#bulk_smtp').show();
        }
    });
    $('body').on('click', '#editSmtp', function(event) {
        $('#smtp_update_modal').modal('show');
    });
    $('body').on('click', '#editBlkSmtp', function(event) {
        $('#blk_smtp_update_modal').modal('show');
    });

    $('body').on('click', '.smtp_type', function(event) {
        if ($(this).val() == 'google') {
            $('#smtp').hide();
            $('#gmail').show();
            $(".smtp_class").prop("required", false);
            $(".gmail_class").prop("required", true);
        } else {
            $(".smtp_class").prop("required", true);
            $(".gmail_class").prop("required", false);
            $('#gmail').hide();
            $('#smtp').show();
        }

    });
    $('body').on('click', '.bulk_smtp_type', function(event) {
        if ($(this).val() == 'google') {
            $('#bulk_smtp').hide();
            $('#bulk_gmail').show();
            $(".bulk_smtp_class").prop("required", false);
            $(".bulk_gmail_class").prop("required", true);
        } else {
            $(".bulk_smtp_class").prop("required", true);
            $(".bulk_gmail_class").prop("required", false);
            $('#bulk_gmail').hide();
            $('#bulk_smtp').show();
        }

    });
</script>
@endpush