@extends('backend.layouts.app')

@section('title', 'Settings: Email Sync')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('email-sync')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Email Sync</h4>
                                        <p>IMAP Sync incoming emails</p>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Application Stage" style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Application Stage"><i class="bi bi-plus-circle"></i> New Account</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Email</th>
                                                        <th>Last Sync</th>
                                                        <th style="width:150px;">Status</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($accounts as $account)
                                                    <tr>
                                                        <td>
                                                            {{ $account->imap_email }}
                                                        </td>
                                                        <td>
                                                            {!! ($account->last_sync_datetime) ? get_date_time_formated($account->last_sync_datetime).": ".$account->last_sync_notes : '' !!}
                                                        </td>
                                                        <td>
                                                            <select class="form-select" id="sync_status" onchange="update_status(this.value,{{$account->id}})">
                                                                <option {{($account->status == 1)? 'selected':''}} value="1">Syncing</option>
                                                                <option {{($account->status == 0)? 'selected':''}} value="0">Disabled</option>
                                                            </select>
                                                            <span style="display:none;" id="load-ing-{{$account->id}}" class="text-success p-3"><b>Updating...</b></span>
                                                        </td>
                                                        <td>
                                                            <a title="Edit" href="javascript:void(0);" class="btn btn-primary btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-id="{{$account->id}}" data-username="{{$account->imap_email}}" data-password="{{$account->imap_password}}" data-host="{{$account->imap_host}}" data-port="{{$account->imap_port}}" data-connection="{{$account->imap_connection}}" data-create_lead="{{$account->create_lead}}" data-filter_subject_type="{{$account->filter_subject_type}}" data-filter_subject_value="{{$account->filter_subject_value}}" data-action_url="{{route('admin.email-sync.update', $account->id)}}"><i class='fas fa-edit ' style='font-size:17px'></i></a>
                                                            <a title="Delete" href="#" onclick="delAcc({{$account->id}})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        {{-- <small><b>Notes:</b>
                                            <ul>
                                                <li>Super Admin is allowed to change a University Applications status to previous status even if "Can go back to previous stage = No"</li>
                                            </ul>
                                        </small> --}}
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="{{route('admin.email-sync.store')}}" id="">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Email Account</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    
                    <div class="form-group">
                        <label class="required-field"><b>Email/Username</b></label>
                        <input type="text" name="username" class="form-control required-field" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field"><b>Password</b></label>
                        <input type="text" name="password" class="form-control required-field" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field"><b>IMAP Hostname</b></label>
                        <input type="text" name="imap_hostname" class="form-control required-field" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field"><b>Port No.</b></label>
                        <input type="number" name="port" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>
                   
                    <div class="form-group">
                        <label class="required-field"><b>Connection Type</b></label>
                        <select name="connection_type" class="form-select" id="connection_type" required>
                            <option value="">Select</option>
                            <option value="ssl">SSL</option>
                            <option value="tls">TLS</option>
                        </select>
                    </div>
                    <hr>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <label for="create_lead"> <input type="checkbox" name="create_lead" id="create_lead" value="1"> Create Leads from incoming emails</label>
                        </div>
                    </div>

                    <div class="form-group mt-2" id="filter_div" style="display: none;">
                        <span class="label"><b>Filter Condition</b></span><br>
                        <div class="row">
                        <div class="col-md-6">
                        <select name="filter_condition" id="filter_condition" class="form-select">
                            <option value="">Select</option>
                            <option value="all">All</option>
                            <option value="equals">Subject Equals</option>
                            <option value="contains">Subject Contains</option>
                        </select>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="filter_val" id="filter_val" class="form-control">
                        </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="{{route('admin.email-sync.update')}}" id="">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Email Account</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="acc_id" id="edit_id">
                    <div class="form-group">
                        <label class="required-field"><b>Email/Username</b></label>
                        <input type="text" name="username" id="edit_username" class="form-control required-field" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field"><b>Password</b></label>
                        <input type="text" name="password" id="edit_password" class="form-control required-field" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field"><b>IMAP Hostname</b></label>
                        <input type="text" name="imap_hostname" id="edit_host" class="form-control required-field" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field"><b>Port No.</b></label>
                        <input type="number" name="port" id="edit_port" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>
                   
                    <div class="form-group">
                        <label class="required-field"><b>Connection Type</b></label>
                        <select name="connection_type" class="form-select" id="edit_connection_type" required>
                            <option value="">Select</option>
                            <option value="ssl">SSL</option>
                            <option value="tls">TLS</option>
                        </select>
                    </div>
                    <hr>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <label for="edit_create_lead"> <input type="checkbox" name="create_lead" id="edit_create_lead" value="1"> Create Leads from incoming emails</label>
                        </div>
                    </div>

                    <div class="form-group mt-2" id="edit_filter_div" style="display: none;">
                        <span class="label"><b>Filter Condition</b></span><br>
                        <div class="row">
                        <div class="col-md-6">
                        <select name="filter_condition" id="edit_filter_condition" class="form-select">
                            <option value="">Select</option>
                            <option value="all">All</option>
                            <option value="equals">Subject Equals</option>
                            <option value="contains">Subject Contains</option>
                        </select>
                        </div>
                        <div class="col-md-6">
                            <input type="text" name="filter_val" id="edit_filter_val" class="form-control">
                        </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>

@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>
    $(document).ready(function() {

        $('#create_lead').change(function() {
        if($(this).is(":checked")) {
            $("#filter_div").css('display','block');
            $("#filter_condition,#filter_val").prop("required", true);
            return;
        }
        $("#filter_div").css('display','none');
        $("#filter_condition,#filter_val").prop("required", false);
        });

        $('#filter_condition').change(function() {
            if($(this).val()=="all") {
                $("#filter_val").css('display','none');
                $("#filter_val").prop("required", false);
            }else{
                $("#filter_val").css('display','block');
                $("#filter_val").prop("required", true);
            }
        });

       
        $('.edit_row').click(function() {
            $('#edit_id').val($(this).data('id'));
            $('#edit_username').val($(this).data('username'));
            $('#edit_password').val($(this).data('password'));
            $("#edit_host").val($(this).data('host'));
            $('#edit_port').val($(this).data('port'));
            $('#edit_filter_val').val($(this).data('filter_subject_value'));
            var create_lead = $(this).data('create_lead');
            var filter_condition = $(this).data('filter_subject_type');
            var imap_connection = $(this).data('connection');
            $('#edit_connection_type').val(imap_connection).trigger('change');
            $('#edit_filter_condition').val(filter_condition).trigger('change');
           

            if(create_lead == '0'){
                $("#edit_filter_div").css('display','none');
                $('#edit_create_lead').prop("checked", false);
                $("#edit_filter_condition,#edit_filter_val").prop("required", false);
            }else{
                $("#edit_filter_div").css('display','block');
                $('#edit_create_lead').prop("checked", true);
                $("#edit_filter_condition,#edit_filter_val").prop("required", true);
            }
                        
            $('#edit_app-status').attr('action', $(this).data('action_url'));

        });

        $('#edit_create_lead').change(function() {
            if($(this).is(":checked")) {
                $("#edit_filter_div").css('display','block');
                $("#edit_filter_condition,#edit_filter_val").prop("required", true);
                return;
            }
            $("#edit_filter_div").css('display','none');
            $("#edit_filter_condition,#edit_filter_val").prop("required", false);
        });

        $('#edit_filter_condition').change(function() {
            if($(this).val()=="all") {
                $("#edit_filter_val").css('display','none');
                $("#edit_filter_val").prop("required", false);
            }else{
                $("#edit_filter_val").css('display','block');
                $("#edit_filter_val").prop("required", true);
            }
        });


        $('#edit_modal').on('hidden.bs.modal', function () {
            $('#edit_modal form')[0].reset();
        });
        $('#create_modal').on('hidden.bs.modal', function () {
            $('#create_modal form')[0].reset();
        });
    });
    function delAcc(id){
        // var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        var warning = "";
        Swal.fire({
            title: "Are you sure you want to delete this Email Account?",
            html: "" + warning + "",
            showCancelButton: true,
            confirmButtonColor: "#DC3545",
            confirmButtonText: `Delete`,
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('admin/settings/email-sync/delete/')}}/"+id;
                } else if (result.isDenied) {
                    
                }
        });
    }

function update_status(status,id){
    $("#load-ing-"+id).show();
     $.ajax({
            url: '{{ route('admin.email-sync.updateStatus') }}',
            method: "get",
            data: {
                id: id, 
                status: status
            },
            success: function (response) {
                console.log(response);
                $("#load-ing-"+id).hide();
                if(response.status == 200){
                    $.toast({
                        heading: 'Success',
                        text: response.message,
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                }else{
                    $.toast({
                        heading: 'Error',
                        text: 'Something went wrong!',
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 8
                    });
                }
            }
       });
  }
</script>
@endpush