@extends('backend.layouts.app')

@section('title', 'Settings: Email Sync')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('manage-forms')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Forms</h4>
                                        {{-- <p>IMAP Sync incoming emails</p> --}}
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Form" style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Form"><i class="bi bi-plus-circle"></i> New Form</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>Heading</th>
                                                        {{-- <th>Last Sync</th> --}}
                                                        {{-- <th style="width:150px;">Status</th> --}}
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($forms as $form)
                                                    <tr>
                                                        <td>
                                                            {{ $form->title }}
                                                        </td>
                                                        <td>
                                                            {{ $form->form_heading }}
                                                        </td>
                                                        <td>
                                                            <a title="View Form" target="_blank" href="{{route('form-builder.view-form', $form->id)}}" class="btn btn-outline-primary me-1" ><i class='fas fa-eye ' style='font-size:17px'></i></a>

                                                            <button title="Get Link" class="btn btn-outline-primary me-1 get_form_url" data-form_url="{{ route('form-builder.view-form', $form->id) }}"><i class='fas fa-link' style='font-size:17px'></i></button>

                                                            <button title="Get Embed Code" class="btn btn-outline-primary me-1 get_form_embed" data-form_embed_code="{{ route('form-builder.view-form-embed', $form->id) }}"><i class='fa fa-code' style='font-size:17px'></i></button>

                                                            <button title="Get Form HTML" class="btn btn-outline-primary me-1 get_form_html" data-form_html="{{ $form->id}}"><i class='fa fa-file-code' style='font-size:17px'></i></button>

                                                            <button title="Get Form QR" class="btn btn-outline-primary me-1 get_form_qr" data-form_qr="{{ $form->id}}"><i class='fa fa-qrcode' style='font-size:17px'></i></button>

                                                            <button style="padding: 4px 8px;" type="button" class="btn btn-outline-danger dropdown-toggle action_dropdown_btn" data-bs-toggle="dropdown" aria-expanded="true">
                                                            <b style="font-size: 13px; "><i class="fa fa-cog" style="width:13px;" aria-hidden="true"></i></b>
                                                            </button>

                                                            <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow" data-popper-placement="bottom-end">
                                                                <a href="{{route('admin.form-builder.edit-form', $form->id)}}" class="py-2 dropdown-item "><i class="fas fa-edit text-primary"></i> &nbsp;Edit</a>
                                                                <a href="javascript:void(0)" class="py-1 dropdown-item" data-html="true" onclick="delForm({{$form->id}})"><i class="fas fa-trash-alt text-danger"></i> &nbsp;Delete</a>
                                                            </div>

                                                            {{-- <a title="Edit" href="{{route('admin.edit-form', $form->id)}}" class="btn btn-primary btn-sm edit_row" ><i class='fas fa-edit ' style='font-size:17px'></i></a>
                                                            <a title="Delete" href="#" onclick="delForm({{$form->id}})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a> --}}
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                       
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="{{route('admin.store-form')}}" id="">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Create New Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="title" class="form-control mb-0" maxlength="100" required>
                        <small> This is for your reference only</small>
                    </div>
                    <div class="form-group">
                        <label class=""><b>Form Heading</b></label>
                        <input type="text" name="form_heading" class="form-control" maxlength="100">
                    </div>
                    <div class="form-group">
                        <label class=""><b>Form Description Text</b></label>
                        <input type="text" name="description" class="form-control" maxlength="200">
                    </div>
                    <div class="form-group">
                        <label class="required-field"><b>Redirect URL after form Submission</b></label>
                        <input class="form-control" type="text" id="redirect_url" name="redirect_url" value="{{url('page/thank-you')}}" required>
                    </div>
                    <div class="form-group">
                        <div class="form-input">
                            <label class="required-field"> Branch</label>
                            <select class="form-select mb-0" name="branch" id="assign_to_branch" required>
                                <option value="">Select Branch</option>
                                @foreach($branches as $branch)
                                <option value="{{$branch->id}}">{{$branch->branch_name}}</option>
                                @endforeach
                            </select>
                            <small>Assign the new lead to this branch</small>
                        </div>
                        <label class="">Assign the new leads to</label>
                        <select class="form-select" name="assign_to" id="assign_to">
                            <option value="">Select Staff</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Create Form</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="link_modal" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Copy Form Link</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Form Link</b></label>
                        <input class="form-control" type="text" readonly id="form_link" value="">
                        <button class="btn btn-primary btn-sm" onClick="javascript:copyToClipboard()">Copy Link</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="embed_modal" role="dialog">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Embed Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Embed HTML</b></label>
                        {{-- <input class="form-control" type="text" id="form_embed" value=""> --}}
                        <textarea class="form-control" id="form_embed" readonly value=""></textarea>
                        <button class="btn btn-primary btn-sm" onClick="javascript:copyEmbedToClipboard()">Copy Embed Code</button>
                    </div>
                    <p class="small"><b>Note:</b> The default height of the form is set to 983. You can change it by editing 'height="983"' in the copied code.</p>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="html_code_modal" role="dialog">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">HTML Form Code</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>HTML Code</b></label>
                        <textarea class="form-control" rows="10" id="form_html" readonly value=""></textarea>
                        <button class="btn btn-primary btn-sm" onClick="javascript:copyHtmlToClipboard()">Copy HTML Code</button>
                    </div>
                    <p class="small"><b>Note:</b> You can customize the styling of the form fields by adding style attribute or by using css classes.</p>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="qr_modal" role="dialog">
    <div class="modal-dialog modal-md modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Form QR Code</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <div class="form-group">
                        <p id="form_qr_code"></p>
                    </div>
                    <button class="btn btn-primary btn-sm mt-4" onClick="javascript:printQr()">Print QR Code</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
@push('after-styles')
<link href="{{ asset('assets/plugins/toast-master/css/jquery.toast.css') }}" rel="stylesheet">
@endpush
@push('after-scripts')
<script src="{{ asset('assets/plugins/toast-master/js/jquery.toast.js') }}"></script>
<script>
$(document).ready(function() {
$('#assign_to_branch').change(function(){
            var branch_id= $('#assign_to_branch').val();
            if(branch_id!=''){
            $.ajax({
            type: "get",
            url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+branch_id,
            cache: false,
            success: function(data){                     
            try{  
                if(data){
                    console.log(data);
                $("#assign_to").empty();
                    $("#assign_to").append('<option>Select Staff</option>');
                $.each(data,function(key,value){
                    $("#assign_to").append('<option value="'+key+'">'+value+'</option>');
                });
                }else{
                    $("#assign_to").empty();
                }
            }catch(e) {     
                alert('Exception while request..');
            }   

            },
            error: function(){                      
                alert('Error while request..');
            }
            });
            }
        });
});

    function delForm(id){
        // var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        var warning = "";
        Swal.fire({
            title: "Are you sure you want to delete this Form?",
            html: "" + warning + "",
            showCancelButton: true,
            confirmButtonColor: "#DC3545",
            confirmButtonText: `Delete`,
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('admin/delete-form/')}}/"+id;
                } else if (result.isDenied) {
                    
                }
        });
    }

    $('.get_form_url').click(function() {
        $('#form_link').val($(this).data('form_url'));
        $('#link_modal').modal('show');
    });

    $('.get_form_embed').click(function() {
        var form_url =  $(this).data('form_embed_code');
        $('#form_embed').val('<iframe src="'+form_url+'" width="100%" height="983" frameborder="0" marginheight="0" marginwidth="0">Loading…</iframe>');
        $('#embed_modal').modal('show');
    });

    $('.get_form_html').click(function() {
        var form_id =  $(this).data('form_html');
        // $('#form_html').val('');

            var base_url = "{{ url('admin/form-builder/')}}/" + form_id + "/form_html";
            $.get(base_url, function(data) {
                $('#html_code_modal').on('shown.bs.modal', function() {
                    $('#html_code_modal #form_html').val(data);
                });
                $('#html_code_modal').modal('show');
                $('#html_code_modal').on('hidden.bs.modal', function() {
                    $('#html_code_modal #form_html').val("");
                });
            });
        $('#html_code_modal').modal('show');
    });

    $('.get_form_qr').click(function() {
        var form_id =  $(this).data('form_qr');

            var base_url = "{{ url('admin/form-builder/')}}/" + form_id + "/form_qr";
            $.get(base_url, function(data) {
                $('#qr_modal').on('shown.bs.modal', function() {
                    $('#qr_modal #form_qr_code').html(data);
                });
                $('#qr_modal').modal('show');
                $('#qr_modal').on('hidden.bs.modal', function() {
                    $('#qr_modal #form_html').val("");
                });
            });
        $('#qr_modal').modal('show');
    });


    function copyToClipboard() {
          
            var copyText = document.getElementById("form_link");
            copyText.select();
            copyText.setSelectionRange(0, 99999);
            navigator.clipboard.writeText(copyText.value);
            $.toast({
                        heading: 'Success',
                        text: "Link Copied",
                        position: 'top-right',
                        loaderBg: '#ff6849',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
    }
    function copyEmbedToClipboard() {
          
          var copyText = document.getElementById("form_embed");
          copyText.select();
          copyText.setSelectionRange(0, 99999);
          navigator.clipboard.writeText(copyText.value);
          $.toast({
                      heading: 'Success',
                      text: "Code Copied",
                      position: 'top-right',
                      loaderBg: '#ff6849',
                      icon: 'success',
                      hideAfter: 2000,
                      stack: 6
                  });
  }

  function copyHtmlToClipboard() {
          
          var copyText = document.getElementById("form_html");
          copyText.select();
          copyText.setSelectionRange(0, 99999);
          navigator.clipboard.writeText(copyText.value);
          $.toast({
                      heading: 'Success',
                      text: "HTML Copied",
                      position: 'top-right',
                      loaderBg: '#ff6849',
                      icon: 'success',
                      hideAfter: 2000,
                      stack: 6
                  });
  }

function printQr() {
  var divToPrint=document.getElementById('form_qr_code');
  var newWin=window.open('','Print-Window');
  newWin.document.open();
  newWin.document.write('<html><body style="text-align:center;" onload="window.print()">'+divToPrint.innerHTML+'</body></html>');
  newWin.document.close();
  setTimeout(function(){newWin.close();},2);
}
</script>
@endpush