@extends('backend.layouts.app')

@section('title', 'Settings')
@php
if(count($holidays)) {
$show_count = 4;
} else {
$show_count = 10;
}
@endphp
@section('content')

<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('holidays')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="integrations_settings">
                                <h4>Holidays</h4><br />
                                <p>Weekly Off: {{env('WEEKLY_OFF')}}</p>
                            <form class="g-3" action="{{route('admin.settings.holidays.save')}}" method="post">
                            @csrf

                            <div class="row">
                                <div class="col-sm-12 col-md-12">
                                    <h4>Year {{date('Y')}} Holidays</h4>
                                    <br />
                                    @foreach($holidays as $holiday)
                                    <div class="row form-group">
                                        <div class="col-sm-4 col-md-3">
                                            <input type="text" autocomplete="off" class="form-control mydatepicker" name="holidays[date][]" value="{{date('d-m-Y',strtotime($holiday->date))}}">
                                        </div>
                                        <div class="col-sm-4 col-md-5">
                                            <input type="text" autocomplete="off" class="form-control mydatepicker" name="holidays[event][]" value="{{$holiday->event}}" maxlength="100">
                                        </div>
                                    </div>
                                    @endforeach
                                    @for($i=0;$i<$show_count;$i++)
                                    <div class="row form-group">
                                        <div class="col-sm-4 col-md-3">
                                            <input type="text" autocomplete="off" class="form-control mydatepicker" name="holidays[date][]" value="" placeholder="Date">
                                        </div>
                                        <div class="col-sm-4 col-md-5">
                                            <input type="text" class="form-control" name="holidays[event][]" value="" placeholder="Event/Reason" maxlength="100">
                                        </div>
                                    </div>
                                    @endfor

                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-8">
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                    </div>
                                </div>
                            </div>

                        </form>
                            </div><!-- End Bordered Tabs -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }

        $('#outbound_call_provider').change(function() {
            var provider = $(this).val();
            $('#zadarma').hide();
            $('#exotel').hide();
            $('#'+provider).show();
        });

    });
</script>
@endpush