@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('integrations')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="integrations_settings">
                                <h4>Integrations</h4>
                                {{-- <div class="row">
                                    <div class="col-sm-12 col-md-12"> --}}
                                       {{-- <h6>Email to Lead</h6>
                                       <small>Convert every incoming email to your Inbox into a Lead</small>
                                       <br />
                                       <br /> --}}
                                        
                                        {{-- @if(check_email_sync_accounts())
                                        <p>Status:
                                        <span class="badge badge-success">Enabled</span>
                                        @else
                                        <p class="mb-0">Status:
                                        <span class="badge badge-danger">Disabled</span>
                                        {{-- <p class="mt-0"><small>Contact Support to enable this feature</small></p> --}}
                                        
                                {{-- </p>
                                    </div>
                                </div> --}}
                                <div class="row">
                                    <div class="col-sm-12 col-md-12">
                                        <hr>
                                        <h5 class="mb-2">Google Sheets Lead Sync</h5>
                                        <!-- <h6>Running Facebook Lead Ads? Convert facebook ad form submissions to CRM Leads</h6> -->
                                        <!-- <p>1. From your FB Ad Manager, connect with Google Sheet to send leads to your Google Sheet.</p> -->
                                        <p>1. Create a Google sheet. Refer this sheet for sample columns: <a href="https://docs.google.com/spreadsheets/d/1A0oqRTBy2di6TyKMWHM5Ikw7SSRHa4dM6kOQhSWmHJ8/edit?gid=0#gid=0" class="text-primary" target="_blank">Sample Google Sheet</a>.</p>
                                        <p>2. Create a google cloud app using google workspace account and download the credentials.json file.</p>
                                        <p>Refer <a class="text-primary" href="{{ asset('docs/googleSheetsIntegration.pdf') }}" target="_blank">Instructions Document</a></p>
                                        <p>Upload Credentials.json file</p>
                                        <form action="{{route('admin.google.upload.credentials')}}" enctype="multipart/form-data" method="post" id="jsonUploadForm">
                                            @csrf
                                            <div class="col-6 mb-3">
                                                <label for="credentials" class="form-label">Select JSON File</label>
                                                <input type="file" name="credentials" id="credentials" class="form-control" accept=".json" required>
                                            </div>
                                            <button class="btn btn-sm btn-outline-primary" type="submit">Upload</button>
                                        </form>
                                        @if ($fileExists)
                                        <br>
                                            <h6 class="mb-2">Connect your Google Account where Google Sheet is Located for Google Sheets Leads Sync.</h6>
                                            <a href="{{ route('admin.google.redirect') }}" class="btn btn-primary mb-2">Connect</a> 
                                            <br>
                                            <p>Connected Google Sheets: 
                                                <a class="btn btn-sm btn-outline-primary mb-2" href="{{ route('admin.google.sheets') }}">View</a>
                                            </p>
                                        @endif
                                    </div>
                                </div>
                                {{-- <div class="row"> --}}
                                    {{-- <div class="col-sm-12 col-md-12"> --}}
                                        {{-- <hr> --}}
                                        {{-- <h6 class="mb-2">Whatsapp Integration</h6> --}}
                                        {{-- <small>Send Whatsapp message to leads/students from the portal.</small> --}}
                                        {{-- <br /> --}}
                                        {{-- <br /> --}}
                                        {{-- @if(env('WATI_WHATSAPP_TOKEN')) --}}
                                        {{-- @if(get_site_config('whatsapp_enabled')) --}}
                                        {{-- <p>Status: --}}
                                        {{-- <span class="badge badge-success">Enabled</span> --}}
                                        {{-- @else --}}
                                        {{-- <p class="mb-0">Status: --}}
                                        {{-- <span class="badge badge-danger">Disabled</span> --}}
                                        
                                        {{-- @endif --}}
                                    {{-- </div> --}}
                                {{-- </div>  --}}

                                <div class="row">
                                    <div class="col-sm-12 col-md-12">
                                        <hr>
                                        <h5 class="mb-2">Google Lead Ads Sync</h5>
                                        <h6 class="mb-2">Google Ads Lead Form Webhook Key</h6>
                                        {{-- <small>Send Whatsapp message to leads/students from the portal. You must have API subscription on <a target="_blank" href="https://www.wati.io/">https://www.wati.io/</a></small> --}}
                                        <form action="{{route('admin.settings.google-leads-webhook-key.save')}}" method="post">
                                        @csrf
                                        <input type="text" name="google_lead_webhook_key" class="form-control w-25" value="{{get_site_config('google_lead_webhook_key')}}">
                                        <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                        </form>
                                        <small><b>Note:</b> You can create a google lead ad & set the webhook url to: {{"<site url>"}}/google_leads</small>
                                    </div>
                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
    });

    document.getElementById("jsonUploadForm").addEventListener("submit", function(e) {
        const fileInput = document.getElementById("credentials");
        const file = fileInput.files[0];

        if (file && file.type !== "application/json" && !file.name.endsWith(".json")) {
            e.preventDefault();
            alert("Only .json files are allowed.");
        }
    });

    function copyToClipboard() {
        containerid = 'web_lead_html_code';
        if (document.selection) {
            var range = document.body.createTextRange();
            range.moveToElementText(document.getElementById(containerid));
            range.select().createTextRange();
            document.execCommand("copy");
        } else if (window.getSelection) {
            var range = document.createRange();
            range.selectNode(document.getElementById(containerid));
            window.getSelection().addRange(range);
            document.execCommand("copy");
            alert("Text has been copied to Clipboard")
        }
    }
</script>
@endpush