@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')


<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('landing-pages')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="web_lead_settings">
                                <h4>Landing/ Lead Capture Pages</h4><br />
                                <div class="row">
                                    <div class="col-sm-12 col-md-12">

                                        <form method="post" action="{{route('admin.show-page')}}">
                                            @csrf
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-input">
                                                        <select class="form-select" name="lead_page" id="lead_page" required>
                                                            <option value="One">Page Design 1</option>
                                                            <option value="Two">Page Design 2</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-8 myDiv" id="showOne">
                                                    <label>Page Preview</label><br />
                                                    <img src="{{ url('assets/landing-pages/assets-one/images/landing-page1-layout.jpg') }}" style="max-height:300px;" class="rounded img-fluid img-thumbnail" alt="Image Preview" data-enlargable style="cursor: pointer;">
                                                </div>
                                                <div class="col-md-8 myDiv" id="showTwo">
                                                <img src="{{ url('assets/landing-pages/assets-two/images/landing-page2-layout.jpg') }}" style="max-height:300px;" class="rounded img-fluid img-thumbnail" alt="Image Preview" data-enlargable style="cursor: pointer;">
                                                </div>
                                            </div>
                                            <div id="page_one_block" style="display: none;">
                                                <div class="form-input">
                                                    <label class="required-field"> Banner Area text heading</label>
                                                    <input type="text" class="form-control p1_input" name="p1_banner_heading" id="p1_banner_heading" value="Come Study In Australia">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Banner Area text description</label>
                                                    <textarea class="form-control p1_input" name="p1_banner_desc" id="p1_banner_desc">One of the top 3 destinations to study abroad
22,000+ courses to choose from</textarea>
                                                </div>
                                                <hr class="my-4">

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 1 title</label>
                                                    <input type="text" class="form-control p1_input" name="p1_intro_b1_title" id="p1_intro_b1_title" value="Post-study Opportunities">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 1 description</label>
                                                    <textarea class="form-control p1_input" name="p1_intro_b1_desc" id="p1_intro_b1_desc">Post-study Work opportunities. With Bachelors, Masters or Doctorate degree you can work in Australia and gain experience</textarea>
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 2 title</label>
                                                    <input type="text" class="form-control p1_input" name="p1_intro_b2_title" id="p1_intro_b2_title" value="Stable Job Market">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 2 description</label>
                                                    <textarea class="form-control p1_input" name="p1_intro_b2_desc" id="p1_intro_b2_desc">Whatever discipline you choose to study you will be in a stable job market with salary range anywhere between AUD 70k to 150k</textarea>
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 3 title</label>
                                                    <input type="text" class="form-control p1_input" name="p1_intro_b3_title" id="p1_intro_b3_title" value="Range of Programs">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 3 description</label>
                                                    <textarea class="form-control p1_input" name="p1_intro_b3_desc" id="p1_intro_b3_desc">You have very flexible course options like part time to online courses. There are also VET programs which allows you to learn while pursuing your job</textarea>
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 4 title</label>
                                                    <input type="text" class="form-control p1_input" name="p1_intro_b4_title" id="p1_intro_b4_title" value="Funds and Scholarships">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block 4 description</label>
                                                    <textarea class="form-control p1_input" name="p1_intro_b4_desc" id="p1_intro_b4_desc">Australian govt spends around 250 million dollars to provide fellowships, scholarships and grants for the international students</textarea>
                                                </div>

                                                <hr class="my-4">

                                                {{-- //University Block --}}
                                                <div class="form-input">
                                                    <label class="required-field"> University Block 1 title</label>
                                                    <input type="text" class="form-control p1_input" name="p1_ub1_title" id="p1_ub1_title" value="Why Study in Australia?">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> University Block 1 description</label>
                                                    <textarea class="form-control p1_input" name="p1_ub1_desc" id="p1_ub1_desc" rows="5">Number one reason is, It is cost effective. Your degree is recognized globally.

The courses and curriculum is such that you gain experience along with the education. Every half year, 60,000+ jobs are added, giving ample opportunity to secure a job after completion of your study.

Opportunity to earn scholarship of up to 50 percent. After graduation you get to work for up to 6 years.</textarea>
                                                </div>
                                                <div class="form-input">
                                                    <label class="required-field"> University Block 2 title</label>
                                                    <input type="text" class="form-control p1_input" name="p1_ub2_title" id="p1_ub2_title" value="Benefits of Choosing Australia for International students">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> University Block 2 description</label>
                                                    <textarea type="text" class="form-control p1_input" name="p1_ub2_desc" id="p1_ub2_desc" rows="5">There are 38 Australian Universities and all of them offer full time and internship opportunities through their job portals.

You get to work for more than 40 hours a fortnight as part-time and also during holidays. Good thing to note is even full-time work opportunities are also available.

There is huge job openings listed to attract new workforce. Approximately around 60,000+ jobs are listed half-yearly.</textarea>
                                                </div>
                                            </div>

                                            {{-- //page 2 --}}
                                            <div id="page_two_block" style="display: none;">
                                                <div class="form-input">
                                                    <label class="required-field"> Banner text heading</label>
                                                    <input type="text" class="form-control p2_input" name="p2_banner_heading" id="p2_banner_heading" value="We sail you with right study abroad opportunities out of sea of options out there">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Banner sub heading</label>
                                                    <input type="text" class="form-control p2_input" name="p2_banner_desc" id="p2_banner_desc" value="We educate you with right study abroad opportunity for fulfilling your career goal">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block title</label>
                                                    <input type="text" class="form-control p2_input" name="p2_intro_title" id="p2_intro_title" value="ABOUT <span>US</span>">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Intro Block description</label>
                                                    <textarea class="form-control p2_input" name="p2_intro_desc" id="p2_intro_desc" rows="6">With 10 years industry experience we stand by our motto of "Right guidance and last mile support"

We simply the whole study abroad process with our 3-step process of establishing right connection between students, recruitment partners and institutions

We are one of the largest platform for study abroad services with offices across various cities of India.

With a solid team size of 30+ members we have helped 1500 plus students in the last year alone to fulfil their dream of studying abroad.
                                                    </textarea>
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 1 title</label>
                                                    <input type="text" class="form-control p2_input" name="p2_study_b1_title" id="p2_study_b1_title" value="Get Right Planning for your Career">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 1 description</label>
                                                    <textarea class="form-control p2_input" name="p2_study_b1_desc" id="p2_study_b1_desc" rows="4">We provide multiple career options with complete guidance. We break up things with right strategy for the short term goals while keeping you on track for achieving the long term goal.</textarea>
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 2 title</label>
                                                    <input type="text" class="form-control p2_input" name="p2_study_b2_title" id="p2_study_b2_title" value="Get Guaranteed Admission">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 2 description</label>
                                                    <textarea class="form-control p2_input" name="p2_study_b2_desc" id="p2_study_b2_desc">With our vast partnership with many universities across various countries, those candidates who fulfil the basic requirements are provided guaranteed admission in top universities.</textarea>
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 3 title</label>
                                                    <input type="text" class="form-control p2_input" name="p2_study_b3_title" id="p2_study_b3_title" value="Guidance and Documentation">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 3 description</label>
                                                    <textarea class="form-control p2_input" name="p2_study_b3_desc" id="p2_study_b3_desc">Whether its helping in applying or fulfilling admission formalities Or GMAT, GRE, SAT, IELTS, TOEFL, We have extensive resources to help you pass with ease. We help at each step to make the process smoother.</textarea>
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 4 title</label>
                                                    <input type="text" class="form-control p2_input" name="p2_study_b4_title" id="p2_study_b4_title" value="Right Information for Students">
                                                </div>

                                                <div class="form-input">
                                                    <label class="required-field"> Study Block 4 description</label>
                                                    <textarea class="form-control p2_input" name="p2_study_b4_desc" id="p2_study_b4_desc">Latest development in the industry / Information about universities / Changes in the Visa process or fluctuations in the job market - We track it all on a day to day basis so that you get right info and be stress free.</textarea>
                                                </div>
                                            </div>
                                            <!-- <p id="layout_block" class="float-left" style="display: none;">Page Layout: <button class="btn btn-link btn-sm" type="submit" formtarget="_blank" name="sub_btn" value="view_page">View</button></p> -->
                                            <div class="text-center pt-4">
                                                <button class="btn btn-primary btn-sm" name="sub_btn" value="view_page" type="submit" id="preview_btn">Preview</button>
                                                <button class="btn btn-primary btn-sm" name="sub_btn" value="generate_page" type="submit" id="show_page">Download</button>
                                            </div>
                                            <div>
                                                <p><strong>Notes:</strong></p>
                                                <ol>
                                                    <li>You can edit the above field contents as required and download the landing page.</li>
                                                    <li>You can upload the landing page to your website. You can modify the html code wherever needed.</li>
                                                    <li>When the form is submitted by a student on this page, a lead will be created in the CRM.</li>
                                                </ol>
                                            </div>
                                        </form>

                                    </div>
                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="modal01" class="modal fade" tabindex="-1" aria-labelledby="documentRequestLabel" aria-hidden="true">
    <span class="w3-button w3-hover-red w3-xlarge w3-display-topright">&times;</span>
    <div class="w3-modal-content w3-animate-zoom">
        <img id="img01" style="width:100%">
    </div>
</div>
@endsection
@push('after-styles')
<style>
    .myDiv {
        display: none;
    }
</style>
@endpush

@push('after-scripts')
<script>
    $(document).ready(function() {
        var demovalue = "One";
        $("div.myDiv").hide();
        $("#layout_block,#show" + demovalue).show();
        if (demovalue == "One") {
            $("#page_one_block").show();
            $(".p2_input").attr('required', false);
            $(".p1_input").attr('required', true);
            $("#page_two_block").hide();
        } else {
            $("#page_one_block").hide();
            $(".p1_input").attr('required', false);
            $(".p2_input").attr('required', true);
            $("#page_two_block").show();
        }

        $('#lead_page').on('change', function() {
            demovalue = $(this).val();
            $("div.myDiv").hide();
            $("#layout_block,#show" + demovalue).show();
            if (demovalue == "One") {
                $("#page_one_block").show();
                $(".p2_input").attr('required', false);
                $(".p1_input").attr('required', true);
                $("#page_two_block").hide();
            } else {
                $("#page_one_block").hide();
                $(".p1_input").attr('required', false);
                $(".p2_input").attr('required', true);
                $("#page_two_block").show();
            }

        });


    });





    $('img[data-enlargable]').addClass('img-enlargable').click(function() {
        var src = $(this).attr('src');
        $('<div>').css({
            background: 'RGBA(0,0,0,.5) url(' + src + ') no-repeat center',
            backgroundSize: 'contain',
            width: '100%',
            height: '100%',
            position: 'fixed',
            zIndex: '10000',
            top: '0',
            left: '0',
            cursor: 'zoom-out'
        }).click(function() {
            $(this).remove();
        }).appendTo('body');
    });
</script>
@endpush