@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')
<div class="row">
    <div class="col-xl-12">
        
        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('master-setup')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">  
                            {{-- <form id="formSubmit" class="row g-3" action="{{route('admin.master-setup.check')}}" method="post">                     
                                @csrf --}}
                            <div class="tab-pane fade general active show" id="content_blocks">
                                <h4 class="pb-3">Master Setup</h4>
                            
                                <div class="card" @if(get_site_config('setup_general')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif >
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>App name, Logo, Contact information</h6>
                                                <p> Set your app name, contact phone, email id, website logo, email logo, favorite icon</a></p>
                                                <form id="submit1" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_general">
                                                    <input type="checkbox" value="0" @if(get_site_config('setup_general')) checked @endif name="setup_general" >
                                                    <label> I have completed this step</label><br>
                                                </form>
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.settings')}}" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 

                                
                                <div class="card" @if(get_site_config('setup_modules')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif>
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>Modules</h6>
                                                <p> Enable or disable the modules as per your requirement. Country Information, Course Suggestions, Course finder, Support Tickets, Payment gateways</a></p>
                                                <form id="submit2" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_modules">
                                                    <input type="checkbox" class="m-auto" value="0" @if(get_site_config('setup_modules')) checked @endif name="setup_modules" >
                                                    <label> I have completed this step</label><br>
                                                </form>                                                
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.settings')}}#modules" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 

                                <div class="card" @if(get_site_config('setup_leads')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif>
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>Leads</h6>
                                                <p> Add or remove Lead Status values. Define default lead status name. Lead Sources, Enable/disable automated emails to leads</a></p>
                                                <form id="submit3" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_leads">
                                                    <input type="checkbox" class="m-auto" value="0" @if(get_site_config('setup_leads')) checked @endif name="setup_leads" >
                                                    <label> I have completed this step</label><br>
                                                </form>
                                                
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.leads-settings')}}" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 

                                <div class="card" @if(get_site_config('setup_students')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif>
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>Student Documents</h6>
                                                <p> Enable/disable the documents which can be uploaded by students. Define the documents that are mandatory before student can submit the overseas study University Applications.</a></p>
                                                <form id="submit4" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_students">
                                                    <input type="checkbox" class="m-auto" value="0" @if(get_site_config('setup_students')) checked @endif name="setup_students" >
                                                    <label> I have completed this step</label><br>
                                                </form>
                                                
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.settings.student')}}" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 

                                <div class="card" @if(get_site_config('setup_abroad')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif>
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>Study Abroad Countries</h6>
                                                <p> Enable/disable the countries to which students can submit the University Applications for overseas study</a></p>
                                                <form id="submit5" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_abroad">
                                                    <input type="checkbox" class="m-auto" value="0" @if(get_site_config('setup_abroad')) checked @endif name="setup_abroad" >
                                                    <label> I have completed this step</label><br>
                                                </form>
                                                
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.country-settings')}}" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 

                                <div class="card" @if(get_site_config('setup_abroad_course_finder')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif>
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>Study Abroad Course Finder</h6>
                                                <p> Add/import Courses, University data for course finder search</a></p>
                                                <form id="submit6" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_abroad_course_finder">
                                                    <input type="checkbox" class="m-auto" value="0" @if(get_site_config('setup_abroad_course_finder')) checked @endif name="setup_abroad_course_finder" >
                                                    <label> I have completed this step</label><br>
                                                </form>
                                                
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.coursemanagement')}}" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 

                                <div class="card" @if(get_site_config('setup_staff_roles')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif>
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>Staff & Roles</h6>
                                                <p> Define the roles in your organization & configure the appropriate permissions. Assign the role to staff members.</a></p>
                                                <form id="submit7" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_staff_roles">
                                                    <input type="checkbox" class="m-auto" value="0" @if(get_site_config('setup_staff_roles')) checked @endif name="setup_staff_roles" >
                                                    <label> I have completed this step</label><br>
                                                </form>
                                                
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.auth.staff')}}" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 

                                <div class="card" @if(get_site_config('setup_students_leads_data')) style="border:2px solid #72c972;background:transperent" @else style="border:2px solid #f34949;background:transperent" @endif>
                                    <div class="card-body p-3">
                                        <div class="row align-items-center">
                                            <div class="col-10">
                                                <h6>Import Students, Leads data</h6>
                                                <p> Import your existing students, leads data from csv file</a></p>
                                                <form id="submit8" action="{{route('admin.master-setup.check')}}" method="post">
                                                    @csrf
                                                    <input type="hidden" name="key" value="setup_students_leads_data">
                                                    <input type="checkbox" class="m-auto" value="0" @if(get_site_config('setup_students_leads_data')) checked @endif name="setup_students_leads_data" >
                                                    <label> I have completed this step</label><br>
                                                </form>
                                                
                                            </div>
                                            <div class="col-2">
                                                <a href="{{route('admin.import-export.index', "students")}}" class="btn btn-sm btn-primary">Configure</a>
                                            </div>
                                        </div>      
                                    </div>
                                </div> 
                      
                            </div> 
                            {{-- </form>                             --}}

                        </div><!-- End Bordered Tabs -->

                    </div>
                </div>

            </div>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    addDeleteForms();
</script>

{{-- Gourav --}}
<script>
    let checks = document.querySelectorAll('input');

    checks.forEach(check => {
        check.addEventListener('click', ()=> {
            let form = check.form.id;
            let formSubmit = document.getElementById(form);
            formSubmit.submit();    
        })
    });
</script>
@endpush