@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')


<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('meta-lead')!!}
                        </ul>
                    </div>

                    <div class="col-6">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="web_lead_settings">
                                <h4>Meta Leads Settings</h4><br />
                                <div class="row">
                                    <div class="col-sm-12 col-md-12">

                                        <form name='web_lead' id="web_lead_form" action="{{route('admin.meta-lead-save')}}">
                                            @csrf
                                                <div class="form-input">
                                                    <div class="mb-1" style="font-weight:600;">
                                                        Assign the Meta Lead Ad generated leads to:
                                                    </div>
                                                    <label class="required-field">
                                                        Branch
                                                    </label>
                                                    <select class="form-select" name="meta_lead_assign_to_branch" id="meta_lead_assign_to_branch" required>
                                                        <option value="">Select Branch</option>
                                                        @foreach($branches as $branch)
                                                        <option {{($meta_lead_assign_to_branch == $branch->id)? 'selected' : ''}} value="{{$branch->id}}">{{$branch->branch_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <label class="">
                                                    Staff
                                                </label>

                                                <select class="form-select" name="meta_lead_assign_to" id="meta_lead_assign_to">
                                                    <option value="">Select Staff</option>
                                                     @foreach($staff as $stf)
                                                    <option {{($meta_lead_assign_to == $stf->id)? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                                                    @endforeach 
                                                </select>
                                            </div>
                                            
                                            <br />
                                            
                                            <div class="text-center fixed-save">
                                                <button class="btn btn-primary btn-md" name="submit" type="submit" id="submit">Save</button>
                                            </div>

                                        </form>
                                   
                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    
</script>
@endpush