@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')

<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('outbound-call')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="sms_settings">
                                <h4>Outbound Call Configuration</h4><br />
                                <div class="row">
                                    <div class="col-sm-12 col-md-6">

                                        <form name='settings_sms' id="settings_sms" method="post" action="{{route('admin.settings.outbound-call.save')}}">
                                            @csrf
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="outbound_call_enabled" value='1' name="outbound_call_enabled" @if(get_site_config('outbound_call_enabled')) checked="checked" @endif>
                                                <label class="form-check-label" for="outbound_call_enabled">
                                                    <b>Enable Outbound Call</b>
                                                </label>
                                            </div>
                                            <div class="from-group mt-2">
                                                <label>Provider</label>
                                                <select name="outbound_call_provider" id="outbound_call_provider" class="form-select">
                                                    <option value="">Select</option>
                                                    <option value="zadarma" @if(get_site_config('outbound_call_provider')=='zadarma' ) selected @endif>Zadarma</option>
                                                    <option value="exotel" @if(get_site_config('outbound_call_provider')=='exotel' ) selected @endif>Exotel</option>
                                                </select>
                                            </div>
                                            <div id="zadarma" class="mt-2" @if(get_site_config('outbound_call_provider')!='zadarma' ) style="display:none;" @endif>
                                                <label><strong>Zadarma Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>API Key</label>
                                                    <input type="text" class="form-control" name="zadarma_api_key" value="{{get_site_config('zadarma_api_key')}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>API Secret</label>
                                                    <input type="text" class="form-control" name="zadarma_api_secret" value="{{get_site_config('zadarma_api_secret')}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Agent No.</label>
                                                    <input type="text" class="form-control" name="zadarma_agent_number" value="{{get_site_config('zadarma_agent_number')}}">
                                                </div>
                                            </div>

                                            <div id="exotel" class="mt-2" @if(get_site_config('outbound_call_provider')!='exotel' ) style="display:none;" @endif>
                                                <label><strong>Exotel Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>API Key</label>
                                                    <input type="text" class="form-control" name="exotel_api_key" value="{{get_site_config('exotel_api_key')}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>API Secret</label>
                                                    <input type="text" class="form-control" name="exotel_api_secret" value="{{get_site_config('exotel_api_secret')}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Agent No.</label>
                                                    <input type="text" class="form-control" name="exotel_agent_number" value="{{get_site_config('exotel_agent_number')}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Account SID</label>
                                                    <input type="text" class="form-control" name="exotel_sid" value="{{get_site_config('exotel_sid')}}">
                                                </div>
                                            </div>

                                            <div class="text-center mt-3">
                                                <button class="btn btn-primary btn-sm" name="submit" type="submit" id="submit">Save</button>
                                            </div>
                                        </form>
                                    </div>

                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }

        $('#outbound_call_provider').change(function() {
            var provider = $(this).val();
            $('#zadarma').hide();
            $('#exotel').hide();
            $('#'+provider).show();
        });

    });
</script>
@endpush