@extends('backend.layouts.app')

@section('title', 'Settings: Services status')

@section('content')

<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('services-list')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Additional Services List</h4>
                                        <p>Do you provide services other than University Admissions? Add them here</p>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Services Stage" style="float: right;">
                                            <a href="{{route('admin.settings.service-stages')}}" class="btn btn-primary btn-sm me-1" title="Service Status"> Service Status</a>
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Service Stage"><i class="bi bi-plus-circle"></i> New</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Service</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($stages as $stage)
                                                    <tr>
                                                        <td>@if($stage->service_name){{$stage->service_name}}@endif</td>
                                                        <td>{{$stage->display_order}}</td>
                                                        <td>
                                                            <a title="Edit" href="javascript:void(0);" class="btn btn-primary btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-service_id="{{$stage->id}}" data-display_order="{{$stage->display_order}}" data-service_name="{{$stage->service_name}}" data-country_field="{{$stage->country_field}}" data-amount="{{$stage->amount}}" data-visa_service="{{$stage->visa_service}}" data-action_url="{{route('admin.settings.application-stages.update', $stage->id)}}"><i class='fas fa-edit' style='font-size:17px'></i></a>
                                                            <a title="Delete" href="#" onclick="delStatus({{$stage->id}})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade " tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-body">
            <form method="post" action="{{route('admin.settings.services.list.store')}}" id="">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add New Services</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="required-field"><b>Title</b></label>
                            <input type="text" name="service_name" class="form-control required-field" placeholder="" maxlength="50" required>
                        </div>
                        {{-- <div class="form-group row mt-2">
                            <div class="col-sm-12">
                                <span class="label required-field"><b>Is this Visa Service?</b></span><br>
                                <input type="radio" name="visa_service" id="visa_service_yes" value="1" required> <label for="visa_service_yes"> Yes</label>
                                &nbsp;
                                &nbsp;
                                <input type="radio" name="visa_service" id="visa_service_no" value="0" required> <label for="visa_service_no"> No</label>&nbsp;
                            </div>
                        </div> --}}
                        <div class="form-group row mt-2" id="country_block">
                            <div class="col-sm-6">
                                <span class="label required-field"><b>Country Field Required?</b></span><br>
                                <input type="radio" name="country_field" id="country_field_yes" value="1"> <label for="country_field_yes"> Yes</label>
                                &nbsp;
                                &nbsp;
                                <input type="radio" name="country_field" id="country_field_no" value="0"> <label for="country_field_no"> Not Applicable</label>&nbsp;
                            </div>
                            <div class="col-sm-6">
                                <span class="label"><b>Amount</b></span><br>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="padding: 5px 10px;font-size: 15px;">{{env('APP_CURRENCY_SYMBOL')}}</span>
                                    </div>
                                    <input type="number" name="amount" class="form-control" placeholder="Amount" value="">
                                </div>
                            </div>
                        </div>
                        <div class="form-group mt-2">
                            <label class="label required-field">Display Order</label>
                            <input type="number" name="display_order" class="form-control" value="" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary w-25 mx-auto">Add</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-body">
            <form method="post" action="{{route('admin.settings.services.list.edit-store')}}" id="edit_app-status">
                @csrf
                <input type="hidden" name="service_id" value="" id="service_id">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Services</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="required-field"><b>Title</b></label>
                            <input type="text" name="service_name" id="edit_service_name" class="form-control required-field" placeholder="" maxlength="50" required>
                        </div>
                        {{-- <div class="form-group row mt-2">
                            <div class="col-sm-12">
                                <span class="label required-field"><b>Is this Visa Service?</b></span><br>
                                <input type="radio" name="visa_service" id="edit_visa_service_yes" value="1" checked> <label for="edit_visa_service_yes"> Yes</label>
                                &nbsp;
                                &nbsp;
                                <input type="radio" name="visa_service" id="edit_visa_service_no" value="0"> <label for="edit_visa_service_no"> No</label>&nbsp;
                            </div>
                        </div> --}}
                        <div class="form-group row mt-2" id="edit_country_block">
                            <div class="col-sm-6">
                                <span class="label required-field"><b>Country Field Required?</b></span><br>
                                <input type="radio" name="country_field" id="edit_country_field_yes" value="1"> <label for="edit_country_field_yes"> Yes</label>
                                &nbsp;
                                &nbsp;
                                <input type="radio" name="country_field" id="edit_country_field_no" value="0"> <label for="edit_country_field_no"> Not Applicable</label>&nbsp;
                            </div>
                            <div class="col-sm-6">
                                <span class="label"><b>Amount</b></span><br>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="padding: 5px 10px;font-size: 15px;">{{env('APP_CURRENCY_SYMBOL')}}</span>
                                    </div>
                                    <input type="number" id="amount" name="amount" class="form-control" placeholder="Amount" value="">
                                </div>
                            </div>
                        </div>
                        <div class="form-group mt-2">
                            <label class="label required-field">Display Order</label>
                            <input type="number" name="display_order" id="edit_display_order" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary w-25 mx-auto">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('.edit_row').click(function() {
            $('#service_id').val($(this).data('service_id'));
            $('#edit_service_name').val($(this).data('service_name'));
            $('#amount').val($(this).data('amount'));
            $('#edit_display_order').val($(this).data('display_order'));
            
            // if($(this).data('visa_service') == '1'){
            //     $('#edit_visa_service_yes').prop('checked', true);
            //     $("#edit_country_field_no").prop("disabled", true);
            //     $('#edit_country_field_yes').prop('checked', true);
            // } else if($(this).data('visa_service') == '0'){
            //     $("#edit_country_field_no").prop("disabled", false);
            //     $('#edit_country_field_yes').prop('checked', false);
            //     $('#edit_visa_service_no').prop('checked', true);                
            // }

            if($(this).data('country_field') == '1'){
                $('#edit_country_field_yes').prop('checked', true);
            } else if($(this).data('country_field') == '0'){
                $('#edit_country_field_no').prop('checked', true);                
            }
        });

        $("#edit_visa_service_yes").click(function() {
            $("#edit_country_field_no").prop("disabled", true);
            //$('#edit_country_field_yes').prop('checked', true);
            $("[name='country_field']").prop('required',true);
        });
        $("#edit_visa_service_no").click(function() {
            $("#edit_country_field_no").prop("disabled", false);
            $("[name='country_field']").prop("required", false);
            //$("#edit_country_field_no").prop('checked', true);
        });

        $("#visa_service_yes").click(function() {
            $("#country_field_no").prop("disabled", true);
            $('#country_field_yes').prop('checked', true);
            $("[name='country_field']").prop('required',true);
        });
        $("#visa_service_no").click(function() {
            $("#country_field_no").prop("disabled", false);
            $('#country_field_yes').prop('checked', false);
            $("[name='country_field']").prop("required", false);
            //$("#country_field_no").prop('checked', true);
        });
    });

    function delStatus(id){
        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        Swal.fire({
            title: "Are you sure you want to delete this services ?",
            html: "" + warning + "",
            showCancelButton: true,
            confirmButtonColor: "#DC3545",
            confirmButtonText: `Delete`,
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('admin/settings/services-list/delete/')}}/"+id;
                } else if (result.isDenied) {
                    
                }
        });
    }
</script>
@endpush