@extends('backend.layouts.app')

@section('title', 'Settings: University Applications status')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('service-stages')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Service Statuses</h4>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Application Stage" style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Application Stage"><i class="bi bi-plus-circle"></i> New</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>Service</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($stages as $stage)
                                                    <tr>
                                                        <td>{{ $stage->status_name }}
                                                            @if($stage->case_close_stage =='1')
                                                            <br>
                                                            <span class="badge badge-danger">Case Close Stage</span>
                                                            @elseif($stage->default_stage =='1')
                                                            <br>
                                                            <span class="badge badge-success">Default Stage</span>
                                                            @endif
                                                        </td>
                                                        <td>{{ get_services($stage->service_id) }}
                                                        </td>
                                                        <td>{{ $stage->stage_order }}</td>
                                                        <td>
                                                            <a title="Edit" href="javascript:void(0);" class="btn btn-primary btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-id="{{$stage->id}}" data-display_order="{{$stage->stage_order}}" data-color="{{$stage->color}}" data-name="{{$stage->status_name}}" data-case_close_stage="{{$stage->case_close_stage}}" data-default_stage="{{$stage->default_stage}}" data-service_id="{{$stage->service_id}}" data-action_url="{{route('admin.settings.service-stage.update', $stage->id)}}"><i class='fas fa-edit ' style='font-size:17px'></i></a>
                                                            <a title="Delete" href="#" onclick="delStatus({{$stage->id}})" class="btn btn-danger btn-sm {{($stage->default_stage || $stage->case_close_stage) ? 'disabled' : ''}}"><i class="fa fa-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        {{-- <small><b>Notes:</b>
                                            <ul>
                                                <li>Super Admin is allowed to change a Service status to previous status even if "Can go back to previous stage = No"</li>
                                            </ul>
                                        </small> --}}
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="{{route('admin.settings.service-stage.store')}}" id="">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Service Stage</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Service</b></label>
                        <select name="service" class="form-select required-field" required>
                            <option value="">Select Service</option>
                            @if($services)
                                @foreach($services as $service)
                                    <option value="{{$service->id}}">{{$service->service_name}}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="name" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label"><b>Is this Default or Case Close stage?</b></span><br>
                            <select class="form-select" name="stage_type">
                                <option value="">Select</option>
                                <option value="default">Default</option>
                                <option value="case_close">Case Close stage</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group mt-2">
                        <label class="label required-field">Stage Order</label>
                        <input type="number" name="stage_order" class="form-control" value="1" required>
                    </div>
                    <div class="form-group mt-2">
                        <label class="required-field"><b>Color</b></label>
                        <input type="text" autocomplete="off" class="form-control colorPicker" name="color" required />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="" id="edit_service-status">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Service Stage</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Service</b></label>
                        <select name="service" id="edit_service" class="form-select required-field" required>
                            <option value="">Select Service</option>
                            @if($services)
                                @foreach($services as $service)
                                    <option value="{{$service->id}}">{{$service->service_name}}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="name" id="edit_name" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label"><b>Is this Default or Case Close stage?</b></span><br>
                            <select class="form-select" name="stage_type" id="edit_stage_type">
                                <option value="">Select</option>
                                <option value="default">Default</option>
                                <option value="case_close">Case Close stage</option>
                            </select>
                        </div>
                    </div>
                    {{-- <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Is this Case Close stage?</b></span><br>
                            <input type="radio" checked name="edit_case_close" id="edit_case_close_no" value="0"> <label for="edit_case_close_no"> No</label>&nbsp;
                            &nbsp;
                            &nbsp;
                            <input type="radio" name="edit_case_close" id="edit_case_close_yes" value="1"> <label for="edit_case_close_yes"> Yes</label>
                        </div>
                    </div> --}}

                  
                    <div class="form-group mt-2">
                        <label class="label required-field">Stage Order</label>
                        <input type="number" name="stage_order" id="edit_stage_order" class="form-control" required>
                    </div>
                    <div class="form-group mt-2">
                        <label class="required-field"><b>Color</b></label>
                        <input type="text" autocomplete="off" id="edit_color" class="form-control colorPicker" name="color" required />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $(".select2").select2({
            dropdownParent: $("#edit_modal")
        });
        $(".select3").select2({
            dropdownParent: $("#create_modal")
        });
       
        $('.edit_row').click(function() {
            $('#edit_name').val($(this).data('name'));
            $('#edit_service').val($(this).data('service_id'));
            $('#edit_stage_order').val($(this).data('display_order'));
           
            $('#edit_color').val($(this).data('color'));
            var case_close_stage = $(this).data('case_close_stage');
            var default_stage = $(this).data('default_stage');
          
            if(default_stage == '1'){
                $('#edit_stage_type').val("default");
            } 
            if(case_close_stage == '1'){
                $('#edit_stage_type').val("case_close");
            }
             
                        
            $('#edit_service-status').attr('action', $(this).data('action_url'));

        });

        //Edit
        $('#edit_modal').on('hidden.bs.modal', function () {
            $('#edit_modal form')[0].reset();
        });


    });
    function delStatus(id){
        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        Swal.fire({
            title: "Are you sure you want to delete this Service status?",
            html: "" + warning + "",
            showCancelButton: true,
            confirmButtonColor: "#DC3545",
            confirmButtonText: `Delete`,
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('admin/settings/service-stage/delete/')}}/"+id;
                } else if (result.isDenied) {
                    
                }
        });
    }
</script>
@endpush