@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')


<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('sms')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="sms_settings">
                                <h4>SMS Gateway Configuration</h4><br />
                                <div class="row">
                                    <div class="col-sm-12 col-md-6">

                                        <form name='settings_sms' id="settings_sms" method="post" action="{{route('admin.settings.sms.save')}}">
                                            @csrf
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="sms_enabled" value='1' name="sms_enabled" @if(get_site_config('sms_enabled')) checked="checked" @endif>
                                                <label class="form-check-label" for="sms_enabled">
                                                    <b>Enable SMS Notifications</b>
                                                </label>
                                            </div>
                                            <div class="from-group mt-2">
                                                <label>SMS Provider</label>
                                                <select name="sms_provider" id="sms_provider" class="form-select">
                                                    <option value="">Select</option>
                                                    <option value="Twilio" @if(get_site_config('sms_provider')=='Twilio' ) selected @endif>Twilio</option>
                                                    <option value="Textlocal" @if(get_site_config('sms_provider')=='Textlocal' ) selected @endif>Textlocal</option>
                                                    <option value="Msg91" @if(get_site_config('sms_provider')=='Msg91' ) selected @endif>Msg91</option>
                                                    <option value="Gupshup" @if(get_site_config('sms_provider')=='Gupshup' ) selected @endif>Gupshup</option>
                                                    <option value="Voodoo" @if(get_site_config('sms_provider')=='Voodoo' ) selected @endif>Voodoo</option>
                                                    <option value="Fast2sms" @if(get_site_config('sms_provider')=='Fast2sms' ) selected @endif>Fast2sms</option>
                                                    <option value="Other" @if(get_site_config('sms_provider')=='Other' ) selected @endif>Other</option>
                                                </select>
                                            </div>

                                            <div id="Twilio" class="mt-2" @if(get_site_config('sms_provider')!='Twilio' ) style="display:none;" @endif>
                                                <label><strong>Twilio Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>Account SID</label>
                                                    <input type="text" class="form-control" name="twilio_sms_senderid" placeholder="Account SID" value="{{(get_site_config('sms_provider')=='Twilio') ? get_site_config('sms_senderid') : ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Auth Token</label>
                                                    <input type="text" class="form-control" name="twilio_sms_auth_token" placeholder="Auth Token" value="{{(get_site_config('sms_provider')=='Twilio') ? get_site_config('sms_auth_token') : ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Twilio Phone No.</label>
                                                    <input type="text" class="form-control" name="sms_from_phone" placeholder="Twilio Phone No." value="{{get_site_config('sms_from_phone')}}">
                                                </div>
                                            </div>

                                            <div id="Textlocal" class="mt-2" @if(get_site_config('sms_provider')!='Textlocal' ) style="display:none;" @endif>
                                                <label><strong>Textlocal Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>Sender ID</label>
                                                    <input type="text" class="form-control" name="textlocal_sms_senderid" placeholder="Sender ID" value="{{(get_site_config('sms_provider')=='Textlocal') ? get_site_config('sms_senderid') : ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>API Key</label>
                                                    <input type="text" class="form-control" name="textlocal_sms_auth_token" placeholder="API Key" value="{{(get_site_config('sms_provider')=='Textlocal') ? get_site_config('sms_auth_token'): ''}}">
                                                </div>
                                            </div>

                                            <div id="Msg91" class="mt-2" @if(get_site_config('sms_provider')!='Msg91' ) style="display:none;" @endif>
                                                <label><strong>Msg91 Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>Sender ID</label>
                                                    <input type="text" class="form-control" name="msg91_sms_senderid" placeholder="Sender ID" value="{{(get_site_config('sms_provider')=='Msg91') ? get_site_config('sms_senderid') : ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Auth Key</label>
                                                    <input type="text" class="form-control" name="msg91_sms_auth_token" placeholder="Auth Key" value="{{(get_site_config('sms_provider')=='Msg91') ? get_site_config('sms_auth_token'): ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Flow ID</label>
                                                    <input type="text" class="form-control" name="sms_flow_id" placeholder="Flow ID" value="{{get_site_config('sms_flow_id')}}">
                                                </div>
                                            </div>

                                            <div id="Gupshup" class="mt-2" @if(get_site_config('sms_provider')!='Gupshup' ) style="display:none;" @endif>
                                                <label><strong>Gupshup Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>User ID</label>
                                                    <input type="text" class="form-control" name="gupshup_sms_senderid" placeholder="User ID" value="{{(get_site_config('sms_provider')=='Gupshup') ? get_site_config('sms_senderid') : ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Password</label>
                                                    <input type="text" class="form-control" name="gupshup_sms_auth_token" placeholder="Password" value="{{(get_site_config('sms_provider')=='Gupshup') ? get_site_config('sms_auth_token') : ''}}">
                                                </div>
                                            </div>

                                            <div id="Voodoo" class="mt-2" @if(get_site_config('sms_provider')!='Voodoo' ) style="display:none;" @endif>
                                                <label><strong>Voodoo Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>Sender</label>
                                                    <input type="text" class="form-control" name="voodoo_sms_senderid" placeholder="Sender" value="{{(get_site_config('sms_provider')=='Voodoo') ? get_site_config('sms_senderid') : ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>API Key</label>
                                                    <input type="text" class="form-control" name="voodoo_sms_auth_token" placeholder="API Key" value="{{(get_site_config('sms_provider')=='Voodoo') ? get_site_config('sms_auth_token'): ''}}">
                                                </div>
                                            </div>

                                            <div id="Fast2sms" class="mt-2" @if(get_site_config('sms_provider')!='Fast2sms' ) style="display:none;" @endif>
                                                <label><strong>Fast2sms Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>Sender ID</label>
                                                    <input type="text" class="form-control" name="fast2sms_sms_senderid" placeholder="Sender ID" value="{{(get_site_config('sms_provider')=='Fast2sms') ? get_site_config('sms_senderid') : ''}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>API Key</label>
                                                    <input type="text" class="form-control" name="fast2sms_sms_auth_token" placeholder="API Key" value="{{(get_site_config('sms_provider')=='Fast2sms') ? get_site_config('sms_auth_token') : ''}}">
                                                </div>
                                            </div>


                                            <div id="Other" class="mt-2" @if(get_site_config('sms_provider')!='Other' ) style="display:none;" @endif>
                                                <label><strong>Other SMS Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>API URL</label>
                                                    <input type="text" class="form-control" name="sms_api_url" placeholder="API URL" value="{{get_site_config('sms_api_url')}}">
                                                    <small>Use {numbers} to replace with mobile nos.</small>
                                                    <p class="small">Use {message} to replace with the message.</p>
                                                </div>
                                            </div>


                                            <div class="text-center mt-3">
                                                <button class="btn btn-primary btn-sm" name="submit" type="submit" id="submit">Save</button>
                                            </div>
                                        </form>
                                    </div>

                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }

        $('#sms_provider').change(function() {
            var provider = $(this).val();
            $('#Twilio').hide();
            $('#Textlocal').hide();
            $('#Msg91').hide();
            $('#Gupshup').hide();
            $('#Voodoo').hide();
            $('#Fast2sms').hide();
            $('#Other').hide();

            $('#'+provider).show();
        });

    });
</script>
@endpush