@extends('backend.layouts.app')

@section('title', 'Settings: Stundent status')

@section('content')

<div class="row">
   
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('student-status')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Student Status</h4>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Student Status" style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Student Status"><i class="bi bi-plus-circle"></i> New</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Status</th>
                                                        <th>Auto Assign On</th>
                                                        <th>Stage</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($statusData as $stage)
                                                    <tr>
                                                        <td><span class="badge" style="background-color: {{$stage->color}};">{{ $stage->overseas_status_name }}</span></td>
                                                        <td>
                                                            @if($stage->assign_on_create =='1')
                                                            Create Student
                                                            @elseif($stage->assign_on_course_pref =='1')
                                                            Course Preference Added
                                                            @elseif($stage->assign_on_doc_upload =='1')
                                                            Documents Uploaded
                                                            @elseif($stage->assign_on_appl_create =='1')
                                                            Application Processing
                                                            @else
                                                            --
                                                            @endif
                                                        </td>
                                                        <td>
                                                            @if($stage->is_completed_success =='1')
                                                            <br>
                                                            <span class="badge badge-success">Admission Complete</span>
                                                            @elseif($stage->is_dropout =='1')
                                                            <br>
                                                            <span class="badge badge-danger">Rejected/Dropout</span>
                                                            @else
                                                            --
                                                            @endif
                                                        </td>
                                                        <td>{{ $stage->display_order }}</td>
                                                        <td>
                                                            <a title="Edit" href="javascript:void(0);" class="btn btn-primary btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-id="{{$stage->id}}" data-display_order="{{$stage->display_order}}" data-color="{{$stage->color}}" data-name="{{$stage->overseas_status_name}}"
                                                            data-auto_assign="@if($stage->assign_on_create){{'assign_on_create'}}@elseif($stage->assign_on_course_pref){{'assign_on_course_pref'}}@elseif($stage->assign_on_doc_upload){{'assign_on_doc_upload'}}@elseif($stage->assign_on_appl_create){{'assign_on_appl_create'}}@else{{''}}@endif" 
                                                            data-status_stage="@if($stage->is_completed_success){{'is_completed_success'}}@elseif($stage->is_dropout){{'is_dropout'}}@else{{''}}@endif"
                                                            data-action_url="{{route('admin.settings.student-status.update', $stage->id)}}"><i class='fas fa-edit ' style='font-size:17px;' ></i></a>
                                                            <a title="Delete" href="#" onclick="delStatus({{$stage->id}})" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        {{-- <small><b>Notes:</b>
                                            <ul>
                                                <li>Super Admin is allowed to change a University Applications status to previous status even if "Can go back to previous stage = No"</li>
                                            </ul>
                                        </small> --}}
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="{{route('admin.settings.student-status.store')}}" id="">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Student Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="name" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>
                    
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Auto Assign to this status?</b></span><br>
                            <ul class="mt-1" style="list-style: none;padding:0;">
                            <li><input type="radio" checked name="assign_to_status" id="do_not_assign" value="0"> <label for="do_not_assign"> Do not auto assign</label>
                            </li>
                            <li><input type="radio" name="assign_to_status" id="assign_on_create" value="assign_on_create"> <label for="assign_on_create"> On Student create/Lead conversion to student</label>
                            </li>
                            <li><input type="radio" name="assign_to_status" id="assign_on_course_pref" value="assign_on_course_pref"> <label for="assign_on_course_pref"> On Course Preference added by student/staff</label>
                            </li>
                            <li><input type="radio" name="assign_to_status" id="assign_on_doc_upload" value="assign_on_doc_upload"> <label for="assign_on_doc_upload"> On Documents Upload completion</label>
                            </li>
                            <li><input type="radio" name="assign_to_status" id="assign_on_appl_create" value="assign_on_appl_create"> <label for="assign_on_appl_create"> On University Application creation</label>
                            </li>
                            </ul>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Status stage</b></span><br>
                            <ul class="mt-1" style="list-style: none;padding:0;">
                            <li>
                                <input type="radio" checked name="status_stage" id="none_stage" value="0"> <label for="none_stage"> None</label>
                            </li>
                            <li>
                                <input type="radio" name="status_stage" id="is_completed_success" value="is_completed_success"> <label for="is_completed_success"> Admission Complete</label>
                            </li>
                            <li>
                                <input type="radio" name="status_stage" id="is_dropout" value="is_dropout"> <label for="is_dropout"> Dropout/Rejected</label>
                            </li>
                        </div>
                    </div>

                    <div class="form-group mt-2">
                        <label class="required-field"><b>Color</b></label>
                        <input type="text" autocomplete="off" class="form-control colorPicker" name="color" required />
                    </div>
                    <div class="form-group mt-2">
                        <label class="label required-field">Display Order</label>
                        <input type="number" name="display_order" class="form-control" value="99" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog" role="document">
        <form method="post" action="" id="edit_stu-status">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Student Status</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label class="required-field"><b>Name</b></label>
                        <input type="text" name="edit_name" id="edit_name" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>

                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Auto Assign to this status?</b></span><br>
                            <ul class="mt-1" style="list-style: none;padding:0;">
                            <li><input type="radio" name="edit_assign_to_status" id="edit_do_not_assign" value="0"> <label for="edit_do_not_assign"> Do not auto assign</label>
                            </li>
                            <li><input type="radio" name="edit_assign_to_status" id="edit_assign_on_create" value="assign_on_create"> <label for="edit_assign_on_create"> On Student create/Lead conversion to student</label>
                            </li>
                            <li><input type="radio" name="edit_assign_to_status" id="edit_assign_on_course_pref" value="assign_on_course_pref"> <label for="edit_assign_on_course_pref"> On Course Preference added by student/staff</label>
                            </li>
                            <li><input type="radio" name="edit_assign_to_status" id="edit_assign_on_doc_upload" value="assign_on_doc_upload"> <label for="edit_assign_on_doc_upload"> On Documents Upload completion</label>
                            </li>
                            <li><input type="radio" name="edit_assign_to_status" id="edit_assign_on_appl_create" value="assign_on_appl_create"> <label for="edit_assign_on_appl_create"> On University Application creation</label>
                            </li>
                            </ul>
                        </div>
                    </div>
                    <div class="form-group row mt-2">
                        <div class="col-sm-12">
                            <span class="label required-field"><b>Status stage</b></span><br>
                            <ul class="mt-1" style="list-style: none;padding:0;">
                            <li>
                                <input type="radio" name="edit_status_stage" id="edit_none_stage" value="0"> <label for="edit_none_stage"> None</label>
                            </li>
                            <li>
                                <input type="radio" name="edit_status_stage" id="edit_is_completed_success" value="is_completed_success"> <label for="edit_is_completed_success"> Admission Complete</label>
                            </li>
                            <li>
                                <input type="radio" name="edit_status_stage" id="edit_is_dropout" value="is_dropout"> <label for="edit_is_dropout"> Dropout/Rejected</label>
                            </li>
                        </div>
                    </div>
                    <div class="form-group mt-2">
                        <label class="required-field"><b>Color</b></label>
                        <input type="text" autocomplete="off" id="edit_color" class="form-control colorPicker" name="edit_color" required />
                    </div>
                    <div class="form-group mt-2">
                        <label class="label required-field">Display Order</label>
                        <input type="number" name="edit_display_order" id="edit_display_order" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary w-25 mx-auto">Update</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('.edit_row').click(function() {
            $('#edit_name').val($(this).data('name'));
            $('#edit_display_order').val($(this).data('display_order'));
            $('#edit_color').val($(this).data('color'));
            var edit_auto_assign = $(this).data('auto_assign');
            var edit_status_stage = $(this).data('status_stage');
            
            if(edit_auto_assign){
                $('#edit_'+edit_auto_assign).prop("checked", true);
            }else{
                $('#edit_do_not_assign').prop("checked", true);
            }

            if(edit_status_stage){
                $('#edit_'+edit_status_stage).prop("checked", true);
            }else{
                $('#edit_none_stage').prop("checked", true);
            }
                 
            $('#edit_stu-status').attr('action', $(this).data('action_url'));

        });

        //Edit
        $('#edit_modal').on('hidden.bs.modal', function () {
            $('#edit_modal form')[0].reset();
        });


    });

    function delStatus(id){
        var warning = "<b class='text-danger'>This action cannot be undone!</b>";
        Swal.fire({
            title: "Are you sure you want to delete this Student status?",
            html: "" + warning + "",
            showCancelButton: true,
            confirmButtonColor: "#DC3545",
            confirmButtonText: `Delete`,
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = "{{ url('admin/settings/student-status/delete/')}}/"+id;
                } else if (result.isDenied) {
                    
                }
        });
    }
</script>
@endpush