@extends('backend.layouts.app')

@section('title', 'Settings: Study Levels')

@section('content')

<div class="row">
    <div class="col-xl-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('study-levels')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">
                            <div class="tab-pane fade active show" id="">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <h4>Study Levels</h4>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="btn-toolbar float-right" role="toolbar" aria-label="New Study Level" style="float: right;">
                                            <button class="btn btn-primary btn-sm ml-1" data-bs-toggle="modal" data-bs-target="#create_modal" title="Add New Study Level"><i class="bi bi-plus-circle"></i> New</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-2">
                                    <div class="col">
                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Title</th>
                                                        <th>Degree</th>
                                                        <th>Display Order</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($levels as $level)
                                                    <tr>
                                                        <td>{{ $level->study_level }}</td>
                                                        <td>{{ $level->degree }}</td>
                                                        <td>{{ $level->display_order }}</td>
                                                        <td>
                                                            <a title="Edit" href="javascript:void(0);" class="btn btn-primary btn-sm edit_row" data-bs-toggle="modal" data-bs-target="#edit_modal" data-id="{{$level->id}}" data-study_level="{{$level->study_level}}" data-degree="{{$level->degree}}" data-display_order="{{$level->display_order}}" data-action_url="{{route('admin.settings.study-levels.update', $level->id)}}"><i class='fas fa-edit ' style='font-size:17px'></i></a>
                                                            <a title="Delete" href="{{ route('admin.settings.study-levels.destroy',$level->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?" class="btn btn-danger btn-sm" class="btn btn-primary"><i class="fa fa-trash"></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>

                                        </div>
                                    </div><!-- End Bordered Tabs -->

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" tabindex="-1" id="create_modal" role="dialog">
    <div class="modal-dialog " role="document">
        <form method="post" action="{{route('admin.settings.study-levels.store')}}" id="add_study-level">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Study Level</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="study_level" class="form-control required-field" placeholder="" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field">Degree</label>
                        <select class="form-control form-select" name="degree" required>
                            <option value="Pre-bachelors">Pre-bachelors</option>
                            <option value="Bachelors">Bachelors</option>
                            <option value="Pre-masters">Pre-masters</option>
                            <option value="Masters">Masters</option>
                            <option value="Ph.D">Ph.D</option>
                            <option value="Others">Others</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Display Order</label>
                        <input type="number" name="display_order" class="form-control" value="1" required>
                    </div>
                </div>
                <hr>
                <div class="mx-auto">
                    <button type="submit" class="btn btn-primary">Add</button>
                </div>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" tabindex="-1" id="edit_modal" role="dialog">
    <div class="modal-dialog " role="document">
        <form method="post" action="" id="edit_study-level">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Study Level</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Title</label>
                        <input type="text" name="study_level" id="edit_study_level" class="form-control" maxlength="100" required>
                    </div>

                    <div class="form-group">
                        <label class="required-field">Degree</label>
                        <select class="form-control form-select" id="edit_degree" name="degree" required>
                            <option value="Pre-bachelors">Pre-bachelors</option>
                            <option value="Bachelors">Bachelors</option>
                            <option value="Pre-masters">Pre-masters</option>
                            <option value="Masters">Masters</option>
                            <option value="Ph.D">Ph.D</option>
                            <option value="Others">Others</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Display Order</label>
                        <input type="number" name="display_order" id="edit_display_order" class="form-control" required>
                    </div>
                </div>
                <hr>
                <div class="mx-auto">
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('.edit_row').click(function() {
            $('#edit_study_level').val($(this).data('study_level'));
            $("#edit_degree").val($(this).data('degree')).change();
            $('#edit_display_order').val($(this).data('display_order'));            
            $('#edit_study-level').attr('action', $(this).data('action_url'));
        });
    });
</script>
@endpush