@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')
<div class="row">
    <div class="col" style="margin-bottom:10px;">
        <h4 style="">Settings</h4>
    </div>
</div>
<div class="row">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-body pt-3">
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('uni-apply-agents')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general active show" id="uni_apply_agents">

                                <div class="row">
                                    <div class="col-sm-12 col-md-9">
                                        <h4>Add New University Apply Agent</h4>
                                        <form action="{{route('admin.uni-apply-agent.save')}}" method="post">
                                            @csrf
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label class="required-field">Name</label>
                                                        <input type="text" class="form-control" name="name" maxlength="150" required />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group mb-3">
                                                        <label>Phone</label>
                                                        <input type="text" class="form-control" name="phone" maxlength="12" />
                                                    </div>
                                                </div>
                                                <div class="col-sm-6 col-md-6">
                                                    <div class="form-group mb-3">
                                                        <label>Email</label>
                                                        <input type="email" class="form-control" name="email" maxlength="50" />
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="form-group mb-3">
                                                        <label>Address</label><br />
                                                        <textarea id="address" name="address" class="form-control"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-sm-12 col-md-12">
                                                    <div class="form-group mb-3">
                                                        <label>@lang('labels.general.taxid')</label>
                                                        <input type="text" class="form-control" name="tax_id" maxlength="50">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-md-4 mb-3">
                                                        <label >Tax type</label>
                                                        <select name="tax_type" class="form-select">
                                                            <option value="">Select</option>
                                                        <option {{old('tax_type' == 'inclusive')? 'selected' : ''}} value="inclusive">Inclusive</option>
                                                        <option {{old('tax_type' == 'exclusive')? 'selected' : ''}} value="exclusive">Exclusive</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4 mb-3">
                                                    <label >Tax Percent</label>
                                                    <input type="number" step="any" name="tax_percent" class="form-control" value="{{old('tax_percent')}}" >
                                                </div>
                                                <div class="form-group col-md-4 mb-3">
                                                        <label>Commission Count</label>
                                                        <select name="commission_count" class="form-select">
                                                        <option {{old('commission_count' == '1')? 'selected' : ''}} value="1">1</option>
                                                        <option {{old('commission_count' == '2')? 'selected' : ''}} value="2">2</option>
                                                        <option {{old('commission_count' == '3')? 'selected' : ''}} value="3">3</option>
                                                        <option {{old('commission_count' == '4')? 'selected' : ''}} value="4">4</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary btn-sm">Save</button>
                                            </div>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-12">
                                        <hr>
                                        <h4>Existing University Apply Agents</h4>

                                        <div class="table-responsive">
                                            <table class="table eductrl-datatable">
                                                <thead>
                                                    <tr>
                                                        <th>Name</th>
                                                        <th>Address</th>
                                                        <th>Contact</th>
                                                        <th>Tax Details</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @if(count($agents))
                                                    @foreach($agents as $agent)
                                                    <tr>
                                                        <td>{{$agent->name}}</td>
                                                        <td>{!!$agent->address!!}</td>
                                                        <td>{!!"<b>Phone:</b> ".$agent->phone!!}<br>{!!"<b>Email:</b> ".$agent->email!!}</td>
                                                        <td>{!!"<b>"!!} @lang('labels.general.taxid'){!!":</b> ".$agent->tax_id!!}<br>{!!"<b>Tax Type:</b> ".$agent->tax_type!!}<br>{!!"<b>Tax %:</b> ".$agent->tax_percent!!}</td>
                                                        <td>
                                                            <a href="{{ route('admin.uni-apply-agent.edit', $agent->id)}}"><i class='fas fa-edit text-primary' style='font-size:17px'></i></a>&nbsp;
                                                            <a href="{{ route('admin.uni-apply-agent.delete', $agent->id)}}" data-method="delete" data-trans-button-cancel="Cancel" data-trans-button-confirm="Delete" data-trans-title="Are you sure?"><i class='fas fa-trash-alt text-danger' style='font-size:17px'></i></a>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                    @else
                                                    <tr>
                                                        <td colspan="5" class="text-center">No Agents Found</td>
                                                    </tr>
                                                    @endif
                                                </tbody>
                                            </table>
                                        </div>

                                    </div>
                                </div>

                            </div>

                        </div><!-- End Bordered Tabs -->

                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    addDeleteForms();
</script>
@endpush