@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')


<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('web-to-lead')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="web_lead_settings">
                                <h4>Web to Lead Form Builder</h4><br />
                                <div class="row">
                                    <div class="col-sm-12 col-md-6">

                                        <form name='web_lead' id="web_lead_form" action="{{route('admin.web-to-lead-save')}}">
                                            @csrf
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="web_lead_enabled" value='1' name="web_lead_enabled" @if($web_lead_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_enabled">
                                                    <b>Enable Web to Lead</b>
                                                </label>
                                            </div>
                                            <div class="form-input mb-2">
                                                <label class="required-field">
                                                    Form Name
                                                </label>
                                                <input class="form-control mb-0" type="text" id="web_lead_form_name" name="web_lead_form_name" value="{{$web_lead_form_name}}" required>
                                                <small>This will be stored in lead source details</small>
                                            </div>
                                            <div class="form-input">
                                                <label class="required-field">
                                                    Redirect URL after form Submission
                                                </label>
                                                <input class="form-control" type="text" id="web_lead_redirect_url" name="web_lead_redirect_url" value="{{$web_lead_redirect_url}}" required>
                                            </div>
                                            <div class="form-input">
                                                <div class="form-input">
                                                    <label class="required-field">
                                                        Branch
                                                    </label>
                                                    <select class="form-select" name="web_lead_assign_to_branch" id="web_lead_assign_to_branch" required>
                                                        <option value="">Select Branch</option>
                                                        @foreach($branches as $branch)
                                                        <option {{($web_lead_assign_to_branch == $branch->id)? 'selected' : ''}} value="{{$branch->id}}">{{$branch->branch_name}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <label class="">
                                                    Assign the new leads to
                                                </label>

                                                <select class="form-select" name="web_lead_assign_to" id="web_lead_assign_to">
                                                    <option value="">Select Staff</option>
                                                    {{-- @foreach($staff as $stf)
                                                    <option {{($web_lead_assign_to == $stf->id)? 'selected' : ''}} value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                                                    @endforeach --}}
                                                </select>
                                            </div>
                                            
                                            <br />
                                            <h6>Lead Form Fields</h6>
                                            <span class="text-smaller">Enable/disable the below form fields</span><br /><br />
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_first_name_enabled" name="web_lead_first_name_enabled" @if($web_lead_first_name_enabled=='1' ) checked="checked" @endif disabled>
                                                <label class="form-check-label" for="web_lead_first_name_enabled">
                                                    First Name
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_last_name_enabled" name="web_lead_last_name_enabled" @if($web_lead_last_name_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_last_name_enabled">
                                                    Last Name
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_gender_enabled" name="web_lead_gender_enabled" @if($web_lead_gender_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_gender_enabled">
                                                    Gender
                                                </label>
                                            </div>
                                           <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_email_enabled" name="web_lead_email_enabled" @if($web_lead_email_enabled=='1' ) checked="checked" @endif 
                                                @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'email' || get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile') onclick="return false" checked="checked" disabled  @endif>
                                                <label class="form-check-label" for="web_lead_email_enabled">
                                                    Email
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_mobile_enabled" name="web_lead_mobile_enabled" @if($web_lead_mobile_enabled=='1' ) checked="checked" @endif 
                                                @if(get_site_config('lead_create_web2lead_api_import_mandatory') == 'mobile' || get_site_config('lead_create_web2lead_api_import_mandatory') == 'email_and_mobile') onclick="return false" checked="checked" disabled  @endif>
                                                <label class="form-check-label" for="web_lead_mobile_enabled">
                                                    Mobile Number
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_whatsapp_enabled" name="web_lead_whatsapp_enabled" @if($web_lead_whatsapp_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_whatsapp_enabled">
                                                    Whatsapp Number
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_alternate_contact_enabled" name="web_lead_alternate_contact_enabled" @if($web_lead_alternate_contact_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_alternate_contact_enabled">
                                                    Alternate Contact
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_country_of_citizenship_enabled" name="web_lead_country_of_citizenship_enabled" @if($web_lead_country_of_citizenship_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_country_of_citizenship_enabled">
                                                    Country of Citizenship
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_current_course_enabled" name="web_lead_current_course_enabled" @if($web_lead_country_of_citizenship_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_current_course_enabled">
                                                    Currently Studying Course
                                                </label>
                                            </div>

                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_study_level_enabled" name="web_lead_study_level_enabled" @if($web_lead_study_level_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_study_level_enabled">
                                                    Interested Study Level
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_course_interested_enabled" name="web_lead_course_interested_enabled" @if($web_lead_course_interested_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_course_interested_enabled">
                                                    Course Interested to Study
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_intake_enabled" name="web_lead_intake_enabled" @if($web_lead_intake_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_intake_enabled">
                                                    Intake
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_country_pref_enabled" name="web_lead_country_pref_enabled" @if($web_lead_country_pref_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_country_pref_enabled">
                                                    Country Interested to Study In
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_qualification_enabled" name="web_lead_qualification_enabled" @if($web_lead_qualification_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_qualification_enabled">
                                                    Qualification
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_passout_year_enabled" name="web_lead_passout_year_enabled" @if($web_lead_passout_year_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_passout_year_enabled">
                                                    Passout Year
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_score_enabled" name="web_lead_score_enabled" @if($web_lead_score_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_score_enabled">
                                                    Score/Grade
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_accommodation_enabled" name="web_lead_accommodation_enabled" @if($web_lead_accommodation_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_accommodation_enabled">
                                                    Require Accommodation
                                                </label>
                                            </div>

                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_study_permit_enabled" name="web_lead_study_permit_enabled" @if($web_lead_study_permit_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_study_permit_enabled">
                                                    Require Study Permit
                                                </label>
                                            </div>

                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_dob_enabled" name="web_lead_dob_enabled" @if($web_lead_dob_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_dob_enabled">
                                                    Date of Birth
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value='1' id="web_lead_city_enabled" name="web_lead_city_enabled" @if($web_lead_city_enabled=='1' ) checked="checked" @endif>
                                                <label class="form-check-label" for="web_lead_city_enabled">
                                                    City
                                                </label>
                                            </div>
                                            @if(count($custom_attributes))
                                                @foreach($custom_attributes as $custom_attribute)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value='1' id="web_lead_{{$custom_attribute->attr_name}}_enabled" name="{{$custom_attribute->attr_name}}" @if($custom_attribute->web_to_lead=='1' ) checked="checked" @endif>
                                                    <label class="form-check-label" for="web_lead_{{$custom_attribute->attr_name}}_enabled">
                                                        {{$custom_attribute->label}}
                                                    </label>
                                                </div>
                                                @endforeach
                                            @endif
                                            <div class="text-center">
                                                <button class="btn btn-primary btn-sm" name="submit" type="submit" id="submit">Save</button>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="col-sm-12 col-md-6">
                                        <h6>HTML Code</h6>
                                        <label>Copy the below code to your website HTML code</label>
                                        <span class="text-smaller">
                                            <ul style="padding-left:15px !important;">
                                                <li>You can add more fields other than the available default fields, they will be stored in lead description</li>
                                                <li>You can also customize the css for input fields.</li>
                                            </ul>
                                        </span>
                                        <div style="height:230px;overflow-y:scroll;padding:3px;border:1px solid #ccc;" id='web_lead_html_code'>
                                            {!! nl2br(e($html_code)) !!}
                                        </div>
                                        <br />
                                        @if($web_lead_enabled == '1')
                                        <div class="text-center">
                                            <button class="btn btn-primary btn-sm" onClick="javascript:copyToClipboard()" id="copy_code">Copy Code</button>
                                        </div>
                                        @endif

                                    </div>
                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }
        // $('#web_lead_assign_to').change(function(){
        //     var staff_id= $('#web_lead_assign_to').val();
        //     if(staff_id!=''){
        //     $.ajax({
        //     type: "get",
        //     url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+staff_id,
        //     cache: false,
        //     success: function(data){                     
        //     try{  
        //         if(data){
        //             console.log(data);
        //         $("#web_lead_assign_to_branch").empty();
        //             $("#web_lead_assign_to_branch").append('<option>Select</option>');
        //         $.each(data,function(key,value){
        //             $("#web_lead_assign_to_branch").append('<option value="'+key+'">'+value+'</option>');
        //         });
        //         }else{
        //             $("#web_lead_assign_to_branch").empty();
        //         }
        //     }catch(e) {     
        //         alert('Exception while request..');
        //     }   

        //     },
        //     error: function(){                      
        //         alert('Error while request..');
        //     }

        //         });
        //     }
        // });

        $('#web_lead_assign_to_branch').change(function(){
            var branch_id= $('#web_lead_assign_to_branch').val();
            if(branch_id!=''){
            $.ajax({
            type: "get",
            url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+branch_id,
            cache: false,
            success: function(data){                     
            try{  
                if(data){
                    console.log(data);
                $("#web_lead_assign_to").empty();
                    $("#web_lead_assign_to").append('<option>Select Staff</option>');
                $.each(data,function(key,value){
                    $("#web_lead_assign_to").append('<option value="'+key+'">'+value+'</option>');
                });
                }else{
                    $("#web_lead_assign_to").empty();
                }
            }catch(e) {     
                alert('Exception while request..');
            }   

            },
            error: function(){                      
                alert('Error while request..');
            }
            });
            }
        });
    });

    $(window).on('load', function() {
        if($('#web_lead_assign_to_branch').val()!=''){
            var branch_id= $('#web_lead_assign_to_branch').val();
            var cur_staff = "{{$web_lead_assign_to}}";
            $.ajax({
            type: "get",
            url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+branch_id,
            cache: false,
            success: function(data){                     
            try{  
                //$('#web_lead_assign_to_branch').html(data.html);
                if(data){
                $("#web_lead_assign_to").empty();
                $("#web_lead_assign_to").append('<option>Select Staff</option>');
                $.each(data,function(key,value){
                    if(key == cur_staff){
                        var sel = "selected";
                    }else{
                        var sel = "";
                    }
                    $("#web_lead_assign_to").append('<option '+sel+' value="'+key+'">'+value+'</option>');
                });
            }else{
               $("#web_lead_assign_to").empty();
            }
            }catch(e) {     
                alert('Exception while request..');
            }   

            },
            error: function(){                      
                alert('Error while request..');
            }
        });
    }
    });

    // $(window).on('load', function() {
    //     if($('#web_lead_assign_to').val()!=''){
    //         var staff_id= $('#web_lead_assign_to').val();
    //         var cur_branch = "{{$web_lead_assign_to_branch}}";
    //         $.ajax({
    //         type: "get",
    //         url: "{{url('admin/settings/web-to-lead/get-staff-branch')}}/"+staff_id,
    //         cache: false,
    //         success: function(data){                     
    //         try{  
    //             //$('#web_lead_assign_to_branch').html(data.html);
    //             if(data){
    //             $("#web_lead_assign_to_branch").empty();
    //             $("#web_lead_assign_to_branch").append('<option>Select</option>');
    //             $.each(data,function(key,value){
    //                 if(key == cur_branch){
    //                     var sel = "selected";
    //                 }else{
    //                     var sel = "";
    //                 }
    //                 $("#web_lead_assign_to_branch").append('<option '+sel+' value="'+key+'">'+value+'</option>');
    //             });
    //         }else{
    //            $("#web_lead_assign_to_branch").empty();
    //         }
    //         }catch(e) {     
    //             alert('Exception while request..');
    //         }   

    //         },
    //         error: function(){                      
    //             alert('Error while request..');
    //         }
    //     });
    // }
    // });

    function copyToClipboard() {
        containerid = 'web_lead_html_code';
        if (document.selection) {
            var range = document.body.createTextRange();
            range.moveToElementText(document.getElementById(containerid));
            range.select().createTextRange();
            document.execCommand("copy");
        } else if (window.getSelection) {
            var range = document.createRange();
            range.selectNode(document.getElementById(containerid));
            window.getSelection().addRange(range);
            document.execCommand("copy");
            alert("Text has been copied to Clipboard")
        }
    }
</script>
@endpush