@extends('backend.layouts.app')

@section('title', 'Settings')

@section('content')


<div class="row">
    <div class="col-sm-12">

        <div class="card">
            <div class="card-body pt-3">
                <div class="row">
                    <div class="col" style="margin-bottom:10px;">
                        <h4 style="">Settings</h4>
                    </div>
                </div>
                <!-- Bordered Tabs -->

                <div class="row">
                    <div class="col-2">
                        <ul class="nav flex-column nav-tabs nav-tabs-bordered">
                            {!!get_settings_tabs('whatsapp')!!}
                        </ul>
                    </div>

                    <div class="col-10">
                        <div class="tab-content pt-4">

                            <div class="tab-pane fade general show active" id="">
                                <h4>Whatsapp Configuration</h4><br />
                                <div class="row">
                                    <div class="col-sm-12 col-md-6">

                                        <form name='' id="" method="post" action="{{route('admin.settings.whatsapp.save')}}">
                                            @csrf
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="whatsapp_enabled" value='1' name="whatsapp_enabled" @if(get_site_config('whatsapp_enabled')) checked="checked" @endif>
                                                <label class="form-check-label" for="whatsapp_enabled">
                                                    <b>Enable Whatsapp</b>
                                                </label>
                                            </div>
                                            <div class="from-group mt-2">
                                                <label>Provider</label>
                                                <select name="whatsapp_provider" id="whatsapp_provider" class="form-select">
                                                    <option value="">Select</option>
                                                    <option value="whatsapp_cloud_api" @if(get_site_config('whatsapp_provider')=='whatsapp_cloud_api' ) selected @endif>Whatsapp Cloud API</option>
                                                    <option value="wati" @if(get_site_config('whatsapp_provider')=='wati' ) selected @endif>Wati</option>
                                                    <option value="aisensy" @if(get_site_config('whatsapp_provider')=='aisensy' ) selected @endif>Aisensy</option>
                                                </select>
                                            </div>
                                            <div id="wati" class="mt-2" @if(get_site_config('whatsapp_provider')!='wati' ) style="display:none;" @endif>
                                                <label><strong>Wati Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>API Endpoint</label>
                                                    <input type="text" class="form-control" placeholder="API Endpoint" name="wati_api_endpoint" value="{{get_site_config('wati_api_endpoint')}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Token <small>(Without "Bearer")</small></label>
                                                    <input type="text" class="form-control" placeholder="Token (Without Bearer)" name="wati_token" value="{{get_site_config('wati_token')}}">
                                                </div>
                                               
                                            </div>

                                            <div id="aisensy" class="mt-2" @if(get_site_config('whatsapp_provider')!='aisensy' ) style="display:none;" @endif>
                                                <label><strong>Aisensy Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>API Key</label>
                                                    <input type="text" class="form-control" placeholder="API Key" name="aisensy_api_key" value="{{get_site_config('aisensy_api_key')}}">
                                                </div>
                                               
                                            </div>

                                            <div id="whatsapp_cloud_api" class="mt-2" @if(get_site_config('whatsapp_provider')!='whatsapp_cloud_api' ) style="display:none;" @endif>
                                                <label><strong>Whatsapp Cloud API Settings</strong></label><br />
                                                <div class="form-group">
                                                    <label>Phone Number ID</label>
                                                    <input type="text" class="form-control" placeholder="Phone Number ID" name="whatsapp_phone_number_id" value="{{get_site_config('whatsapp_phone_number_id')}}">
                                                </div>
                                                <div class="form-group">
                                                    <label>Access Token</label>
                                                    <input type="text" class="form-control" placeholder="Access Token" name="whatsapp_cloud_access_token" value="{{get_site_config('whatsapp_cloud_access_token')}}">
                                                </div>
                                               
                                            </div>

                                            <div class="text-center mt-3">
                                                <button class="btn btn-primary btn-sm" name="submit" type="submit" id="submit">Save</button>
                                            </div>
                                        </form>
                                    </div>

                                </div>
                            </div><!-- End Bordered Tabs -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        let selectedTab = window.location.hash;
        if (selectedTab) {
            //console.log('show tab:'+selectedTab);
            $('.nav-link[data-bs-target="' + selectedTab + '"]').trigger('click');
        }

        $(document).ready(function() {
            $('#whatsapp_provider').change(function() {
                var provider = $(this).val();
                // Hide all provider settings
                $('#wati, #aisensy, #whatsapp_cloud_api').hide();
                // Show selected provider settings
                if(provider) {
                    $('#' + provider).show();
                }
            });
        });
    });
</script>
@endpush