@extends('backend.layouts.app')
@section('title', "Add New Shipping Config")
@section('content')
<div class="card">
  <div class="card-body">
    <div class="row">
      <div class="col-sm-10 col-10">
        <h4 class="card-title mb-0">
          Add New Shipping Config
        </h4>
      </div>
      <!--col-->
      <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
        <a href="{{ route('admin.shipping-configuration') }}" class="btn btn-sm btn-primary" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </a>
      </div>
    </div>
    <!--row-->

    <div class="row mt-4">
      <div class="col-md-12">
        <form action="{{route('admin.shipping.save-shipping')}}" method="POST" onsubmit="return validateform()">
          @csrf
          <div class="form-group">
            <label for="exampleInputText1"><strong>Config Name</strong> <span style="color: red"> *</span> </label>
            <input type="text" class="form-control form-width" id="exampleInputText1" value="{{old('name')}}" name="name" placeholder="Enter Config Name" required>
          </div>

          <!-- <hr> -->
          <div>
            <div class="form-group">
              <label for="exampleFormControlSelect1">Zone <span style="color: red"> *</span></label>
              <select class="form-control form-select" id="exampleFormControlSelect1" name="zone" style="margin-bottom: 10px;" required>
                <option value="" selected disabled>Select Zone</option>
                <?php if ($zones) {
                  for ($i = 0; $i < count($zones); $i++) { ?>
                    <option value="<?= $zones[$i]; ?>"><?= $zones[$i]; ?></option>
                <?php }
                }
                ?>
              </select>
              <a href="{{route('admin.zones')}}"><u>Manage Zones</u></a>
            </div>

            <div class="form-group mt-2">
              <label><strong>Rate Type</strong> <span style="color: red"> *</span></label>
              <select name="ratetype" id="ratetype" class="form-control form-select" style="margin-bottom: 10px;" required>
                <option value="">Select Rate Type</option>
                <option value="flat">Flat Rate</option>
              </select>

            </div>
            <input type="hidden" name="currency" value="{{config('app.currency_symbol')}}">
            <div class="col-md-12 col-lg-12">
              <div class="form-group row" id="forflatrate">
                {{-- <div class="col-md-4 col-lg-4">
                                            <label for="title" class=" col-form-label"><strong>Currency</strong> <span style="color: red;"> *</span> </label>
                                            <div class="col-sm-10">
                                             <select name="currency" class="form-control">
                                                  <?php
                                                  for ($i = 0; $i < count($currencies); $i++) { ?>
                                                         <option value="{{$currencies[$i]->code}}">{{$currencies[$i]->symbol}} {{$currencies[$i]->code}}</option>
              <?php }
              ?>
              </select>
              </div>
            </div> --}}
            <div class="col-md-6 col-lg-6">
              <label for="title" class="col-sm-2 col-form-label"><strong>Rate</strong> <span style="color: red;"> *</span> </label>
              <div class="col-sm-10">
                <input type="text" class="form-control form-width60" id="flatamount" name="amount" required>
              </div>
            </div>
            {{-- <b id="flatrateerror" style="color:red;">Flat Rate Amount is Required.</b> --}}
          </div>
      </div>
    </div>
    <div class="col-lg-6 col-sm-12 ">
      <button class="btn btn-primary" type="submit">Save </button>
      <a href="{{route('admin.shipping-configuration')}}" class="btn btn-outline-secondary" type="button">Cancel</a>
    </div>
    </form>
  </div>
</div>
<!--col-->
</div>
<!--row-->
</div>
</div>
@endsection

@push ('after-scripts')
<script type="text/javascript">
  $(document).ready(function() {
    var type = $('#type').val();
    if (type == "physical") {
      $('#physical').css('display', 'block');
    } else {
      $('#physical').css('display', 'none');
    }
    $('#type').on('change', function() {
      var type = $('#type').val();
      if (type == "physical") {
        $('#physical').css('display', 'block');
      } else {
        $('#physical').css('display', 'none');
      }
    });
  });
</script>
<script type="text/javascript">
  $(document).ready(function() {
    $('#short_desc_en').keyup(function() {
      var head_text_length = $('#short_desc_en').val().length;
      var text_remaining = 500 - head_text_length;
      // alert(head_text_length);
      $('#brief_desc_count').html(head_text_length + ' / ' + 500);
    });

    $('#short_desc_fr').keyup(function() {
      var head_text_length = $('#short_desc_fr').val().length;
      var text_remaining = 500 - head_text_length;
      // alert(head_text_length);
      $('#brief_desc_count_fr').html(head_text_length + ' / ' + 500);
    });

    $('#short_desc_it').keyup(function() {
      var head_text_length = $('#short_desc_it').val().length;
      var text_remaining = 500 - head_text_length;
      // alert(head_text_length);
      $('#brief_desc_count_it').html(head_text_length + ' / ' + 500);
    });

    $('#short_desc_es').keyup(function() {
      var head_text_length = $('#short_desc_es').val().length;
      var text_remaining = 500 - head_text_length;
      // alert(head_text_length);
      $('#brief_desc_count_es').html(head_text_length + ' / ' + 500);
    });

    $('#short_desc_de').keyup(function() {
      var head_text_length = $('#short_desc_de').val().length;
      var text_remaining = 500 - head_text_length;
      // alert(head_text_length);
      $('#brief_desc_count_de').html(head_text_length + ' / ' + 500);
    });

    $('#short_desc_pt').keyup(function() {
      var head_text_length = $('#short_desc_pt').val().length;
      var text_remaining = 500 - head_text_length;
      // alert(head_text_length);
      $('#brief_desc_count_pt').html(head_text_length + ' / ' + 500);
    });
  });
</script>
@endpush