@extends('backend.layouts.app')
@push('after-styles')
<link rel="stylesheet" href="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.css') }} " />
@endpush
@push('after-scripts')
    <script src="{{ asset('assets/plugins/html5-editor/wysihtml5-0.3.0.js') }}"></script>
    <script src="{{ asset('assets/plugins/html5-editor/bootstrap-wysihtml5.js') }}"></script>
    <script>
    $(document).ready(function() {
        $('.textarea_editor').wysihtml5();
    });
    </script>
@endpush
@section('title', "Edit Shipping")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-8">
                <h4 class="card-title mb-0">
                    Edit Shipping
                </h4>
            </div>
            <!--/.col-->
        </div>
      
        
        <!--/.row-->
            <div class="tab-content" id="myTabContent">
                <form action="{{route('admin.shipping.update-shipping')}}" method="POST"  onsubmit="return validateform()">
                    @csrf
                    <input type="hidden" name="id" value="{{$shippingconfigs->id}}">
                      <div class="form-group">
                        <label for="exampleInputText1"><strong>Config Name</strong> <span style="color: red"> *</span> </label>
                        <input type="text" class="form-control form-width" id="exampleInputText1" value="{{$shippingconfigs->name}}" name="name" placeholder="Enter Config Name"  required>
                      </div>
                       
                      <!-- <hr> -->

                      <div >
                          <div class="form-group">
                            <label for="exampleFormControlSelect1">Zone <span style="color: red"> *</span></label>
                            <select class="form-control form-width" id="exampleFormControlSelect1" name="zone" style="margin-bottom: 10px;" required>
                            <option value="" selected disabled>Select Zone</option>
                             <?php if($zones){
                                    for($i=0;$i<count($zones);$i++){ ?>
                                    <option value="<?=$zones[$i]->zone_name;?>" <?php if($zones[$i]->id == $shippingconfigs->zone_id){ ?> selected <?php } ?> ><?=$zones[$i]->zone_name;?></option>
                                   <?php }
                             }
                             ?>
                            </select>
                            <a href="{{route('admin.zones')}}"><u>Manage Zones</u></a>
                          </div>
                        
                        <div class="form-group">
                          <div class="form-check form-check-inline">
                            <label ><strong>Rate Type</strong> <span style="color: red"> *</span>    </label>
                          </div>

                          <select name="ratetype" id="ratetype" class="form-control form-width" style="margin-bottom: 10px;" required>
                            <option value="">Select Rate Type</option>
                            <option value="flat" <?php if($shippingconfigs->rate_type == "flat_rate"){ ?> selected <?php }?>>Flat Rate</option>
                            {{-- <option value="weight">Weight Based</option> --}}
                          </select>
                          
                        </div>
                        <input type="hidden" name="currency" value="{{config('app.currency_symbol')}}">
                         <div class="col-md-12 col-lg-12">
                            <div class="form-group row" id="forflatrate">
                                {{-- <div class="col-md-4 col-lg-4">
                                    <label for="title" class=" col-form-label"><strong>Currency</strong> <span style="color: red;"> *</span> </label>
                                    <div class="col-sm-10">
                                     <select name="currency" class="form-control">
                                          <?php 
                                              for ($i=0; $i <count($currencies); $i++) { ?>
                                                 <option value="{{$currencies[$i]->code}}" <?php if($shippingconfigs->currency == $currencies[$i]->code){ ?> selected <?php }?> >{{$currencies[$i]->symbol}} {{$currencies[$i]->code}}</option> 
                                              <?php }
                                              ?>
                                     </select>
                                    </div>
                                </div> --}}
                                <div class="col-md-6 col-lg-6">
                                    <label for="title" class="col-sm-2 col-form-label"><strong>Rate</strong> <span style="color: red;"> *</span> </label>
                                    <div class="col-sm-10">
                                      <input type="text" class="form-control form-width60" id="flatamount" name="amount" value="{{$shippingconfigs->flat_rate_value}}" >
                                    </div>
                                </div>
                                 <b id="flatrateerror" style="color:red;">Flat Rate Amount is Required.</b>
                          </div>
                         </div>
                      </div>
                        <div class="col-lg-6 col-sm-12 " >
                          <button class="btn btn-primary" type="submit">save </button>
                          <a href="{{route('admin.shipping-configuration')}}" class="btn btn-primary" type="button">Cancel</a>
                        </div>

                    </form>
              
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-styles')

@endpush

@push ('after-scripts')
<script type="text/javascript">
    $( document ).ready(function() {
      $('#flatrateerror').hide();
      $('#weightrangeerror').hide();
      $('#weightrangeerror').css("color", "red");
      var ratetype = $('#ratetype').val();
      if(ratetype == 'flat'){
          $('#forflatrate').show();
          $('#forweight').hide();
      }else if(ratetype == 'weight'){
          $('#forweight').show();
          $('#forflatrate').hide();
      }
  });
  
  $('#ratetype').on('change', function () {
      //alert($('#ratetype').val());
      var ratetype = $('#ratetype').val();
      if(ratetype == 'flat'){
          $('#forflatrate').show();
          $('#forweight').hide();
      }else if(ratetype == 'weight'){
          $('#forweight').show();
          $('#forflatrate').hide();
      }
  });
  
  function validateform(){
    var ratetype = $('#ratetype').val();
      if(ratetype == 'flat'){
       var rate = $('#flatamount').val();
       if(rate == ''){
        $('#flatrateerror').show();
        return false;
       }
       }
      //else if(ratetype == 'weight'){
      //  var weightcount = $('#weightrangecount').val();
      //  //alert('amount'+weightcount)
      //   for(i=1;i<=weightcount;i++){
      //     var amountid = '#amou'+i;
      //     //alert();
      //     var amount = $(amountid).val();
      //     if(amount == ''){
      //       $('#weightrangeerror').show();
      //       return false;
      //       break;
      //     }
      //   }
      // }
    
  }
  </script>
@endpush
