@extends('backend.layouts.app')
@section('title', "Shipping Configuration List")
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-5">
                <h4 class="card-title mb-0">
                    Shipping Configuration List
                </h4>
            </div><!--col-->
            <div class="col-sm-7 col-7">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="New Course Info Page"  style="margin-top: 20px;float: right;"> 
                    <a href="{{ route('admin.shipping.add-shipping') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="Add New Product"><i class="bi bi-plus-circle"></i> Create</a>
                </div><!--btn-toolbar-->
            </div><!--col-->            
        </div><!--row-->    

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="configs-table">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th class="text-right">Actions</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection      

@push ('after-scripts')
<!-- DataTables Core and Extensions -->
<script type="text/javascript">

    $('#configs-table').DataTable({
        processing: true,
        serverSide: true,
        autoWidth: true,
        responsive: true,
        ajax: '{{ route("admin.shipping.shipping-list") }}',
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'action', name: 'action', orderable: false, searchable: false}
        ],
        columnDefs: [
            {
                "targets": 0, 
                "className": "text-center",
           },{
                "targets": 1,
                "className": "text-center",
           },{
                "targets": 2, 
                "className": "text-center",
           }
         ],
    });


</script>
@endpush
