@extends('backend.layouts.app')

@section('title', 'Create SMS Template')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-sm-5">
                    <h4 class="card-title mb-0">
                        Create SMS Template
                    </h4>
                </div><!--col-->
            </div><!--row-->

            <div class="row mt-4">
                <div class="col-md-8">
                    {{ html()->form('POST', route('admin.smstemplates.store'))->class('form-horizontal')->open() }}
                    <div style="margin-top:10px;">
                        <div class="form-group mb-3">
                            <label class="required-field">Title</label>
                            <input tyle="text" name="hook" class="form-control" maxlength="50"
                                value="{{ old('hook') }}" placeholder="Unique Name for template" required>
                        </div>
                        <div class="form-group mb-3">
                            <label>Template ID</label>
                            <input tyle="text" name="template_id" class="form-control" maxlength="50"
                                value="{{ old('template_id') }}" placeholder="Template ID">
                        </div>
                        <div class=" mb-3" style="width:80vw;">

                        <div class="row">
                            <label>Message</label>
                            <div class="col-8">
                                <input type="hidden" name='template' value="mail">
                                <textarea name='message' id="message" rows="3" class="form-control" required>{{ old('message') }}</textarea>
                            </div>
                            <div class="col-4">
                                <div class="container">
                                    <div class="">
                                        <div class=" text-start ">
                                            <label>Rephrase Message using AI <img class="mb-4 ms-1" src="{{asset('assets/backend/img/creative.png')}}"></label>
                                        </div>
                                        <div class="mt-2">
                                            <!-- Tone selection and rephrase button -->
                                            <div class="form-group  row">
                                                <div class="col-md-8">
                                                    <select name="tone" id="tone" class="form-control form-select">
                                                        <option value="Neutral">Neutral Tone</option>
                                                            <option value="Professional">Professional Tone</option>
                                                        <!-- Additional tone options can go here -->
                                                    </select>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="btn btn-primary btn-block" onclick="getRephrasedMessage()">
                                                        Rephrase</div>

                                                </div>
                                            </div>

                                            <!-- Message area for loading or error messages -->
                                            <div class="form-group">
                                                <small id="buffer" class="form-text text-muted"
                                                    style="display: none;">Please
                                                    wait...</small>
                                                <div class="alert" id="response-alert" style="display: none;"></div>
                                            </div>

                                            <!-- Rephrased message textarea -->
                                            <div class="form-group" id="rephrasedContainer" style="display: none;">
                                                <label class="font-weight-bold">Rephrased Message</label>
                                                <textarea class="form-control" style="background-color: rgb(255, 255, 255)" id="rephrasedMessage" name="rephrasedMessage" rows="10" readonly></textarea>

                                                <!-- Copy button -->
                                                <div class="text-start">
                                                    <div class="btn btn-sm" onclick="copyText()">
                                                        <i class="fas fa-copy"></i> Copy
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                        <div class="form-group" style="text-align: center;margin-top:50px;">
                            {{ form_submit('Create') }}
                            <a href="{{ route('admin.smstemplates') }}"
                                class="btn btn-secondary btn-sm waves-effect waves-light " title="Cancel"> Cancel
                            </a>
                        </div>
                        {{ html()->form()->close() }}
                    </div>

                </div><!--col-->
            </div>
            <div class="row">
                <div class="col-md-12 mt-4">
                    <p><strong>Variables that you can use in message:</strong></p>
                    <p>
                        <?php
                        $variables = '#' . $variables . '#';
                        $variables = str_replace(',', '#<br>#', $variables);
                        echo $variables;
                        ?>
                    </p>
                    <p><strong>Note:</strong> <br> #password# works with LEAD_WELCOME, STUDENT_CREATE_WELCOME templates only
                    </p>
                </div>
            </div>
        </div>
    </div>


@endsection

@push('after-scripts')
    <script>
        const alertDiv = document.getElementById('response-alert');
        const rephraseDiv = document.getElementById('rephrasedContainer');
        const rephraseMessage = document.getElementById('rephrasedMessage');
        const buffer = document.getElementById('buffer');
        const tone = document.getElementById('tone');

        function getRephrasedMessage() {
            buffer.style.display = 'block';
            rephraseDiv.style.display = 'none';
            alertDiv.style.display = 'none';
            $.ajax({
                url: "{{ route('admin.ai_rephrase.openapi.call') }}",
                type: "POST",
                data: {
                    message: document.getElementById('message').value,
                    tone: tone.value,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        buffer.style.display = 'none';
                        rephraseMessage.value = response.rephrased_message;
                        rephraseDiv.style.display = 'block';
                    } else if (response.status === 'failed') {
                        buffer.style.display = 'none';
                        alertDiv.innerHTML = response.message; // Set the message
                        alertDiv.className =
                            'alert alert-danger'; // Add Bootstrap success class
                        alertDiv.style.display = 'block'; // Show the alert

                    } else {
                        alertDiv.innerHTML =
                            "There was an issue saving your data. Please try again."; // Set the message
                        alertDiv.className =
                            'alert alert-warning'; // Add Bootstrap success class
                        alertDiv.style.display = 'block'; // Show the alert

                    }
                },
                error: function(xhr) {
                    if (xhr.status === 422) { // Laravel validation error
                        const errors = xhr.responseJSON.errors;
                        let errorMessage = '\n';
                        for (const field in errors) {
                            errorMessage += `${errors[field][0]}\n`;
                        }
                        alert(errorMessage);
                    } else {
                        alert("An error occurred. Please try again.");
                    }
                }
            });
        }

        function copyText() {
            var textarea = $("#rephrasedMessage")[0];

            // Select the text field
            textarea.select();
            textarea.setSelectionRange(0, 99999); // For mobile devices

            // Copy the text inside the text area
            document.execCommand("copy");

            // Alert or display a success message
            alertDiv.innerHTML = "Message copied to clipboard!"; // Set the message
            alertDiv.className =
                'alert alert-success'; // Add Bootstrap success class
            alertDiv.style.display = 'block'; // Show the alert

        }
        // $("#editor_intro").prop("required", false);
    </script>
@endpush
