
@extends('backend.layouts.app')
@section('title', app_name() . ' | Profile Management' )

@section('content')


@if($logged_in_user->user_unlock)
<div style="display: flex
;
    justify-content: end;
    margin-right: 30px;">
<a href="{{ route('admin.auth.abasic.info.edit') }}" class="btn btn-primary btn-sm" style="margin-bottom:0px !important ; padding:5px;">
<i class="fas fa-edit text-sub " style="color:white !important;"></i>   Edit Profile
</a>
</div>
@endif

<div class="row page-titles">
    <!-- <div class="col-md-5 align-self-center">
       
    </div> -->
   
</div>

<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">

    <!-- ============================================================== -->
    <!-- Start Page Content -->
    <!-- ============================================================== -->
    <div class="row">
        <div class="col-12">
                <div class="card-body">                


                        <div class="row mt-4 mb-4 row-resp" style=" justify-content: space-between;    box-shadow: 0px 2px 20px rgba(1, 41, 112, 0.1); background: white; padding: 20px 10px;border-radius: 20px">
                            <div class="col-2 col-2-resp" style="margin: auto;
                                    justify-content: center;
                                    align-items: center;
                                    display: flex
                                ;
                                    flex-direction: column;">
                                    <div class="mx-auto text-center">
                                            @if( $staff_details->photo != '')
                                            <img width="100px" height="100px" src="{{ asset('storage/staff_doc/thumb/' . basename($staff_details->photo)) }}" alt="user not found" style="border-radius: 50%" />
                                            @else
                                                @if( $logged_in_user->gender == "female")
                                                    <img src="{{asset('assets/images/users/girl.png')}}" width="60px" height="60px" style="border-radius: 50%" class="border" alt="">
                                                @else
                                                    <img src="{{asset('assets/images/users/boy.png')}}" width="60px" height="60px" style="border-radius: 50%" class="border" alt="">
                                                @endif
                                            {{-- <img width="60px" height="60px" src="{{ asset('assets/images/users/user.jpg') }}" alt="user" style="border-radius: 50%" /> --}}
                                            @endif

                                    </div>

                                    <h4 class="card-title mb-0" style="text-align:center">
                                        {{ $logged_in_user->first_name }}    {{$logged_in_user->last_name}}
                                    </h4>
                                     

                            </div>
                            
                            <div class="seperate-div"></div>
                            <div class="col-9 col-2-resp" style="display: flex;flex-wrap: wrap;">
                            <h3 class="text-start mt-4" style="width:100%;padding:10px 0px;font-size:25px !important">Basic Information</h3>
                                <div class="col-sm-12 col-md-4">
                                    <label>Emp ID</label>
                                 
                                   
                                                                        
                                        @if($staff_details->emp_id== NULL)
                                        <br>
                                                <p>- -</p>
                                        <br>
                                        @else
                                        <br>
                                        <p>{{$staff_details->emp_id }}</p>
                                        <br> 
                                        @endif 
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <label>   {{__('validation.attributes.frontend.email') }}</label>
                                 
                                     
                                        <br>
                                        <p style="text-transform: none;">{{$logged_in_user->email}}</p>
                                        <br>
                                        <!-- mobile fetching -->
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <label>  {{ __('validation.attributes.frontend.mobile') }}</label>

                                            @if($logged_in_user->mobile == NULL)
                                            <br>
                                                <p>---</p>
                                            <br>
                                            @else
                                            
                                            <p>{{$logged_in_user->dialcode ? '+' . $logged_in_user->dialcode : ''}} {{$logged_in_user->mobile}}</p>
                                            <br>
                                            @endif
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <label> Whatsapp</label>

                                            <!-- whatsapp number fetching -->
                                           
                                            @if($logged_in_user->whatsapp == NULL)
                                            <br>
                                                <p>---</p>
                                            <br>
                                            @else
                                            <p>{{$logged_in_user->whatsapp_dialcode ? '+' . $logged_in_user->whatsapp_dialcode : ''}} {{$logged_in_user->whatsapp}}</p>
                                            <br>
                                            @endif
                                            
                                                            

                            </div>
                        </div>

                        </div>    <!-- row end -->
                    
                        <div class="row mt-4 mb-4" style=" margin:20px auto ;    padding: 20px; box-shadow: 0px 2px 20px rgba(1, 41, 112, 0.1); background: white;border-radius: 20px"">
                            <div class="row">
                            <div class="col-12 d-flex d-flex-1 justify-content-between">
                           
                                        <h3 class="text-start  mt-4">
                                            Personal Details 
            
                                        </h3>
                                        
                                       

                                    
                            </div>
                        </div>
                        <div class="row row-cols-4">
                            <div class="col-md-4">
                                    <br>
                                    {{ __('labels.frontend.user.profile.gender') }}
                                    <br>
                                    @if($logged_in_user->gender == NULL)
                                            <strong>- -</strong>
                                    @else
                                    <strong>{{$logged_in_user->gender}}</strong>
                                    @endif  
                                
                                   
                                </div><!--col-->
                                <div class="col-md-4">
                                            <br>
                                            DOB
                                            <br>
                                            @if($staff_details->dob == NULL)
                                                    <strong>- -</strong>
                                            @else
                                                <strong>{{ $staff_details->dob ? date('d-m-Y', strtotime($staff_details->dob)) : '-' }}</strong>
                                            @endif  
                                        </div><!--col-->
                                <div class="col-md-4">
                        @php
                            $years = $months = null;

                            if (!empty($staff_details->dob)) {
                                try {
                                    $dob = \Carbon\Carbon::parse($staff_details->dob);
                                    $now = \Carbon\Carbon::now();
                                    $diff = $dob->diff($now);
                                    $years = $diff->y;
                                    $months = $diff->m;
                                } catch (\Exception $e) {
                                    $years = $months = null; // invalid date fallback
                                }
                            }
                        @endphp

                        <br> Age
                        <br>
                        <strong>
                            @if(!is_null($years) && !is_null($months) && !($years == 0 && $months == 0))
                                {{ $years }} years and {{ $months }} months
                            @else
                                --
                            @endif
                        </strong>

                        </div>
                                <div class="col-md-4">
                                        <br> Blood group
                                        
                                        <br /><strong>{{ ($staff_details && $staff_details->blood_group) ? $staff_details->blood_group : '--' }}</strong>
                                </div>
                                                            
                              
                        
                                   

                                    <div class="col-md-4">
                                    <br>
                                        {{ __('labels.frontend.user.profile.marital_status') }}:
                                    <br>
                                        @if($staff_details->marital_status == NULL)
                                                <strong>- -</strong>
                                        @else
                                        <strong>{{$staff_details->marital_status}}</strong>
                                        @endif  
                                        
                                    </div><!--col-->
                                    <div class="col-md-4">
                                        <br> Father/Spouse Name
                                        <br /><strong>{{ ($staff_details->father_name) ? $staff_details->father_name : '--' }}</strong>
                                    </div>
                                    <div class="col-md-4">
                                        <br> Mother Name
                                        <br /><strong>{{ ($staff_details->mother_name) ? $staff_details->mother_name : '--' }}</strong>
                                    </div>
                                    <div class="col-md-4">
                                        <br>
                                        {{_label('aadhar_number')}}
                                        <br>
                                            @if($staff_details->aadhar_no == NULL)
                                                    <strong>- -</strong>
                                            @else
                                            <strong>{{$staff_details->aadhar_no}}</strong> 
                                            @endif  
                                        
                                        </div><!--col-->
                                
                                        <div class="col-md-4">
                                        <br>
                                            Citizenship
                                            <br>
                                            @if($logged_in_user->country == NULL)
                                                    <strong>- -</strong>
                                            @else
                                            <strong>{{get_country_name($logged_in_user->country)}}</strong> 
                                            @endif  
                                        
                                    </div><!--col-->
                                    <br>
                                    <div class="col-md-6">
                                        <br>
                    
                                        About/Expertise
                                        <br>
                                        @if($staff_details->about == NULL)
                                                <strong>- -</strong>
                                        @else
                                        <strong>{{$staff_details->about}}</strong>
                                        @endif  
                                    
                                    </div><!--col-->
                                    </div>
                                    <br>
                                    <hr style="margin-top:20px;">

                                       <!-- seperation details starts -->
                                       {{--     <h3 class="text-start mt-4">
                                           Seperation Information </h3>
                                            <div class="row">
                                                <div class="col-8 col-sm-6 resp">
                                                    <br>
                                                    Date Of Exit


                                                </div> <!--col-->
                                                
                                            </div> <!--row-->
                                               <!-- seperation details ends -->

                                            --}} 
                                            
                                    <div class="row">
                                    <h3 class="text-start  mt-4">
                                    Hierarchy Information 
            
                                        </h3>
                                        <div class="col-8 col-sm-6">
                                                    <br>
                                                    Reporting Manager
                                                    @if($staff_details->reporting_to == NULL)
                                                        <strong>- -</strong>
                                                    @else
                                                    <strong>{{get_user_full_name_by_id($staff_details->reporting_to) }}</strong> 
                                                    @endif  
                                                


                                        </div>
                                    </div><!-- row end -->
                                    <hr>
                                  
                                    <h3 class="text-start mt-4">
                                    Employment Details
    
                                                </h3>
                                                <div class="row">
                                                       
                                                
                                                        <div class="col-8 col-sm-4">
                                                            <br>
                                                        
                                                            Designation
                                                            <br>
                                                            @if($staff_details->designation == NULL)
                                                                 <strong>- -</strong>
                                                            @else
                                                            <strong>{{$staff_details->designation }}</strong> 
                                                            @endif  
                                                        </div><!--col-->
    
                                                        <div class="col-8 col-sm-4">
                                                        <br>
                                                            Department
                                                        <br>   
                                                            @if($staff_details->department == NULL)
                                                                 <strong>- -</strong>
                                                            @else
                                                            <strong>{{$staff_details->department }}</strong> 
                                                            @endif  
                                                        </div><!--col-->
                                                        <div class="col-8 col-sm-4">
                                                    <br>
                                                    Reporting Manager <br>
                                                    @if($staff_details->reporting_to == NULL)
                                                        <strong>- -</strong>
                                                    @else
                                                    <strong>{{get_user_full_name_by_id($staff_details->reporting_to) }}</strong> 
                                                    @endif  
                                                


                                        </div>
                                                        
                                                        <div class="col-8 col-sm-4 ">
                                                        <br>
                                                            Employment Type
                                                            <br>
                                                          <strong>{{$staff_details->emp_type ? $staff_details->emp_type : '--'}}</strong>
    
                                                        </div> <!--col-->
                                                        <div class="col-8 col-sm-4 ">
                                                        <br>
                                                            Employee Status
                                                            <br>
                                                            @if($staff_details->emp_status == NULL)
                                                                 <strong>- -</strong>
                                                            @else
                                                            <strong>{{$staff_details->emp_status }}</strong>
                                                            @endif
                                                    
                                                         
    
                                                        </div> <!--col-->
                                                        <div class="col-8 col-sm-4 ">
                                                        <br>
                                                           Source Of Hire
                                                           <br>
                                                           @if($staff_details->hiring_source == NULL)
                                                                 <strong>- -</strong>
                                                            @else
                                                            <strong>{{$staff_details->hiring_source }}</strong> 
                                                            @endif
                                                    
                                                        
    
                                                        </div> <!--col-->
                                                    
                                                        <div class="col-8 col-sm-4">
                                                        <br>
                                                            Date Of Joining
                                                    
                                                            <br>
                                                        @if($staff_details->emp_start_date == NULL)
                                                             <strong>--</strong>
                                                        @else
                                                        <strong>{{get_date_formated($staff_details->emp_start_date) }}</strong> 
                                                        @endif
    
                                                        </div> <!--col-->
    
                                                        
                                                        <div class="col-8 col-sm-4">
                                                            <br /> Past Experience
                                                            <br /><strong>{{$staff_details->past_experience_year ? $staff_details->past_experience_year .' '. 'year' : ''}} {{$staff_details->past_experience_month ? $staff_details->past_experience_month  .' '. 'month' : '--'}}</strong>
                                            
                                                        </div>
                                                        <div class="col-8 col-sm-4 ">
                                                        <br>
                                                            Current Experience
                                                            <br>
                                                            @php
                                                            use Carbon\Carbon;

                                                            if (!empty($staff_details) && !empty($staff_details->emp_start_date)) {
                                                                $emp_start_date = Carbon::parse($staff_details->emp_start_date);
                                                                $today_date = Carbon::now();

                                                                $years = $emp_start_date->diff($today_date)->y;
                                                                $months = $emp_start_date->diff($today_date)->m;
                                                            } else {
                                                                $years = 0;
                                                                $months = 0;
                                                            }
                                                        @endphp
                                                        @if($years == 0 && $months == 0)
                                                            <strong style="text-transform:none">Less than a month</strong>
                                                        @elseif($years == 0)
                                                            <strong>{{ $months }} months</strong>
                                                        @else
                                                            <strong>{{ $years }} years and {{ $months }} months</strong>
                                                        @endif


    
                                                        </div> <!--col-->
                                                
                                                        <div class="col-8 col-sm-4">
                                                        <br>
                                                                Current CTC 
                                                                <br>
                                                            
                                                            @if($staff_details->ctc == NULL)
                                                                 <strong>- -</strong>
                                                            @else
                                                            <strong>{{$staff_details->ctc }}</strong> 
                                                            @endif  
                                                        
                                                        </div><!--col-->
                                                        <div class="col-8 col-sm-4">
                            <br> {{_label('aadhar_number')}}
                            <br /><strong>{{ ($staff_details && $staff_details->aadhar_no) ? $staff_details->aadhar_no : '--' }}</strong>
                        </div>
                        <div class="col-8  col-md-4">
                            <br />{{_label('pan_card_number')}}
                            <br /><strong>{{ ($staff_details && $staff_details->pan_no) ? $staff_details->pan_no: '--' }}</strong>
                        </div>
                        <div class=" col-8 col-md-4">
                                                <br /> Onboarding Status:
                                                <br>
                                              
                                                @if($staff_details->onboarding_status)  
                                                        <strong>{{ $staff_details->onboarding_status}}</strong>
                                                @else
                                                        <strong>--</strong>
                                                @endif
                                                </div><!--col-->

                              
    
                                            
                                                 </div><!--row-->
                                                 <hr style="margin-top:20px;">
                                                 <h3 class="text-start mt-4">Identity Information</h3>
                                                 <br>

                                                    <div class="row">
                                                    <div class="col-8 col-sm-6">
                                                    <br>
                                                    Passport Number
                                                        <br>
                                                        @if($staff_details->passport_no == NULL)
                                                                <strong>- -</strong>
                                                        @else
                                                        <strong>{{$staff_details->passport_no }}</strong> 
                                                        @endif  
                                                    
                                                    </div><!--col-->
    
                                                    <div class="col-8 col-sm-6">
                                                    <br>
                                                    Date Of Issue
                                                    <br>
                                                        @if($staff_details->passport_issue_date == NULL )
                                                                <strong>- -</strong>
                                                        @else
                                                        <strong>{{get_date_formated($staff_details->passport_issue_date)}} </strong>
                                                        @endif  
    
                                                    </div><!--col-->
    
                                                    <div class="col-8 col-sm-6">
                                                    <br>
                                                        Date Of Expiry
                                                        <br>
                                                        @if($staff_details->passport_expiry_date == NULL)
                                                                <strong>- -</strong>
                                                        @else
                                                        <strong>{{get_date_formated($staff_details->passport_expiry_date)}}</strong> 
                                                        @endif  
    
                                                    </div><!--col-->
    
                                                    <div class="col-8 col-sm-6">
                                                    
                                                    Issuing Country
                                                
                                                      @php
                                                            $countryName = null;
                                                            if (!empty($staff_details->passport_issue_country)) {
                                                                $countryName = get_country_name($staff_details->passport_issue_country);
                                                            }
                                                        @endphp

                                                        @if($countryName)
                                                            <strong>{{ $countryName }}</strong>
                                                        @else
                                                            <strong>{{ $staff_details->passport_issue_country }}</strong>
                                                        @endif

 
    
                                                    </div><!--col-->
    
                                                    
                                                    </div><!--row-->
    
                                                        <hr>
                                                         <!-- Work Information ends-->
    
    
    
                                <!-- Contact Details starts -->
    
                                 <div class="row">
    <div class="col-12">
        <h3 class="text-start mt-3">Contact Details</h3>
    </div>

    <div class="col-sm-6 mb-2">
        Work Phone Number: 
        <strong>
            {{ $staff_details->work_phone_dialcode ?? '' }}
            {{ $staff_details->work_phone_no ?: '--' }}
        </strong>
    </div>

    <div class="col-sm-6 mb-2">
        Extension: 
        <strong>{{ $staff_details->extension ?: '--' }}</strong>
    </div>

    <div class="col-sm-6 mb-2">
        Seating Location: 
        <strong>{{ $staff_details->seating_location ?: '--' }}</strong>
    </div>

    <div class="col-sm-6 mb-2">
        Personal Mobile Number: 
        <strong>{{ $staff_details->personal_phone ?: '--' }}</strong>
    </div>

    <div class="col-sm-6 mb-2">
        Personal Email Address: 
        <strong class="email">{{ $staff_details->personal_email ?: '--' }}</strong>
    </div>
</div>

<hr>

<div class="row">
    <div class="col-12 col-sm-6 mb-3">
        <h3 class="text-start mt-3">Current Address</h3>
        @if($staff_details->country || $staff_details->state || $staff_details->city || $staff_details->postal_code)
            <div>{{ $logged_in_user->address_2 }}</div>
            <div>{{ $staff_details->city }}</div>
            <div>{{ get_state_name($staff_details->state) }}</div>
            <div>
                {{ get_country_name($staff_details->country) }}
                @if($staff_details->postal_code) - {{ $staff_details->postal_code }} @endif
            </div>
        @else
            <strong>--</strong>
        @endif
    </div>

    <div class="col-12 col-sm-6 mb-3">
        <h3 class="text-start mt-3">Permanent Address</h3>
        @if($staff_details->permanent_country || $staff_details->permanent_state || $staff_details->permanent_city || $staff_details->permanent_postal_code)
            <div>{{ $logged_in_user->address_1 }}</div>
            <div>{{ $staff_details->permanent_city }}</div>
            <div>{{ get_state_name($staff_details->permanent_state) }}</div>
            <div>
                {{ get_country_name($staff_details->permanent_country) }}
                @if($staff_details->permanent_postal_code) - {{ $staff_details->permanent_postal_code }} @endif
            </div>
        @else
            <strong>--</strong>
        @endif
    </div>
</div>

                                   
    
                                <hr >
    
    
                                <!-- contact details ends -->
    
    
    
                               

                        


                        <!-- Emergency Contact information starts -->
                        <h3 class="text-start mt-4"> Emergency Contact Information </h3>
                        <br>
                                <div class="row row-cols-4">
                                        <div class="col-md-4">
                                            Name
                                            <br>
                                       
                                        @if($staff_details->emergency_contact_name == NULL)
                                            <strong>--</strong>
                                        @else
                                        <strong>{{$staff_details->emergency_contact_name}}</strong>
                                        @endif

                                        </div><!--col-->
                                        <div class="col-md-4">
                                             email Address

                                        <br>
                                        @if($staff_details->emergency_contact_email ==NULL)
                                            <strong>--</strong>
                                        @else
                                        <strong class="email">{{$staff_details->emergency_contact_email}}</strong>
                                        @endif
                                                                    

                                        </div><!--col-->

                                        <div class="col-md-4">
                                        Phone Number
                                        <br>
                                        @if($staff_details->emergency_contact_ph_no ==NULL)
                                        <strong>--</strong>
                                        @else
                                        <strong>{{$staff_details->emergency_contact_ph_no}}</strong>
                                        @endif

                                        </div><!--col-->
                                        <div class="col-md-4">
                                        Address
                                        <br>
                                        @if($staff_details->emergency_contact_address == NULL)
                                        <strong>--</strong>
                                        @else
                                        <strong>{{$staff_details->emergency_contact_address}}</strong>
                                        @endif

                                        </div><!--col-->
                                        <br>

                                    </div>
                                    <hr style="margin-top:20px;">




                        <!-- Emergency Contact information ends -->
<!-- visa information starts -->

<h3 class="text-start mt-4"> VISA Information </h3>
                                <div class="row">
                                        <div class="col-8 col-sm-6">
                                        VISA Number
                                        @if($staff_details->visa_no == NULL)
                                            <strong>--</strong>
                                        @else
                                        <strong>{{$staff_details->visa_no}}</strong>
                                        @endif

                                        </div><!--col-->
                                        <div class="col-8 col-sm-6">

                                        VISA Expiry Date
                                        @if($staff_details->visa_expiry_date == NULL)
                                            <strong>--</strong>
                                        @else
                                        <strong>{{get_date_formated($staff_details->visa_expiry_date)}}</strong>
                                        @endif
                                        </div><!--col-->

                                        <div class="col-8 col-sm-6">
                                        Entry Clearance
                                        @if($staff_details->entry_clearance == NULL)
                                            <strong>--</strong>
                                        @else
                                        <strong>{{$staff_details->entry_clearance}}</strong>
                                        @endif
                                        

                                        </div><!--col-->
                                        <div class="col-8 col-sm-6">
                                        BRP
                                        @if($staff_details->brp == NULL)
                                            <strong>--</strong>
                                        @else
                                        <strong>{{$staff_details->brp}}</strong>
                                        @endif
                                        

                                        </div><!--col-->

                                    </div>
                                    <hr>



                        <!-- visa information ends -->
                 

                 <!-- CoS Information starts --> 
                             
                         {{--   <h3 class="text-start mt-4"> CoS Information </h3> 
                           <div class="row"> 
                            <div class="col-8 col-sm-6">
                                CoS Number
                                @if($staff_details->cos_no == NULL)
                                    <strong>--</strong>
                                @else
                                    <strong>{{$staff_details->cos_no}}</strong>
                                @endif

                            </div>
                            <div class="col-8 col-sm-6">
                                Cos Status
                                @if($staff_details->cos_status == NULL)                               
                                <strong>--</strong>
                                @else
                                <strong>{{$staff_details->cos_status}}</strong>
                                @endif

                            </div>
                            <div class="col-8 col-sm-6">
                                CoS Issue Date
                                @if($staff_details->cos_issue_date == NULL)
                                <strong>--</strong>
                                @else
                                <strong>{{get_date_formated($staff_details->cos_issue_date)}}</strong>
                                @endif

                            </div>
                            <div class="col-8 col-sm-6">
                                CoS Expiry Date
                                @if($staff_details->cos_expiry_date)
                                <strong>{{get_date_formated($staff_details->cos_expiry_date)}}</strong>
                                
                                @else
                                <strong>--</strong>
                                @endif

                            </div>
                            <div class="col-8 col-sm-6">
                                Employment Start Date
                                @if($staff_details->emp_start_date)
                                <strong>{{get_date_formated($staff_details->emp_start_date)}}</strong>
                                @else
                                <strong>--</strong>
                                @endif

                            </div>
                            <div class="col-8 col-sm-6">
                                Employment End Date
                                <strong>{{$staff_details->emp_end_date ? get_date_formated($staff_details->emp_end_date): '--'}}</strong>

                            </div>
                         </div>  --}}
                         
                         <hr style="margin-top:20px;">
                                                <h3 class="text-start mt-4">Bank Details </h3>
                    <div class="row">
                        <div class="col-8 col-md-4">
                            <br />Account Number
                            <br /><strong>{{ ($staff_details && $staff_details->bank_account_no) ? $staff_details->bank_account_no: '--'}}</strong>
                        </div>
                        <div class=" col-8 col-md-4">
                            <br />Account Holder Name
                            <br /><strong>{{ ($staff_details && $staff_details->bank_payee) ? $staff_details->bank_payee: '--'}}</strong>
                        </div>
                        <div class="col-8 col-md-4">
                            <br />Bank Name
                            <br /><strong>{{ ($staff_details && $staff_details->bank_bank_name) ? $staff_details->bank_bank_name: '--'}}</strong>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-8 col-md-4">
                            <br />Branch Name
                            <br /><strong>{{ ($staff_details && $staff_details->bank_branch) ? $staff_details->bank_branch: '--'}}</strong>
                        </div>
                        <div class="col-8 col-md-4">
                            <br />{{_label('ifsc_code')}}
                            <br /><strong>{{ ($staff_details && $staff_details->bank_ifsc) ? $staff_details->bank_ifsc: '--'}}</strong>
                        </div>
                    </div>
                    <hr style="margin-top:20px;">


                    <h3 class="text-start mt-4"> Documents </h3>
                                 <div class="row">
                                    
                                    <div class="col-8 col-sm-6">
                                               
                                        Passport
                                        @if(!empty($staff_details->passport_doc))
                                            <div class="file-box">
                                               
                                                <a href="{{ route('admin.auth.file.download', basename($staff_details->passport_doc)) }}" style="margin-left: 10px;"  >
                                                                                                    <i class="fa fa-download"></i>
                                                </a>
                                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'passport_doc']) }}" method="POST" class="d-inline">
                                                                                @csrf
                                                                                @method('DELETE')
                                                                                <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                    <i class="fas fa-trash"></i> 
                                                                                </button>
                                                                            
                                                                            </form>
                                            </div>
                                        @else
                                            <p>--</p>
                                        @endif


                                                    
                                    </div>

                                    <div class="col-8 col-sm-6">

                                        Contract Document
                                        
                                        @if(!empty($staff_details->doc_contract_agreement))
                                        <div class="file-box">
                                           
                                            <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_contract_agreement)) }}" >
                                                        <i class="fa fa-download"></i>
                                                    </a>
                                                    
                                                    <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_contract_agreement']) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                        <i class="fas fa-trash"></i> 
                                                                                    </button>
                                      
                                                    </form>
                                        </div>
                                        @else
                                            <p>--</p>
                                        @endif

                                                    
                                    </div>
                                   {{-- <div class="col-8 col-sm-6">
                                       HMRC Document
                                       @if(!empty($staff_details->hmrc_document_doc))
                                            <div class="file-box">
                                            
                                                <a href="{{ route('admin.auth.file.download', basename($staff_details->hmrc_document_doc)) }}" style="margin-left: 10px;"  >
                                                                                                    <i class="fa fa-download"></i>
                                                </a>
                                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'hmrc_document_doc']) }}" method="POST" class="d-inline">
                                                                        @csrf
                                                                                @method('DELETE')
                                                                                <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');"class="doc-delete-btn">
                                                                                                                    <i class="fas fa-trash"></i> 
                                                                                                                </button>
                                                                            
                                                                            </form>
                                            </div>
                                        @else
                                            <p>--</p>
                                        @endif
                                                    
                                    </div> 
                                    <div class="col-8 col-sm-6">
                                       National Insurance 
                                       @if(!empty($staff_details->national_insurance_doc))
                                                <div class="file-box">
                                                    
                                                    <a href="{{ route('admin.auth.file.download', basename($staff_details->national_insurance_doc)) }}" style="margin-left: 10px;" >
                                                                                                        <i class="fa fa-download"></i>
                                                    </a>
                                                    <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'national_insurance_doc']) }}" method="POST" class="d-inline">
                                                                            @csrf
                                                                                    @method('DELETE')
                                                                                    <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                                                        <i class="fas fa-trash"></i> 
                                                                                                                    </button>
                                                                                
                                                                                </form>
                                                </div>
                                            @else
                                                <p>--</p>
                                            @endif
                                                         
                                    </div> --}}
                                    <div class="col-8 col-sm-6">
                                      Offer Letter:
                                      <br>
                                        
                                        @if($staff_details->doc_offer_letter)
                                        <div class="file-box">
                                       
                                            <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_offer_letter)) }}" style="margin-left: 10px;"  >
                                                <i class="fa fa-download"></i>
                                            </a>
                                            <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_offer_letter']) }}" method="POST" class="d-inline">

                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');"class="doc-delete-btn">
                                                    <i class="fas fa-trash"></i> 
                                                    </button>
                                                
                                            </form>
                                     </div>
                                            @else
                                               <p>--</p>
                                            @endif
                                      
                                    </div>
                                    <div class="col-8 col-sm-6">
                                       Resume:
                                       <br>
                                       
                                        @if($staff_details->doc_resume)
                                        <div class="file_box">
                    
                                            <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_resume)) }}" style="margin-left: 10px;"  >
                                                <i class="fa fa-download"></i>
                                            </a>
                                            <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_resume']) }}" method="POST" class="d-inline">

                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');"class="doc-delete-btn">
                                                    <i class="fas fa-trash"></i> 
                                                    </button>
                                                
                                            </form>
                                            </div>
                                            @else
                                              <p>--</p> 
                                            @endif
                                        </strong>
                                    </div>
                        
                        <div class="col-8 col-sm-6">
                            <br />{{_label('pancard_document')}}
                            @if($staff_details->doc_pan_card)
                                    
                                    <div class="file-box">
                                       
                                        <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_pan_card)) }}" >
                                                                <i class="fa fa-download"></i>
                                        </a>
                                                            
                                        <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_pan_card']) }}" method="POST" class="d-inline">

                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                    <i class="fas fa-trash"></i> 
                                                                                </button>
                                              
                                        </form>
                                    </div>
                                @else
                                    <p>--</p>
                                @endif
                           
                        </div>
                       
                        <div class="col-8 col-sm-6">
                            <br />{{_label('aadhar_document')}}
                          <br>
                            <strong>
                            
                                @if($staff_details->doc_aadhar_card)
                                <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_aadhar_card)) }}" style="margin-left: 10px;"  >
                                    <i class="fa fa-download"></i>
                                </a>
                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_aadhar_card']) }}" method="POST" class="d-inline">

                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');"class="doc-delete-btn">
                                           <i class="fas fa-trash"></i> 
                                        </button>
                                      
                                </form>
                              
                                @endif
                            </strong>
                                     </div>
                                    <hr>
                                    <div class="row">
                           
                                
                           <!-- Display Uploaded Documents -->
                           <h3 class="text-start mt-4">Additional Documents</h3>
                           @if($aditional_documents_details->count())
                             
                                    @foreach($aditional_documents_details as $document)
                                <div class="col-sm-12 col-md-4" style="display:flex;gap: 10px;">
                                    <p>{{ get_filename_formated($document->document_title) }}  </p>
                                    <a href="{{ route('admin.auth.download.additional.document', $document->id) }}">
                                        <i class="fa fa-download"></i>
                                    </a>
                                     <form action="{{ route('admin.auth.delete-staff-additional-doc', ['document_id' => $document->id, 'staff_id' => $staff_details->staff_id]) }}" method="POST" class="d-inline">
                                    @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                            <i class="fas fa-trash"></i> 
                                        </button>
                                    </form>
                                </div>

                                  
                                @endforeach

                                    @else
                                    <p>--</p>
                                @endif

                              
                                               
                            </div><!--row-->
                                     </div>


                            <!-- documents ends -->
                             <hr style="margin-top:20px;">
                    <!-- work experience started -->

                                              
                                        <div class="row">
                                                       

                                             <h3 class="text-start mt-4"> Work Experience </h3>
                                             <div class="mt-4 table-responsive">                 
                                                <table class="table dataTable no-footer" style="border:0px;">
                                                    <thead>
                                                        <tr>
                                                        <th scope="col">Company Name</th>
                                                        <th scope="col">Job Title</th>
                                                        <th scope="col">From date</th>
                                                        <th scope="col">To Date</th>
                                                       
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($staff_workexperience_details->isEmpty())
                                                        <tr>
                                                            <td colspan="5" class="text-center">No Work Experience Found</td>
                                                        </tr>
                                                        @else
                                                            @foreach ($staff_workexperience_details as $exp)
                                                                <tr>
                                                                
                                                                        <td>{{ $exp->company_name }}</td>
                                                                        <td>{{ $exp->job_title }}</td>
                                                                        @if($exp->from_date == NULL)
                                                                        <td>--</td>
                                                                        @else
                                                                        <td>{{get_date_formated($exp->from_date) }}</td>
                                                                        @endif
                                                                        @if($exp->to_date != NULL)
                                                                        <td>{{ get_date_formated($exp->to_date) ?? 'Present' }}</td>
                                                                        @else
                                                                        <td>--</td>
                                                                        @endif
                                                                     
                                                                        
                                                                </tr>
                                                            @endforeach
                                                        @endif
                                                    
                                                    </tbody>
                                                </table>
                                     </div>
                                      </div>
                                             

                            <!-- educational details starts -->

                                        <h3 class="text-start mt-4">Educational Details</h3>
                                        <div class="row">
                                        <div class="mt-4 table-responsive">
                                                <table class="table dataTable no-footer" style="border:0px;">
                                                    <thead>
                                                        <tr>
                                                        <th scope="col">Institute Name</th>
                                                        <th scope="col">Degree/Diploma</th>
                                                        <th scope="col">Specification</th>
                                                        <th scope="col">Year Of Completion</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($staff_education_details->isEmpty())
                                                        <tr>
                                                            <td colspan="4" class="text-center">No Education Found</td>
                                                        </tr>
                                                        @else

                                                                @foreach($staff_education_details as $edu)
                                                                <tr>
                                                                
                                                                <td>{{$edu->institute_name}}</td>
                                                                <td>{{$edu->degree}}</td>
                                                                <td>{{$edu->course_specialization}}</td>
                                                                @if($edu->completion_date == NULL)
                                                                <td>--</td>
                                                                @else
                                                                <td>{{get_date_formated($edu->completion_date)}}</td>
                                                                @endif
                                                                </tr>
                                                                @endforeach
                                                        @endif
                                                    </tbody>
                                                    </table>
                                             
                                     </div>
                                            </div>
                                       
                                       


                                <!-- educational details ends -->


                                <!-- dependent details starts -->

                                <h3 class="text-start mt-4"> Dependent details</h3>
                                        <div class="row">
                                        <div class="mt-4 table-responsive">
                                                <table class="table dataTable no-footer" style="border:0px;">
                                                    <thead>
                                                        <tr>
                                                        <th scope="col">Name</th>
                                                        <th scope="col">Relationship</th>
                                                        <th scope="col">Date Of Birth</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($staff_dependent_details->isEmpty())
                                                        <tr>
                                                            <td colspan="3" class="text-center">No Dependent Found</td>
                                                        <tr>
                                                        @else
                                                            @foreach($staff_dependent_details as $dep)
                                                            <tr>
                                                            
                                                            <td>{{$dep->dep_name}}</td>
                                                            <td>{{$dep->relationship}}</td>
                                                            @if($dep->date_of_birth == NULL)
                                                            <td>--</td>
                                                            @else
                                                            <td>{{get_date_formated($dep->date_of_birth)}}</td>
                                                            @endif
                                                            </tr>
                                                            @endforeach
                                                        
                                                        @endif
                                                        
                                                        </tr>
                                                    
                                                    </tbody>
                                                    </table>
                                             
                                     </div>
                                            </div>
                                       
                                     

                        <!-- dependent details ends -->
                                  
                       
                         
                           
                        

                          <!-- System fields starts -->
                       {{--    @if($logged_in_user->isAdmin())
                                    @include('backend.staff.staff_see_other_profile')
                                    @endif
                       <h3 class="text-start mt-4">
                                           System Fields </h3>
                                            <div class="row">
                                                <div class="col-8 col-sm-6">
                                                    Added By <br>
                                                   <strong>{{get_user_full_name_by_id($logged_in_user->created_by)}}</strong>
                                                    

                                                </div> <!--col-->
                                                <div class="col-8 col-sm-6 ">
                                                    Added Time <br>
                                                    <strong>{{$logged_in_user->created_at}}</strong>

                                                </div> <!--col-->
                                                <div class="col-8 col-sm-6 ">
                                                Modified By <br>
                                                <strong> - -</strong>

                                                </div> <!--col-->
                                                <div class="col-8 col-sm-6 ">
                                                Modified Time <br>
                                                <strong>{{$logged_in_user->updated_at}}</strong>

                                                </div> <!--col-->
                                                





                                            
                                            </div> <!--row-->
                                               <!-- system field ends -->
                             


                                   
                                               --}}  

                                    

                        </div><!-- row mt-4 mb-4 end -->
                     

                                      
            </div>
        </div>
    </div>
</div>
<!-- ============================================================== -->
<!-- End Container fluid  -->
<!-- ============================================================== -->                    
@endsection


@push('after-styles') 


<style>
    .table>thead{
        background: #edefff;
    }
     .fa-download{
        color:#594545;
    }
    .doc-delete-btn{
        border: none;
    background: none;
    color: #CB4154;
    }
    .doc-delete-btn:hover , .doc-delete-btn:active {
        color:#0d6efd;
    }

    .btn-outline-info:hover , .btn-outline-info:active{
        border:unset !important;
        
    }
    a .text-sub:hover{
        color:unset !important;
    }
    .text-sub{
        color:unset !important;
    }
    .col-9 label , .col-9 h6{
        font-size:17px !important;
    }
    .seperate-div{
        width: 2px !important;
    height: 200px;
    background: rgb(129, 128, 128);
    margin: auto;
    padding: 0px !important;
    }
    strong , p{
        color:rgb(23, 23, 23) !important;
    }
    p{
       color: rgb(23, 23, 23) !important; 
      
        font-weight: 600;
    }
    .container-fluid{
        text-transform: capitalize;
    }
          .btn:hover {

color: white;
}
.btn{
    color:white;
    padding: 5px 10px !important;
  }  

.create-btn{
background-color: #0d6efd;
border-color: #0d6efd;
}
.col-md-8{
  width: 100%;
  margin: 50px auto;
 
}
.col-sm-4, .col-8 , .col-sm-6 ,.col{
    margin-bottom: 15px;
}

.all-form-group-box{
  display: flex;
  flex-wrap: wrap;
  justify-content: left;
  margin-bottom: 100px;
  gap: 30px;
}
.row1{
  min-width: 200px;
  max-width: 100%;
  margin-top: 20px;
}

.col-md-8{
  display: flex;
  justify-content: space-between;
}
.col-sm-6{
  width: 33.3333333%;
    display: flex
;
    flex-direction: column;
    font-family: 'Source Sans Pro', sans-serif !important;
    font-size: 14px !important;
}
hr{
  margin: 1rem 0;
    color: inherit;
    background-color: currentColor;
    border: 0;
    opacity: .25;
}
tbody, td, tfoot, th, thead, tr {

    border: none !important;
}

   
        .card-title , .row {
            text-transform: capitalize;
        }
        @media (max-width:1300px) {
        .resp{
            width:40% !important;
        }
    } 
     
    @media (max-width:1100px) {
        .resp{
            width:50% !important;
        }
    } 
    @media (max-width:900px) {
        .col-sm-6{
            width:50%;
        }
    }
    @media (max-width:600px) {
        .resp{
            width:50% !important;
        }
    }
    @media (max-width:500px) {
        .col-sm-6 , .resp{
            width:100% !important;
        }
        .col-12{
            width:100% !important;
        }
        .btn{
            align-self: flex-start;
        }
        .d-flex-1{
            flex-direction: column;
            gap: 10px;
        }
    }
@media (max-width:1035px) {
    .row-cols-4>*{
        width:33.333333%;
    }
    
}
    
@media (max-width:670px) {
    .row-cols-4>* {
        width: 50%;
    }
}
@media (max-width:460px) {
    .row-cols-4>* {
        width: 100%;
    }
}
@media (max-width:770px) {
    .row-resp{
        display: flex
;
        flex-direction: column;
        margin: auto;
        justify-content: center;
        align-items: center;
    }
    .seperate-div{
        display:none;
    }
    .col-2-resp{
        width: 100%;
    }
}
.email{
    text-transform:none;
}
   </style>



@endpush

@push('after-scripts')


<script>
document.getElementById('downloadBtn').addEventListener('click', function(event) {
        event.preventDefault(); // Stop default behavior

        let link = document.createElement('a');
        link.href = this.href;
        link.setAttribute('download', 'PAN_Card.pdf'); // Force download
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    });
</script>

@endpush



