@extends('backend.layouts.app')

@section('title','Staff Management | ' . __('labels.backend.access.users.create'))

@section('content')

{{ html()->form('POST', route('admin.auth.staff.store'))->class('form-horizontal')->open() }}

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Staff Management
                    <small class="text-muted">@lang('labels.backend.access.users.create')</small>
                </h4>
            </div>
            <!--col-->
        </div>
        <!--row-->

        <hr>

        <div class="row mt-4 mb-4">
            <div class="col-md-6">
                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.first_name'))->class('col-md-3 required-field form-control-label')->for('first_name') }}

                    <div class="col-md-9">
                        {{ html()->text('first_name')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.first_name'))
                                    ->attribute('maxlength', 191)
                                    ->required()
                                    ->autofocus() }}
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.last_name'))->class('col-md-3 required-field form-control-label')->for('last_name') }}

                    <div class="col-md-9">
                        {{ html()->text('last_name')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.last_name'))
                                    ->attribute('maxlength', 191)
                                    ->required() }}
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->


                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.email'))->class('col-md-3 required-field form-control-label')->for('email') }}

                    <div class="col-md-9">
                        {{ html()->email('email')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.email'))
                                    ->attribute('maxlength', 191)
                                    ->required() }}
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->
            </div>
            @unless(env('SAAS_MAIL_SERVER'))
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group row mb-3">
                        <label class="col-md-3 form-control-label">Email Integration</label>
                <div class="col-md-9 mb-3">
                    {{-- {{ html()->label(
                            html()->checkbox('email_integration')
                                  ->class('switch-input')
                                  ->id('email_inte')
                            . '<span class="switch-slider" data-checked="on" data-unchecked="off"> Enable (Send email from staff account)</span>')
                        ->class('switch switch-label switch-pill switch-primary mr-2')}} --}}
                    <input type="checkbox" name='email_integration' class='switch-input' id='email_inte' value="1" {{(get_site_config('smtp_type')== 'google')? 'disabled':''}}>
                             Enable (Send email from staff account)
                             @if(get_site_config('smtp_type')== 'google')
                             <p><small class="badge" style="background-color: #fa4141 !important">This Feature is disabled because Google Workspace Email is in use.</small></p>
                             @endif
                    <div id="smtp_blk" style="display: none;">
                        <div class="row">
                            <div class="col-sm-6">
                                <input type="text" name="smtp_host" class="form-control req_smtp" placeholder="Outgoing SMTP Host Name*">
                            </div>
                            <div class="col-sm-3">
                                <input type="number" name="smtp_port" class="form-control req_smtp" placeholder="Port*">
                            </div>
                            <div class="col-sm-3">
                                <select class="form-select form-control req_smtp" name="smtp_encryption">
                                    <option value="">Encryption*</option>
                                    <option value="tls">TLS</option>
                                    <option value="ssl">SSL</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <input type="text" name="smtp_password" class="form-control req_smtp" placeholder="Password or Google app password*">
                            </div>
                        </div>
                        {{--<div class="row mt-2">
                            <div class="col-sm-4">
                                <input type="text" value="" name="imap_host" class="form-control mb-0 req_smtp" placeholder="IMAP Host Name*">
                                <small>For Email Sync(fetch)</small>
                            </div>
                            <div class="col-sm-2">
                                <input type="number" value="" name="imap_port" class="form-control req_smtp" placeholder="IMAP Port*">
                            </div>
                        </div>--}}
                        <label style="font-weight:400 !important;">You can configure <strong>Email Sync(fetch)</strong> from <a class="text-primary" href="{{route('admin.email-sync')}}">Settings > Email Sync</a></label>
                    </div>
                </div>
                    </div>
                </div>
            </div>
            @endunless

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.mobile'))->class('col-md-3 form-control-label required-field')->for('mobile') }}

                        <div class="col-md-9">
                            <div class="input-group">
                                <div class="input-group-prepend" style="width: 50%">
                                    <select class="form-select select2" name="dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;" required>
                                        {{-- <option value=''>Dialcode</option> --}}
                                        @foreach($dialcodes as $dialcode)
                                        <option {{($dialcode->code == Request::old('dialcode') || env('USER_DEFAULT_DIALCODE') == $dialcode->code)? 'selected' : ''}} value="{{$dialcode->code}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <input type="text" class="form-control" name="mobile" placeholder="Mobile No." onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" value="{{ Request::old('mobile') }}" minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}">
                            </div>
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->
                    <div class="form-group row mb-3">
                        <div class="col-md-3">
                            <label class="">Whatsapp No.</label>
                        </div>
                        <div class="col-md-9">
                            <div class="input-group">
                                <div class="input-group-prepend" style="width: 50%">
                                    <select class="form-select select2" id="whatsapp_dialcode" name="whatsapp_dialcode" style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                        {{-- <option value=''>Dialcode</option> --}}
                                        @foreach($dialcodes as $dialcode)
                                        <option {{($dialcode->code == Request::old('whatsapp_dialcode') || env('USER_DEFAULT_DIALCODE') == $dialcode->code)? 'selected' : ''}} value="{{$dialcode->code}}">{{$dialcode->name}} +{{$dialcode->code}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <input type="text" onfocus="this.removeAttribute('readonly');" readonly onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))" class="form-control" id="whatsapp_number" name="whatsapp_number" placeholder="Whatsapp No."  value="{{ Request::old('whatsapp_number') }}"  minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}" maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}">
                            </div>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.password'))->class('col-md-3 required-field form-control-label')->for('password') }}

                        <div class="col-md-9">
                            {{ html()->password('password')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.password'))
                                    ->required() }}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->

                    <div class="form-group row mb-3">
                        {{ html()->label(__('validation.attributes.backend.access.users.password_confirmation'))->class('col-md-3 required-field form-control-label')->for('password_confirmation') }}

                        <div class="col-md-9">
                            {{ html()->password('password_confirmation')
                                    ->class('form-control')
                                    ->placeholder(__('validation.attributes.backend.access.users.password_confirmation'))
                                    ->required() }}
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->

                    <div class="form-group row mb-3">
                        {{ html()->label("Branch(s)")->class('col-md-3 required-field form-control-label')->for('branch') }}
                        <div class="col-md-9">
                            <select class="form-select select2" id="branch" name="branch[]" multiple required>
                                @foreach ($branch_list as $branch)
                                <option value="{{ $branch->id }}">{{ $branch->branch_name }}</option>
                                @endforeach
                                <option value="all">ALL BRANCHES</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        {{ html()->label("Reporting To")->class('col-md-3 required-field form-control-label')->for('reporting_to') }}
                        <div class="col-md-9">
                            <select class="form-select" id="reporting_to" name="reporting_to" required>
                                @foreach (get_managerial_list() as $managerial)
                                <option value="{{ $managerial->id }}">{{ $managerial->first_name ." ". $managerial->last_name  }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>


                    {{--
                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.active'))->class('col-md-2 form-control-label')->for('active') }}

                    <div class="col-md-10">
                        <label class="switch switch-label switch-pill switch-primary">
                            {{ html()->checkbox('active', true, '1')->class('switch-input') }}
                            <span class="switch-slider" data-checked="yes" data-unchecked="no"></span>
                        </label>
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.confirmed'))->class('col-md-2 form-control-label')->for('confirmed') }}

                    <div class="col-md-10">
                        <label class="switch switch-label switch-pill switch-primary">
                            {{ html()->checkbox('confirmed', true, '1')->class('switch-input') }}
                            <span class="switch-slider" data-checked="yes" data-unchecked="no"></span>
                        </label>
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->

                @if(! config('access.users.requires_approval'))
                <div class="form-group row mb-3">
                    {{ html()->label(__('validation.attributes.backend.access.users.send_confirmation_email') . '<br/>' . '<small>' .  __('strings.backend.access.users.if_confirmed_off') . '</small>')->class('col-md-2 form-control-label')->for('confirmation_email') }}

                    <div class="col-md-10">
                        <label class="switch switch-label switch-pill switch-primary">
                            {{ html()->checkbox('confirmation_email', true, '1')->class('switch-input') }}
                            <span class="switch-slider" data-checked="yes" data-unchecked="no"></span>
                        </label>
                    </div>
                    <!--col-->
                </div>
                <!--form-group-->
                @endif
                --}}

            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group row mb-3">
                        {{ html()->label(__('labels.backend.access.users.table.abilities'))->class('col-md-2 required-field form-control-label') }}

                        <div class="col-md-10">
                            <div class="table-responsive">
                                <table class="table table-borderless">
                                    <thead>
                                        <tr>
                                            <th>@lang('labels.backend.access.users.table.roles')</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                @if($roles->count())
                                                @foreach($roles as $role)
                                                @if(\Auth::user()->isAdmin())
                                                    @if(strtolower($role->name) == 'user' || strtolower($role->name) == 'trainer' || strtolower($role->name) == 'agent')
                                                    @continue;
                                                    @endif
                                                @endif
                                                @if(!\Auth::user()->isAdmin())
                                                    @if(strtolower($role->name) == 'user' || strtolower($role->name) == 'trainer' || strtolower($role->name) == 'agent' || strtolower($role->name) == 'administrator')
                                                    @continue;
                                                    @endif
                                                @endif
                                                <div class="card">
                                                    <div class="card-header" style="padding-bottom: 0px;">
                                                        <div class="checkbox d-flex align-items-center">
                                                            {{ html()->label(
                                                                            html()->radio('roles[]', old('roles') && in_array($role->name, old('roles')) ? true : false, $role->name)
                                                                                  ->class('switch-input')
                                                                                  ->id('role-'.$role->id)
                                                                            . '<span class="switch-slider" data-checked="on" data-unchecked="off"></span>')
                                                                        ->class('switch switch-label switch-pill switch-primary mr-2')
                                                                        ->for('role-'.$role->id) }}
                                                            {{ html()->label(ucwords($role->name))->class('mx-2')->for('role-'.$role->id) }}
                                                        </div>
                                                    </div>
                                                    <div class="card-body" style="padding-top: 10px;">
                                                        @if($role->id != 1)
                                                        @if($role->permissions->count())
                                                        @foreach($role->permissions as $permission)
                                                        <span class="mx-1 text-nowrap"><i class="fas fa-check text-success"></i> {{ ucwords($permission->name) }}</span>
                                                        @endforeach
                                                        @else
                                                        @lang('labels.general.none')
                                                        @endif
                                                        @else
                                                        @lang('labels.backend.access.users.all_permissions')
                                                        @endif
                                                    </div>
                                                </div>
                                                <!--card-->
                                                @endforeach
                                                @endif
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!--col-->
                    </div>
                    <!--form-group-->
                </div>
                <!--col-->
            </div>
            <!--row-->
        </div>
        <!--card-body-->

        <div class="card-footer clearfix">
            <div class="row" style="text-align:center">
                <div class="col">
                    <input type="hidden" name="active" value="1">
                    <input type="hidden" name="confirmed" value="1">

                    {{ form_submit(__('buttons.general.crud.create')) }}
                    {{ form_cancel(route('admin.auth.staff'), __('buttons.general.cancel')) }}
                </div>
                <!--col-->

                <!--  <div class="col text-right">
                    </div> -->
                <!--col-->
            </div>
            <!--row-->
        </div>
        <!--card-footer-->
    </div>
    <!--card-->
    {{ html()->form()->close() }}
    @endsection

    @push ('after-styles')
    <style>
        input[readonly] {
            cursor: text;
            background-color: #fff !important;
        }
    </style>
    @endpush

    @push('after-scripts')
    <script>
        $(document).ready(function() {
            // hide show title on load
            if ($("input[name='email_integration']:checked").length) { // can use :checked selector to see if input with value of home is checked (see link above)
                $("#smtp_blk").show();
                $('.req_smtp').attr('required', 'required');
            } else {
                $("#smtp_blk").hide();
                $('.req_smtp').attr('required', false);
            }

            $("input[name='email_integration']").on('change', function() {
                if (this.checked) {
                    $("#smtp_blk").show();
                    $('.req_smtp').attr('required', 'required');
                } else {
                    $("#smtp_blk").hide();
                    $('.req_smtp').attr('required', false);
                }
            })
        });
    </script>
    @endpush