@extends('backend.layouts.app')
@section('title', 'Staff Management | ' . __('labels.backend.access.users.view'))

@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-12 d-flex justify-content-between">
                <div>
                    <h4 class="card-title mb-0">
                        {{ $user->name }}
                    </h4>
                </div>

                <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back" onclick="document.location ='{{ route('admin.auth.staff') }}'" title="Back">
                    <i class="fa fa-reply" aria-hidden="true"></i> 
                </button>
            </div>
        </div>

        <div class="row">
            <div class="col-md-3">
                <div class="p-3 mt-3 text-left card" style="background-color: rgb(245, 245, 245);">
                    <div class="mx-auto text-center">
                        @if($userStaff && $userStaff->photo)
                       <img src="{{ asset('storage/staff_doc/thumb/' . basename($userStaff->photo)) }}" alt="user"  width="100" height="100" class="rounded-circle">

                            {{-- <img src="{{asset('storage/'.$userStaff->photo)}}" alt="user" width="100" height="100" class="rounded-circle" /> --}}
                        @else
                            <img src="{{ $user->picture }}" width="150" height="150" style="mix-blend-mode: multiply;" alt="Profile Picture" />
                        @endif
                    </div>
                    <br />
                    <div class="mb-3">
                        Employee ID
                        <br /><strong>{{($userStaff && $userStaff->emp_id) ? $userStaff->emp_id : '--' }}</strong>
                    </div>
                    <div class="mb-3">
                   Email
                    <br /><strong class="email">{{($user && $user->email) ? $user->email : '--' }}</strong>
                    </div>
                  <div class="mb-3">Mobile
                    <br /><strong>{{ ($user && $user->dialcode && $user->mobile) ? '+' . $user->dialcode . '-' . $user->mobile : '--' }}</strong>
                    </div>
                    <div class="mb-3">Whatsapp number
                    <br /><strong>{{ ($user && $user->dialcode) ?  '+' . $user->dialcode :''}}{{ ($user && $user->whatsapp ) ? $user->whatsapp : '--' }}</strong>
                    </div>
                    <div class="mb-3">Alternate Phone
                    <br /><strong>{{ ($user && $user->alternate_contact) ? $user->alternate_contact : '--' }}</strong>
                    </div>
                    <div class="mb-3">Branch
                    <br /><strong>{{get_staff_branch_names($user->id)}}</strong>
                    </div>
                    <div class="mb-3">Reporting to
                    <br /><strong>@if ($user && $user->reporting_to){{get_user_full_name_by_id($user->reporting_to)}}@else -- @endif</strong>
                    </div>
                </div>
            </div>

            <div class="col-md-9">
                <div class="card p-3 mt-3">
                    <h3 class="text-start mt-4">Personal Details</h3>
                    {{-- <h3 class="text-start mt-4 pb-3 ps-3 pt-3" style="border-bottom: 1px solid rgb(204, 204, 204);">Personal Details</h3> --}}
                    <div class="row">
                        <div class="col-md-4">
                            <br>Gender
                            <br /><strong>{{($userStaff && $userStaff->gender) ? $userStaff->gender : '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                            <br>  DOB
                            <br><strong>{{ ($userStaff && $userStaff->dob) ? get_date_formated($userStaff->dob) : '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                        <br> Age
                        @if($userStaff && $userStaff->dob)
                            @php
                            $dob = \Carbon\Carbon::parse($userStaff->dob);
                            $now = \Carbon\Carbon::now();
                            $diff = $dob->diff($now); 
                            $years = $diff->y;
                            $months = $diff->m; 
                            @endphp
                            <br> <strong>{{"$years years and $months months"}}</strong>
                        @else
                            <strong>--</strong>
                        @endif
                       
                        </div>
                        
                        <div class="col-md-4">
                            <br> Blood group
                            
                            <br /><strong>{{ ($userStaff && $userStaff->blood_group) ? $userStaff->blood_group : '--' }}</strong>
                        </div>
                   
                        <div class="col-md-4">
                            <br> Marital Status
                            <br /><strong>{{ ($userStaff && $userStaff->marital_status) ? $userStaff->marital_status : '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                            <br> Father/Spouse Name
                            <br /><strong>{{ ($userStaff && $userStaff->father_name) ? $userStaff->father_name : '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                            <br> Mother Name
                            <br /><strong>{{ ($userStaff && $userStaff->mother_name) ? $userStaff->mother_name : '--' }}</strong>
                        </div>
                       
                        <div class="col-md-4">
                            <br> Citizenship
                            <br /><strong>{{ ($userStaff && $userStaff->address) ? get_country_name($userStaff->address) : '--' }}</strong>
                        </div>
                        <div class="col-md-6">
                            <br> About/Expertise
                            <br /><strong>{{ ($userStaff && $userStaff->about) ? $userStaff->about : '--' }}</strong>
                        </div>
                    </div>
                    <hr>
                    <h3 class="text-start mt-4">Employment Details</h3>
                    <div class="row">
                        <div class="col-md-4">
                            <br />Designation
                            <br /><strong>{{ ($userStaff && $userStaff->designation) ? $userStaff->designation: '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                            <br />Department
                            <br /><strong>{{ ($userStaff && $userStaff->department) ? $userStaff->department: '--' }}</strong>
                        </div>
                       {{-- <div class="col-md-4">
                            <br>
                            Reporting Manager <br>
                            @if(!$userStaff || is_null($userStaff->reporting_to) || $userStaff->reporting_to == '')
                                <strong>- -</strong>
                            @else
                                <strong>{{ get_user_full_name_by_id($userStaff->reporting_to) }}</strong>
                            @endif
                        </div> --}}

                        <div class="col-md-4">
                            <br />Employment Type
                            <br /><strong>{{($userStaff && $userStaff->emp_type) ? $userStaff->emp_type : '--'}}</strong>
            
                        </div>
                        <div class="col-md-4">
                            <br />Employment Status
                            <br /><strong>{{($userStaff && $userStaff->emp_status)? $userStaff->emp_status : '--'}}</strong>
            
                        </div>
                        <div class="col-md-4">
                            <br /> Source Of Hire
                            <br /><strong>{{($userStaff && $userStaff->hiring_source) ? $userStaff->hiring_source: '--'}}</strong>
            
                        </div>
                        <div class="col-md-4">
                            <br /> Past Experience
                            <br /><strong>{{$userStaff && $userStaff->past_experience_year ? $userStaff->past_experience_year .' '. 'year' : ''}} {{$userStaff && $userStaff->past_experience_month ? $userStaff->past_experience_month  .' '. 'month' : '--'}}</strong>
            
                        </div>
                        <div class="col-md-4">
                            <br />Start Date
                            <br><strong>{{ ($userStaff && $userStaff->emp_start_date) ? \Carbon\Carbon::parse($userStaff->emp_start_date)->format('d-m-Y') : '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                            <br /> Current Experience
                            @php
                            use Carbon\Carbon ;

                            if(!empty($userStaff) && !empty($userStaff->emp_start_date)){
                                $emp_start_date = Carbon::parse($userStaff->emp_start_date);
                                $today_date = Carbon::now();

                                $years = $emp_start_date->diff($today_date)->y;
                                $months = $emp_start_date->diff($today_date)->m;
                            
                            }else {
                                $years = 0;
                                $months = 0;
                            }
                            @endphp
                            <br />
                            @if($years == 0 && $months == 0)
                                <strong style="text-transform:none">Less than a month</strong>
                            @elseif($years == 0)
                                <strong>{{ $months }} months</strong>
                            @else
                                <strong>{{ $years }} years and {{ $months }} months</strong>
                            @endif

                        </div>
                       

                        
                        <div class="col-md-4">
                            <br />Current CTC
                            <br /><strong>{{ ($userStaff && $userStaff->ctc) ? $userStaff->ctc: '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                            <br> {{_label('aadhar_number')}}
                            <br /><strong>{{ ($userStaff && $userStaff->aadhar_no) ? $userStaff->aadhar_no : '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                            <br />{{_label('pan_card_number')}}
                            <br /><strong>{{ ($userStaff && $userStaff->pan_no) ? $userStaff->pan_no: '--' }}</strong>
                        </div>
                        <div class="col-md-4">
                                                <br /> Onboarding Status:
                                                <br>
                                              
                                                @if( $userStaff && $userStaff->onboarding_status)  
                                                        <strong>{{ $userStaff->onboarding_status}}</strong>
                                                @else
                                                        <strong>--</strong>
                                                @endif
                                                </div><!--col-->

                        
                    </div>
                    

                        
                   
                    <hr>
                    <div class="row">
                                    <h3 class="text-start  mt-4">
                                    Hierarchy Information 
            
                                        </h3>
                                        <div class="col-8 col-sm-6">
                                                    <br>
                                                    Reporting Manager 
                                                    <br />
                                              <strong>    @if($userStaff && $userStaff->reporting_to){{get_user_full_name_by_id($userStaff->reporting_to)}}@else -- @endif  </strong>  
                                                


                                        </div>
                        </div>
                        <hr>
                        <h3 class="text-start mt-4">
                        Seperation Information </h3>
                        <div class="row">
                            <div class="col-8 col-sm-6 resp">
                                <br>
                                Date Of Exit
                                
                                <br /> <strong>{{ $userStaff && $userStaff->emp_end_date ? get_date_formated($userStaff->emp_end_date) :'--' }}</strong>
                      

                            </div> <!--col-->
                            
                        </div> <!--row-->
                            <!-- seperation details ends -->

                        <hr>
                    
                    <h3>Contact Details</h3>
                    <div class="row mt-3">
                        <div class="col-md-4">
                        <br />Work Phone Number

                        <br /> <strong>
                            {{ $userStaff?->work_ph_dialcode && $userStaff?->work_phone_no
                                ? '+' . $userStaff->work_ph_dialcode . '-' . $userStaff->work_phone_no
                                : ($userStaff?->work_ph_dialcode
                                    ? '+' . $userStaff->work_ph_dialcode
                                    : ($userStaff?->work_phone_no ?? '--'))
                             }}
                        </strong>
                      
                        </div>
                        <div class="col-md-4">
                        <br />Extension
                        <br /> <strong>{{$userStaff && ( $userStaff->extension) ?  $userStaff->extension: '--' }}</strong>
                      
                        </div>
                        <div class="col-md-4">
                        <br />Seating Location
                        <br /><strong>{{ ($userStaff && $userStaff->seating_location) ? $userStaff->seating_location: '--' }}</strong>
                      
                        </div>
                        <div class="col-md-4">
                        <br />Personal Mobile number
                        <br />
                        <strong>
                        {{ $user?->dialcode || $userStaff?->personal_phone
                                ? ( ($user?->dialcode ? '+' . $user->dialcode : '') . 
                                    ($user?->dialcode && $userStaff?->personal_phone ? '-' : '') . 
                                    ($userStaff?->personal_phone ?? '') )
                            : '--' }} 
                        </strong>
                      
                        </div>
                        <div class="col-md-4">
                        <br />Personal Email Address
                        <br /> <strong>{{ ($userStaff && $userStaff->personal_email) ? $userStaff->personal_email: '--' }}</strong>
                      
                        </div>
                    </div>
                    <hr>
                    
                    <div class="row mt-3">
                        <div class="col-md-6">
                        <h3 class="text-start mt-4"> Current Address</h3>
                        @if($userStaff && ($userStaff->country != NULL || $userStaff->state != NULL || $userStaff->city != NULL || $userStaff->postal_code != NULL ))
                           <strong>{{$user->address_2}}</strong>
                           <br>
                            <strong>{{$userStaff->city}}</strong>
                            <br />
                            <strong>{{get_state_name($userStaff->state)}}</strong>
                            <br />
                            <strong>{{get_country_name($userStaff->country)}}
                                @if($userStaff->postal_code)
                                
                                    - {{$userStaff->postal_code}}
                                @endif

                                </strong>
                            
                        @else
                                <strong>- - </strong>
                        @endif  
                    </div>
                       
                        <div class="col-md-6">
                        <h3 class="text-start mt-4"> Permanent Address</h3>
                        @if($user->address_1)
                         <strong>{{$user->address_1}}</strong>
                            <br />
                        @endif
                        @if( $userStaff && ($userStaff->permanent_country != NULL || $userStaff->permanent_state != NULL || $userStaff->permanent_city != NULL || $userStaff->permanent_postal_code != NULL) )
                            <strong>{{$userStaff->permanent_city}}</strong>
                            <br /> <strong>{{get_state_name($userStaff->permanent_state)}}</strong>
                            
                            <br /> <strong>{{get_country_name($userStaff->permanent_country)}}
                                @if($userStaff->permanent_postal_code)
                                
                                    - {{$userStaff->permanent_postal_code}}
                                @endif

                                </strong>
                            
                        @else
                                <strong>- - </strong>
                        @endif 

                        </div>
                    </div>
                    <hr>
                     <!-- visa information starts -->
                           <!-- Emergency Contact information starts -->
                           <h3 class="text-start mt-4"> Emergency Contact Information </h3>
                        <br>
                                <div class="row row-cols-4">
                                        <div class="col">
                                             Name
                                            <br>
                                       
                                     <strong>  {{($userStaff && ($userStaff->emergency_contact_name)) ? $userStaff->emergency_contact_name : '--' }}</strong> 
                                        

                                        </div><!--col-->
                                        <div class="col">
                                        email Address

                                        <br>
                                      <strong>  {{($userStaff && ($userStaff->emergency_contact_email)) ? $userStaff->emergency_contact_email : '--' }}</strong>
                                       
                                                                    

                                        </div><!--col-->

                                        <div class="col">
                                        Phone Number
                                        <br>
                                    <strong>  {{($userStaff && ($userStaff->emergency_contact_ph_no)) ? $userStaff->emergency_contact_ph_no : '--' }}</strong>  
                                        

                                        </div><!--col-->
                                        <div class="col">
                                        Address
                                        <br>
                                      <strong>{{($userStaff && ($userStaff->emergency_contact_address)) ? $userStaff->emergency_contact_address : '--' }}</strong>  
                                       

                                        </div><!--col-->
                                        <br>

                                    </div>
                                    <hr>


                            <h3 class="text-start mt-4">Identity Informaition</h3>
                    <div class="row mt-3">
                        <div class="col-md-4">
                        <br />Passport Number
                        <br />
                     <strong> @if ($userStaff && $userStaff->passport_no){{$userStaff->passport_no}}@else -- @endif  </strong>  
                        
                        
                       
                        </div>
                        <div class="col-md-4">
                            <br>Date Of Issue
                            <br>
                            @if ($userStaff && $userStaff->passport_issue_date){{get_date_formated($userStaff->passport_issue_date)}}@else -- @endif  
                        
                             
                        </div>
                        <div class="col-md-4">
                        <br />Date Of Expiry
                        <br /> <strong>{{ ($userStaff && $userStaff->passport_expiry_date) ? get_date_formated($userStaff->passport_expiry_date): '--' }}</strong>
                      
                        </div>
                        <div class="col-md-4">
                        <br />Issuing Country
                        <br /> <strong>{{ ($userStaff && $userStaff->passport_issue_country) ?get_country_name($userStaff->passport_issue_country): '--' }}</strong>
                      
                        </div>
                        
                    
                    </div>
                    <hr>

                        <!-- Emergency Contact information ends -->

                     <h3 class="text-start mt-4"> VISA Information </h3>
                                <div class="row">
                                        <div class="col-8 col-sm-4">
                                        <br />  VISA Number
                                        <br />
                                       <strong>{{($userStaff && $userStaff->visa_no) ? $userStaff->visa_no : '--' }}</strong> 
                                      

                                        </div><!--col-->
                                        <div class="col-8 col-sm-4">

                                        <br /> VISA Expiry Date
                                        <br />
                                     <strong>   {{($userStaff && $userStaff->visa_expiry_date) ? get_date_formated($userStaff->visa_expiry_date) : '--' }}</strong>
                                       
                                        </div><!--col-->

                                        <div class="col-8 col-sm-4">
                                        <br />Entry Clearance
                                        <br />
                                      <strong>{{($userStaff && $userStaff->entry_clearance) ? $userStaff->entry_clearance : '--' }}</strong>  
                                      

                                        </div><!--col-->
                                        <div class="col-8 col-sm-4">
                                        <br />BRP
                                        <br />
                                      <strong>  {{($userStaff && $userStaff->brp) ? $userStaff->brp : '--' }}</strong>
                                      

                                        </div><!--col-->

                                    </div>
                                    <hr>



                        <!-- visa information ends -->


                    
                         <!-- CoS Information starts --> 
                             
                        {{-- <h3 class="text-start mt-4"> CoS Information </h3> 
                           <div class="row"> 
                            <div class="col-md-4">
                            <br /> CoS Number
                                <br />
                             <strong>   {{ ($userStaff && $userStaff->cos_no) ? $userStaff->cos_no: '--' }}</strong>
                               
                            </div>
                            <div class="col-md-4">
                            <br /> Cos Status
                                <br />
                              <strong>  {{ ($userStaff && $userStaff->cos_status) ? $userStaff->cos_status: '--' }}</strong>
                             

                            </div>
                            <div class="col-md-4">
                            <br /> CoS Issue Date
                                <br />
                                <strong>  {{ ($userStaff && $userStaff->cos_issue_date) ? get_date_formated($userStaff->cos_issue_date): '--' }}
                        </strong> 

                            </div>
                            <div class="col-md-4">
                            <br /> CoS Expiry Date
                                <br />
                             <strong> {{ ($userStaff && $userStaff->cos_expiry_date) ? get_date_formated($userStaff->cos_expiry_date): '--' }}</strong> 
                               

                            </div>
                            <div class="col-md-4">
                            <br />Employment Start Date
                                <br />
                               <strong>{{ ($userStaff && $userStaff->emp_start_date) ? get_date_formated($userStaff->emp_start_date): '--' }}</strong> 
                                

                            </div>
                            <div class="col-md-4">
                            <br /> Employment End Date
                                <br />
                              <strong> {{ ($userStaff && $userStaff->emp_end_date) ? get_date_formated($userStaff->emp_end_date): '--' }}</strong> 
                               
                            </div>
                         </div> 
                         
                                                <hr> --}}




                    <h3 class="text-start mt-4">Bank Details </h3>
                    <div class="row">
                        <div class="col-md-4">
                            <br />Account Number
                            <br /><strong>{{ ($userStaff && $userStaff->bank_account_no) ? $userStaff->bank_account_no: '--'}}</strong>
                        </div>
                        <div class="col-md-4">
                            <br />Account Holder Name
                            <br /><strong>{{ ($userStaff && $userStaff->bank_payee) ? $userStaff->bank_payee: '--'}}</strong>
                        </div>
                        <div class="col-md-4">
                            <br />Bank Name
                            <br /><strong>{{ ($userStaff && $userStaff->bank_bank_name) ? $userStaff->bank_bank_name: '--'}}</strong>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <br />Branch Name
                            <br /><strong>{{ ($userStaff && $userStaff->bank_branch) ? $userStaff->bank_branch: '--'}}</strong>
                        </div>
                        <div class="col-md-4">
                            <br />{{_label('ifsc_code')}}
                            <br /><strong>{{ ($userStaff && $userStaff->bank_ifsc) ? $userStaff->bank_ifsc: '--'}}</strong>
                        </div>
                    </div>
                    <hr>
                    <h3 class="text-start mt-4">Documents </h3>
                    <div class="row mb-3 email">
                    <div class="col-md-4">
                                               
                                                <br />Passport
                                               <br>
                                               @if(!empty($userStaff->passport_doc))
                                                   <div class="file-box">
                                                       
                                                       <a href="{{ route('admin.auth.file.download', basename($userStaff->passport_doc)) }}" style="margin-left: 10px;"  >
                                                                                                           <i class="fa fa-download"></i>
                                                       </a>
                                                       <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $userStaff->staff_id, 'passport_doc']) }}" method="POST" class="d-inline">
                                                                                       @csrf
                                                                                       @method('DELETE')
                                                                                       <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                           <i class="fas fa-trash"></i> 
                                                                                       </button>
                                                                                   
                                                                                   </form>
                                                   </div>
                                               @else
                                                   <p>--</p>
                                               @endif


                                           
                           </div>
                           <div class="col-md-4">
                            <br /> Contract Document:
                          
                                @if($userStaff && $userStaff->doc_contract_agreement)
                                    
                            <div class="file-box">
                               
                                <a href="{{ route('admin.auth.file.download', basename($userStaff->doc_contract_agreement)) }}" >
                                                        <i class="fa fa-download"></i>
                                </a>
                              
                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $userStaff->staff_id, 'doc_contract_agreement']) }}" method="POST" class="d-inline">

                                         @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                            <i class="fas fa-trash"></i> 
                                                                        </button>
                                      
                                </form>
                            </div>
                        @else
                            <p>--</p>
                        @endif
                        </div>
                        
                       
                        <div class="col-md-4">
                            <br />Offer Letter:
                            <br>
                            <strong>
                                @if($userStaff && $userStaff->doc_offer_letter)
                                
                                <a href="{{ route('admin.auth.file.download', basename($userStaff->doc_offer_letter)) }}" style="margin-left: 10px;"  >
                                    <i class="fa fa-download"></i>
                                </a>
                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $userStaff->staff_id, 'doc_offer_letter']) }}" method="POST" class="d-inline">

                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');"class="doc-delete-btn">
                                           <i class="fas fa-trash"></i> 
                                        </button>
                                      
                                </form>
                                @else
                                    --
                                @endif
                            </strong>
                        </div>
                        <div class="col-md-4">
                            <br />Resume:
                            <br>
                            <strong>
                                @if($userStaff && $userStaff->doc_resume)
                               
                                <a href="{{ route('admin.auth.file.download', basename($userStaff->doc_resume)) }}" style="margin-left: 10px;"  >
                                    <i class="fa fa-download"></i>
                                </a>
                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $userStaff->staff_id, 'doc_resume']) }}" method="POST" class="d-inline">

                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');"class="doc-delete-btn">
                                           <i class="fas fa-trash"></i> 
                                        </button>
                                      
                                </form>
                                @else
                                    --
                                @endif
                            </strong>
                        </div>
                        
                        <div class="col-md-4">
                            <br />{{_label('pancard_document')}}
                            @if($userStaff && $userStaff->doc_pan_card)
                                    
                                    <div class="file-box">
                                     
                                        <a href="{{ route('admin.auth.file.download', basename($userStaff->doc_pan_card)) }}" >
                                                                <i class="fa fa-download"></i>
                                        </a>
                                                            
                                        <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $userStaff->staff_id, 'doc_pan_card']) }}" method="POST" class="d-inline">

                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                    <i class="fas fa-trash"></i> 
                                                                                </button>
                                              
                                        </form>
                                    </div>
                                @else
                                    <p>--</p>
                                @endif
                           
                        </div>
                       
                        <div class="col-md-4">
                            <br />{{_label('aadhar_document')}}
                          <br>
                            <strong>
                        
                                @if($userStaff && $userStaff->doc_aadhar_card)
                                <a href="{{ route('admin.auth.file.download', basename($userStaff->doc_aadhar_card)) }}" style="margin-left: 10px;"  >
                                    <i class="fa fa-download"></i>
                                </a>
                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $userStaff->staff_id, 'doc_aadhar_card']) }}" method="POST" class="d-inline">

                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');"class="doc-delete-btn">
                                           <i class="fas fa-trash"></i> 
                                        </button>
                                      
                                </form>
                                @else
                                    --
                                @endif
                            </strong>
                        </div>
                       
                        
                       
                   
                    <hr style="margin-top:20px;">
                    <div class="row mt-4 not-capitalize">
                    <h3 class="text-start mt-4">Additional Documents</h3>
                    @if($aditional_documents_details->count())
                             
                        @foreach($aditional_documents_details as $document)
                         <div class="col-sm-12 col-md-4" style="display:flex;gap: 10px;">
                             <p>{{ $document->document_title }}  </p>
                             <a href="{{ route('admin.auth.download.additional.document', $document->id) }}">
                                 <i class="fa fa-download"></i>
                             </a>
                             <form action="{{ route('admin.auth.delete-staff-additional-doc', ['document_id' => $document->id, 'staff_id' => $userStaff->staff_id]) }}" method="POST" class="d-inline">
                                @csrf
                                 @method('DELETE')
                                 <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                     <i class="fas fa-trash"></i> 
                                 </button>
                             </form>
                         </div>

                           
                        @endforeach

                    @else
                        <p>--</p>
                    @endif

                       
                                        
                 
                             
                    </div>
          
                                <hr>
                                <div class="row">
                                                       

                                                       <h3 class="text-start mt-4"> Work Experience </h3>
                                                       <div class="mt-4 table-responsive">                     
                                                          <table class="table dataTable no-footer" style="border:0px !important; cellpadding:0px !important">
                                                              <thead>
                                                                  <tr>
                                                                  <th scope="col">Company Name</th>
                                                                  <th scope="col">Job Title</th>
                                                                  <th scope="col">From date</th>
                                                                  <th scope="col">To Date</th>
                                                                
                                                                  </tr>
                                                              </thead>
                                                              <tbody>
                                                              @if(isset($staff_workexperience_details) && $staff_workexperience_details->isNotEmpty())

                                                                      @foreach ($staff_workexperience_details as $exp)
                                                                          <tr>
                                                                          
                                                                                  <td>{{ $exp->company_name }}</td>
                                                                                  <td class="fix-width">{{ $exp->job_title }}</td>
                                                                                  @if($exp->from_date == NULL)
                                                                                  <td>--</td>
                                                                                  @else
                                                                                  <td>{{get_date_formated($exp->from_date) }}</td>
                                                                                  @endif
                                                                                  @if($exp->to_date != NULL)
                                                                                  <td>{{ get_date_formated($exp->to_date) ?? 'Present' }}</td>
                                                                                  @else
                                                                                  <td>--</td>
                                                                                  @endif
                                                                                  
                                                                                  
                                                                          </tr>
                                                                      @endforeach
                                                                      
                                                                 
                                                                  @else
                                                                  <tr>
                                                                      <td colspan="4" class="text-center">No Work Experience Found</td>
                                                                  </tr>
                                                                     
                                                                  @endif
                                                              
                                                              </tbody>
                                                          </table>
                        </div>
                                                </div>
                                                       
          
                                                    
                                       
                                            

                                                                              <!-- educational details starts -->

                                        <h3 class="text-start mt-4">Educational Details</h3>
                                        <div class="row">
                                        <div class="mt-4 table-responsive">
                                                <table class="table dataTable no-footer" style="border:0px;">
                                                    <thead>
                                                        <tr>
                                                        <th scope="col">Institute Name</th>
                                                        <th scope="col">Degree/Diploma</th>
                                                        <th scope="col">Specialization</th>
                                                        <th scope="col">Year Of Completion</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($staff_education_details->isEmpty())
                                                        <tr>
                                                            <td colspan="4" class="text-center">No Education Found</td>
                                                        </tr>
                                                        @else

                                                                @foreach($staff_education_details as $edu)
                                                                <tr>
                                                                
                                                                <td>{{$edu->institute_name}}</td>
                                                                <td>{{$edu->degree}}</td>
                                                                <td>{{$edu->course_specialization}}</td>
                                                                @if($edu->completion_date == NULL)
                                                                <td>--</td>
                                                                @else
                                                                <td>{{get_date_formated($edu->completion_date)}}</td>
                                                                @endif
                                                                </tr>
                                                                @endforeach
                                                        @endif
                                                    </tbody>
                                                    </table>
                                                </div>
                                             

                                            </div>
                                       
                                   
                                           <!-- educational details ends -->


                                <!-- dependent details starts -->

                                <h3 class="text-start mt-4"> Dependent details</h3>
                                        <div class="row">
                                        <div class="mt-4 table-responsive">
                                                <table class="table dataTable no-footer" style="border:0px;">
                                                    <thead>
                                                        <tr>
                                                        <th scope="col">Name</th>
                                                        <th scope="col">Relationship</th>
                                                        <th scope="col">Date Of Birth</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($staff_dependent_details->isEmpty())
                                                        <tr>
                                                            <td colspan="3" class="text-center">No Dependent Found</td>
                                                        <tr>
                                                        @else
                                                            @foreach($staff_dependent_details as $dep)
                                                            <tr>
                                                            
                                                            <td>{{$dep->dep_name}}</td>
                                                            <td>{{$dep->relationship}}</td>
                                                            @if($dep->date_of_birth == NULL)
                                                            <td>--</td>
                                                            @else
                                                            <td>{{get_date_formated($dep->date_of_birth)}}</td>
                                                            @endif
                                                            </tr>
                                                            @endforeach
                                                        
                                                        @endif
                                                        
                                                        </tr>
                                                    
                                                    </tbody>
                                                    </table>
                                                </div>

                                            </div>
                                       
                                    


                  
                    
                            
                          
                         </div> 

                            <hr style="margin-top: 20px;">
                         
                            <h3 class="text-start mt-4"> System Fields  </h3>
                            <div class="row mb-3">
                                    <br>
                                        <div class="col-md-4">
                                        <br />  Added By:
                                        <br />
                                            @if( $user->created_by )
                                             <strong>{{ get_user_full_name_by_id($user->created_by)}}</strong>
                                             
                                                    @else
                                                    <strong>- - </strong>
                                                    @endif
                                    
                                        </div><!--col-->
                                       <br>
                                        <div class="col-md-4">
                                        <br /> Added Time: 
                                        <br />
                                                @if( $user->created_at)  
                                                <strong>{{get_date_time_formated($user->created_at)}}</strong>
                                                        
                                                    @else
                                                    <strong>- - </strong>
                                                    @endif

                                         
                                    
                                        </div><!--col-->
                                        <br>
                                        <div class="col-md-4">
                                        <br />  Modified By: 
                                            <br />
                                            {{ $userStaff && ($userStaff->modified_by) ? get_user_full_name_by_id($userStaff->modified_by) : '--' }}
                                        </div><!--col-->
                                        <br>
                                        <div class="col-md-4">
                                        <br /> Modified Time:
                                            <br />
                                          <strong> {{ $userStaff && ($userStaff->updated_at) ? get_date_time_formated($userStaff->updated_at) : '--' }}</strong> 
                                              
                                         
                                    
                                        </div><!--col-->
                                        
                                       
                                        
                                        <br>
    
                                
                                        
                                </div><!--row-->


                   

                </div>
            </div>
        </div>
    </div>

   {{-- <div class="card-footer">
        <div class="row">
            <div class="col text-muted text-end">
                <small>
                    <strong>@lang('labels.backend.access.users.tabs.content.overview.created_at'):</strong>
                    {{ timezone()->convertToLocal($user->created_at) }} ({{ $user->created_at->diffForHumans() }}),
                    <strong>@lang('labels.backend.access.users.tabs.content.overview.last_updated'):</strong>
                    {{ timezone()->convertToLocal($user->updated_at) }} ({{ $user->updated_at->diffForHumans() }})
                    @if($user->trashed())
                    <strong>@lang('labels.backend.access.users.tabs.content.overview.deleted_at'):</strong>
                    {{ timezone()->convertToLocal($user->deleted_at) }} ({{ $user->deleted_at->diffForHumans() }})
                    @endif
                </small>
            </div>
        </div>
    </div> --}}
</div>
@endsection

@push('after-styles')

<style>
    table.dataTable tbody td{
        border:none !important;
    }
       .fix-width{
        max-width: 300px;
        overflow: hidden;

    }
    th{
        min-width: 80px;
    }
    .table>:not(caption)>*>*{
        padding: 0.8rem 0.5rem !important;
    }
    .table>thead{
        background: #edefff;
    }
    .table{
        padding:10px;
        margin-left:5px;
    }
        .card-title ,.col, p , strong , td,th {
   text-transform: capitalize;
}
.email , .not-capitalize{
    text-transform: none;
}

tbody, td, tfoot, th, thead, tr {

border: none !important;
}
.doc-delete-btn {
    border: none;
    background: none;
    color: #CB4154;
}

</style>