@extends('backend.layouts.app')
@section('title', 'Staff Management | ' . __('labels.backend.access.users.edit'))

@section('content')

    <div class="container-fluid" style="padding: 0px; margin: -25px -10px -10px -10px;">
        <div class="container-fluid" style="padding-top:25px"> 
            <ul class="nav nav-tabs customtab2" role="tablist">
                <li class="nav-item">
                    <a class="nav-link border active py-2" style="background-color: rgb(13,110,253); color: white; padding: 4px 25px;"
                        href="{{ route('admin.auth.staff.edit', $user->id) }}" role="tab">
                        <span class="hidden-sm-up"><i class="ti-user"></i></span>
                        <span class="hidden-xs-down">Overview</span>
                    </a>
                </li>&nbsp;
                <li class="nav-item ms-2">
                    <a class="nav-link border py-2" style="background-color: rgb(239,242,247); padding: 4px 25px;"
                        href="{{ route('admin.auth.staff.edit.profile', $user->id) }}" role="tab">
                        <span class="hidden-sm-up"><i class="ti-folder"></i></span>
                        <span class="hidden-xs-down">Profile</span>
                    </a>
                </li>
            </ul>

            <div class="row">
                <div class="col-12">
                    {{ html()->modelForm($user, 'PATCH', route('admin.auth.staff.update', $user->id))->class('form-horizontal')->open() }}
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-10">
                                    <h3 class="card-title mb-0">{{ $user->name }}</h3>
                                </div>
                                <div class="col-sm-2 " style="margin-top:20px;text-align: right;">
                                    <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back"
                                        onclick="document.location ='{{ route('admin.auth.staff') }}'" title="Back">
                                        <i class="fa fa-reply" aria-hidden="true"></i> </button>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <span class="text-smaller">Fields marked with <span style="color:red;">*</span> are
                                            mandatory</span>
                                    </div>
                                </div>
                                <hr>
                                <div class="row mt-4 mb-4">
                                    <div class="col-sm-12 col-md-9">
                                        <div class="form-group row">
                                            <div class="col-sm-12 col-md-4">
                                                <label class="col-form-label required-field">First Name</span></label>
                                                <div class="">
                                                    <input type="text" placeholder="First Name" class="form-control"
                                                        name="first_name"
                                                        value="@if (Request::old('first_name')) {{ Request::old('first_name') }}@else{{ $user->first_name }} @endif"
                                                        required>
                                                </div>
                                            </div>

                                            <div class="col-sm-12 col-md-4">
                                                <label class="col-form-label required-field">Last Name</label>
                                                <div class="">
                                                    <input type="text" placeholder="Last Name" class="form-control"
                                                        name="last_name"
                                                        value="@if (Request::old('last_name')) {{ Request::old('last_name') }}@else{{ $user->last_name }} @endif"
                                                        required>
                                                </div>
                                            </div>
                                        </div>

                                        

                                        <div class="form-group row ">
                                            <div class="col-sm-12 col-md-8">
                                                <label class="col-form-label required-field">Email</label>
                                                <div class="">
                                                    <input type="text" placeholder="Email ID" class="form-control"
                                                        name="email"
                                                        value="@if (Request::old('email')) {{ Request::old('email') }}@else{{ $user->email }} @endif"
                                                        required>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row ">
                                            <div class="col-sm-12 col-md-6">
                                                <label class="col-form-label required-field">Mobile No.</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend" style="width: 50%">
                                                        <select class="form-select select2" id="dialcode" name="dialcode"
                                                            style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                                            <option value=''>Dialcode</option>
                                                            @foreach ($dialcodes as $dialcode)
                                                                <option
                                                                    {{ Request::old('dialcode') == $dialcode->code || $dialcode->code == $user->dialcode ? 'selected' : '' }}
                                                                    value="{{ $dialcode->code }}">{{$dialcode->name}} +{{$dialcode->code}}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <input type="text" placeholder="Mobile No." class="form-control"
                                                        onkeypress="return (event.charCode !=8 && event.charCode ==0 || (event.charCode >= 48 && event.charCode <= 57))"
                                                        name="mobile"
                                                        value="@if (Request::old('mobile'))
{{ Request::old('mobile') }}@else{{ $user->mobile }}
@endif"
                                                        minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}"
                                                        maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}" required>
                                                    @if (auth()->user()->isAgent())
                                                        <span class="small">Note: No email/sms are sent to student</span>
                                                    @endif
                                                </div>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <label for="whatsapp_number" class="col-form-label">Whatsapp No.</label>
                                                <div class="input-group">
                                                    <div class="input-group-prepend" style="width: 50%">
                                                        <select class="form-select select2" id="whatsapp_dialcode"
                                                            name="whatsapp_dialcode"
                                                            style="padding:0.49rem 2rem 0.375rem 0.75rem;">
                                                            <option value=''>Dialcode</option>
                                                            @foreach ($dialcodes as $dialcode)
                                                                <option
                                                                    @if (Request::old('whatsapp_dialcode') == $dialcode->code) selected @elseif($dialcode->code == $user->whatsapp_dialcode) selected @endif
                                                                    value="{{ $dialcode->code }}">{{$dialcode->name}} +{{$dialcode->code}}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <input type="text" placeholder="Whatsapp No." id="whatsapp_number"
                                                        minlength="{{ config('app.USER_MOBILE_MIN_LENGTH') }}"
                                                        maxlength="{{ config('app.USER_MOBILE_MAX_LENGTH') }}"
                                                        class="form-control" name="whatsapp_number"
                                                        value="@if (Request::old('whatsapp_number')) {{ Request::old('whatsapp_number') }}@else{{ $user->whatsapp }} @endif">
                                                </div>
                                            </div>

                                            <div class="col-sm-12 col-md-4">
                                                <label for="alternate_contact" class="col-form-label">Alternate
                                                    Contact</label>
                                                <div class="">
                                                    <input type="text" placeholder="Alternate Contact"
                                                        id="alternate_contact" maxlength="50" class="form-control"
                                                        name="alternate_contact"
                                                        value="@if (Request::old('alternate_contact')) {{ Request::old('alternate_contact') }}@else{{ $user->alternate_contact }} @endif">
                                                </div>
                                            </div>
                                        </div>
                                        @unless (env('SAAS_MAIL_SERVER'))
                                            <hr>
                                            <div class="form-group row mb-3">
                                                <label class='col-md-2 form-control-label' for='email_inte'>Email
                                                    Integration</label>
                                                <div class="col-md-10">
                                                    <label>
                                                        <input type="checkbox"
                                                            {{ $staff_details && $staff_details->email_integration ? 'checked' : '' }}
                                                            name='email_integration' class='switch-input' id='email_inte'
                                                            value="1"
                                                            {{ get_site_config('smtp_type') == 'google' ? 'disabled' : '' }}>
                                                        Enable (Send email from staff account)
                                                        @if (get_site_config('smtp_type') == 'google')
                                                            <p><small class="badge"
                                                                    style="background-color: #fa4141 !important">This Feature
                                                                    is disabled because Google Workspace Email is in
                                                                    use.</small></p>
                                                        @endif
                                                    </label>
                                                    <div id="smtp_blk" style="display: none;">
                                                        <div class="row">
                                                            <div class="col-md-5">
                                                                <input type="text"
                                                                    value="{{ $staff_details ? $staff_details->smtp_host : '' }}"
                                                                    name="smtp_host" class="form-control req_smtp"
                                                                    placeholder="Outgoing SMTP Host Name*">
                                                            </div>
                                                            <div class="col-md-2">
                                                                <input type="number"
                                                                    value="{{ $staff_details ? $staff_details->smtp_port : '' }}"
                                                                    name="smtp_port" class="form-control req_smtp"
                                                                    placeholder="SMTP Port*">
                                                            </div>
                                                            <div class="col-md-3">
                                                                <select class="form-select form-control req_smtp"
                                                                    name="smtp_encryption">
                                                                    <option value="">Encryption*</option>
                                                                    <option
                                                                        {{ $staff_details && $staff_details->smtp_encryption == 'tls' ? 'selected' : '' }}
                                                                        value="tls">TLS</option>
                                                                    <option
                                                                        {{ $staff_details && $staff_details->smtp_encryption == 'ssl' ? 'selected' : '' }}
                                                                        value="ssl">SSL</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="row mb-2">
                                                            <div class="col-md-5">
                                                                <input type="text" class="form-control mb-0"
                                                                    value="{{ $staff_details->smtp_username }}" readonly>
                                                                <small>Email ID</small>
                                                            </div>
                                                            <div class="col-md-7">
                                                                <input type="hidden" name="old_smtp_password"
                                                                    value="{{ $staff_details ? $staff_details->smtp_password : '' }}">
                                                                <div class="col-md-8">
                                                                    <input type="text" name="smtp_password"
                                                                        class="form-control mb-0"
                                                                        placeholder="Password or Google app password">
                                                                </div>
                                                                <small>Leave blank if you don't want to change existing
                                                                    password</small>
                                                            </div>
                                                        </div>
                                                        {{-- <div class="row mt-2">
                                                    <div class="col-sm-5">
                                                        <input type="text" value="{{($staff_details)? $staff_details->imap_host :''}}" name="imap_host" class="form-control mb-0 req_smtp" placeholder="IMAP Host Name*">
                                                        <small>For Email Sync(fetch)</small>
                                                    </div>
                                                    <div class="col-sm-2">
                                                        <input type="number" value="{{($staff_details)? $staff_details->imap_port: ''}}" name="imap_port" class="form-control req_smtp" placeholder="Port*">
                                                    </div>
                                                </div> --}}
                                                        <label style="font-weight:400 !important;">You can configure
                                                            <strong>Email Sync(fetch)</strong> from <a class="text-primary"
                                                                href="{{ route('admin.email-sync') }}">Settings > Email
                                                                Sync</a></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                        @endunless

                                        <div class="form-group row ">
                                            {{ html()->label('Branch(s)')->class('col-md-2 required-field form-control-label')->for('branch') }}
                                            <div class="col-md-10">
                                                <select class="form-select select2" id="branch" name="branch[]" multiple required>
                                                    @foreach ($branch_list as $branch)
                                                        <option value="{{ $branch->id }}" @if(in_array($branch->id, $staff_branch)) selected @endif>{{ $branch->branch_name }}</option>
                                                    @endforeach
                                                    <option value="all">ALL BRANCHES</option>
                                                </select>
                                            </div>
                                        </div>
                                        @if ($user->id != 1)
                                            <div class="form-group row mt-2 mb-2">
                                                {{ html()->label('Reporting To')->class('col-md-2 required-field form-control-label')->for('reporting_to') }}
                                                <div class="col-md-10">
                                                    <select class="form-select" id="reporting_to" name="reporting_to"
                                                        required>
                                                        @foreach (get_managerial_list() as $managerial)
                                                            <option
                                                                {{ $user->reporting_to == $managerial->id ? 'selected' : '' }}
                                                                value="{{ $managerial->id }}">
                                                                {{ $managerial->first_name . ' ' . $managerial->last_name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="form-group row mb-3">
                                            {{ html()->label('Abilities')->class('col-md-2 form-control-label required-field') }}
                                            <table class="table table-borderless ">
                                                <thead>
                                                    <tr>
                                                        <th>@lang('labels.backend.access.users.table.roles')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            @if ($roles->count())
                                                                @foreach ($roles as $role)
                                                                    @if (\Auth::user()->isAdmin())
                                                                        @if (strtolower($role->name) == 'user' || strtolower($role->name) == 'trainer' || strtolower($role->name) == 'agent')
                                                                            @continue;
                                                                        @endif
                                                                    @endif
                                                                    @if (!\Auth::user()->isAdmin())
                                                                        @if (strtolower($role->name) == 'user' ||
                                                                                strtolower($role->name) == 'trainer' ||
                                                                                strtolower($role->name) == 'agent' ||
                                                                                strtolower($role->name) == 'administrator')
                                                                            @continue;
                                                                        @endif
                                                                    @endif
                                                                    <div class="card">
                                                                        <div class="card-header"
                                                                            style="padding-bottom: 0px;">
                                                                            <div
                                                                                class="checkbox d-flex align-items-center">
                                                                                <div class="form-check">
                                                                                    <input name="roles[]"
                                                                                        class="form-check-input"
                                                                                        type="radio"
                                                                                        id="role-{{ $role->id }}"
                                                                                        value="{{ $role->name }}"
                                                                                        <?php if (in_array($role->name, $userRoles)) {
                                                                                            echo 'checked';
                                                                                        } ?>>
                                                                                    <label class="form-check-label"
                                                                                        for="role-{{ $role->id }}">
                                                                                        {{ ucfirst($role->name) }}
                                                                                    </label>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                        <div class="card-body" style="padding-top: 10px;">
                                                                            @if ($role->id != 1)
                                                                                @if ($role->permissions->count())
                                                                                    @foreach ($role->permissions as $permission)
                                                                                        <span class="mx-1 text-nowrap"><i
                                                                                                class="fas fa-check text-success"></i>
                                                                                            {{ ucwords($permission->name) }}</span>
                                                                                    @endforeach
                                                                                @else
                                                                                    @lang('labels.general.none')
                                                                                @endif
                                                                            @else
                                                                                @lang('labels.backend.access.users.all_permissions')
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                    <!--card-->
                                                                @endforeach
                                                            @endif
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <div class="row" style="text-align:center;">
                                    <div class="col">
                                        {{ form_submit(__('buttons.general.crud.update')) }}
                                        {{ form_cancel(route('admin.auth.staff'), __('buttons.general.cancel')) }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{ html()->closeModelForm() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push ('after-styles')
<style>
    input[readonly] {
        cursor: text;
        background-color: #fff !important;
    }
</style>
@endpush

@push('after-scripts')
    <script>
        $(document).ready(function() {
            $('#country').on('change', function() {
                var idCountry = this.value;
                $("#state-dd").html('');
                $.ajax({
                    url: "{{ url('api/fetch-states') }}",
                    type: "POST",
                    data: {
                        country_id: idCountry,
                        _token: '{{ csrf_token() }}'
                    },
                    dataType: 'json',
                    success: function(result) {
                        $('#state-dd').html('<option value="">Select State</option>');
                        $.each(result.states, function(key, value) {
                            // if(value.id == "{{ old('state') }}"){
                            //     var selectedState = "selected=\"'selected'\"";
                            // }
                            // else{
                            //     var selectedState = "";
                            // }
                            if (value.id == "{{ $user ? $user->state : '' }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else if (value.id == "{{ old('state') }}") {
                                var selectedState = "selected=\"'selected'\"";
                            } else {
                                var selectedState = "";
                            }
                            $("#state-dd").append('<option ' + selectedState +
                                ' value="' + value.id + '">' + value.name +
                                '</option>');
                        });
                    }
                });
            });

            $('#country').trigger('change');

            // $('#dialcode').change(function(){
            //     var dialcode = $('#dialcode').val();
            //     $('#whatsapp_dialcode').val(dialcode);
            // })

        });

        function chk_mend(elClass) {
            el = document.getElementsByClassName(elClass);
            var atLeastOneChecked = false; //at least one cb is checked
            for (i = 0; i < el.length; i++) {
                if (el[i].checked === true) {
                    atLeastOneChecked = true;
                }
            }

            if (atLeastOneChecked === true) {
                for (i = 0; i < el.length; i++) {
                    el[i].required = false;
                }
            } else {
                for (i = 0; i < el.length; i++) {
                    el[i].required = true;
                }
            }
        }


        $(document).ready(function() {
            // hide show title on load
            if ($("input[name='email_integration']:checked")
                .length
            ) { // can use :checked selector to see if input with value of home is checked (see link above)
                $("#smtp_blk").show();
                $('.req_smtp').attr('required', 'required');
            } else {
                $("#smtp_blk").hide();
                $('.req_smtp').attr('required', false);
            }

            $("input[name='email_integration']").on('change', function() {
                if (this.checked) {
                    $("#smtp_blk").show();
                    $('.req_smtp').attr('required', 'required');
                } else {
                    $("#smtp_blk").hide();
                    $('.req_smtp').attr('required', false);
                }
            })
        });
    </script>
@endpush
