@extends('backend.layouts.app')
@section('title', 'Staff Management | ' . __('labels.backend.access.users.edit'))

@section('content')

<div class="container-fluid" style="padding: 0px; margin: -25px -10px -10px -10px;">
    <div class="container-fluid" style="padding-top: 25px">
        <ul class="nav nav-tabs customtab2" role="tablist">
            <li class="nav-item">
                <a class="nav-link bprder py-2 border" style="background-color: rgb(239,242,247); padding: 4px 25px;"
                    href="{{ route('admin.auth.staff.edit', $user->id) }}" role="tab">
                    <span class="hidden-sm-up"><i class="ti-user"></i></span>
                    <span class="hidden-xs-down">Overview</span>
                </a>
            </li>&nbsp;
            <li class="nav-item ms-2">
                <a class="nav-link border active py-2" style="background-color: rgb(13,110,253); color: white; padding: 4px 25px;"
                    href="{{ route('admin.auth.staff.edit.profile', $user->id) }}" role="tab">
                    <span class="hidden-sm-up"><i class="ti-folder"></i></span>
                    <span class="hidden-xs-down">Profile</span>
                </a>
            </li>
        </ul>

        <div class="row">

            <div class="col-sm-12">
                <div class="card">
                    <div class="text-start text-smaller text-dark fs-20 card-header bg-theme ps-4 p-2 d-flex justify-content-between" style="padding: 7px 12px !important;">
                        <div>
                            <h3 class="card-title mb-0">{{ $user->name }}</h3>
                            <div class="row">
                                <div class="col">
                                    <span class="text-start text-smaller my-2">Fields marked with <span style="color:red;">*</span> are mandatory</span>
                                </div>
                                
                            </div>
                        </div>
                        <div class="" style="margin-top:20px;text-align: right;">
                            <button type="cancel" name="back" class="btn btn-primary btn-sm " value="Back"
                                onclick="document.location ='{{ route('admin.auth.staff') }}'" title="Back">
                                <i class="fa fa-reply" aria-hidden="true"></i> </button>
                        </div>
                    </div>
                
                    <div class="my-5 card-body">
                        <form action="{{ route('admin.auth.staff.edit.save', ['user' => $user->id]) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                            <div class="col">
                                                <span>Employee Photo</span>
                                            </div>
                                <div class="col-md-12">
                                    <div style="width:100px;  height:100px;margin:3px 10px 2px 1px;  ">
                                        @if($staff_details->photo)
                                        {{-- <img src="{{asset('storage/'.$staff_details->photo)}}"
                                            alt="user" width="100" height="100" style="border-radius: 50%" /> --}}
                                              <img src="{{ asset('storage/staff_doc/thumb/' . basename($staff_details->photo)) }}" alt="user"  width="100" height="100" style="border-radius: 50%">
                                        @else
                                        <img src="https://media.istockphoto.com/id/1451587807/vector/user-profile-icon-vector-avatar-or-person-icon-profile-picture-portrait-symbol-vector.jpg?s=612x612&w=0&k=20&c=yDJ4ITX1cHMh25Lt1vI1zBn2cAKKAlByHBvPJ8gEiIg="
                                            alt="user" width="120" height="120" style="border-radius: 50%" />
                                        @endif
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    {{ html()->file('profile_img')->class('form-control mb-0')->accept('image/jpeg, image/jpg, image/png ') }}
                                    <!-- <small class="form-text text-muted">Upload the photo here.</small> -->
                                </div>
                            </div>

                            <p2> File size must not exceed 2MB </p2>
                            <h3 class="py-4 text-start custom-margin">Personal Details</h3>
                            <div class="row mt-4 mb-4">
                                <div class=" col-sm-12 col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;" class="required-field">Gender</label>
                                        <div>
                                            <div class="form-check form-check-inline">
                                                <input type="radio" class="radio-col-blue form-check-input"
                                                    name="gender" id="male" value="male"
                                                    @if(Request::old('gender') == "male") checked @elseif($staff_details->gender == "male") checked @endif required>

                                                <label class=" form-check-label" for="male">Male</label>

                                                <div class="invalid-feedback">
                                                    &nbsp;Please choose a gender.
                                                </div>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input type="radio" class="radio-col-blue form-check-input"
                                                    name="gender" id="female" value="female"
                                                    @if(Request::old('gender') == "female") checked @elseif($staff_details->gender == "female") checked @endif required>
                                                <label class=" form-check-label" for="female">Female</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;" class="">Marital Status</label>
                                        <div>
                                            <div class="form-check form-check-inline">
                                                <input type="radio" class="radio-col-blue form-check-input"
                                                    name="marital_status" id="single" value="single"
                                                    @if(Request::old('marital_status') == "single") checked @elseif($staff_details->marital_status == "single") checked @endif>
                                                <label class=" form-check-label" for="single">Single</label>
                                                <div class="invalid-feedback">
                                                    &nbsp;Please choose a marital status.
                                                </div>
                                            </div>
                                            <div class="form-check form-check-inline">
                                                <input type="radio" class="radio-col-blue form-check-input"
                                                    name="marital_status" id="married" value="married"
                                                    @if(Request::old('marital_status') == "married") checked @elseif($staff_details->marital_status == "married") checked @endif>
                                                <label class=" form-check-label" for="married">Married</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                </div>
                                <div class="row mt-4 mb-4">
                                            <div class="col-md-4">
                                                    <div class="form-group" style="margin-bottom:15px !important;">
                                                        <label class="col-form-label  required-field">Date of Birth</label>
                                                                <div class="input-group">
                                                                    <input type="text" placeholder="Date of Birth" class="form-control"  
                                                                    autocomplete="off" id="dateOfBirth" name="dob" 
                                                                    value="{{ old('dob', $staff_details->dob ? \Carbon\Carbon::parse($staff_details->dob)->format('d-m-Y') : '') }}">
                                                                        <div class="input-group-append">
                                                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                                                        </div>
                                                    </div>
                                            </div>
                                    </div>
                                    
                               
                                
                                <div class="col-sm-12 col-md-4">
                                    <div class="form-group">
                                        <label for="state" class="col-form-label">Blood group</label>
                                        <select class="form-select" id="blood_group" name="blood_group">
                                            <option value="">Select Blood group</option>
                                                <option @if(Request::old('blood_group') == "A+" || $staff_details->blood_group == "A+") selected @endif value="A+">A+</option>
                                                <option @if(Request::old('blood_group') == "A-" || $staff_details->blood_group == "A-") selected @endif value="A-">A-</option>
                                                <option @if(Request::old('blood_group') == "B+" || $staff_details->blood_group == "B+") selected @endif value="B+">B+</option>
                                                <option @if(Request::old('blood_group') == "B-" || $staff_details->blood_group == "B-") selected @endif value="B-">B-</option>
                                                <option @if(Request::old('blood_group') == "AB+" || $staff_details->blood_group == "AB+") selected @endif value="AB+">AB+</option>
                                                <option @if(Request::old('blood_group') == "AB-" || $staff_details->blood_group == "AB-") selected @endif value="AB-">AB-</option>
                                                <option @if(Request::old('blood_group') == "O+" || $staff_details->blood_group == "O+") selected @endif value="O+">O+</option>
                                                <option @if(Request::old('blood_group') == "O-" || $staff_details->blood_group == "O-") selected @endif value="O-">O-</option>
                                            </select>
                                        </div>
                                    </div>

                                <div class="col-sm-12 col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label" >Father/Spouse Name</label>
                                        <input type="text" class="form-control input-box-inner-style "
                                            name="father_name" placeholder="Father/Spouse Name"
                                            value="@if(Request::old('father_name')){{Request::old('father_name')}}@elseif($staff_details->father_name){{$staff_details->father_name}}@endif"
                                            maxlength="50">
                                    </div>

                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;">Mother's Name</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="mother_name" placeholder="Mother's Name" 
                                            value="@if(Request::old('mother_name')){{Request::old('mother_name')}}@elseif($staff_details->mother_name){{$staff_details->mother_name}}@endif"
                                            maxlength="50" value="">
                                    </div>
                                </div>
                                <div class="col-sm-12 col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem; ">Citizenship</label>
                                        <select class="form-select" id="country" name="address">
                                            <option value="{{get_country_name($staff_details->address)}}">{{$staff_details->address ? get_country_name($staff_details->address) : 'Select Citizenship'}}</option>
                                            @foreach ($countries as $country)
                                            <option value="{{ $country->id }}"
                                                @if (Request::old('address') == $country->id || $staff_details->address == $country->id) selected @endif>
                                                {{ $country->title_en }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12 col-md-8">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem; ">About/expertise</label>
                                        <textarea  class="form-control input-box-inner-style "
                                            name="about" placeholder="About/Expertise"
                                            value="{{$staff_details->about}}"
                                            maxlength="50">{{ $staff_details->about }}</textarea>
                                    </div>

                                </div>
                            </div>
                            <hr>

                            <h3 class="mt-3 text-start">Identity Information</h3>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;">Passport Number</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="passport_no" maxlength="50" placeholder="Passport Number"
                                            value="{{$staff_details->passport_no ? $staff_details->passport_no : '' }}">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                <label for=" Passport Number" class=" form-check-label required">Issue Date</label>
                                    <div class="input-group">
                                        <input type="text" placeholder="Passport Issue Date" class="form-control datepicker"  autocomplete="off" id="passport_issue_date" name="passport_issue_date" 
                                        value="{{ old('passport_issue_date', $staff_details->passport_issue_date ? \Carbon\Carbon::parse($staff_details->passport_issue_date)->format('d-m-Y') : '') }}">
                                        <div class="input-group-append">
                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                        </div>  
                                    
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for=" Passport Number" class=" form-check-label required">Expiry Date</label>
                                    <div class="input-group">
                                        <input type="text" placeholder="Passport Expiry Date" class="form-control datepicker"  autocomplete="off" id="passport_expiry_date" name="passport_expiry_date" 
                                        value="{{ old('passport_expiry_date', $staff_details->passport_expiry_date ? \Carbon\Carbon::parse($staff_details->passport_expiry_date)->format('d-m-Y') : '') }}">
                                        <div class="input-group-append">
                                        <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                        </div> 
                                    </div>  
                                </div>
                                
                                <div class="col-md-4">
                                <label for=" Passport Number" class=" form-check-label required"> Issuing Country</label>
                                                       
                                                
                                                       <select class="form-select" name="passport_issue_country" id="country_id">
                                                           
                                                           @foreach ($countries as $country)
                                                           <option value="{{ $country->id }}"
                                                               @if (Request::old('passport_issue_country') == $country->id || $staff_details->passport_issue_country == $country->id) selected @endif>
                                                               {{ $country->title_en }}
                                                           </option>
                                                           @endforeach
                                                       </select>
                                </div>
                              
                            </div>
                                <hr>
                                <h3 class="mt-3 text-start">Employment Details</h3>
                                <div class="row ">
                                    <div class=" col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label required-field">Employee ID</label>
                                            <input type="text" class="form-control input-box-inner-style"
                                                id="employee_ID" name="employee_ID" maxlength="50" placeholder="Employee Id" 
                                                value="@if(Request::old('employee_ID')){{Request::old('employee_ID')}}@elseif($staff_details->emp_id){{$staff_details->emp_id}}@endif" required>
                                            <div class="invalid-feedback">
                                                Please choose a Employee ID.
                                            </div>
                                        </div>
                                    </div>
                                    @if ($user->id != 1)
                                            <div class="col-md-4">
                                                {{ html()->label('Reporting To')->class('col-form-label required-field')->for('reporting_to') }}
                                               
                                                    <select class="form-select" id="reporting_to" name="reporting_to"
                                                        required>
                                                        @foreach (get_managerial_list() as $managerial)
                                                            <option
                                                                {{ $user->reporting_to == $managerial->id ? 'selected' : '' }}
                                                                value="{{ $managerial->id }}">
                                                                {{ $managerial->first_name . ' ' . $managerial->last_name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                
                                            </div>
                                        @endif
                                        <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label required-field">Date Of Joining </label>
                                                <div class="input-group">
                                                    <input type="text"
                                                        class="form-control datepicker input-box-inner-style"
                                                        name="emp_start_date"
                                                        placeholder="dd-mm-yyyy"
                                                        value="@if(Request::old('emp_start_date')) {{ date('d-m-Y', strtotime(Request::old('emp_start_date'))) }} @elseif($staff_details->emp_start_date) {{ date('d-m-Y', strtotime($staff_details->emp_start_date)) }} @endif" >
                                                        <div class="input-group-append">
                                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                                        </div>
                                                </div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label required-field">Designation</label>
                                        <select class="form-select" name="employee_designation">
                                                <option value="{{$staff_details->designation}}">{{$staff_details->designation ?? 'Select Designation'}}</option>
                                                @foreach(get_employee_designation() as $designation)
                                                    <option value="{{ $designation }}" {{ (old('employee_designation') == $designation) ? 'selected' : '' }}>
                                                        {{ $designation }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                   
                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label required-field">Department</label>
                                            <select class="form-select" name="department">
                                                <option value="{{$staff_details->department}}">{{$staff_details->department ? $staff_details->department :'Select department type'}}</option>
                                               
                                                @foreach(get_employee_department() as $department)
                                                    <option value="{{ $department }}" {{ (old('employee_designation') == $department) ? 'selected' : '' }}>
                                                        {{ $department }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label required-field">Employment Type</label>
                                        <select class="form-select" name="employee_type">
                                            
                                            <option value="">Select employement type
                                            </option>
                                            @foreach(get_employee_type() as $emptype)
                                                <option value="{{ $emptype }}" {{ (old('employee_type',$staff_details->emp_type) == $emptype) ? 'selected' : '' }}>
                                                    {{ $emptype }}
                                                </option>
                                            @endforeach
                                        </select>

                                    </div>
                                </div>
                                <div class="col-md-4">
                                   
                                <label class="col-form-label ">Onboarding Status</label>
                                <select class="form-select input-box-inner-style" name="onboarding_status">
                                      <option value="">Select Onboarding status
                                            </option>
                                        @foreach(get_onboarding_status() as $status)

                                            <option value="{{$status}}" {{(old('onboarding_status',$staff_details->onboarding_status)== $status ? 'selected' : '')}}>{{$status}}</option>

                                        @endforeach
                                    </select>
                                </div>                                 
                                                            
                                                               
                                <div class="col-md-4">
                                <div class="form-group" style="margin-bottom:15px !important;">
                                    <label class="col-form-label">Employment Status</label>
                                    <select class="form-select input-box-inner-style" name="emp_status">
                                         <option value="">Select Employment status
                                            </option>
                                        @foreach(get_employee_status() as $empStatus)
                                        <option value="{{ $empStatus }}" {{ (old('empStatus',$staff_details->emp_status) == $empStatus) ? 'selected' : '' }}>
                                                        {{ $empStatus }}
                                        </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label">Source Of Hire</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="hiring_source" maxlength="50" placeholder="Source Of Hire"
                                            value="{{$staff_details->hiring_source}}">
                                    </div>
                                </div>
                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                        <label class="col-form-label">Current CTC</label>
                                        <input type="number" class="form-control input-box-inner-style"
                                        name="current_ctc" placeholder="Current CTC"
                                        value="@if(Request::old('current_ctc')){{Request::old('current_ctc')}}@elseif($staff_details->ctc){{$staff_details->ctc}}@endif"
                                        maxlength="50" pattern="[0-9]*" inputmode="numeric">
                                        </div>
                                    </div>
                                    <div class="col-md-4" style="width:250px !important;" >
                                      
                                        <label class="col-form-label">Past Experience</label>
                                        <div style="display:flex;gap:20px;" >
                                       
                                            <div class="input-group">
                                                    <input type="number" class="form-control input-box-inner-style" style="width:35px !important;height: 35px;"
                                                    name="past_experience_year" maxlength="50" placeholder="years"
                                                    value="{{$staff_details->past_experience_year ? $staff_details->past_experience_year : '' }}" > 
                                                <div class="input-group-append" style="margin-left:5px;margin-top:3px;">
                                                    <span>Years</span>
                                                </div>
                                            </div>
                                        <div class="input-group">  
                                            <input type="number" class="form-control input-box-inner-style" style="width:35px !important;height: 35px;"
                                            name="past_experience_month" maxlength="50" placeholder="months"
                                            value="{{$staff_details->past_experience_month ? $staff_details->past_experience_month : '' }}">
                                            <div class="input-group-append" style="margin-left:5px;margin-top:3px;">
                                                <span>Months</span>
                                            </div>
                                        </div>

                                        </div>
                                </div>
                             </div>
                                   

                                   <div class="form-group row">
                                   
                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                            <label class="col-form-label">{{_label('aadhar_number')}}</label>
                                            <input type="text" class="form-control input-box-inner-style"
                                                name="aadhar_number" placeholder="{{_label('aadhar_number')}}" 
                                                value="@if(Request::old('aadhar_number')){{Request::old('aadhar_number')}}@elseif($staff_details->aadhar_no){{$staff_details->aadhar_no}}@endif"
                                                maxlength="50">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                            <label class="col-form-label required-field" >{{_label('pan_card_number')}}</label>
                                            <input type="text" class="form-control input-box-inner-style"
                                                name="pan_number" maxlength="50" placeholder="{{_label('pan_card_number')}}"
                                                value="@if(Request::old('pan_number')){{Request::old('pan_number')}}@elseif($staff_details->pan_no){{$staff_details->pan_no}}@endif">
                                        </div>
                                    </div>
                                </div>
                                    <!-- <div class="col-md-4">
                                        <div class="form-group">                                            
                                            <label for="country"  class="col-form-label">Citizenship</label>
                                            <select class="form-select" id="country" name="country">
                                                <option value="">Select Country</option>
                                                @foreach ($countries as $country)
                                                <option value="{{ $country->id }}"
                                                    @if (Request::old('country') == $country->id || $staff_details->country == $country->id) selected @endif>
                                                    {{ $country->title_en }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div> -->
                               
                                
                                <div class="form-group row">
                                    <div class="col-md-4">
                                <label class="col-form-label">Date Of Exit </label>
                                                <div class="input-group">
                                                    <input type="text"
                                                        class="form-control datepicker input-box-inner-style"
                                                        name="emp_end_date"
                                                        placeholder="dd-mm-yyyy"
                                                        value="@if(Request::old('emp_end_date')) {{ date('d-m-Y', strtotime(Request::old('emp_end_date'))) }} @elseif($staff_details->emp_end_date) {{ date('d-m-Y', strtotime($staff_details->emp_end_date)) }} @endif" >
                                                        <div class="input-group-append">
                                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                                        </div>
                                                </div>
                                                </div>
                                  </div>
                                
                                
                                    <hr>
                                    <h3 class="text-start mt-4">Contact Details</h3>
                                  
                                   
                                       <div class="form-group row">

                                       <div class="col-sm-12 col-md-4">
                                                        
                                                        <label class="col-form-label">Work Phone No.</label>
                                                                <div class="input-group">
                                                                    <div class="input-group-prepend" style="width: 35%">
                                                                    <select name="work_ph_dialcode" id="country_code" class="form-control" 
        style="padding: 0.55rem 0.75rem; appearance: auto;">
    @foreach($countries as $country)
        <option value="{{ $country->tel }}" 
            {{ $staff_details->work_ph_dialcode == $country->tel ? 'selected' : '' }}>
            {{ $country->code }} +{{ $country->tel }}
        </option>
    @endforeach
</select>

        
        
                                                                    </div>
                                                                    <input type="text" class="form-control" name="work_phone_no" value="{{$staff_details->work_phone_no}}" placeholder="Work phone Number"
                                                                    pattern="[0-9+\-()]*" 
                                                                     maxlength="15"
                                                                    title="Only digits, +,(), and - are allowed"
                                                                    oninput="this.value = this.value.replace(/[^0-9+\-()]/g, '')">
                                                                   
                                                                </div>
                                                              
        
        
                                                                
                                                            </div><!--col-->

                                                   <div class="col-sm-12 col-md-4">
                                                         <label class="col-form-label ">Extension</label>
                                                            {{ html()->text('extension')
                                                                    ->class('form-control')
                                                                    ->placeholder(__('Extension'))
                                                                    ->value($staff_details->extension)
                                                                    }}

                                                                           

                                                            </div><!--col-->
                                                           
                                                            <div class="col-sm-12 col-md-4">
                                                            <label class="col-form-label ">Seating Location</label>

                                                            <select name="seating_location" id="seating_location" class="form-select">
                                                                <option value="{{$staff_details->seating_location}}">{{$staff_details->seating_location ? $staff_details->seating_location : 'Select seating Location'}}</option>

                                                                @foreach($branch_details as $branch)
                                                                    <option value="{{$branch->branch_name}}">{{$branch->branch_name}}</option>
                                                                @endforeach
                                                            </select>

                                                           
                                                            </div><!--col-->
                                                            
                                                           
                                                            <div class="col-sm-12 col-md-4">
                                                                <label class="col-form-label">Personal Mobile Number</label>
                                                                <div class="input-group">
                                                                <div class="input-group-prepend">
                                                                    <select class="form-select" name="dialcode">
                                                                        <option value=''>Dialcode</option>
                                                                        @foreach($dialcodes as $dialcode)
                                                                            <option {{ ($dialcode->code == $userdata->first()->dialcode) ? 'selected' : '' }} value="{{ $dialcode->code }}">
                                                                                {{ $dialcode->code }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                         
                                                                <input type="text" 
                                                                    class="form-control" 
                                                                    name="personal_phone" 
                                                                    value="{{ $staff_details->personal_phone }}" 
                                                                    placeholder="Personal Phone Number"
                                                                    pattern="[0-9]*" 
                                                                    title="Only digits are allowed"
                                                                    maxlength="10"
                                                                    oninput="this.value = this.value.replace(/[^0-9]/g, '')">
                                                            </div>
                                                             </div>

                                                            <div class="col-sm-12 col-md-4">
                                                            <label class="col-form-label ">Personal Email Address</label>
                                                            {{ html()->email('personal_email')
                                                                    ->class('form-control ')
                                                                    ->placeholder(__('Personal Email Address'))
                                                                
                                                                    ->attribute('minlength', config('app.USER_MOBILE_MIN_LENGTH'))
                                                                    ->value($staff_details->personal_email)
                                                                    }}

                                                            </div><!--col-->
                                                          
                                
                                       </div>



                                      <!-- contact detail ends-->
                                 <hr>
                                 <!-- current address -->
                                  
                                <div class="row">
                                    <h3 class="mt-3 text-start">Current Address</h3>
                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                            <label style="margin-bottom: 0.2rem;">Address</label>
                                            <input type="text" class="form-control input-box-inner-style"
                                                name="address_2" maxlength="50" placeholder="Address"
                                                value="@if(Request::old('address_2')){{Request::old('address_2')}}@elseif($user->address_2){{$user->address_2}}@endif">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                            <label >{{ __('labels.frontend.user.profile.country') }}</label>
                                            <select class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                    id="country-dd" name="country" >
                                                <option value="{{ $staff_details->country }}">
                                                    {{$staff_details->country ? get_country_name($staff_details->country) :'Select Country' }}
                                                </option>
                                                @foreach ($countries as $country)
                                                    <option value="{{ $country->id }}"
                                                        @if (Request::old('country') == $country->id || $country->id == $staff_details->country) 
                                                            selected 
                                                        @endif>
                                                        {{ $country->title_en }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="col-md-4">
                                            <label >{{ __('labels.frontend.user.profile.state') }}</label>
                                            <select class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                    name="state" id="state-dd" >
                                                    @if ($staff_details->state)
                                                        <option value="{{ $staff_details->state }}" selected>
                                                            {{ get_state_name($staff_details->state) }}
                                                        </option>
                                                    @else
                                                        <option value="">Select State</option>
                                                    @endif
                                            </select>
                                        </div>

                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                            <label style="margin-bottom: 0.2rem;">City</label>
                                            <input type="text" class="form-control input-box-inner-style"
                                                name="city" maxlength="50" placeholder="City"
                                                value="@if(Request::old('city')){{Request::old('city')}}@elseif($staff_details->city){{$staff_details->city}}@endif">
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                            <label style="margin-bottom: 0.2rem;">Postal Code</label>
                                            <input type="text" class="form-control input-box-inner-style"
                                                name="postal_code" maxlength="50" placeholder="Postal Code"
                                                value="@if(Request::old('postal_code')){{Request::old('postal_code')}}@elseif($staff_details->postal_code){{$staff_details->postal_code}}@endif">
                                        </div>
                                    </div>
                                </div>
                            <hr>
                                                                       
                                    <!-- Permanent Address -->
                                    <h3 class="text-start mt-4"> Permanent Address</h3>
                                    <div class="form-group  row">
                                    <div class="col-md-4">
                                        <div class="form-group" style="margin-bottom:15px !important;">
                                            <label style="margin-bottom: 0.2rem;">Address</label>
                                            <input type="text" class="form-control input-box-inner-style"
                                                name="address_1" maxlength="50" placeholder="Address"
                                                value="@if(Request::old('address_1')){{Request::old('address_1')}}@elseif($user->address_1){{$user->address_1}}@endif">
                                        </div>
                                    </div>
                                  

                                    <div class="col-md-4">
                                        <label>{{ __('labels.frontend.user.profile.country') }}</label>
                                        <select class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                id="country-permanant" name="country-permanant">
                                            <option value="{{ $staff_details->permanent_country }}">
                                                {{$staff_details->permanent_country ? get_country_name($staff_details->permanent_country) : 'Select country' }}
                                            </option>
                                            @foreach ($countries as $country)
                                                <option value="{{ $country->id }}"
                                                    @if (Request::old('country-permanant') == $country->id || $country->id == $staff_details->permanent_country) 
                                                        selected 
                                                    @endif>
                                                    {{ $country->title_en }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-4">
                                        <label>{{ __('labels.frontend.user.profile.state') }}</label>
                                        <select class="form-control form-select shadow-none text-dark input-box-inner-style border"
                                                name="state-permanant" id="state-permanant"
                                                value="{{ $staff_details->permanent_state ? $staff_details->permanent_state : '' }}">
                                        </select>
                                    </div>

                                        <div class="col-sm-12 col-md-4 ">
                                                {{ html()->label(__('labels.frontend.user.profile.city'))->for('city') }}
                                                        
                                                        {{ html()->text('permanent_city')
                                                                ->class('form-control')
                                                                ->placeholder(__('City'))
                                                                ->value($staff_details->permanent_city)
                                                                ->attribute('maxlength', 50) }} 
                                                </div> <!--col-->
           
                                                <div class="col-sm-12 col-md-4">
                                            
                                                        {{ html()->label(__('labels.frontend.user.profile.postal_code'))->for('post_code') }}
                                            
                                                        {{ html()->text('permanent_postal_code')
                                                                ->class('form-control')
                                                                ->placeholder(__('Postal Code'))
                                                                ->value($staff_details->permanent_postal_code)
                                                                ->attribute('maxlength', 50) }}
                                                
                                                </div><!--col-->

                                    </div><!-- form-group --> 
                                    <hr>
                                    <!-- Emergency Contact details starts -->
                                    <h3 class="text-start mt-4">Emergency Contact Information </h3>

                                        <div class="form-group row">

                                            
                                            <div class="col-md-4">
                                            <label for="emergency contact name" class="col-form-label ">Name</label>
                                            
                                                {{ html()->text('emergency_contact_name')
                                                        ->class('form-control')
                                                        ->placeholder(__('Emergeny Contact Name'))
                                                        ->value($staff_details->emergency_contact_name)
                                                        ->attribute('maxlength', 50) }}
                                            </div><!--col-->
                                            <div class="col-md-4">
                                            <label for="emaergency contact email" class="col-form-label ">Email Address</label>
                                            
                                                {{ html()->email('emergency_contact_email')
                                                        ->class('form-control')
                                                        ->placeholder(__('Emergency contact Emil Address'))
                                                        ->value($staff_details->emergency_contact_email)
                                                        
                                                       
                                                    }}
                                            </div><!--col-->

                                            <div class="col-md-4">
                                            <label for="emergency contact phone number" class="col-form-label ">Phone Number</label>
                                            
                                                {{ html()->text('emergency_contact_ph_no')
                                                        ->class('form-control')
                                                        ->placeholder(__('Emergency contact Number'))
                                                        ->value($staff_details->emergency_contact_ph_no)
                                                        ->attribute('maxlength', config('app.USER_MOBILE_MAX_LENGTH'))
                                                        ->attribute('minlength', config('app.USER_MOBILE_MIN_LENGTH'))
                                                        ->attribute('oninput', "this.value = this.value.replace(/[^0-9]/g, '')") 
                                                    }}
                                            </div><!--col-->
                                            <div class="col-md-4">
                                            <label for="emergencyaddress" class="col-form-label ">Address</label>
                                            
                                                {{ html()->text('emergency_contact_address')
                                                        ->class('form-control')
                                                        ->placeholder(__('Emergency contact Address'))
                                                        ->value($staff_details->emergency_contact_address)
                                                        ->attribute('maxlength', 50) }}
                                            </div><!--col-->


                                            
                                        </div>





                                    

                            <hr>

                            <h3 class="mt-3 text-start">Bank Details </h3>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;">Account Number</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="account_number" maxlength="50" placeholder="Account Number"
                                            value="@if(Request::old('account_number')){{Request::old('account_number')}}@elseif($staff_details->bank_account_no){{$staff_details->bank_account_no}}@endif">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;">Account Holders Name</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="account_holder_name" maxlength="50" placeholder="Account holders name"
                                            value="@if(Request::old('account_holder_name')){{Request::old('account_holder_name')}}@elseif($staff_details->bank_payee){{$staff_details->bank_payee}}@endif">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;">Bank Name</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="bank_name" maxlength="50" placeholder="Bank name"
                                            value="@if(Request::old('bank_name')){{Request::old('bank_name')}}@elseif($staff_details->bank_bank_name){{$staff_details->bank_bank_name}}@endif"
                                            @if ($staff_details->bank_bank_name) value="{{ $staff_details->bank_bank_name }}" @endif>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;">{{_label('ifsc_code')}}</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="ifsc_code" maxlength="50" placeholder="{{_label('ifsc_code')}}"
                                            value="@if(Request::old('ifsc_code')){{Request::old('ifsc_code')}}@elseif($staff_details->bank_ifsc){{$staff_details->bank_ifsc}}@endif">
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group" style="margin-bottom:15px !important;">
                                        <label style="margin-bottom: 0.2rem;">Branch Name</label>
                                        <input type="text" class="form-control input-box-inner-style"
                                            name="branch_name" maxlength="50" placeholder="Branch name"
                                            value="@if(Request::old('branch_name')){{Request::old('branch_name')}}@elseif($staff_details->bank_branch){{$staff_details->bank_branch}}@endif">
                                    </div>
                                </div>
                            </div>
                            

                                    <hr>
                                      <!-- VISA details starts -->
                                      <h3 class="text-start mt-4">VISA Information </h3>
                                        <div class="row">
                                        <div class="col-md-4">
                                        <label for="visa number" class="col-form-label ">VISA Number</label>
                                        
                                            {{ html()->text('visa_no')
                                                    ->class('form-control')
                                                    ->placeholder(__('VISA Number'))
                                                    ->value($staff_details->visa_no)
                                                    ->attribute('maxlength', 50) }}
                                        </div><!--col-->
                                        <div class="col-md-4">
                                            <label for="visa_expiry_date" class="col-form-label ">VISA Expiry Date</label>
                                                <div class="input-group">

                                                    <input type="text" placeholder="Visa Expiry Date" class="form-control datepicker"  autocomplete="off" id="visa_expiry_date" name="visa_expiry_date" 
                                                    value="{{ old('visa_expiry_date', $staff_details->visa_expiry_date ? \Carbon\Carbon::parse($staff_details->visa_expiry_date)->format('d-m-Y') : '') }}">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                                    </div>
                                                </div>
                                        </div><!--col-->

                                        <div class="col-md-4">
                                        <label for="wentryclearance" class="col-form-label ">Entry Clearance</label>
                                        
                                            {{ html()->text('entry_clearance')
                                                    ->class('form-control')
                                                    ->placeholder(__('Entry Clearance'))
                                                    ->value($staff_details->entry_clearance)
                                                    ->attribute('maxlength', 50) }}
                                        </div><!--col-->
                                        <div class="col-md-4">
                                        <label for="brp" class="col-form-label ">BRP</label>
                                        
                                            {{ html()->text('brp')
                                                    ->class('form-control')
                                                    ->placeholder(__('BRP'))
                                                    ->value($staff_details->brp)
                                                    ->attribute('maxlength', 50) }}
                                        </div><!--col-->
                                        </div>
                                
                            <div class="mt-4 p-3 row" style=" text-align:center;">
                                <div class="col">
                                    {{ form_submit(__('buttons.general.crud.update')) }}
                                    
                                </div>
                            </div>

                        </form>
                    </div>
</div>


                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card">
                                                <div class="card-body">

                                         <!-- work experience details starts -->
                                   
                            <div class="form-group row">
                                <div style="display:flex;justify-content: space-between;width: 100%;margin:10px auto;"> 
                    
                                    <h3 class="text-start mt-4">Work Experience Details</h3>                                
                                    <a href="#" class="btn btn-primary btn-sm ml-1 workexpModal" data-user-id="{{ $staff_details->staff_id }}">
                                        <span class="bi bi-plus-circle-fill"></span> &nbsp; Create
                                    </a>

                                </div>                                    
                                 
                                <!-- New work experience details Modal -->
                                    <div class="modal fade" id="workexpModal">
                                        <div class="modal-dialog modal-lg modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Add Work Experience Detail</h5>
                                                    <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body load_workexp_modal"></div>
                                            </div>
                                        </div>
                                    </div>

                        
                                    <div class="mt-4 table-responsive">
                                        
                                                <table class="table dataTable no-footer" style="border:0px;">
                                                    <thead>
                                                        <tr>
                                                        <th scope="col">Company Name</th>
                                                        <th scope="col">Job Title</th>
                                                        <th scope="col">From date</th>
                                                        <th scope="col">To Date</th>
                                                        <th scope="col"  >Job Description</th>
                                                        <th scope="col">Relevent</th>
                                                        <th scope="col">Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($staff_workexperience_details->isEmpty())
                                                        <tr>
                                                            <td colspan="7" class="text-center">No Work Experience Details Found</td>
                                                        </tr>
                                                        @else
                                                            @foreach ($staff_workexperience_details as $exp)
                                                                <tr>
                                                                
                                                                        <td>{{ $exp->company_name }}</td>
                                                                        <td class="fix-width">{{ $exp->job_title }}</td>
                                                                        <td>{{get_date_formated($exp->from_date) }}</td>
                                                                        <td>{{ get_date_formated($exp->to_date) ?? 'Present' }}</td>
                                                                        <td class="fix-width">{{ $exp->job_descp }}</td>
                                                                        <td>{{ $exp->relevant }}</td>
                                                                        <td> 
                                                                             <div class="action-buttons">
                                                                        <a href="#" 
                                                                        class="btn btn-outline-primary editworkexpModal" data-user-id="{{$exp->id}}" >
                                                                            <i class="fas fa-edit text-sub" ></i> &nbsp; Edit
                                                                        </a>
                                                                <form action="{{ route('admin.auth.delete-workexp-info', ['workexp_id' => $exp->id]) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this record?');">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-outline-danger">
                                                                    <i class="fas fa-trash"></i> Delete
                                                                </button>
                                                            </form>
                                            </div>
                                                                    

                                                               
                                                            @endforeach
                                                        @endif
                                                    
                                                                <!-- Edit Education Modal -->
                                                                <div class="modal fade" id="editworkexpModal" tabindex="-1" aria-hidden="true">
                                                                        <div class="modal-dialog modal-lg modal-dialog-centered">
                                                                            <div class="modal-content">
                                                                                <div class="modal-header">
                                                                                    <h5 class="modal-title">Edit Work Experience Details</h5>
                                                                                    <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                                                                                </div>
                                                                                <div class="modal-body load_workexp_edit_modal">
                                                                                    <!-- This will be filled dynamically -->
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>



                                                                  
                                                                    </td>
                                                                    </tr>                                                     



                                                    </tbody>
                                                 </table>
                                        <div>
                                             

                                          
                    </div>
                                       

                                    <!-- work experience ends -->
                                    </div>
             </div>
         </div>
</div>


                        <div class="row">
                            <div class="col-sm-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="form-group row">
                                            <div style="display:flex;justify-content: space-between;width: 100%;margin:10px auto;"> 
                
                                            <h3 class="text-start mt-4">Educational Details</h3>                                
                                            <a href="#" class="btn btn-primary btn-sm ml-1 educationModal" data-user-id="{{  $staff_details->staff_id }}">
                                                <span class="bi bi-plus-circle-fill"></span> &nbsp; Create 
                                            </a>

                                            </div>  
                                                  <!-- New Education details Modal -->
                                            <div class="modal fade" id="educationModal">
                                                <div class="modal-dialog modal-lg modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">Add Academic Detail</h5>
                                                            <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body load_modal"></div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mt-4 table-responsive">
                                        <table class="table dataTable no-footer" style="border:0px;">
                                                    <thead>
                                                        <tr>
                                                        <th scope="col">Institute Name</th>
                                                        <th scope="col">Degree/Diploma</th>
                                                        <th scope="col">Specialization</th>
                                                        <th scope="col">Date Of Completion</th>
                                                        <th scope="col">Actions</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @if($staff_education_details->isEmpty())
                                                        <tr>
                                                            <td colspan="5" class="text-center">No Education Details Found</td>
                                                        </tr>
                                                        @else

                                                                @foreach($staff_education_details as $edu)
                                                                <tr>
                                                                
                                                                <td>{{$edu->institute_name}}</td>
                                                                <td>{{$edu->degree}}</td>
                                                                <td>{{$edu->course_specialization}}</td>
                                                                <td>{{get_date_formated($edu->completion_date)}}</td>
                                                               
                                                                <td> 

 <div class="action-buttons">
                                                                 <!-- Edit Education details Modal -->
                                                                 
                                                                 <a href="#" class="btn btn-outline-primary editeducationModal" data-user-id="{{ $edu->id }}">
                                                                 <i class="fas fa-edit text-sub"></i> &nbsp; Edit
                                                                </a>

                                                                <form action="{{ route('admin.auth.delete-edu-info', ['education_id' => $edu->id]) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this record?');">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="submit" class="btn btn-outline-danger">
                                                                    <i class="fas fa-trash"></i> Delete
                                                                </button>
                                                            </form>

                                                               
                                                                   
                                                                @endforeach
                                                                @endif
                                                                    


                                            </div>
                                                                  
                                                                    

                                                                    </td>
                                                                
                                                                </tr>
                                                         
                                                    </tbody>
                                                    </table>
                                        </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <!-- Edit Education Modal -->
                                                                    <div class="modal fade" id="editeducationModal" tabindex="-1" aria-hidden="true">
                                                                        <div class="modal-dialog modal-lg modal-dialog-centered">
                                                                            <div class="modal-content">
                                                                                <div class="modal-header">
                                                                                    <h5 class="modal-title">Edit Academic Details</h5>
                                                                                    <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                                                                                </div>
                                                                                <div class="modal-body load_education_edit_modal">
                                                                                    <!-- This will be filled dynamically -->
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                        <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card">
                                                <div class="card-body">


                                   <!-- dependent details starts -->
                                   
                                   <div class="form-group row">
                                        <div style="display:flex;justify-content: space-between;width: 100%;margin:10px auto;"> 

                                            <h3 class="text-start mt-4"> Dependent Details </h3>
                                            <a href="#" class="btn btn-primary dependentModal" data-user-id="{{ $staff_details->staff_id }}">
                                            <span class="bi bi-plus-circle-fill"></span> &nbsp; Create
                                            </a>
                                            </div>

                                            <div class="modal fade" id="dependentModal">
                                                <div class="modal-dialog modal-lg modal-dialog-centered">
                                                        <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title">Add Dependent Detail</h5>
                                                                    <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                                                                </div>
                                                                <div class="modal-body load_dependent_modal">


                                                                </div>
                                                        </div>
                                                </div>
                                            </div>

                                          



                                        </div>

                                        <div class="table-responsive mt-4">
                    
                                    
                                            <table class="table dataTable no-footer" style="border:0px;">
                                                        <thead>
                                                            <tr>
                                                            <th scope="col">Name</th>
                                                            <th scope="col">Relationship</th>
                                                            <th scope="col">Date Of Birth</th>
                                                            <th scope="col">Actions</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                             @if (count($staff_dependent_details) != 0)
                            
                                                                @foreach($staff_dependent_details as $dep)
                                                                <tr>
                                                                    <td>
                                                                        @if($dep->dep_name != NULL)
                                                                            {{$dep->dep_name}}
                                                                        @else
                                                                        <h6>--</h6>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        @if($dep->relationship != NULL)
                                                                            {{$dep->relationship}}
                                                                        @else
                                                                        <h6>--</h6>
                                                                        @endif
                                                                    </td>
                                                                    <td>
                                                                        @if($dep->date_of_birth !=NULL)
                                                                            {{get_date_formated($dep->date_of_birth)}}
                                                                        @else
                                                                        <h6>--</h6>
                                                                        @endif
                                                                    </td>
                                                            
                                                                    <td > 
                                                                        <div class="action-buttons">
                                                                            <a href="#" 
                                                                            class="btn btn-outline-primary editdependentModal" data-user-id="{{ $dep->id }}">
                                                                                <i class="fas fa-edit text-sub" ></i> &nbsp; Edit
                                                                            </a>
                                                                            <form action="{{ route('admin.auth.delete-dependent-info', ['dependent_id' => $dep->id]) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this record?');">
                                                                                @csrf
                                                                                @method('DELETE')
                                                                                <button type="submit" class="btn btn-outline-danger">
                                                                                    <i class="fas fa-trash"></i> Delete
                                                                                </button>
                                                                            </form>
                                            </div>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                                @else
                                <tr>
                                    <td colspan="4" class="text-center">No Dependent Details Found</td>
                                </tr>
                            @endif
                                                               
                                                           
                                                        </tbody>

                                                      
                                            </table>
                                        </div>  
                                    </div>
                                       

                                        
                                    <!-- dependent details ends -->





                 
                                    </div>
                                            </div>
                                    </div>
                                    </div>
                                    </div>

                                    <div class="modal fade" id="editdependentModal" tabindex="-1" aria-hidden="true">
                                                <div class="modal-dialog modal-lg modal-dialog-centered">
                                                        <div class="modal-content">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title">Edit Dependent Detail</h5>
                                                                    <button type="button" class="btn-close border" data-bs-dismiss="modal"></button>
                                                                </div>
                                                                <div class="modal-body load_edit_dependent_modal">


                                                                </div>
                                                        </div>
                                                </div>
                                            </div>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="card">
                                                <div class="card-body">

                 <!-- documents upload starts -->


                 <h3 class="text-start mt-4"> Documents</h3>

                      <div class="form-group  row">
                      <div class="col-sm-12 col-md-4">
                                    <div class="form-container">
                                        <div class="form-group">
                                        <form action="{{ route('admin.auth.staff-file-upload', ['staff_id'=>$staff_details->staff_id ,'document_column_name'=>'passport_doc'] ) }}" method="POST" enctype="multipart/form-data">
                                                        @csrf
                                                  <label for="passport" style="margin-bottom:10px;">Passport </label>
                                                        <input type="file" name="passport_doc" class="form-control" accept="image/*,.pdf">
                                                        <small class="text-muted">
                                                            Max upload size: {{ config('app.staff_doc_max_size') }} MB
                                                        </small></br>
                                                        <button type="submit" class="btn btn-primary">Upload</button>
                                                    </form>
                                                    @if(!empty($staff_details->passport_doc))
                                                    <div class="file-box">
                                                        <strong style="font-size:14px;">
                                                            {{ get_filename_formated($staff_details->passport_doc) }}
                                                        </strong>
                                                        <a href="{{ route('admin.auth.file.download', basename($staff_details->passport_doc)) }}" style="margin-left: 10px;" >
                                                            <i class="fa fa-download"></i>
                                                        </a>
                                                        
                                                        <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'passport_doc']) }}" method="POST" class="d-inline">

                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                                <i class="fas fa-trash"></i> 
                                                            </button>
                                                        
                                                        </form>
                                                    </div>
                                            
                                                @endif
                                            
                                        </div>
                                    </div>
                                </div>
                          
    
                            <div class="col-sm-12 col-md-4">
                                    <form action="{{ route('admin.auth.staff-file-upload', ['staff_id'=>$staff_details->staff_id ,'document_column_name'=>'doc_contract_agreement']) }}" method="POST" enctype="multipart/form-data">
                                                @csrf
                                                <label for="contract" style="margin-bottom:10px;">Contract:</label>
                                                <input type="file" name="doc_contract_agreement" class="form-control" accept="image/*,.pdf">
                                                <small class="text-muted">
                                                            Max upload size: {{ config('app.staff_doc_max_size') }} MB
                                                        </small></br>
                                                <button type="submit" class="btn btn-primary">Upload</button>
                                            </form>
                                            @if(!empty($staff_details->doc_contract_agreement))
                                            <div class="file-box">
                                            <strong style="font-size:14px;">
                                                {{ ucfirst(preg_replace('/^\d{10}-/', '', get_filename_formated($staff_details->doc_contract_agreement))) }}
                                            </strong>
                                            <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_contract_agreement)) }}" >
                                                <i class="fa fa-download"></i>
                                            </a>
                                            <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_contract_agreement']) }}" method="POST" class="d-inline">


                                
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                <i class="fas fa-trash"></i> 
                                            </button>
                            
                                    </form>
                            </div>
        
                            @endif

                                        
                            </div><!--col-->
                           

                            
                                   

                                        <div class="col-sm-12 col-md-4">
                                    <div class="form-container">
                                        <!-- Offer Letter -->
                                        <div class="form-group">
                                            <form action="{{ route('admin.auth.staff-file-upload', ['staff_id'=>$staff_details->staff_id ,'document_column_name'=>'doc_offer_letter'] ) }}" method="POST" enctype="multipart/form-data">

                                            @csrf
                                            <label for="offerLetter" style="margin-bottom:10px;">Offer Letter</label>
                                            <input type="file" name="doc_offer_letter" class="form-control" accept="image/*,.pdf" >
                                            <!-- Placeholder Display -->
                                             <small class="text-muted">
                                                            Max upload size: {{ config('app.staff_doc_max_size') }} MB
                                                        </small></br>
                                            <button type="submit" class="btn btn-primary">Upload</button>
                                            </form>

                                            @if(!empty($staff_details->doc_offer_letter))
                                            <div class="file-box">
                                                <strong style="font-size:14px;">
                                                    {{ get_filename_formated($staff_details->doc_offer_letter) }}
                                                </strong>
                                                <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_offer_letter)) }}" style="margin-left: 10px;"  >
                                                                        <i class="fa fa-download"></i>
                                                </a>
                                                <!-- Delete Button -->
                                                <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_offer_letter']) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                        <i class="fas fa-trash"></i> 
                                                                                    </button>
                                                
                                                </form>
                                            </div>
                                            @endif
                                       
                              
                                    </div>
                            </div>
                            </div>
                                <!-- Resume -->
                                <div class="col-md-4">
                                    <div class=" form-container">
                                        <div class="form-group">
                                        <form action="{{ route('admin.auth.staff-file-upload', ['staff_id'=>$staff_details->staff_id ,'document_column_name'=>'doc_resume'] ) }}" method="POST" enctype="multipart/form-data">

                                                @csrf
                                                <label for="resume" style="margin-bottom:10px;">Resume</label>
                                                <input type="file" name="doc_resume" class="form-control" accept="image/*,.pdf" >
                                                <!-- Placeholder Display -->
                                                 <small class="text-muted">
                                                            Max upload size: {{ config('app.staff_doc_max_size') }} MB
                                                        </small></br>
                                                <button type="submit" class="btn btn-primary">Upload</button>
                                                </form>

                                                @if(!empty($staff_details->doc_resume))
                                                <div class="file-box">
                                                    <strong style="font-size:14px;">
                                                        {{ get_filename_formated($staff_details->doc_resume) }}
                                                    </strong>
                                                    <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_resume)) }}" style="margin-left: 10px;"  >
                                                                            <i class="fa fa-download"></i>
                                                    </a>
                                                    <!-- Delete Button -->
                                                    <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_resume']) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                            <i class="fas fa-trash"></i> 
                                                                                        </button>
                                                    
                                                    </form>
                                                </div>
                                                @endif

                                       
                                    </div>
                                </div>
                                                                            </div>
                            <div class="col-sm-12 col-md-4">
              
                            <form action="{{ route('admin.auth.staff-file-upload', ['staff_id'=>$staff_details->staff_id ,'document_column_name'=>'doc_aadhar_card'] ) }}" method="POST" enctype="multipart/form-data">

                                 @csrf
                                        <label for="aadharcard" style="margin-bottom:10px;">{{_label('aadhar_document')}}</label>
                                        <input type="file" name="doc_aadhar_card" class="form-control" accept="image/*,.pdf" >
                                        <!-- Placeholder Display -->
                                         <small class="text-muted">
                                                            Max upload size: {{ config('app.staff_doc_max_size') }} MB
                                                        </small></br>
                                        <button type="submit" class="btn btn-primary">Upload</button>
                            </form>
                           
                                @if(!empty($staff_details->doc_aadhar_card))
                                <div class="file-box">
                                    <strong style="font-size:14px;">
                                        {{ get_filename_formated($staff_details->doc_aadhar_card) }}
                                    </strong>
                                    <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_aadhar_card)) }}" style="margin-left: 10px;"  >
                                                            <i class="fa fa-download"></i>
                                     </a>
                                     <!-- Delete Button -->
                                    <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_aadhar_card']) }}" method="POST" class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                            <i class="fas fa-trash"></i> 
                                                                        </button>
                                      
                                    </form>
                                </div>
                          
                            @endif
                                                         
                                           
                                               
                            </div>
                            <div class="col-md-4">
                                    <div class="form-container">
                                        <div class="form-group">
                                            <label for="pan_card" style="margin-bottom:10px;">{{_label('pancard_document')}}</label>
                                            <form action="{{ route('admin.auth.staff-file-upload', ['staff_id'=>$staff_details->staff_id ,'document_column_name'=>'doc_pan_card'] ) }}" method="POST" enctype="multipart/form-data">
                                                        @csrf
                                                  
                                                        <input type="file" name="doc_pan_card" class="form-control" accept="image/*,.pdf">
                                                        <small class="text-muted">
                                                            Max upload size: {{ config('app.staff_doc_max_size') }} MB
                                                        </small></br>
                                                        <button type="submit" class="btn btn-primary">Upload</button>
                                                    </form>
                                                    @if(!empty($staff_details->doc_pan_card))
                                                    <div class="file-box">
                                                        <strong style="font-size:14px;">
                                                            {{ get_filename_formated($staff_details->doc_pan_card) }}
                                                        </strong>
                                                        <a href="{{ route('admin.auth.file.download', basename($staff_details->doc_pan_card)) }}" style="margin-left: 10px;" >
                                                            <i class="fa fa-download"></i>
                                                        </a>
                                                        
                                                        <form action="{{ route('admin.auth.delete-all-doc', ['staff_id' => $staff_details->staff_id, 'doc_pan_card']) }}" method="POST" class="d-inline">

                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                                                                                <i class="fas fa-trash"></i> 
                                                            </button>
                                                        
                                                        </form>
                                                    </div>
                                            
                                                @endif


                                        </div>

                                    </div>

                                </div>
                                
                                       
                                              
                           
                                          

                            
                    </div>
                    <hr style="margin-top:20px;">
                    <div class="form-group row">
                           
                   
                            <!-- Display Uploaded Documents -->
                            @if($aditional_documents_details->count())
                               
                                <h3 class="text-start mt-4">Additional Documents</h3>
                                <div class="additional-doc-div" style="border:none; display:flex;flex-wrap: wrap;">   
                         
                                @foreach($aditional_documents_details as $document)
                                <div class="col-sm-12 col-md-4" style="display:flex;gap: 10px;">
                                    <p >{{mb_substr( $document->document_title , 0, 20) }}  </p>
                             
                                    <a href="{{ route('admin.auth.download.additional.document', $document->id) }}">
                                        <i class="fa fa-download"></i>
                                    </a>
                                
                                    <form action="{{ route('admin.auth.delete-staff-additional-doc', ['document_id' => $document->id, 'staff_id' => $staff_details->staff_id]) }}" method="POST" class="d-inline">
                                    @csrf
                                        @method('DELETE')
                                        <button type="submit" onclick="return confirm('Are you sure you want to delete this document?');" class="doc-delete-btn">
                                            <i class="fas fa-trash"></i> 
                                        </button>
                                    </form>
                                </div>

                                  
                                @endforeach
                            @else
                                <p></p>
                                </div>
                            @endif
                             
                            <br>
                                        </div>
                         <div class="card-body">
                            @if($aditional_documents_details->count()<5)
                            <div class="additional-doc-div">
                            <label for="Other documents" style="margin-bottom:10px;">Add new document</label>
                            <br> 
                          
                            <form action="{{ route('admin.auth.update-staff-doc', $staff_details->staff_id) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="staff_id" value="{{$staff_details->staff_id}}">
                            <div class="form-group" style="display:flex;gap:20px;">
                            <label for="document title" class="required-field" >Title</label>
                            <input type="text" name="document_title"  class="form-control" style="width:60%;" placeholder="Enter title">
                           
                            <button type="submit" class="btn btn-primary mt-2" style="margin-top:0px !important;" >Upload</button>
                            </div>
                         
                             
                        
                            
                            <div class="additional-doc-div-2" style="margin-left:58px;">
                                 
                            <small class="text-muted">
                                                            Max upload size: {{ config('app.staff_doc_max_size') }} MB
                            </small></br>
                            <input type="file" name="document_file" class="form-control" style="width:87px;" accept="image/*,.pdf" required>
                       

                            
                            </div>
                        </form>
                        @endif
                        </div>
                            </div>
                                          
                            </div>

                            </div>  



</div>
</div>
 </div>   

                    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
                    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
                    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
                    </body>


                </div>
            </div>

        </div>
    </div>



    @endsection

    @push('after-styles')

<style>
    .fix-width{
        max-width: 300px;
        overflow: hidden;

    }
    
    .table>thead{
        background: #edefff;
    }
    .input-group-text{
        height:33px;
    }
    .col-md-1{
        width:100px !important;
    }
    .card-title , .row, p , strong , td,th  , option , select{
   text-transform: capitalize;
}
  .table-responsive  table tr td:last-child {
    
    justify-content: center;
    width: fit-content;
    gap: 20px;
    border: none !important;
    align-items: center;
    margin: auto;
}

.action-buttons {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 20px;
}
.additional-doc-div-2{
        display: -webkit-inline-box;
    justify-content: left;
    align-items: center;
    gap: 25px;

    }
    .additional-doc-div{
    border: 1px solid #ced4da;
    border-radius: 5px;
    padding: 10px;
    width: 100%;
    max-width:650px;
    
    }
    .file-upload{
        display:flex;
        gap:50px;
    }
    /* .table>:not(caption)>*>*{
        min-width:200px;
    } */
    .fa-download{
        color:#594545;
    }
    .doc-delete-btn{
        border: none;
    background: none;
    color: #CB4154;
    }
    .doc-delete-btn:hover , .doc-delete-btn:active {
        color:#0d6efd;
    }

    .btn-outline-info:hover , .btn-outline-info:active{
        border:unset !important;
        
    }
    a .text-sub:hover{
        color:unset !important;
    }
    .text-sub{
        color:unset !important;
    }
    table tr th:last-child{
        text-align:center;
    }
    .col-md-4{
        margin-top:10px;
        
    }
</style>
    @endpush

    @push('after-scripts')
    
    <script>
      
//   $(document).ready(function () {
//     $('.datepicker').datetimepicker({
//         format: 'd-m-Y',
//         timepicker: false,
//         scrollInput: false,
//         maxDate: 0, 
//         onChangeDateTime: function(dp, $input) {
//             $input.trigger('change'); 
//         }
//     });
// });
$(document).ready(function () {
    function fetchStates(countryId, stateDropdownId, selectedState = null) {
        $(stateDropdownId).html('<option value="">Loading...</option>');

        if (countryId) {
            $.ajax({
                url: "{{ url('api/fetch-states') }}",
                type: "POST",
                data: {
                    country_id: countryId,
                    _token: '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function (response) {
                    $(stateDropdownId).html('<option value="">Select State</option>');

                    $.each(response.states, function (index, state) {
                        let selected = (state.id == selectedState) ? 'selected' : '';
                        $(stateDropdownId).append(
                            '<option value="' + state.id + '" ' + selected + '>' + state.name + '</option>'
                        );
                    });
                },
                error: function (xhr, status, error) {
                    console.log("Error fetching states:", xhr.responseText);
                }
            });
        } else {
            $(stateDropdownId).html('<option value="">Select State</option>');
        }
    }

    let existingState = '{{ $staff_details->state }}';
    

    $('#country-dd').on('change', function () {
        let countryId = $(this).val();
        fetchStates(countryId, "#state-dd");
    });

    if ($('#country-dd').val()) {
        fetchStates($('#country-dd').val(), "#state-dd", existingState);
    }
    let existingPermanantState = '{{ $staff_details->permanent_state }}';

$('#country-permanant').on('change', function () {
    let countryId = $(this).val();
    fetchStates(countryId, "#state-permanant");
});

if ($('#country-permanant').val()) {
    fetchStates($('#country-permanant').val(), "#state-permanant", existingPermanantState);
}
});
     
$(document).ready(function () {
    $('.datepicker').datetimepicker({
        format: 'd-m-Y',
        timepicker: false,
        scrollInput: false,
        onChangeDateTime: function(dp, $input) {
            $input.trigger('change'); 
        }
    });

    // Open the datepicker only for the corresponding input field
    $('.input-group-text').each(function () {
        $(this).click(function () {
            $(this).closest('.input-group').find('.datepicker').focus();
        });
    });
});


$(document).ready(function(){
    var today = new Date();
    var minAgeDate = new Date(today.getFullYear() - 16, today.getMonth(), today.getDate());

        $('#dateOfBirth').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            scrollInput: false,
            maxDate: minAgeDate,
            onChangeDateTime: function(dp , $input){
                $input.trigger('change'); 
            }
        });
    });
        // function chk_mend(elClass) {
        //   el = document.getElementsByClassName(elClass);
        //   var atLeastOneChecked = false; //at least one cb is checked
        //   for (i = 0; i < el.length; i++) {
        //     if (el[i].checked === true) {
        //       atLeastOneChecked = true;
        //     }
        //   }

        //   if (atLeastOneChecked === true) {
        //     for (i = 0; i < el.length; i++) {
        //       el[i].required = false;
        //     }
        //   } else {
        //     for (i = 0; i < el.length; i++) {
        //       el[i].required = true;
        //     }
        //   }
        // }

        
// add work experience modal form show
$('.workexpModal').on('click', function() {
    var staffId = $(this).data('user-id');
    console.log(staffId);
                var base_url = "{{ route('admin.auth.work-info-create') }}";
                $.get(base_url, function(data) {
                    $('#workexpModal').on('shown.bs.modal', function() {  
                        $('#workexpModal .load_workexp_modal').html(data);
                        $('#add_staff_workexp_detail_id').val(staffId);
                    });
                    $('#workexpModal').modal('show');
                    $('#workexpModal').on('hidden.bs.modal', function() {
                        $('#workexpModal .load_workexp_modal').html("");
                    });
                });
            });






//edit work experience details modal form

$('.editworkexpModal').on('click', function() {
                var workExpId = $(this).data("user-id");
                var base_url = "{{ route('admin.auth.work-info-edit') }}?id=" + workExpId;
                $.get(base_url, function(data) {
                    $('#editworkexpModal').on('shown.bs.modal', function() {  
                        $('#editworkexpModal .load_workexp_edit_modal').html(data);
                        
                    });
                    $('#editworkexpModal').modal('show');
                    $('#editworkexpModal').on('hidden.bs.modal', function() {
                        $('#editworkexpModal .load_workexp_edit_modal').html("");
                    });
                });
            });



// add education details modal form 

$('.educationModal').on('click', function() {
    var staffId = $(this).data('user-id');
                var base_url = "{{ route('admin.auth.store-education-info') }}";
                $.get(base_url, function(data) {
                    $('#educationModal').on('shown.bs.modal', function() {  
                        $('#educationModal .load_modal').html(data);
                        $('#add_staff_education_detail_id').val(staffId);
                    });
                    $('#educationModal').modal('show');
                    $('#educationModal').on('hidden.bs.modal', function() {
                        $('#educationModal .load_modal').html("");
                    });
                });
            });

//edit educational details modal form

$('.editeducationModal').on('click', function() {
                var educationId = $(this).data("user-id");
                
                var base_url = "{{ route('admin.auth.load-education-edit-modal') }}?id=" + educationId;
                $.get(base_url, function(data) {
                    $('#editeducationModal').on('shown.bs.modal', function() {  
                        $('#editeducationModal .load_education_edit_modal').html(data);
                        // $('#add_staff_education_detail_id').val(educationId);
                    });
                    $('#editeducationModal').modal('show');
                    $('#editeducationModal').on('hidden.bs.modal', function() {
                        $('#editeducationModal .load_education_edit_modal').html("");
                    });
                });
            });


// add dependent details modal form show

$('.dependentModal').on('click', function() {
    var staffId = $(this).data('user-id');
                var base_url = "{{ route('admin.auth.dependent-info') }}";
                $.get(base_url, function(data) {
                    $('#dependentModal').on('shown.bs.modal', function() {  
                        $('#dependentModal .load_dependent_modal').html(data);
                        $('#add_staff_dependent_detail_id').val(staffId);
                    });
                    $('#dependentModal').modal('show');
                    $('#dependentModal').on('hidden.bs.modal', function() {
                        $('#dependentModal .load_dependent_modal').html("");
                    });
                });
            });


//edit dependent details modal form


$('.editdependentModal').on('click', function() {
                var dependentId = $(this).data("user-id");
                console.log(dependentId);
                var base_url = "{{ route('admin.auth.load-dependent-edit-modal') }}?id=" + dependentId;
                $.get(base_url, function(data) {
                    $('#editdependentModal').on('shown.bs.modal', function() {  
                        $('#editdependentModal .load_edit_dependent_modal').html(data);
                        // $('#add_staff_education_detail_id').val(educationId);
                    });
                    $('#editdependentModal').modal('show');
                    $('#editdependentModal').on('hidden.bs.modal', function() {
                        $('#editdependentModal .load_edit_dependent_modal').html("");
                    });
                });
            });

   

            //

    </script>
    @endpush