@extends('backend.layouts.app')

@section('title', app_name() . ' | Staff Management' ) 

@include('backend.auth.user.includes.top-links-staffs')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5 col-10">
                <h4 class="card-title mb-0">
                    Staff Members <small class="text-muted">{{ __('labels.backend.access.users.active') }}</small>
                </h4>
            </div>
            <!--col-->

            <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="@lang('labels.general.toolbar_btn_groups')" style="margin-top: 20px;float: right;">
                    <a href="{{ route('admin.auth.staff.create') }}" class="btn btn-primary btn-sm ml-1" data-toggle="tooltip" title="@lang('labels.general.create_new')"><i class="bi bi-plus-circle"></i> Create</a>
                </div>
                <!--btn-toolbar-->
            </div>
            <!--col-->
        </div>
        <!--row-->


       <!--  {{ html()->modelForm($logged_in_user, 'POST', route('admin.auth.staff.search'))->class('form-horizontal')->open() }}
        <div class="row mt-4">
            <div class="col-md-4 col-sm-12">
                @isset($filter)
                <input class="form-control" type="text" name="q" placeholder="Search" value="{{ $filter }}" />
                @else
                <input class="form-control" type="text" name="q" placeholder="Search" />
                @endisset
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="submit" name="submit" class="form-control btn btn-primary" value="Filter" />
            </div>
            <div class="col-md-1 col-sm-12">
                <input type="cancel" name="cancel" class="form-control btn btn-primary" value="Clear" onclick="document.location ='{{ route('admin.auth.staff') }}'" />
            </div>
        </div>
        {{ html()->closeModelForm() }}
 -->

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="staff_users">
                        <thead>
                            <tr>
                                <th>Name</th>
                                {{-- <th>@lang('labels.backend.access.users.table.first_name')</th>
                                <th>@lang('labels.backend.access.users.table.last_name')</th> --}}
                                <th>@lang('labels.backend.access.users.table.email')</th>
                                <th style="min-width: 150px;">Mobile</th>
                                {{-- <th>Roles</th> --}}
                                <th>Details</th>
                                <th style="min-width: 120px;">Created On</th>
                                <th style="min-width: 92px !important;">@lang('labels.general.actions')</th>
                            </tr>
                        </thead>

                    </table>
                </div>
            </div>
            <!--col-->
        </div>
        <!--row-->
        <div class="row mt-3">
            <div class="col-12">
                <strong>Note:</strong>
                <ul>
                    <li>You can create multiple Administrators.</li>
                    <li>The first Administrator account that pre-exists is called 'Super Admin'.</li>
                </ul>
            </div>
        </div>

    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('#staff_users').DataTable({
            "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "{{route('admin.auth.staff.ajaxuserdata')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content')
                },
            },
            "drawCallback": function( settings ) {
                addDeleteForms();
            },            
            "columns": [
                {
                    "data": "name"
                },
                {
                    "data": "email"
                },
                {
                    "data": "mobile"
                },
                // {
                //     "data": "role",
                //     orderable: false,
                //     searchable: false
                // },
                {
                    "data": "details",
                    orderable: false,
                    searchable: false
                },                
                {
                    "data": "created_at"
                },
                {
                    "data": "options"
                }
            ],
            'order': [[4, 'desc']],
            "columnDefs": [{
                "orderable": false,
                "targets": -1
            }],
            "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4]
                    }
                },
            ]       
        });
    });
</script>
@endpush