@extends('backend.layouts.app')
@section('title', "Staff Attendance")
@push('after-styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">
@endpush
@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-5">
                <h4 class="card-title mb-0">
                    Staff Attendance
                </h4>
            </div>
            <!-- <div class="col-sm-7 col-2">
                <div class="btn-toolbar float-right" role="toolbar" style="margin-top: 20px;float: right;">
                    <a href="{{route('admin.order.generate')}}" class="btn btn-success btn-sm ml-1" data-toggle="tooltip" title="Create Batch">Create Order</a>
                </div>
                
            </div> -->
        </div><!--row--> 
        
        
        <div style="border:1px solid #ccc;border-radius:5px;padding:12px 12px 4px 12px;background-color: #f8f8f8;">
            <div class="row mt-4">
                @if(!\Auth::user()->can('view assigned data only'))
                <div class="col-sm-12 col-md-3">
                    <select class="form-select" name="assigned_to" id="assigned_to">
                        <option value="">- Staff -</option>
                        @foreach($staff as $stf)
                        <option value="{{$stf->id}}">{{$stf->first_name.' '.$stf->last_name}}</option>
                        @endforeach
                    </select>
                </div>
                @endif

                <div class="col-sm-12 col-md-4">
                    <input type="text" id="daterange" value="" name="daterange" class="daterange form-control" placeholder="- Date -">
                </div>

                <div class="col-sm-12 col-md-4">
                    <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                    <button onclick="javascript:clearTable();" class=" btn btn-outline-primary btn-sm">Clear</button>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col">
                <div class="table-responsive">
                    <table class="table" id="data_table">
                        <thead>
                           <tr>
                            <th>Date</th>
                            <th>Staff</th>
                            <th>Details</th>
                            <th>Work Hours</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div><!--col-->

        </div><!--row-->
    </div>
</div>
@endsection      

@push ('after-scripts')
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>


<!-- DataTables Core and Extensions -->
<script>
    $(document).ready(function() {
        loadData();

        $('.daterange').daterangepicker({
            autoUpdateInput: false,
        });
        $('.daterange').on('apply.daterangepicker', function(ev, picker) {
            $(this).val(picker.startDate.format('DD-MM-YYYY') + ' to ' + picker.endDate.format('DD-MM-YYYY'));
        });
        $('.daterange').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });
    });

    function loadData(myleads) {
        $('#data_table').DataTable({
            "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"><"col-md-4 text-end"B>>rtip',
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: "Search By Staff ..."
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [10, 25, 50, 100],
            "ajax": {
                "url": "{{route('admin.ajaxstaffattendance')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'assigned_to': $('#assigned_to').val(),
                    'daterange': $('#daterange').val(),
                },
            },
            "initComplete": function(settings, json) {
                //addDeleteForms();
            },
            'order': [
                [0, 'desc']
            ],
            columns: [{
                    data: 'date',
                    orderable: false,
                },
                {
                    data: 'staff',
                    orderable: false,
                },
                {
                    data: 'details',
                    orderable: false,
                },
                {
                    data: 'work_hours',
                    orderable: false,
                },                
            ],
            @if(isset($search) && strlen($search))
            "search": {
                "search": "{{$search}}"
            },
            @endif "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    }
                },
            ]
        });
    }


    function searchTable() {
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#status_search').val('');
        $('#daterangepicker').val('');
        $('#assigned_to').val('');
        $('#daterange').val('');
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }
</script>
@endpush

@push ('after-styles')
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
    .edu-tooltip {
        position: relative;
        display: inline-block;
        /* border-bottom: 1px dotted black; */
    }

    .edu-tooltip .edu-tooltiptext {
        visibility: hidden;
        width: 300px;
        background-color: black;
        color: #fff;
        font-size: 0.9em;
        text-align: center;
        border-radius: 6px;
        padding: 5px 0;
        position: absolute;
        z-index: 1;
        top: 150%;
        left: 50%;
        margin-left: -60px;
    }

    .edu-tooltip .edu-tooltiptext::after {
        content: "";
        position: absolute;
        bottom: 100%;
        left: 50%;
        margin-left: -5px;
        border-width: 5px;
        border-style: solid;
        border-color: transparent transparent black transparent;
    }

    .edu-tooltip:hover .edu-tooltiptext {
        visibility: visible;
    }
        .lead-horizontal {
            overflow-x: scroll;
        }
</style>

@endpush
