@extends('backend.layouts.app')
@section('title', "Apply for Leave")

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-sm-10 col-10">
                <h4 class="card-title mb-0">
                    Apply for Leave
                </h4>
            </div>
            <div class="col-sm-2 col-2" style="margin-top:20px;text-align: right;">
                <button type="cancel" name="back" class="btn btn-primary btn-sm" value="Back" onclick="document.location ='{{ route('admin.my-leaves') }}'" title="Back"> <i class="fa fa-reply" aria-hidden="true"></i> </button>
            </div>            
        </div>
        <!--row-->

        {{ html()->form('POST', route('admin.my-leaves.save'))->class('form-horizontal')->attribute('enctype', 'multipart/form-data')->open() }}
        <div class="row">
            <div class="col-sm-12 col-md-8 mt-3">
                <div class="form-group">
                    <input type="radio" class="radio-col-blue" id="duration_1" name="duration" value="single" @if(old('duration') !='multi' ) checked @endif />
                    <label for="duration_1">Single/Half Day</label>&nbsp;&nbsp;&nbsp;
                    <input type="radio" class="radio-col-blue" id="duration_2" name="duration" value="multi" @if(old('duration')=='multi' ) checked @endif />
                    <label for="duration_2">Multiple Days</label>
                </div>
                <div class="form-group">
                    <div id="single_day">
                        <label>Leave Date</label>
                        <input type="text" autocomplete="off" class="form-control col-md-6 mydatepicker" id="date" name="date" placeholder="Date" value="{{old('date')}}">
                    </div>
                    <div id="multi_day" style="display:none;">
                        <div class="row">
                            <div class="col-md-6">
                                <label>Date From:</label>
                                <input type="text" autocomplete="off" class="form-control mydatepicker" id="date_from" name="date_from" placeholder="Date" value="{{old('date_from')}}">
                            </div>
                            <div class="col-md-6">
                                <label>&nbsp;To:&nbsp;</label>
                                <input type="text" autocomplete="off" class="form-control mydatepicker" id="date_to" name="date_to" placeholder="Date" value="{{old('date_to')}}">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <select class="form-control form-select col-md-6" id="single_duration" name="single_duration">
                        <option value="full_day" @if(old('single_duration')=='full_day' ) selected @endif>Full Day</option>
                        <option value="first_half" @if(old('single_duration')=='first_half' ) selected @endif>First Half</option>
                        <option value="second_half" @if(old('single_duration')=='second_half' ) selected @endif>Second Half</option>
                    </select>
                    <select class="form-control form-select col-md-6" id="multi_duration" name="multi_duration" style="display:none;">
                        <option value="full_day" @if(old('multi_duration')=='full_day' ) selected @endif>All Days</option>
                        <option value="second_half" @if(old('multi_duration')=='second_half' ) selected @endif>First Day Second Half Onwards</option>
                        <option value="first_half" @if(old('multi_duration')=='first_half' ) selected @endif>Till Last Day First Half</option>
                    </select>
                </div>
                <div class="form-group">
                    <input class="form-control" type="text" name="reason" placeholder="Reason" value="{{old('reason')}}" required>
                </div>
                <div class="form-group">
                    <select class="form-control form-select col-md-6" name="type" required>
                        <option value="">Leave Type</option>
                        <option value="EL" @if(old('type')=='EL' ) selected @endif>Earned Leave</option>
                        <option value="SL" @if(old('type')=='SL' ) selected @endif>Sick Leave</option>
                    </select>
                </div>
                <div class="form-group text-center">
                    <input class="btn btn-primary" type="submit" name="save" onclick="return checkform()" value="Apply">
                </div>

            </div>
        </div>
        </form>
    </div>
</div>
@endsection

@push('after-scripts')
<script>
    $(document).ready(function() {
        $('#duration_1').click(function() {
            $('#multi_day').hide();
            $('#multi_duration').hide();
            $('#single_day').show();
            $('#single_duration').show();
        });
        $('#duration_2').click(function() {
            $('#single_day').hide();
            $('#single_duration').hide();
            $('#multi_day').show();
            $('#multi_duration').show();
        });

        @if(old('duration') == 'multi')
        $('#duration_2').trigger("click");
        @endif

        $('.mydatepicker').datetimepicker({
            timepicker: false,
            format: 'd-m-Y',
            scrollInput: false,
            minDate: new Date()
        });
    });

    function checkform() {
        if ($('#duration_1').is(':checked')) {
            if (!$('#date').val()) {
                alert("Date is required!");
                return false;
            }
        } else {
            if (!$('#date_from').val()) {
                alert("From Date is required!");
                return false;
            }
            if (!$('#date_to').val()) {
                alert("To Date is required!");
                return false;
            }
        }
        return true;
    }
</script>
@endpush