@extends('backend.layouts.app')
@section('title', "Staff Leaves")

@push('after-styles')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css">
<link href="{{asset('assets/DataTables/DataTables-1.12.1/css/dataTables.bootstrap5.min.css')}}" rel="stylesheet" type="text/css">
<link href="{{asset('assets/DataTables/Buttons-2.2.3/css/buttons.bootstrap5.min.css')}}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.min.css')}}" rel="stylesheet" type="text/css" />
<link href="{{ asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet" type="text/css" />
<style>
    div.dataTables_wrapper div.dataTables_filter {
        text-align: left !important;
    }
</style>
@endpush

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-9 col-9">
                <h4 class="card-title mb-0">
                    Staff Leaves
                </h4>
            </div>
            <!--col-->
            <div class="col-md-3 col-3">
                <div class="btn-toolbar float-right" role="toolbar" aria-label="">
                </div>
            </div>
        </div>
        <!--row-->
        <div class="row mt-3">
            <div class="col-sm-12 col-md-5">
                <input class="form-control" id="daterangepicker" autocomplete="off" type="text" name="date_search" placeholder="Leaves Date Range" @if($filters['daterange']) value="{{$filters['daterange']}}" @endif />
            </div>
            <div class="col-sm-12 col-md-3">
                <select class="formm-control form-select" name="status" id="status_search">
                    <option value="">Any Status</option>
                    <option value="0" @if($filters['status']=='0' )selected @endif>Pending Approval</option>
                    <option value="1" @if($filters['status']=='1' )selected @endif>Approved</option>
                </select>
            </div>
            <div class="col-sm-12 col-md-2">
                <button onclick="javascript:searchTable();" class=" btn btn-primary btn-sm">Filter</button>
                <button onclick="javascript:clearTable();" class=" btn btn-primary btn-sm">Clear</button>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col">
                <table id="data_table" class="table">
                    <thead>
                        <tr>
                            <th>Date Applied</th>
                            <th>Staff</th>
                            <th>Leave Dates</th>
                            <th>Days</th>
                            <th>Type</th>
                            <th>Reason</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection

@push('after-scripts')
<script src="{{ asset('assets/plugins/moment/moment.js')}}"></script>
<script src="{{ asset('assets/plugins/bootstrap-datepicker/bootstrap-datepicker.min.js')}}"></script>
<script src="{{ asset('assets/plugins/bootstrap-daterangepicker/daterangepicker.js')}}"></script>
<!-- <script type="text/javascript" src="{{ asset('assets/DataTables/DataTables-1.12.1/js/jquery.dataTables.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/DataTables-1.12.1/js/dataTables.bootstrap5.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/dataTables.buttons.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/buttons.bootstrap5.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/buttons.html5.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/Buttons-2.2.3/js/buttons.print.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/pdfmake-0.1.36/pdfmake.min.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/pdfmake-0.1.36/vfs_fonts.js') }}"></script>
<script type="text/javascript" src="{{ asset('assets/DataTables/JSZip-2.5.0/jszip.min.js') }}"></script> -->

<script>
    $(document).ready(function() {
        loadData();
    });

    function loadData(myleads) {
        $('#data_table').DataTable({
            "dom": '<"row"<"col-md-3 text-start"l><"col-md-5 text-start"f><"col-md-4 text-end"B>>rtip',
            processing: true,
            serverSide: true,
            language: {
                searchPlaceholder: "Search By Staff, Leave type ..."
            },
            autoWidth: true,
            responsive: true,
            lengthMenu: [10, 25, 50, 100],
            "ajax": {
                "url": "{{route('admin.ajaxstaffleaves')}}",
                "dataType": "json",
                "type": "post",
                data: {
                    '_token': $('meta[name="csrf-token"]').attr('content'),
                    'status': $('#status_search').val(),
                    'daterange': $('#daterangepicker').val(),
                },
            },
            "initComplete": function(settings, json) {
                //addDeleteForms();
            },
            'order': [
                [0, 'desc']
            ],
            columns: [{
                    data: 'date'
                },
                {
                    data: 'staff'
                },
                {
                    data: 'leave_dates',
                    orderable: false,
                },
                {
                    data: 'days',
                    orderable: false,
                },
                {
                    data: 'type',
                    orderable: false,
                },
                {
                    data: 'reason',
                    orderable: false,
                },
                {
                    data: 'status',
                    orderable: false,
                },
                {
                    data: 'actions',
                    orderable: false,
                },
            ],
            @if(isset($search) && strlen($search))
            "search": {
                "search": "{{$search}}"
            },
            @endif "buttons": [{
                    extend: 'excel',
                    text: '<i class="ri-file-excel-2-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Excel"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'pdf',
                    text: '<i class="bi bi-file-earmark-pdf" data-toggle="tooltip" data-placement="top" title="Pdf" ></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'print',
                    text: '<i class="bi bi-printer" data-toggle="tooltip" data-placement="top" title="Print"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'copy',
                    text: '<i class="ri-file-copy-2-line export-btn-size"  data-toggle="tooltip" data-placement="top" title="Copy"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
                {
                    extend: 'csv',
                    text: '<i class="ri-file-excel-line export-btn-size" data-toggle="tooltip" data-placement="top" title="Csv"></i>',
                    className: 'btn btn-outline-secondary exportBtn',
                    footer: false,
                    header: true,
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6]
                    }
                },
            ]
        });
    }

    jQuery('#daterangepicker').daterangepicker({
        autoUpdateInput: false,
        locale: {
            format: 'DD/MM/YYYY',
            separator: " to ",
            cancelLabel: 'Clear'
        }
    });
    $('#daterangepicker').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('DD/MM/YYYY') + ' to ' + picker.endDate.format('DD/MM/YYYY'));
    });


    function searchTable() {
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

    function clearTable() {
        $('#status_search').val('');
        $('#daterangepicker').val('');
        $("#data_table").dataTable().fnDestroy();
        loadData();
    }

    function doApprove(request_id) {
        Swal.fire({
            title: "Approve Leaves?",
            showCancelButton: true,
            confirmButtonText: "Yes",
            cancelButtonText: "Cancel",
            type: 'info'
        }).then((result) => {
            result.value && post('{{route("admin.staff-leaves.approve")}}', {
                'id': request_id,
                '_token': $('meta[name="csrf-token"]').attr('content')
            });
        });
    }

    function doReject(request_id) {
        Swal.fire({
            title: "Reject Leaves?",
            showCancelButton: true,
            confirmButtonText: "Reject",
            cancelButtonText: "Cancel",
            type: 'warning'
        }).then(function(result) {
            result.value && post('{{route("admin.staff-leaves.reject")}}', {
                'id': request_id,
                '_token': $('meta[name="csrf-token"]').attr('content')
            });
        });
    }

    function post(path, params, method = 'post') {
        // The rest of this code assumes you are not using a library.
        // It can be made less verbose if you use one.
        const form = document.createElement('form');
        form.method = method;
        form.action = path;

        for (const key in params) {
            if (params.hasOwnProperty(key)) {
                const hiddenField = document.createElement('input');
                hiddenField.type = 'hidden';
                hiddenField.name = key;
                hiddenField.value = params[key];

                form.appendChild(hiddenField);
            }
        }

        document.body.appendChild(form);
        form.submit();
    }
</script>

@endpush